/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.util.SearchlistClassLoader;
import buoy.widget.BStandardDialog;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginRegistry {
    private static final ArrayList<ClassLoader> pluginLoaders = new ArrayList();
    private static final HashSet<Class> categories = new HashSet();
    private static final HashMap<Class, List<Object>> categoryClasses = new HashMap();
    private static final HashMap<String, Map<String, PluginResource>> resources = new HashMap();
    private static final HashMap<String, ExportInfo> exports = new HashMap();
    private static final HashMap<String, Object> classMap = new HashMap();

    public static void scanPlugins() {
        File dir = new File(ArtOfIllusion.PLUGIN_DIRECTORY);
        if (!dir.exists()) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("cannotLocatePlugins")), BStandardDialog.ERROR).showMessageDialog(null);
            return;
        }
        HashSet<JarInfo> jars = new HashSet<JarInfo>();
        for (String file : dir.list()) {
            try {
                jars.add(new JarInfo(new File(dir, file)));
            }
            catch (IOException iOException) {
            }
            catch (Exception ex) {
                System.err.println("*** Exception loading plugin file " + file);
                ex.printStackTrace(System.err);
            }
        }
        PluginRegistry.processPlugins(jars);
    }

    public static void scanPlugins(List<ClassLoader> loaders) {
        HashSet<JarInfo> jars = new HashSet<JarInfo>();
        for (ClassLoader loader : loaders) {
            try {
                jars.add(new JarInfo(loader));
            }
            catch (IOException iOException) {
            }
            catch (Exception ex) {
                System.err.println("*** Exception loading plugin classloader");
                ex.printStackTrace(System.err);
            }
        }
        PluginRegistry.processPlugins(jars);
    }

    private static void processPlugins(HashSet<JarInfo> jars) {
        HashMap<String, JarInfo> nameMap = new HashMap<String, JarInfo>();
        while (jars.size() > 0) {
            boolean processedAny = false;
            for (JarInfo jar : new ArrayList<JarInfo>(jars)) {
                boolean importsOk = true;
                for (String importName : jar.imports) {
                    if (!(importsOk &= nameMap.containsKey(importName))) break;
                }
                if (!importsOk) continue;
                PluginRegistry.processJar(jar, nameMap);
                processedAny = true;
                jars.remove(jar);
            }
            if (processedAny) continue;
            System.err.println("*** The following plugins were not loaded because their imports could not be resolved:");
            for (JarInfo info : jars) {
                if (info.file == null) {
                    System.err.println("(plugin loaded from ClassLoader)");
                    continue;
                }
                System.err.println(info.file.getName());
            }
            System.err.println();
            break;
        }
    }

    private static void processJar(JarInfo jar, Map<String, JarInfo> nameMap) {
        try {
            if (jar.imports.isEmpty() && jar.searchpath.isEmpty()) {
                if (jar.loader == null) {
                    jar.loader = new URLClassLoader(new URL[]{jar.file.toURI().toURL()});
                }
            } else {
                SearchlistClassLoader loader = jar.loader == null ? new SearchlistClassLoader(new URL[]{jar.file.toURI().toURL()}) : new SearchlistClassLoader(jar.loader);
                jar.loader = loader;
                for (String string : jar.imports) {
                    loader.add(nameMap.get((Object)string).loader);
                }
                for (String string : jar.searchpath) {
                    URL url = new URL(string);
                    if (url.getAuthority() != null && url.getAuthority().startsWith("$")) {
                        String string2 = (String)ArtOfIllusion.class.getField(url.getAuthority().substring(1)).get(null);
                        url = new File(string2, url.getPath()).toURI().toURL();
                    }
                    loader.add(url);
                }
            }
            pluginLoaders.add(jar.loader);
            HashMap classNameMap = new HashMap();
            if (jar.name != null && jar.name.length() > 0) {
                nameMap.put(jar.name, jar);
            }
            for (String string : jar.categories) {
                PluginRegistry.addCategory(jar.loader.loadClass(string));
            }
            for (String string : jar.plugins) {
                Object plugin = jar.loader.loadClass(string).newInstance();
                PluginRegistry.registerPlugin(plugin);
                classNameMap.put(string, plugin);
            }
            for (ExportInfo exportInfo : jar.exports) {
                exportInfo.plugin = classNameMap.get(exportInfo.className);
                PluginRegistry.registerExportedMethod(exportInfo);
            }
            for (ResourceInfo resourceInfo : jar.resources) {
                PluginRegistry.registerResource(resourceInfo.type, resourceInfo.id, jar.loader, resourceInfo.name, resourceInfo.locale);
            }
        }
        catch (Exception ex) {
            new BStandardDialog("", UIUtilities.breakString(Translate.text("pluginLoadError", (Object)jar.file.getName())), BStandardDialog.ERROR).showMessageDialog(null);
            System.err.println("*** Exception while initializing plugin " + jar.file.getName() + ":");
            ex.printStackTrace();
        }
    }

    public static List<ClassLoader> getPluginClassLoaders() {
        return new ArrayList<ClassLoader>(pluginLoaders);
    }

    public static void addCategory(Class category) {
        categories.add(category);
    }

    public static List<Class> getCategories() {
        return new ArrayList<Class>(categories);
    }

    public static void registerPlugin(Object plugin) {
        classMap.put(plugin.getClass().getName(), plugin);
        for (Class category : categories) {
            if (!category.isInstance(plugin)) continue;
            List<Object> instances = categoryClasses.get(category);
            if (instances == null) {
                instances = new ArrayList<Object>();
                categoryClasses.put(category, instances);
            }
            instances.add(plugin);
        }
    }

    public static <T> List<T> getPlugins(Class<T> category) {
        List<Object> plugins = categoryClasses.get(category);
        if (plugins == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>(plugins.size());
        for (Object plugin : plugins) {
            list.add(plugin);
        }
        return list;
    }

    public static Object getPluginObject(String classname) {
        return classMap.get(classname);
    }

    public static void registerResource(String type, String id, ClassLoader loader, String name, Locale locale) throws IllegalArgumentException {
        PluginResource resource;
        Map<String, PluginResource> resourcesForType = resources.get(type);
        if (resourcesForType == null) {
            resourcesForType = new HashMap<String, PluginResource>();
            resources.put(type, resourcesForType);
        }
        if ((resource = resourcesForType.get(id)) == null) {
            resource = new PluginResource(type, id);
            resourcesForType.put(id, resource);
        }
        resource.addResource(name, loader, locale);
    }

    public static List<String> getResourceTypes() {
        return new ArrayList<String>(resources.keySet());
    }

    public static List<PluginResource> getResources(String type) {
        Map<String, PluginResource> resourcesForType = resources.get(type);
        if (resourcesForType == null) {
            return new ArrayList<PluginResource>();
        }
        return new ArrayList<PluginResource>(resourcesForType.values());
    }

    public static PluginResource getResource(String type, String id) {
        Map<String, PluginResource> resourcesForType = resources.get(type);
        if (resourcesForType == null) {
            return null;
        }
        return resourcesForType.get(id);
    }

    public static void registerExportedMethod(Object plugin, String method, String id) throws IllegalArgumentException {
        ExportInfo info = new ExportInfo();
        info.plugin = plugin;
        info.method = method;
        info.id = id;
        PluginRegistry.registerExportedMethod(info);
    }

    private static void registerExportedMethod(ExportInfo export) throws IllegalArgumentException {
        if (exports.containsKey(export.id)) {
            throw new IllegalArgumentException("Multiple exported methods with id=" + export.id);
        }
        exports.put(export.id, export);
    }

    public static List<String> getExportedMethodIds() {
        return new ArrayList<String>(exports.keySet());
    }

    public static Object invokeExportedMethod(String id, Object ... args) throws NoSuchMethodException, InvocationTargetException {
        ExportInfo info = exports.get(id);
        if (info == null) {
            throw new NoSuchMethodException("There is no exported method with id=" + id);
        }
        for (Method method : info.plugin.getClass().getMethods()) {
            if (!method.getName().equals(info.method)) continue;
            try {
                return method.invoke(info.plugin, args);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException ex) {
                throw new InvocationTargetException(ex);
            }
        }
        throw new NoSuchMethodException("No method found which matches the specified name and argument types.");
    }

    private static class ResourceInfo {
        String type;
        String id;
        String name;
        Locale locale;

        private ResourceInfo() {
        }
    }

    private static class ExportInfo {
        String method;
        String id;
        String className;
        Object plugin;

        private ExportInfo() {
        }
    }

    public static class PluginResource {
        private String type;
        private String id;
        private ArrayList<String> names;
        private ArrayList<ClassLoader> loaders;
        private ArrayList<Locale> locales;

        private PluginResource(String type, String id) {
            this.type = type;
            this.id = id;
            this.names = new ArrayList();
            this.loaders = new ArrayList();
            this.locales = new ArrayList();
        }

        private void addResource(String name, ClassLoader loader, Locale locale) throws IllegalArgumentException {
            if (this.locales.contains(locale)) {
                throw new IllegalArgumentException("Multiple resource definitions for type=" + this.type + ", name=" + this.id + ", locale=" + locale);
            }
            this.names.add(name);
            this.loaders.add(loader);
            this.locales.add(locale);
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        private int findLocalizedVersion(Locale locale) {
            int bestMatch = 0;
            int bestMatchedLevels = 0;
            for (int i = 0; i < this.locales.size(); ++i) {
                Locale loc = this.locales.get(i);
                int matchedLevels = 0;
                if (loc != null && loc.getLanguage() == locale.getLanguage()) {
                    ++matchedLevels;
                    if (loc.getCountry() == locale.getCountry()) {
                        ++matchedLevels;
                        if (loc.getVariant() == locale.getVariant()) {
                            ++matchedLevels;
                        }
                    }
                }
                if (matchedLevels <= bestMatchedLevels) continue;
                bestMatch = i;
                bestMatchedLevels = matchedLevels;
            }
            return bestMatch;
        }

        public InputStream getInputStream() {
            int index = this.findLocalizedVersion(Translate.getLocale());
            return this.loaders.get(index).getResourceAsStream(this.names.get(index));
        }

        public URL getURL() {
            int index = this.findLocalizedVersion(Translate.getLocale());
            return this.loaders.get(index).getResource(this.names.get(index));
        }

        public String getName() {
            int index = this.findLocalizedVersion(Translate.getLocale());
            return this.names.get(index);
        }

        public ClassLoader getClassLoader() {
            int index = this.findLocalizedVersion(Translate.getLocale());
            return this.loaders.get(index);
        }
    }

    private static class JarInfo {
        File file;
        String name;
        String version;
        ArrayList<String> imports;
        ArrayList<String> plugins;
        ArrayList<String> categories;
        ArrayList<String> searchpath;
        ArrayList<ResourceInfo> resources;
        ArrayList<ExportInfo> exports;
        ClassLoader loader;

        JarInfo(File file) throws IOException {
            this.file = file;
            this.imports = new ArrayList();
            this.plugins = new ArrayList();
            this.categories = new ArrayList();
            this.searchpath = new ArrayList();
            this.resources = new ArrayList();
            this.exports = new ArrayList();
            ZipFile zf = new ZipFile(file);
            try {
                ZipEntry ze = zf.getEntry("extensions.xml");
                if (ze != null) {
                    BufferedInputStream in = new BufferedInputStream(zf.getInputStream(ze));
                    this.loadExtensionsFile(in);
                    return;
                }
                ze = zf.getEntry("plugins");
                if (ze != null) {
                    BufferedReader in = new BufferedReader(new InputStreamReader(zf.getInputStream(ze)));
                    this.loadPluginsFile(in);
                    return;
                }
                throw new IOException();
            }
            finally {
                zf.close();
            }
        }

        JarInfo(ClassLoader loader) throws IOException {
            this.loader = loader;
            this.imports = new ArrayList();
            this.plugins = new ArrayList();
            this.categories = new ArrayList();
            this.resources = new ArrayList();
            this.exports = new ArrayList();
            InputStream in = loader.getResourceAsStream("extensions.xml");
            if (in != null) {
                this.loadExtensionsFile(new BufferedInputStream(in));
                in.close();
                return;
            }
            in = loader.getResourceAsStream("plugins");
            if (in != null) {
                this.loadPluginsFile(new BufferedReader(new InputStreamReader(in)));
                in.close();
                return;
            }
            throw new IOException();
        }

        private void loadExtensionsFile(InputStream in) throws IOException {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(in);
                Element extensions = doc.getDocumentElement();
                if (!"extension".equals(extensions.getNodeName())) {
                    throw new Exception("The root element must be <extension>");
                }
                Node nameNode = extensions.getAttributes().getNamedItem("name");
                if (nameNode != null) {
                    this.name = nameNode.getNodeValue();
                }
                NodeList categoryList = doc.getElementsByTagName("category");
                for (int i = 0; i < categoryList.getLength(); ++i) {
                    Node category = categoryList.item(i);
                    this.categories.add(category.getAttributes().getNamedItem("class").getNodeValue());
                }
                NodeList pluginList = doc.getElementsByTagName("plugin");
                for (int i = 0; i < pluginList.getLength(); ++i) {
                    Node plugin = pluginList.item(i);
                    String className = plugin.getAttributes().getNamedItem("class").getNodeValue();
                    this.plugins.add(className);
                    NodeList children = plugin.getChildNodes();
                    for (int k = 0; k < children.getLength(); ++k) {
                        Node childNode = children.item(k);
                        if (!"export".equals(childNode.getNodeName())) continue;
                        ExportInfo export = new ExportInfo();
                        export.method = childNode.getAttributes().getNamedItem("method").getNodeValue();
                        export.id = childNode.getAttributes().getNamedItem("id").getNodeValue();
                        export.className = className;
                        this.exports.add(export);
                    }
                }
                NodeList importList = doc.getElementsByTagName("import");
                for (int i = 0; i < importList.getLength(); ++i) {
                    NamedNodeMap importMap = importList.item(i).getAttributes();
                    if (importMap.getNamedItem("name") != null) {
                        this.imports.add(importMap.getNamedItem("name").getNodeValue());
                        continue;
                    }
                    if (importMap.getNamedItem("url") == null) continue;
                    this.searchpath.add(importMap.getNamedItem("url").getNodeValue());
                }
                NodeList resourceList = doc.getElementsByTagName("resource");
                for (int i = 0; i < resourceList.getLength(); ++i) {
                    Node resourceNode = resourceList.item(i);
                    ResourceInfo resource = new ResourceInfo();
                    resource.type = resourceNode.getAttributes().getNamedItem("type").getNodeValue();
                    resource.id = resourceNode.getAttributes().getNamedItem("id").getNodeValue();
                    resource.name = resourceNode.getAttributes().getNamedItem("name").getNodeValue();
                    Node localeNode = resourceNode.getAttributes().getNamedItem("locale");
                    if (localeNode != null) {
                        String[] parts = localeNode.getNodeValue().split("_");
                        if (parts.length == 1) {
                            resource.locale = new Locale(parts[0]);
                        } else if (parts.length == 2) {
                            resource.locale = new Locale(parts[0], parts[1]);
                        } else if (parts.length == 3) {
                            resource.locale = new Locale(parts[0], parts[1], parts[2]);
                        }
                    }
                    this.resources.add(resource);
                }
            }
            catch (Exception ex) {
                System.err.println("*** Exception while parsing extensions.xml for plugin " + this.file.getName() + ":");
                ex.printStackTrace();
                throw new IOException();
            }
        }

        private void loadPluginsFile(BufferedReader in) throws IOException {
            String className = in.readLine();
            while (className != null) {
                this.plugins.add(className.trim());
                className = in.readLine();
            }
        }
    }
}

