/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.MeshViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.MeshEditingTool;
import artofillusion.ui.Translate;
import buoy.event.KeyPressedEvent;
import buoy.event.WidgetMouseEvent;
import java.awt.Point;

public class ReshapeMeshTool
extends MeshEditingTool {
    private Point clickPoint;
    private Vec3 clickPos;
    private Vec3[] baseVertPos;
    private UndoRecord undo;

    public ReshapeMeshTool(EditingWindow fr, MeshEditController controller) {
        super(fr, controller);
        this.initButton("movePoints");
    }

    @Override
    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("reshapeMeshTool.helpText"));
    }

    @Override
    public int whichClicks() {
        return 4;
    }

    @Override
    public boolean allowSelectionChanges() {
        return true;
    }

    @Override
    public String getToolTipText() {
        return Translate.text("reshapeMeshTool.tipText");
    }

    @Override
    public void mousePressedOnHandle(WidgetMouseEvent e, ViewerCanvas view, int obj, int handle) {
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        MeshVertex[] v = mesh.getVertices();
        this.clickPoint = e.getPoint();
        this.clickPos = v[handle].r;
        this.baseVertPos = mesh.getVertexPositions();
    }

    @Override
    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        MeshViewer mv = (MeshViewer)view;
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        Point dragPoint = e.getPoint();
        if (this.undo == null) {
            this.undo = new UndoRecord(this.theWindow, false, 13, new Object[]{mesh, mesh.getVertexPositions()});
        }
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (e.isShiftDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                dy = 0;
            } else {
                dx = 0;
            }
        }
        Vec3[] v = this.findDraggedPositions(this.clickPos, this.baseVertPos, dx, dy, mv, e.isControlDown(), this.controller.getSelectionDistance());
        mesh.setVertexPositions(v);
        this.controller.objectChanged();
        this.theWindow.updateImage();
        Vec3 drag = e.isControlDown() ? view.getCamera().getCameraCoordinates().getZDirection().times((double)(-dy) * 0.01) : view.getCamera().findDragVector(this.clickPos, dx, dy);
        this.theWindow.setHelpText(Translate.text("reshapeMeshTool.dragText", (Object)((double)Math.round(drag.x * 100000.0) / 100000.0 + ", " + (double)Math.round(drag.y * 100000.0) / 100000.0 + ", " + (double)Math.round(drag.z * 100000.0) / 100000.0)));
    }

    @Override
    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        Point dragPoint = e.getPoint();
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (e.isShiftDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                dy = 0;
            } else {
                dx = 0;
            }
        }
        if (dx != 0 || dy != 0) {
            if (this.undo != null) {
                this.theWindow.setUndoRecord(this.undo);
            }
            Vec3[] v = this.findDraggedPositions(this.clickPos, this.baseVertPos, dx, dy, (MeshViewer)view, e.isControlDown(), this.controller.getSelectionDistance());
            mesh.setVertexPositions(v);
        }
        this.controller.objectChanged();
        this.theWindow.updateImage();
        this.theWindow.setHelpText(Translate.text("reshapeMeshTool.helpText"));
        this.undo = null;
        this.baseVertPos = null;
    }

    @Override
    public void keyPressed(KeyPressedEvent e, ViewerCanvas view) {
        int i;
        double dy;
        double dx;
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        Vec3[] vert = mesh.getVertexPositions();
        int[] selectDist = this.controller.getSelectionDistance();
        int key = e.getKeyCode();
        if (key == 38) {
            dx = 0.0;
            dy = -1.0;
        } else if (key == 40) {
            dx = 0.0;
            dy = 1.0;
        } else if (key == 37) {
            dx = -1.0;
            dy = 0.0;
        } else if (key == 39) {
            dx = 1.0;
            dy = 0.0;
        } else {
            return;
        }
        e.consume();
        for (i = 0; i < vert.length && selectDist[i] != 0; ++i) {
        }
        if (i == vert.length) {
            return;
        }
        if (view.getSnapToGrid()) {
            double scale = view.getGridSpacing() * view.getScale();
            if (!e.isAltDown()) {
                scale /= (double)view.getSnapToSubdivisions();
            }
            dx *= scale;
            dy *= scale;
        } else if (e.isAltDown()) {
            dx *= 10.0;
            dy *= 10.0;
        }
        this.theWindow.setUndoRecord(new UndoRecord(this.theWindow, false, 13, new Object[]{mesh, vert}));
        Vec3[] v = this.findDraggedPositions(vert[i], vert, dx, dy, (MeshViewer)view, e.isControlDown(), selectDist);
        mesh.setVertexPositions(v);
        this.controller.objectChanged();
        this.theWindow.updateImage();
    }

    private Vec3[] findDraggedPositions(Vec3 pos, Vec3[] vert, double dx, double dy, MeshViewer view, boolean controlDown, int[] selectDist) {
        int i;
        int maxDistance = view.getController().getTensionDistance();
        double tension = view.getController().getMeshTension();
        Vec3[] drag = new Vec3[maxDistance + 1];
        Vec3[] v = new Vec3[vert.length];
        drag[0] = controlDown ? view.getCamera().getCameraCoordinates().getZDirection().times(-dy * 0.01) : view.getCamera().findDragVector(pos, dx, dy);
        for (i = 1; i <= maxDistance; ++i) {
            drag[i] = drag[0].times(Math.pow(((double)(maxDistance - i) + 1.0) / ((double)maxDistance + 1.0), tension));
        }
        if (view.getUseWorldCoords()) {
            Mat4 trans = view.getDisplayCoordinates().toLocal();
            for (int i2 = 0; i2 < drag.length; ++i2) {
                trans.transformDirection(drag[i2]);
            }
        }
        for (i = 0; i < vert.length; ++i) {
            v[i] = selectDist[i] > -1 ? vert[i].plus(drag[selectDist[i]]) : new Vec3(vert[i]);
        }
        return v;
    }
}

