/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class SafeFileOutputStream
extends FilterOutputStream {
    public static final int OVERWRITE = 0;
    public static final int CREATE = 1;
    public static final int APPEND = 2;
    public static final int KEEP_BACKUP = 128;
    private String path = null;
    private File file = null;
    private int mode = -1;
    private byte[] array = null;

    public SafeFileOutputStream(String path, int mode) throws IOException {
        super(null);
        this.open(path, mode);
    }

    public SafeFileOutputStream(File file, int mode) throws IOException {
        super(null);
        this.open(file, mode);
    }

    public void open(String path, int mode) throws IOException {
        this.open(new File(path), mode);
    }

    public void open(File file, int mode) throws IOException {
        if (this.out != null) {
            this.abort();
        }
        this.file = file;
        this.path = file.getPath();
        this.mode = mode;
        if ((mode & 1) > 0 && file.exists()) {
            throw new IOException("File exists: " + this.path);
        }
        this.out = new FileOutputStream(this.path + ".tmp");
        if ((mode & 2) > 0 && file.exists()) {
            FileInputStream in = new FileInputStream(file);
            if (this.array == null) {
                this.array = new byte[10000];
            }
            int count = 0;
            do {
                if ((count = in.read(this.array)) <= 0) continue;
                this.out.write(this.array, 0, count);
            } while (count >= 0);
        }
    }

    public void abort() throws IOException {
        if (this.out != null) {
            this.out.close();
            this.out = null;
            File temp = new File(this.path + ".tmp");
            if (temp.exists()) {
                temp.delete();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.out.flush();
        this.out.close();
        this.out = null;
        File bak = null;
        try {
            bak = new File(this.path + ".bak");
            if (bak.exists() && !bak.delete()) {
                throw new IOException("SafeFileOutputStream.close: could not delete backup file");
            }
            if (this.file.exists() && !this.file.renameTo(bak)) {
                throw new IOException("SafeFileOutputStream.close: could not create backup file");
            }
            File temp = new File(this.path + ".tmp");
            if (!temp.renameTo(this.file)) {
                throw new IOException("SafeFileOutputStream.close: could not make file live");
            }
        }
        finally {
            if (bak != null && bak.exists()) {
                if (!this.file.exists() && !bak.renameTo(this.file)) {
                    throw new IOException("SafeFileOutputStream.close: Error recovering from backup.\nFailed to rename " + bak.getAbsolutePath() + " to " + this.file.getAbsolutePath());
                }
                if ((this.mode & 0x80) == 0 && !bak.delete()) {
                    throw new IOException("SafeFileOutputStream.close: could not delete backup file");
                }
            }
        }
    }

    @Override
    public void write(byte[] array) throws IOException {
        this.out.write(array, 0, array.length);
    }

    @Override
    public void write(byte[] array, int start, int length) throws IOException {
        this.out.write(array, start, length);
    }

    @Override
    public void write(int value) throws IOException {
        this.out.write(value);
    }
}

