/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.Joint;
import artofillusion.animation.Keyframe;
import artofillusion.animation.ObjectRef;
import artofillusion.animation.ObjectRefSelector;
import artofillusion.animation.Skeleton;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.animation.VectorKeyframe;
import artofillusion.animation.WeightTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.BTextField;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.Map;

public class PositionTrack
extends Track {
    ObjectInfo info;
    Timecourse tc;
    int smoothingMethod;
    int mode;
    int relCoords;
    int joint;
    ObjectRef relObject;
    WeightTrack theWeight;
    boolean enablex;
    boolean enabley;
    boolean enablez;
    public static final int ABSOLUTE = 0;
    public static final int RELATIVE = 1;
    public static final int WORLD = 0;
    public static final int PARENT = 1;
    public static final int OBJECT = 2;
    public static final int LOCAL = 3;

    public PositionTrack(ObjectInfo info) {
        this(info, "Position", true, true, true);
    }

    public PositionTrack(ObjectInfo info, String name, boolean affectX, boolean affectY, boolean affectZ) {
        super(name);
        this.info = info;
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.smoothingMethod = 2;
        this.mode = 0;
        this.relCoords = 1;
        this.relObject = new ObjectRef();
        this.theWeight = new WeightTrack(this);
        this.enablex = affectX;
        this.enabley = affectY;
        this.enablez = affectZ;
        this.joint = -1;
    }

    @Override
    public void apply(double time) {
        Joint j;
        Vec3 pos = (VectorKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        double weight = this.theWeight.getWeight(time);
        if (pos == null) {
            return;
        }
        Vec3 v = this.info.getCoords().getOrigin();
        if (this.mode == 0) {
            double w = 1.0 - weight;
            if (this.enablex) {
                v.x *= w;
            }
            if (this.enabley) {
                v.y *= w;
            }
            if (this.enablez) {
                v.z *= w;
            }
        }
        if (this.mode == 0 && this.relCoords == 1) {
            if (this.info.getParent() != null) {
                pos = this.info.getParent().getCoords().fromLocal().times(pos);
            }
        } else if (this.mode == 0 && this.relCoords == 2) {
            CoordinateSystem coords = this.relObject.getCoords();
            if (coords != null) {
                pos = coords.fromLocal().times(pos);
            }
        } else if (this.mode == 1 && this.relCoords == 1) {
            if (this.info.getParent() != null) {
                pos = this.info.getParent().getCoords().fromLocal().timesDirection(pos);
            }
        } else if (this.mode == 1 && this.relCoords == 2) {
            CoordinateSystem coords = this.relObject.getCoords();
            if (coords != null) {
                pos = coords.fromLocal().timesDirection(pos);
            }
        } else if (this.mode == 1 && this.relCoords == 3) {
            pos = this.info.getCoords().fromLocal().timesDirection(pos);
        }
        if (this.joint > -1 && this.mode == 0 && (j = this.info.getSkeleton().getJoint(this.joint)) != null) {
            if (this.info.getPose() != null && !this.info.getPose().equals(this.info.getObject().getPoseKeyframe())) {
                this.info.getObject().applyPoseKeyframe(this.info.getPose());
                j = this.info.getSkeleton().getJoint(this.joint);
            }
            pos = pos.minus(new ObjectRef(this.info, j).getCoords().getOrigin());
            pos.add(this.info.getCoords().getOrigin());
        }
        if (this.enablex) {
            v.x += pos.x * weight;
        }
        if (this.enabley) {
            v.y += pos.y * weight;
        }
        if (this.enablez) {
            v.z += pos.z * weight;
        }
        this.info.getCoords().setOrigin(v);
    }

    @Override
    public Track duplicate(Object obj) {
        PositionTrack t = new PositionTrack((ObjectInfo)obj);
        t.name = this.name;
        t.enabled = this.enabled;
        t.quantized = this.quantized;
        t.mode = this.mode;
        t.relCoords = this.relCoords;
        t.smoothingMethod = this.smoothingMethod;
        t.tc = this.tc.duplicate((ObjectInfo)obj);
        t.relObject = this.relObject.duplicate();
        t.theWeight = (WeightTrack)this.theWeight.duplicate(t);
        t.enablex = this.enablex;
        t.enabley = this.enabley;
        t.enablez = this.enablez;
        t.joint = this.joint;
        return t;
    }

    @Override
    public void copy(Track tr) {
        PositionTrack t = (PositionTrack)tr;
        this.name = t.name;
        this.enabled = t.enabled;
        this.quantized = t.quantized;
        this.mode = t.mode;
        this.relCoords = t.relCoords;
        this.smoothingMethod = t.smoothingMethod;
        this.tc = t.tc.duplicate(this.info);
        this.relObject = t.relObject.duplicate();
        this.theWeight = (WeightTrack)t.theWeight.duplicate(this);
        this.enablex = t.enablex;
        this.enabley = t.enabley;
        this.enablez = t.enablez;
        this.joint = t.joint;
    }

    @Override
    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    @Override
    public Timecourse getTimecourse() {
        return this.tc;
    }

    @Override
    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        this.tc.addTimepoint(k, time, s);
    }

    @Override
    public Keyframe setKeyframe(double time, Scene sc) {
        CoordinateSystem coords;
        Joint j;
        Vec3 pos = this.info.getCoords().getOrigin();
        if (this.joint > -1 && this.mode == 0 && (j = this.info.getSkeleton().getJoint(this.joint)) != null) {
            pos = new ObjectRef(this.info, j).getCoords().getOrigin();
        }
        if (this.relCoords == 1) {
            if (this.info.getParent() != null) {
                pos = this.info.getParent().getCoords().toLocal().times(pos);
            }
        } else if (this.relCoords == 2 && (coords = this.relObject.getCoords()) != null) {
            pos = coords.toLocal().times(pos);
        }
        VectorKeyframe k = new VectorKeyframe(pos);
        this.tc.addTimepoint(k, time, new Smoothness());
        return k;
    }

    @Override
    public Keyframe setKeyframeIfModified(double time, Scene sc) {
        CoordinateSystem coords;
        Joint j;
        if (this.tc.getTimes().length == 0) {
            return this.setKeyframe(time, sc);
        }
        VectorKeyframe pos = (VectorKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        Vec3 current = this.info.getCoords().getOrigin();
        if (this.joint > -1 && this.mode == 0 && (j = this.info.getSkeleton().getJoint(this.joint)) != null) {
            current = new ObjectRef(this.info, j).getCoords().getOrigin();
        }
        if (this.relCoords == 1) {
            if (this.info.getParent() != null) {
                current = this.info.getParent().getCoords().toLocal().times(current);
            }
        } else if (this.relCoords == 2 && (coords = this.relObject.getCoords()) != null) {
            current = coords.toLocal().times(current);
        }
        if (this.enablex && Math.abs(pos.x - current.x) > 1.0E-10 || this.enabley && Math.abs(pos.y - current.y) > 1.0E-10 || this.enablez && Math.abs(pos.z - current.z) > 1.0E-10) {
            return this.setKeyframe(time, sc);
        }
        return null;
    }

    @Override
    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    @Override
    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    @Override
    public boolean isNullTrack() {
        return this.tc.getTimes().length == 0;
    }

    public boolean affectsX() {
        return this.enablex;
    }

    public boolean affectsY() {
        return this.enabley;
    }

    public boolean affectsZ() {
        return this.enablez;
    }

    @Override
    public Track[] getSubtracks() {
        return new Track[]{this.theWeight};
    }

    @Override
    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo;
    }

    @Override
    public Object getParent() {
        return this.info;
    }

    @Override
    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    @Override
    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    public boolean isRelative() {
        return this.mode == 1;
    }

    public void setRelative(boolean rel) {
        this.mode = rel ? 1 : 0;
    }

    public int getCoordinateSystem() {
        return this.relCoords;
    }

    public void setCoordinateSystem(int system) {
        this.relCoords = system;
    }

    public ObjectRef getCoordsObject() {
        return this.relObject;
    }

    public void setCoordsObject(ObjectRef obj) {
        this.relObject = obj;
        this.relCoords = 2;
    }

    public int getApplyToJoint() {
        return this.joint;
    }

    public void setApplyToJoint(int jointID) {
        this.joint = jointID;
    }

    @Override
    public String[] getValueNames() {
        return new String[]{"X", "Y", "Z"};
    }

    @Override
    public double[] getDefaultGraphValues() {
        Vec3 pos = this.info.getCoords().getOrigin();
        return new double[]{pos.x, pos.y, pos.z};
    }

    @Override
    public double[][] getValueRange() {
        double[][] range = new double[3][2];
        for (int i = 0; i < range.length; ++i) {
            range[i][0] = -1.7976931348623157E308;
            range[i][1] = Double.MAX_VALUE;
        }
        return range;
    }

    @Override
    public ObjectInfo[] getDependencies() {
        if (this.relCoords == 2) {
            ObjectInfo relInfo = this.relObject.getObject();
            if (relInfo != null) {
                return new ObjectInfo[]{relInfo};
            }
        } else if (this.relCoords == 1 && this.info.getParent() != null) {
            return new ObjectInfo[]{this.info.getParent()};
        }
        return new ObjectInfo[0];
    }

    @Override
    public void deleteDependencies(ObjectInfo obj) {
        if (this.relObject.getObject() == obj) {
            this.relObject = new ObjectRef();
        }
    }

    @Override
    public void updateObjectReferences(Map<ObjectInfo, ObjectInfo> objectMap) {
        if (objectMap.containsKey(this.relObject.getObject())) {
            ObjectInfo newObject = objectMap.get(this.relObject.getObject());
            this.relObject = this.relObject.getJoint() == null ? new ObjectRef(newObject) : new ObjectRef(newObject, newObject.getSkeleton().getJoint(this.relObject.getJoint().id));
        }
    }

    @Override
    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(1);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(this.smoothingMethod);
        out.writeInt(this.mode);
        out.writeInt(this.relCoords);
        out.writeInt(this.joint);
        out.writeBoolean(this.enablex);
        out.writeBoolean(this.enabley);
        out.writeBoolean(this.enablez);
        out.writeInt(t.length);
        for (int i = 0; i < t.length; ++i) {
            out.writeDouble(t[i]);
            ((VectorKeyframe)v[i]).writeToFile(out);
            s[i].writeToStream(out);
        }
        if (this.relCoords == 2) {
            this.relObject.writeToStream(out);
        }
        this.theWeight.writeToStream(out, scene);
    }

    @Override
    public void initFromStream(DataInputStream in, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.smoothingMethod = in.readInt();
        this.mode = in.readInt();
        this.relCoords = in.readInt();
        this.joint = version == 0 ? -1 : in.readInt();
        this.enablex = in.readBoolean();
        this.enabley = in.readBoolean();
        this.enablez = in.readBoolean();
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        for (int i = 0; i < keys; ++i) {
            t[i] = in.readDouble();
            v[i] = new VectorKeyframe(new Vec3(in));
            s[i] = new Smoothness(in);
        }
        this.tc = new Timecourse(v, t, s);
        this.relObject = this.relCoords == 2 ? new ObjectRef(in, scene) : new ObjectRef();
        this.theWeight.initFromStream(in, scene);
    }

    @Override
    public void editKeyframe(LayoutWindow win, int which) {
        VectorKeyframe key = (VectorKeyframe)this.tc.getValues()[which];
        Smoothness s = this.tc.getSmoothness()[which];
        double time = this.tc.getTimes()[which];
        ValueField xField = new ValueField(key.x, 0, 5);
        ValueField yField = new ValueField(key.y, 0, 5);
        ValueField zField = new ValueField(key.z, 0, 5);
        ValueField timeField = new ValueField(time, 0, 5);
        ValueSlider s1Slider = new ValueSlider(0.0, 1.0, 100, s.getLeftSmoothness());
        final ValueSlider s2Slider = new ValueSlider(0.0, 1.0, 100, s.getRightSmoothness());
        final BCheckBox sameBox = new BCheckBox(Translate.text("separateSmoothness"), !s.isForceSame());
        sameBox.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                s2Slider.setEnabled(sameBox.getState());
            }
        });
        s2Slider.setEnabled(sameBox.getState());
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("editKeyframe"), new Widget[]{xField, yField, zField, timeField, sameBox, new BLabel(Translate.text("Smoothness") + ':'), s1Slider, s2Slider}, new String[]{"X", "Y", "Z", Translate.text("Time"), null, null, "(" + Translate.text("left") + ")", "(" + Translate.text("right") + ")"});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.info)}));
        key.x = xField.getValue();
        key.y = yField.getValue();
        key.z = zField.getValue();
        if (sameBox.getState()) {
            s.setSmoothness(s1Slider.getValue(), s2Slider.getValue());
        } else {
            s.setSmoothness(s1Slider.getValue());
        }
        this.moveKeyframe(which, timeField.getValue());
    }

    @Override
    public void edit(LayoutWindow win) {
        Skeleton s = this.info.getSkeleton();
        Joint[] j = s == null ? null : s.getJoints();
        BTextField nameField = new BTextField(this.getName());
        BComboBox smoothChoice = new BComboBox(new String[]{Translate.text("Discontinuous"), Translate.text("Linear"), Translate.text("Interpolating"), Translate.text("Approximating")});
        smoothChoice.setSelectedIndex(this.smoothingMethod);
        final BComboBox modeChoice = new BComboBox(new String[]{Translate.text("Absolute"), Translate.text("Relative")});
        modeChoice.setSelectedIndex(this.mode);
        final BComboBox coordsChoice = new BComboBox(new String[]{Translate.text("World"), Translate.text("Parent"), Translate.text("OtherObject")});
        if (this.mode == 1) {
            coordsChoice.add(Translate.text("Local"));
        }
        coordsChoice.setSelectedIndex(this.relCoords);
        BComboBox jointChoice = new BComboBox();
        jointChoice.add(Translate.text("objectOrigin"));
        if (j != null) {
            int i;
            for (i = 0; i < j.length; ++i) {
                jointChoice.add(j[i].name);
            }
            for (i = 0; i < j.length; ++i) {
                if (j[i].id != this.joint) continue;
                jointChoice.setSelectedIndex(i + 1);
            }
        }
        final ObjectRefSelector objSelector = new ObjectRefSelector(this.relObject, win, Translate.text("positionRelativeTo"), this.info);
        objSelector.setEnabled(coordsChoice.getSelectedIndex() == 2);
        modeChoice.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                int sel = modeChoice.getSelectedIndex();
                if (sel == 0 && coordsChoice.getItemCount() == 4) {
                    coordsChoice.remove(3);
                }
                if (sel == 1 && coordsChoice.getItemCount() == 3) {
                    coordsChoice.add(Translate.text("Local"));
                }
                objSelector.setEnabled(coordsChoice.getSelectedIndex() == 2);
            }
        });
        coordsChoice.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                objSelector.setEnabled(coordsChoice.getSelectedIndex() == 2);
            }
        });
        RowContainer row = new RowContainer();
        BCheckBox xbox = new BCheckBox("X", this.enablex);
        row.add(xbox);
        BCheckBox ybox = new BCheckBox("Y", this.enabley);
        row.add(ybox);
        BCheckBox zbox = new BCheckBox("Z", this.enablez);
        row.add(zbox);
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("positionTrackTitle"), new Widget[]{nameField, smoothChoice, modeChoice, jointChoice, coordsChoice, objSelector, row}, new String[]{Translate.text("trackName"), Translate.text("SmoothingMethod"), Translate.text("trackMode"), Translate.text("applyTo"), Translate.text("CoordinateSystem"), "", Translate.text("trackAffects")});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 2, new Object[]{this.info, this.info.duplicate()}));
        this.setName(nameField.getText());
        this.smoothingMethod = smoothChoice.getSelectedIndex();
        this.mode = modeChoice.getSelectedIndex();
        this.relCoords = coordsChoice.getSelectedIndex();
        this.relObject = objSelector.getSelection();
        this.joint = jointChoice.getSelectedIndex() == 0 ? -1 : j[jointChoice.getSelectedIndex() - 1].id;
        this.enablex = xbox.getState();
        this.enabley = ybox.getState();
        this.enablez = zbox.getState();
    }
}

