/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Marker;
import artofillusion.animation.PoseTrack;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.animation.SelectionInfo;
import artofillusion.animation.TimeAxis;
import artofillusion.animation.Track;
import artofillusion.animation.TrackDisplay;
import artofillusion.animation.TrackGraph;
import artofillusion.animation.TrackTreeElement;
import artofillusion.animation.TracksPanel;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.GenericTool;
import artofillusion.ui.ObjectTreeElement;
import artofillusion.ui.PopupMenuManager;
import artofillusion.ui.Spacer;
import artofillusion.ui.ThemeManager;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.TreeElement;
import artofillusion.ui.TreeList;
import artofillusion.ui.UIUtilities;
import buoy.event.CommandEvent;
import buoy.event.MouseScrolledEvent;
import buoy.event.RepaintEvent;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BMenuItem;
import buoy.widget.BPopupMenu;
import buoy.widget.BScrollBar;
import buoy.widget.BSeparator;
import buoy.widget.BSlider;
import buoy.widget.BSplitPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.lang.reflect.Constructor;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;

public class Score
extends BorderContainer
implements EditingWindow,
PopupMenuManager {
    LayoutWindow window;
    TreeList theList;
    TimeAxis theAxis;
    private final List<TrackDisplay> graphs;
    BScrollBar scroll;
    ToolPalette viewTools;
    ToolPalette modeTools;
    BLabel helpText;
    BSplitPane div;
    BPopupMenu popupMenu;
    BMenuItem[] popupMenuItem;
    Marker timeMarker;
    private SelectionInfo[] selection;
    int scrollPos;
    int mode;
    int view;
    double startTime;
    double timeScale;
    int yoffset;
    private boolean[] hasRepaintedView;
    private boolean isAnimating;
    private long animateStartClockTime;
    private double animateStartSceneTime;
    private double playbackSpeed;
    private final BButton playButton;
    private final BButton rewindButton;
    private final BButton endButton;
    private final BSlider speedSlider;
    private final BLabel speedLabel;
    private final BLabel timeFrameLabel;
    private final ImageIcon playIcon;
    private final ImageIcon stopIcon;
    public static final int TRACKS_MODE = 0;
    public static final int SINGLE_GRAPH_MODE = 1;
    public static final int MULTI_GRAPH_MODE = 2;
    public static final int SELECT_AND_MOVE = 0;
    public static final int SCROLL_AND_SCALE = 1;
    private final String[] MODE_HELP_TEXT = new String[]{Translate.text("moveKeyframeTool.helpText"), Translate.text("moveScoreTool.helpText")};
    private final double[] SPEEDS = new double[]{0.2, 0.3, 0.4, 0.5, 0.6, 0.8, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0};

    public Score(LayoutWindow win) {
        this.window = win;
        this.playIcon = ThemeManager.getIcon("play");
        this.stopIcon = ThemeManager.getIcon("stop");
        this.playButton = new BButton(this.playIcon);
        this.rewindButton = new BButton(ThemeManager.getIcon("rewind"));
        this.endButton = new BButton(ThemeManager.getIcon("forward"));
        this.playButton.addEventLink(CommandEvent.class, (Object)this, "clickedPlay");
        this.rewindButton.addEventLink(CommandEvent.class, (Object)this, "clickedRewind");
        this.endButton.addEventLink(CommandEvent.class, (Object)this, "clickedEnd");
        this.speedSlider = new BSlider(this.SPEEDS.length / 2, 0, this.SPEEDS.length - 1, BSlider.HORIZONTAL);
        this.speedSlider.addEventLink(ValueChangedEvent.class, (Object)this, "speedChanged");
        this.speedSlider.setMinorTickSpacing(1);
        this.speedSlider.setSnapToTicks(true);
        this.speedSlider.getComponent().setPreferredSize(new Dimension(1, this.speedSlider.getPreferredSize().height));
        this.speedLabel = new BLabel();
        this.speedLabel.setAlignment(BLabel.CENTER);
        this.timeFrameLabel = new BLabel();
        this.timeFrameLabel.setAlignment(BLabel.NORTH);
        RowContainer controlButtons = new RowContainer();
        controlButtons.add(this.rewindButton);
        controlButtons.add(this.playButton);
        controlButtons.add(this.endButton);
        FormContainer controlsContainer = new FormContainer(new double[]{1.0, 0.0}, new double[]{0.0, 0.0, 0.0, 1.0});
        controlsContainer.add(controlButtons, 0, 0, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE));
        controlsContainer.add(this.speedLabel, 0, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL));
        controlsContainer.add(this.speedSlider, 0, 2, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL));
        controlsContainer.add(this.timeFrameLabel, 0, 3, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH));
        controlsContainer.add(new BSeparator(BSeparator.VERTICAL), 1, 0, 1, 4);
        this.theList = new TreeList(win);
        this.theList.setPreferredSize(new Dimension(130, 0));
        this.theList.addEventLink(TreeList.ElementMovedEvent.class, (Object)this, "elementsMoved");
        this.theList.addEventLink(TreeList.ElementExpandedEvent.class, (Object)this, "elementOpenedOrClosed");
        this.theList.addEventLink(TreeList.ElementDoubleClickedEvent.class, (Object)this, "elementDoubleClicked");
        this.theList.addEventLink(SelectionChangedEvent.class, (Object)this, "treeSelectionChanged");
        this.theList.setPopupMenuManager(this);
        this.selection = new SelectionInfo[0];
        int fps = this.window.getScene().getFramesPerSecond();
        this.timeScale = (double)fps * 5.0;
        this.theAxis = new TimeAxis(fps, this.timeScale, this);
        this.graphs = new Vector<TrackDisplay>();
        this.timeMarker = new Marker(this.window.getScene().getTime(), Translate.text("Time"), Color.green);
        this.theAxis.addMarker(this.timeMarker);
        this.scroll = new BScrollBar(0, 0, 0, 0, BScrollBar.VERTICAL);
        this.scroll.addEventLink(ValueChangedEvent.class, (Object)this, "scrollbarChanged");
        this.viewTools = new ToolPalette(1, 3);
        this.modeTools = new ToolPalette(1, 2);
        this.viewTools.addTool(new GenericTool(this, "trackMode", Translate.text("trackModeTool.tipText")));
        this.viewTools.addTool(new GenericTool(this, "singleMode", Translate.text("singleGraphModeTool.tipText")));
        this.viewTools.addTool(new GenericTool(this, "multiMode", Translate.text("multiGraphModeTool.tipText")));
        this.modeTools.addTool(new GenericTool(this, "moveKey", Translate.text("moveKeyframeTool.tipText")));
        this.modeTools.addTool(new GenericTool(this, "panTrack", Translate.text("moveScoreTool.tipText")));
        BorderContainer treeContainer = new BorderContainer();
        treeContainer.add(new Spacer(this.theList, this.theAxis), BorderContainer.NORTH);
        treeContainer.add(this.theList, BorderContainer.CENTER);
        this.div = new BSplitPane(BSplitPane.HORIZONTAL, treeContainer, null);
        this.div.setResizeWeight(0.0);
        this.div.resetToPreferredSizes();
        this.div.getComponent().setBorder(null);
        this.layoutGraphs();
        this.add(this.div, BorderContainer.CENTER);
        FormContainer rightSide = new FormContainer(new double[]{1.0, 1.0}, new double[]{0.0, 0.0, 1.0});
        rightSide.add(this.scroll, 0, 0, 1, 3, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.VERTICAL, null, null));
        rightSide.add(this.viewTools, 1, 0);
        rightSide.add(this.modeTools, 1, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(0, 5, 0, 0), null));
        this.add(controlsContainer, BorderContainer.WEST);
        this.add(rightSide, BorderContainer.EAST);
        this.helpText = new BLabel(this.MODE_HELP_TEXT[this.mode]);
        this.add(this.helpText, BorderContainer.SOUTH);
        this.rebuildList();
        this.createPopupMenu();
        this.setFocusable(true);
        this.setPlaybackSeed(1.0);
        UIUtilities.applyDefaultBackground(controlsContainer);
        UIUtilities.applyDefaultBackground(rightSide);
    }

    private void createPopupMenu() {
        this.popupMenu = new BPopupMenu();
        this.popupMenuItem = new BMenuItem[5];
        this.popupMenuItem[0] = Translate.menuItem("editTrack", this, "editSelectedTrack", null);
        this.popupMenu.add(this.popupMenuItem[0]);
        this.popupMenuItem[1] = Translate.menuItem("duplicateTracks", this, "duplicateSelectedTracks", null);
        this.popupMenu.add(this.popupMenuItem[1]);
        this.popupMenuItem[2] = Translate.menuItem("deleteTracks", this, "deleteSelectedTracks", null);
        this.popupMenu.add(this.popupMenuItem[2]);
        this.popupMenuItem[3] = Translate.menuItem("enableTracks", this.window, "actionPerformed", null);
        this.popupMenu.add(this.popupMenuItem[3]);
        this.popupMenuItem[4] = Translate.menuItem("disableTracks", this.window, "actionPerformed", null);
        this.popupMenu.add(this.popupMenuItem[4]);
    }

    @Override
    public void showPopupMenu(Widget w, int x, int y) {
        Track[] selTrack = this.getSelectedTracks();
        boolean enable = false;
        boolean disable = false;
        for (int i = 0; i < selTrack.length; ++i) {
            if (selTrack[i].isEnabled()) {
                disable = true;
                continue;
            }
            enable = true;
        }
        this.popupMenuItem[0].setEnabled(selTrack.length == 1);
        this.popupMenuItem[1].setEnabled(selTrack.length > 0);
        this.popupMenuItem[2].setEnabled(selTrack.length > 0);
        this.popupMenuItem[3].setEnabled(enable);
        this.popupMenuItem[4].setEnabled(disable);
        this.popupMenu.show(w, x, y);
    }

    public BPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public Track[] getSelectedTracks() {
        Object[] obj = this.theList.getSelectedObjects();
        Track[] tr = new Track[obj.length];
        for (int i = 0; i < tr.length; ++i) {
            tr[i] = (Track)obj[i];
        }
        return tr;
    }

    public SelectionInfo[] getSelectedKeyframes() {
        return this.selection;
    }

    public void setSelectedKeyframes(SelectionInfo[] sel) {
        this.selection = sel;
        for (int i = 0; i < this.graphs.size(); ++i) {
            ((Widget)((Object)this.graphs.get(i))).repaint();
        }
        this.window.updateMenus();
    }

    public void addSelectedKeyframes(SelectionInfo[] newsel) {
        int i;
        Vector<SelectionInfo> v = new Vector<SelectionInfo>();
        for (i = 0; i < this.selection.length; ++i) {
            v.add(this.selection[i]);
        }
        for (i = 0; i < newsel.length; ++i) {
            int j;
            for (j = 0; j < this.selection.length; ++j) {
                if (newsel[i].key != this.selection[j].key) continue;
                for (int k = 0; k < newsel[i].selected.length; ++k) {
                    int n = k;
                    this.selection[j].selected[n] = this.selection[j].selected[n] | newsel[i].selected[k];
                }
                break;
            }
            if (j != this.selection.length) continue;
            v.add(newsel[i]);
        }
        this.selection = new SelectionInfo[v.size()];
        for (i = 0; i < this.selection.length; ++i) {
            this.selection[i] = (SelectionInfo)v.get(i);
        }
        this.window.updateMenus();
    }

    public void removeSelectedKeyframe(Keyframe key) {
        int i;
        Vector<SelectionInfo> v = new Vector<SelectionInfo>();
        for (i = 0; i < this.selection.length; ++i) {
            if (this.selection[i].key == key) continue;
            v.add(this.selection[i]);
        }
        this.selection = new SelectionInfo[v.size()];
        for (i = 0; i < this.selection.length; ++i) {
            this.selection[i] = (SelectionInfo)v.get(i);
        }
        this.window.updateMenus();
    }

    public boolean isKeyframeSelected(Keyframe k) {
        for (int i = 0; i < this.selection.length; ++i) {
            if (this.selection[i].key != k) continue;
            return true;
        }
        return false;
    }

    public boolean isKeyframeSelected(Keyframe k, int value) {
        for (int i = 0; i < this.selection.length; ++i) {
            if (this.selection[i].key != k) continue;
            return this.selection[i].selected.length > value && this.selection[i].selected[value];
        }
        return false;
    }

    public void rebuildList() {
        int i;
        ObjectTreeElement el;
        Scene theScene = this.window.getScene();
        TreeElement[] allEl = this.theList.getElements();
        this.theList.setUpdateEnabled(false);
        this.theList.removeAllElements();
        for (ObjectInfo info : theScene.getObjects()) {
            if (!info.selected) continue;
            el = new ObjectTreeElement(info, null, this.theList, false);
            this.theList.addElement(el);
            el.setExpanded(true);
        }
        for (ObjectInfo info : theScene.getObjects()) {
            if (!info.selected || info.getTracks().length == 0) continue;
            el = (ObjectTreeElement)this.theList.findElement(info);
            el.addTracks();
        }
        for (i = 0; i < allEl.length; ++i) {
            TreeElement el2 = this.theList.findElement(allEl[i].getObject());
            if (el2 == null) continue;
            el2.setExpanded(allEl[i].isExpanded());
            el2.setSelected(allEl[i].isSelected());
        }
        allEl = this.theList.getElements();
        for (i = 0; i < allEl.length; ++i) {
            allEl[i].setSelectable(allEl[i] instanceof TrackTreeElement);
        }
        this.theList.setUpdateEnabled(true);
        this.selectedTracksChanged();
        this.updateScrollbar();
        this.repaintGraphs();
        this.setScrollPosition(this.scrollPos);
    }

    private void layoutGraphs() {
        FormContainer graphContainer;
        Track[] tr = this.getSelectedTracks();
        this.graphs.clear();
        int divider = this.div.getDividerLocation();
        if (this.view == 0) {
            graphContainer = new FormContainer(new double[]{1.0}, new double[]{0.0, 1.0});
            TracksPanel theTracks = new TracksPanel(this.window, this.theList, this, this.window.getScene().getFramesPerSecond(), this.timeScale);
            theTracks.setStartTime(this.startTime);
            theTracks.addMarker(this.timeMarker);
            theTracks.setMode(this.mode);
            graphContainer.add(this.theAxis, 0, 0, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(0, 0, 2, 0), null));
            graphContainer.add(theTracks, 0, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
            this.graphs.add(theTracks);
            this.div.add(graphContainer, 1);
            graphContainer.addEventLink(MouseScrolledEvent.class, (Object)this, "mouseScrolled");
        } else if (this.view == 1 || tr.length == 0) {
            graphContainer = new FormContainer(new double[]{0.0, 1.0}, new double[]{0.0, 1.0});
            TrackGraph gr = new TrackGraph(this.window, this, this.theAxis);
            gr.setSubdivisions(this.window.getScene().getFramesPerSecond());
            gr.setStartTime(this.startTime);
            gr.setScale(this.timeScale);
            gr.addMarker(this.timeMarker);
            gr.setMode(this.mode);
            gr.setTracks(tr);
            gr.setBackground(Color.white);
            graphContainer.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
            graphContainer.add(this.theAxis, 1, 0, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(0, 0, 2, 0), null));
            graphContainer.add(gr.getAxis(), 0, 1);
            graphContainer.add(gr, 1, 1);
            this.graphs.add(gr);
            this.div.add(graphContainer, 1);
            graphContainer.addEventLink(MouseScrolledEvent.class, (Object)this, "mouseScrolled");
        } else if (this.view == 2) {
            double[] weight = new double[tr.length + 1];
            for (int i = 1; i < weight.length; ++i) {
                weight[i] = 1.0;
            }
            FormContainer graphContainer2 = new FormContainer(new double[]{0.0, 1.0}, weight);
            graphContainer2.add(this.theAxis, 1, 0, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(0, 0, 2, 0), null));
            for (int i = 0; i < tr.length; ++i) {
                TrackGraph gr = new TrackGraph(this.window, this, this.theAxis);
                gr.setSubdivisions(this.window.getScene().getFramesPerSecond());
                gr.setStartTime(this.startTime);
                gr.setScale(this.timeScale);
                gr.addMarker(this.timeMarker);
                gr.setMode(this.mode);
                gr.setTracks(new Track[]{tr[i]});
                gr.setBackground(Color.white);
                LayoutInfo layout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, new Insets(i == 0 ? 0 : 4, 0, 0, 0), null);
                graphContainer2.add(gr.getAxis(), 0, i + 1, layout);
                graphContainer2.add(gr, 1, i + 1, layout);
                this.graphs.add(gr);
            }
            this.div.add(graphContainer2, 1);
            graphContainer2.addEventLink(MouseScrolledEvent.class, (Object)this, "mouseScrolled");
        }
        for (Widget child : this.div.getChildren()) {
            UIUtilities.applyDefaultBackground(child);
        }
        UIUtilities.applyDefaultFont(this.div);
        this.div.setDividerLocation(divider);
        this.div.layoutChildren();
        this.repaintAll();
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double time) {
        this.theAxis.setStartTime(time);
        for (int i = 0; i < this.graphs.size(); ++i) {
            this.graphs.get(i).setStartTime(time);
        }
        this.startTime = time;
        this.repaintGraphs();
    }

    public double getScale() {
        return this.timeScale;
    }

    public void setScale(double s) {
        this.theAxis.setScale(s);
        for (int i = 0; i < this.graphs.size(); ++i) {
            this.graphs.get(i).setScale(s);
        }
        this.timeScale = s;
        this.repaintGraphs();
    }

    public void setTime(double time) {
        if (this.hasRepaintedView != null) {
            Arrays.fill(this.hasRepaintedView, false);
        }
        this.timeMarker.position = time;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(3);
        this.timeFrameLabel.setText(Translate.text("timeFrameLabel", (Object)nf.format(time), (Object)Integer.toString((int)Math.round(time * (double)this.window.getScene().getFramesPerSecond()))));
        int graphWidth = ((Widget)((Object)this.graphs.get((int)0))).getBounds().width;
        if (time < this.startTime) {
            this.setStartTime(time);
        } else if (time > this.startTime + (double)graphWidth / this.timeScale) {
            this.setStartTime(time - 0.5 * (double)graphWidth / this.timeScale);
        } else {
            this.repaintGraphs();
        }
    }

    public void startAnimating() {
        if (this.hasRepaintedView == null) {
            this.hasRepaintedView = new boolean[this.window.getAllViews().length];
            Object listener = new Object(){

                void viewRepainted(RepaintEvent ev) {
                    boolean allRepainted = true;
                    for (int i = 0; i < Score.this.hasRepaintedView.length; ++i) {
                        if (ev.getWidget() == Score.this.window.getAllViews()[i]) {
                            ((Score)Score.this).hasRepaintedView[i] = true;
                        }
                        allRepainted &= Score.this.hasRepaintedView[i];
                    }
                    if (Score.this.isAnimating && (!Score.this.window.getSplitView() || allRepainted)) {
                        double elapsedTime = (double)(System.currentTimeMillis() - Score.this.animateStartClockTime) * 0.001;
                        double sceneTime = Score.this.animateStartSceneTime + elapsedTime * Score.this.playbackSpeed;
                        int fps = Score.this.window.getScene().getFramesPerSecond();
                        sceneTime = (double)((int)(sceneTime * (double)fps)) / (double)fps;
                        Score.this.window.setTime(sceneTime);
                    }
                }
            };
            for (ViewerCanvas view : this.window.getAllViews()) {
                view.addEventLink(RepaintEvent.class, listener, "viewRepainted");
            }
        }
        this.animateStartSceneTime = this.window.getScene().getTime();
        this.animateStartClockTime = System.currentTimeMillis();
        this.isAnimating = true;
        this.playButton.setIcon(this.stopIcon);
        this.rewindButton.setEnabled(false);
        this.endButton.setEnabled(false);
        this.window.setTime(this.animateStartSceneTime);
    }

    public void stopAnimating() {
        this.isAnimating = false;
        this.playButton.setIcon(this.playIcon);
        this.rewindButton.setEnabled(true);
        this.endButton.setEnabled(true);
    }

    public boolean getAnimating() {
        return this.isAnimating;
    }

    public double getPlaybackSpeed() {
        return this.playbackSpeed;
    }

    public void setPlaybackSeed(double speed) {
        int speedIndex;
        this.playbackSpeed = speed;
        for (speedIndex = 0; speedIndex < this.SPEEDS.length && speed > this.SPEEDS[speedIndex]; ++speedIndex) {
        }
        this.speedSlider.setValue(speedIndex);
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(1);
        this.speedLabel.setText(Translate.text("playbackSpeedLabel", (Object)nf.format(speed)));
        this.animateStartSceneTime = this.window.getScene().getTime();
        this.animateStartClockTime = System.currentTimeMillis();
    }

    private void mouseScrolled(MouseScrolledEvent ev) {
        this.setStartTime(this.startTime + (double)ev.getUnitsToScroll() / (double)this.window.getScene().getFramesPerSecond());
    }

    private void treeSelectionChanged() {
        this.selectedTracksChanged();
        this.window.updateMenus();
    }

    private void selectedTracksChanged() {
        int i;
        Vector<SelectionInfo> v = new Vector<SelectionInfo>();
        Track[] sel = this.getSelectedTracks();
        block0: for (i = 0; i < this.selection.length; ++i) {
            for (int j = 0; j < sel.length; ++j) {
                if (this.selection[i].track != sel[j]) continue;
                v.addElement(this.selection[i]);
                continue block0;
            }
        }
        this.selection = new SelectionInfo[v.size()];
        for (i = 0; i < this.selection.length; ++i) {
            this.selection[i] = (SelectionInfo)v.elementAt(i);
        }
        if (this.view == 1) {
            ((TrackGraph)this.graphs.get(0)).setTracks(sel);
            this.repaintAll();
        }
        if (this.view == 2) {
            this.layoutGraphs();
        }
    }

    public void tracksModified(boolean updateScene) {
        int i;
        for (int i2 = 0; i2 < this.graphs.size(); ++i2) {
            if (this.graphs.get(i2) instanceof TrackGraph) {
                ((TrackGraph)this.graphs.get(i2)).tracksModified();
                continue;
            }
            ((Widget)((Object)this.graphs.get(i2))).repaint();
        }
        if (!updateScene) {
            return;
        }
        Vector<Track> v = new Vector<Track>();
        for (i = 0; i < this.selection.length; ++i) {
            if (v.contains(this.selection[i].track)) continue;
            v.add(this.selection[i].track);
        }
        for (i = 0; i < v.size(); ++i) {
            Track tr = (Track)v.get(i);
            Object parent = tr.getParent();
            while (parent != null && parent instanceof Track) {
                parent = ((Track)parent).getParent();
            }
            if (!(parent instanceof ObjectInfo)) continue;
            this.window.getScene().applyTracksToObject((ObjectInfo)parent);
        }
        this.window.updateImage();
    }

    public void repaintGraphs() {
        for (int i = 0; i < this.graphs.size(); ++i) {
            Widget gr = (Widget)((Object)this.graphs.get(i));
            gr.repaint();
            if (!(gr instanceof TrackGraph)) continue;
            ((TrackGraph)gr).getAxis().repaint();
        }
        this.theAxis.repaint();
    }

    public void repaintAll() {
        this.repaintGraphs();
        this.theList.repaint();
    }

    private void elementsMoved() {
        this.repaintGraphs();
    }

    private void elementOpenedOrClosed() {
        this.repaintGraphs();
        this.updateScrollbar();
    }

    private void elementDoubleClicked(TreeList.ElementDoubleClickedEvent ev) {
        TreeElement el = ev.getElement();
        if (el != null && el.getObject() instanceof Track) {
            Track tr = (Track)el.getObject();
            tr.edit(this.window);
            Object parent = tr.getParent();
            while (parent != null && parent instanceof Track) {
                parent = ((Track)parent).getParent();
            }
            if (parent instanceof ObjectInfo) {
                this.window.getScene().applyTracksToObject((ObjectInfo)parent);
            }
            this.window.updateImage();
            this.selectedTracksChanged();
            this.repaintAll();
        }
    }

    public void setScrollPosition(int pos) {
        Rectangle size = this.theList.getBounds();
        Dimension prefSize = this.theList.getPreferredSize();
        if (pos > prefSize.height - size.height) {
            pos = prefSize.height - size.height;
        }
        if (pos < 0) {
            pos = 0;
        }
        if (pos == this.scrollPos) {
            return;
        }
        this.theList.setYOffset(-pos);
        for (int i = 0; i < this.graphs.size(); ++i) {
            this.graphs.get(i).setYOffset(-pos);
        }
        this.yoffset = -pos;
        this.theList.repaint();
        this.repaintGraphs();
        this.scrollPos = pos;
        this.updateScrollbar();
    }

    private void scrollbarChanged(ValueChangedEvent ev) {
        this.setScrollPosition(this.scroll.getValue());
    }

    private void updateScrollbar() {
        int height = this.theList.getPreferredSize().height;
        int showing = this.theList.getBounds().height;
        this.scroll.setMaximum(height);
        this.scroll.setExtent(showing);
        this.scroll.setValue(this.scrollPos);
        this.scroll.setUnitIncrement(Math.max(this.theList.getRowHeight(), 1));
        this.scroll.setBlockIncrement(Math.max(showing - this.theList.getRowHeight(), 1));
    }

    public void markerMoved(Marker m, boolean intermediate) {
        if (m == this.timeMarker && m.position != this.window.getScene().getTime()) {
            this.window.setTime(m.position);
        } else {
            this.repaintGraphs();
        }
    }

    @Override
    public void layoutChildren() {
        super.layoutChildren();
        this.updateScrollbar();
    }

    public void editSelectedTrack() {
        Object[] sel = this.theList.getSelectedObjects();
        if (sel.length == 1 && sel[0] instanceof Track) {
            Track tr = (Track)sel[0];
            tr.edit(this.window);
            this.finishEditingTrack(tr);
        }
    }

    public void finishEditingTrack(Track tr) {
        Object parent = tr.getParent();
        while (parent != null && parent instanceof Track) {
            parent = ((Track)parent).getParent();
        }
        if (parent instanceof ObjectInfo) {
            this.window.getScene().applyTracksToObject((ObjectInfo)parent);
        }
        this.setModified();
        this.window.updateImage();
        this.selectedTracksChanged();
        this.repaintAll();
    }

    public void setTracksEnabled(boolean enable) {
        int i;
        Object[] sel = this.theList.getSelectedObjects();
        UndoRecord undo = new UndoRecord(this.window, false);
        Vector<Object> v = new Vector<Object>();
        for (i = 0; i < sel.length; ++i) {
            if (!(sel[i] instanceof Track)) continue;
            Track tr = (Track)sel[i];
            Object parent = tr.getParent();
            while (parent instanceof Track) {
                parent = ((Track)parent).getParent();
            }
            if (parent instanceof ObjectInfo && v.indexOf(parent) == -1) {
                v.addElement(parent);
                undo.addCommand(2, new Object[]{parent, ((ObjectInfo)parent).duplicate()});
            }
            tr.setEnabled(enable);
        }
        for (i = 0; i < v.size(); ++i) {
            this.window.getScene().applyTracksToObject((ObjectInfo)v.elementAt(i));
        }
        this.theList.repaint();
        this.window.setUndoRecord(undo);
        this.window.updateImage();
        this.window.updateMenus();
    }

    public void keyframeSelectedTracks() {
        Scene theScene = this.window.getScene();
        Object[] sel = this.theList.getSelectedObjects();
        double time = theScene.getTime();
        UndoRecord undo = new UndoRecord(this.window, false);
        Vector<SelectionInfo> newkeys = new Vector<SelectionInfo>();
        for (int i = 0; i < sel.length; ++i) {
            Keyframe k;
            if (!(sel[i] instanceof Track)) continue;
            Track tr = (Track)sel[i];
            if (tr.getParent() instanceof ObjectInfo) {
                ObjectInfo info = (ObjectInfo)tr.getParent();
                for (int j = 0; j < info.getTracks().length; ++j) {
                    if (info.getTracks()[j] != tr) continue;
                    undo.addCommand(10, new Object[]{info, j, tr.duplicate(info)});
                }
            }
            if ((k = tr.setKeyframe(time, theScene)) == null) continue;
            newkeys.addElement(new SelectionInfo(tr, k));
        }
        this.window.setUndoRecord(undo);
        if (newkeys.size() > 0) {
            Object[] newsel = new SelectionInfo[newkeys.size()];
            newkeys.copyInto(newsel);
            this.setSelectedKeyframes((SelectionInfo[])newsel);
        }
        this.selectedTracksChanged();
        this.repaintGraphs();
        this.window.updateMenus();
    }

    public void keyframeModifiedTracks() {
        Scene theScene = this.window.getScene();
        int[] sel = this.window.getSelectedIndices();
        double time = theScene.getTime();
        UndoRecord undo = new UndoRecord(this.window, false);
        Vector<SelectionInfo> newkeys = new Vector<SelectionInfo>();
        for (int i = 0; i < sel.length; ++i) {
            ObjectInfo info = theScene.getObject(sel[i]);
            boolean posx = false;
            boolean posy = false;
            boolean posz = false;
            boolean rotx = false;
            boolean roty = false;
            boolean rotz = false;
            for (int j = 0; j < info.getTracks().length; ++j) {
                Track tr = info.getTracks()[j];
                if (!tr.isEnabled() || tr instanceof PositionTrack && posx && posy && posz || tr instanceof RotationTrack && rotx && roty && rotz) continue;
                undo.addCommand(10, new Object[]{info, j, tr.duplicate(info)});
                Keyframe k = tr.setKeyframeIfModified(time, theScene);
                if (k == null) continue;
                newkeys.addElement(new SelectionInfo(tr, k));
                if (tr instanceof PositionTrack) {
                    PositionTrack pt = (PositionTrack)tr;
                    posx |= pt.affectsX();
                    posy |= pt.affectsY();
                    posz |= pt.affectsZ();
                }
                if (!(tr instanceof RotationTrack)) continue;
                RotationTrack rt = (RotationTrack)tr;
                rotx |= rt.affectsX();
                roty |= rt.affectsY();
                rotz |= rt.affectsZ();
            }
        }
        this.window.setUndoRecord(undo);
        if (newkeys.size() > 0) {
            Object[] newsel = new SelectionInfo[newkeys.size()];
            newkeys.copyInto(newsel);
            this.setSelectedKeyframes((SelectionInfo[])newsel);
        }
        this.selectedTracksChanged();
        this.repaintGraphs();
        this.window.updateMenus();
    }

    public void duplicateSelectedTracks() {
        int i;
        Object[] sel = this.theList.getSelectedObjects();
        UndoRecord undo = new UndoRecord(this.window, false);
        Vector<ObjectInfo> modifiedObj = new Vector<ObjectInfo>();
        Vector<Track> addedTrack = new Vector<Track>();
        for (i = 0; i < sel.length; ++i) {
            Track tr;
            if (!(sel[i] instanceof Track) || !((tr = (Track)sel[i]).getParent() instanceof ObjectInfo)) continue;
            ObjectInfo info = (ObjectInfo)tr.getParent();
            if (modifiedObj.indexOf(info) < 0) {
                undo.addCommand(11, new Object[]{info, info.getTracks()});
                modifiedObj.addElement(info);
            }
            for (int j = 0; j < info.getTracks().length; ++j) {
                if (info.getTracks()[j] != tr) continue;
                Track newtr = tr.duplicate(info);
                newtr.setName("Copy of " + tr.getName());
                info.addTrack(newtr, j + 1);
                addedTrack.addElement(newtr);
            }
        }
        this.window.setUndoRecord(undo);
        this.rebuildList();
        for (i = 0; i < addedTrack.size(); ++i) {
            TreeElement el = this.theList.findElement(addedTrack.elementAt(i));
            if (el == null) continue;
            el.setSelected(true);
        }
        this.repaintGraphs();
    }

    public void deleteSelectedTracks() {
        Object[] sel = this.theList.getSelectedObjects();
        UndoRecord undo = new UndoRecord(this.window, false);
        Vector<ObjectInfo> modifiedObj = new Vector<ObjectInfo>();
        for (int i = 0; i < sel.length; ++i) {
            Track tr;
            if (!(sel[i] instanceof Track) || !((tr = (Track)sel[i]).getParent() instanceof ObjectInfo)) continue;
            ObjectInfo info = (ObjectInfo)tr.getParent();
            if (modifiedObj.indexOf(info) < 0) {
                undo.addCommand(11, new Object[]{info, info.getTracks()});
                modifiedObj.addElement(info);
            }
            info.removeTrack(tr);
        }
        this.window.setUndoRecord(undo);
        this.rebuildList();
        this.repaintGraphs();
    }

    public void selectAllTracks() {
        Scene theScene = this.window.getScene();
        int[] sel = this.window.getSelectedIndices();
        this.theList.setUpdateEnabled(false);
        for (int i = 0; i < sel.length; ++i) {
            ObjectInfo info = theScene.getObject(sel[i]);
            TreeElement el = this.theList.findElement(info);
            if (el == null) continue;
            for (int j = 0; j < el.getNumChildren(); ++j) {
                this.theList.setSelected(el.getChild(j), true);
            }
        }
        this.theList.setUpdateEnabled(true);
        this.selectedTracksChanged();
        this.window.updateMenus();
    }

    public void addTrack(Object[] obj, Class trackClass, Object[] extraArgs, boolean deselectOthers) {
        int i;
        int which;
        Object[] args;
        Scene theScene = this.window.getScene();
        UndoRecord undo = new UndoRecord(this.window, false);
        Vector<Track> added = new Vector<Track>();
        if (extraArgs == null) {
            args = new Object[1];
        } else {
            args = new Object[extraArgs.length + 1];
            for (int i2 = 0; i2 < extraArgs.length; ++i2) {
                args[i2 + 1] = extraArgs[i2];
            }
        }
        Constructor<?>[] con = trackClass.getConstructors();
        for (which = 0; which < con.length && con[which].getParameterTypes().length != args.length; ++which) {
        }
        try {
            for (i = 0; i < obj.length; ++i) {
                if (!(obj[i] instanceof ObjectInfo)) continue;
                ObjectInfo info = (ObjectInfo)obj[i];
                if (trackClass == PoseTrack.class) {
                    Object3D posable = info.getObject().getPosableObject();
                    if (posable == null) continue;
                    if (posable != info.getObject()) {
                        String[] options = new String[]{Translate.text("Yes"), Translate.text("No")};
                        BStandardDialog dlg = new BStandardDialog("", UIUtilities.breakString(Translate.text("mustConvertToActor", (Object)info.getName())), BStandardDialog.QUESTION);
                        int choice = dlg.showOptionDialog(this.window, options, options[0]);
                        if (choice == 1) continue;
                        theScene.replaceObject(info.getObject(), posable, undo);
                    }
                }
                undo.addCommand(11, new Object[]{info, info.getTracks()});
                args[0] = info;
                Track newtrack = (Track)con[which].newInstance(args);
                info.addTrack(newtrack, 0);
                added.add(newtrack);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.window.setUndoRecord(undo);
        if (deselectOthers) {
            this.theList.deselectAll();
        }
        this.rebuildList();
        for (i = 0; i < added.size(); ++i) {
            this.theList.setSelected(added.get(i), true);
        }
        this.selectedTracksChanged();
        this.window.updateMenus();
    }

    public void editSelectedKeyframe() {
        if (this.selection.length != 1) {
            return;
        }
        this.selection[0].track.editKeyframe(this.window, this.selection[0].keyIndex);
        this.tracksModified(true);
    }

    public void deleteSelectedKeyframes() {
        Hashtable<Track, Track> changedTracks = new Hashtable<Track, Track>();
        block0: for (int i = 0; i < this.selection.length; ++i) {
            Track tr = this.selection[i].track;
            Keyframe[] keys = tr.getTimecourse().getValues();
            for (int j = 0; j < keys.length; ++j) {
                if (keys[j] != this.selection[i].key) continue;
                if (changedTracks.get(tr) == null) {
                    changedTracks.put(tr, tr.duplicate(tr.getParent()));
                }
                tr.deleteKeyframe(j);
                continue block0;
            }
        }
        this.selection = new SelectionInfo[0];
        UndoRecord undo = new UndoRecord(this.window, false);
        Enumeration tracks = changedTracks.keys();
        while (tracks.hasMoreElements()) {
            Track tr = (Track)tracks.nextElement();
            Object parent = tr.getParent();
            while (parent != null && parent instanceof Track) {
                parent = ((Track)parent).getParent();
            }
            if (parent instanceof ObjectInfo) {
                this.window.getScene().applyTracksToObject((ObjectInfo)parent);
            }
            undo.addCommand(12, new Object[]{tr, changedTracks.get(tr)});
        }
        this.window.setUndoRecord(undo);
        this.window.updateMenus();
        this.tracksModified(true);
    }

    private void clickedPlay() {
        if (this.isAnimating) {
            this.stopAnimating();
        } else {
            this.startAnimating();
        }
    }

    private void clickedRewind() {
        double minTime = Math.min(0.0, this.window.getScene().getTime());
        for (ObjectInfo obj : this.window.getScene().getAllObjects()) {
            for (Track track : obj.getTracks()) {
                double[] keyTimes = track.getKeyTimes();
                if (keyTimes.length <= 0) continue;
                minTime = Math.min(minTime, keyTimes[0]);
            }
        }
        if (minTime != this.window.getScene().getTime()) {
            this.window.setTime(minTime);
        }
    }

    private void clickedEnd() {
        double maxTime = Math.max(0.0, this.window.getScene().getTime());
        for (ObjectInfo obj : this.window.getScene().getAllObjects()) {
            for (Track track : obj.getTracks()) {
                double[] keyTimes = track.getKeyTimes();
                if (keyTimes.length <= 0) continue;
                maxTime = Math.max(maxTime, keyTimes[keyTimes.length - 1]);
            }
        }
        if (maxTime != this.window.getScene().getTime()) {
            this.window.setTime(maxTime);
        }
    }

    private void speedChanged() {
        this.setPlaybackSeed(this.SPEEDS[this.speedSlider.getValue()]);
    }

    @Override
    public boolean confirmClose() {
        return true;
    }

    @Override
    public ToolPalette getToolPalette() {
        return this.modeTools;
    }

    @Override
    public void setTool(EditingTool tool) {
        if (this.view != this.viewTools.getSelection()) {
            this.view = this.viewTools.getSelection();
            this.layoutGraphs();
        }
        if (this.mode != this.modeTools.getSelection()) {
            this.mode = this.modeTools.getSelection();
            for (int i = 0; i < this.graphs.size(); ++i) {
                this.graphs.get(i).setMode(this.mode);
            }
            this.setHelpText(this.MODE_HELP_TEXT[this.mode]);
        }
    }

    @Override
    public void setHelpText(String text) {
        this.helpText.setText(text);
    }

    @Override
    public BFrame getFrame() {
        return this.window;
    }

    @Override
    public void updateImage() {
    }

    @Override
    public void updateMenus() {
    }

    @Override
    public void setUndoRecord(UndoRecord command) {
        this.window.setUndoRecord(command);
    }

    @Override
    public void setModified() {
        this.window.setModified();
    }

    @Override
    public Scene getScene() {
        return this.window.getScene();
    }

    @Override
    public ViewerCanvas getView() {
        return null;
    }

    @Override
    public ViewerCanvas[] getAllViews() {
        return null;
    }
}

