/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.UndoRecord;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Marker;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.animation.Score;
import artofillusion.animation.SelectionInfo;
import artofillusion.animation.TimeAxis;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.animation.TrackDisplay;
import artofillusion.animation.VerticalAxis;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.MouseClickedEvent;
import buoy.event.MouseDraggedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.RepaintEvent;
import buoy.widget.CustomWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class TrackGraph
extends CustomWidget
implements TrackDisplay {
    private LayoutWindow window;
    private double hscale;
    private double vscale;
    private double hstart;
    private double vstart;
    private double[] dragKeyTime;
    private double[][] dragKeyValue;
    private int subdivisions;
    private int mode;
    private int oldHeight;
    private int effectiveMode;
    private Score theScore;
    private TimeAxis timeAxis;
    private VerticalAxis vertAxis;
    private Point lastPos;
    private Point dragPos;
    private Rectangle lastBounds;
    private boolean draggingBox;
    private boolean lineAtBottom;
    private Vector<Marker> markers;
    private TrackInfo[] tracks;
    private UndoRecord undo;
    public static final int HANDLE_SIZE = 5;
    public static final int TICK_SIZE = 6;
    public static final Color[] LINE_COLOR = new Color[]{new Color(0, 0, 255), new Color(0, 175, 0), new Color(255, 128, 0), new Color(0, 170, 170), new Color(192, 0, 255), new Color(192, 192, 0)};
    public static final Color[] LIGHT_LINE_COLOR = new Color[LINE_COLOR.length];
    public static final Color SELECTED_VALUE_COLOR;
    public static final Color SELECTED_KEY_COLOR;

    public TrackGraph(LayoutWindow win, Score sc, TimeAxis ta) {
        this.window = win;
        this.theScore = sc;
        this.timeAxis = ta;
        this.vertAxis = new VerticalAxis();
        this.hstart = win.getScore().getStartTime();
        this.hscale = win.getScore().getScale();
        this.subdivisions = win.getScene().getFramesPerSecond();
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(200, 100));
        this.addEventLink(MousePressedEvent.class, (Object)this, "mousePressed");
        this.addEventLink(MouseReleasedEvent.class, (Object)this, "mouseReleased");
        this.addEventLink(MouseDraggedEvent.class, (Object)this, "mouseDragged");
        this.addEventLink(MouseClickedEvent.class, (Object)this, "mouseClicked");
        this.addEventLink(RepaintEvent.class, (Object)this, "paint");
        this.tracks = new TrackInfo[0];
        this.markers = new Vector();
    }

    private void sizeChanged() {
        this.lastBounds = this.getBounds();
        if (this.vscale <= 0.0) {
            this.setDefaultGraphRange(false);
        } else {
            if (this.oldHeight <= 0 || this.lastBounds.height <= 0) {
                return;
            }
            this.vscale *= (double)((float)this.lastBounds.height / (float)this.oldHeight);
            this.oldHeight = this.lastBounds.height;
        }
    }

    @Override
    public void setStartTime(double time) {
        this.hstart = time;
    }

    @Override
    public void setScale(double s) {
        this.hscale = s;
    }

    @Override
    public void setSubdivisions(int s) {
        this.subdivisions = s;
    }

    @Override
    public void setYOffset(int offset) {
    }

    @Override
    public void addMarker(Marker m) {
        this.markers.addElement(m);
    }

    @Override
    public void setMode(int m) {
        this.mode = m;
    }

    public VerticalAxis getAxis() {
        return this.vertAxis;
    }

    public void setTracks(Track[] t) {
        int i;
        boolean listChanged = t.length != this.tracks.length;
        for (i = 0; i < t.length && i < this.tracks.length; ++i) {
            if (t[i] == this.tracks[i].track) continue;
            listChanged = true;
        }
        this.tracks = new TrackInfo[t.length];
        for (i = 0; i < t.length; ++i) {
            this.tracks[i] = new TrackInfo(t[i]);
        }
        this.selectionChanged();
        this.setDefaultGraphRange(!listChanged);
    }

    public void showLineAtBottom(boolean show) {
        this.lineAtBottom = show;
    }

    private void setDefaultGraphRange(boolean largerOnly) {
        Rectangle dim = this.getBounds();
        double oldmin = this.vstart;
        double oldmax = this.vstart + (double)dim.height / this.vscale;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int which = 0; which < this.tracks.length; ++which) {
            int j;
            int i;
            TrackInfo info = this.tracks[which];
            for (i = 0; i < info.keyValue.length; ++i) {
                for (j = 0; j < info.keyValue[i].length; ++j) {
                    if (info.disabled[j]) continue;
                    if (info.keyValue[i][j] < min) {
                        min = info.keyValue[i][j];
                    }
                    if (!(info.keyValue[i][j] > max)) continue;
                    max = info.keyValue[i][j];
                }
            }
            for (i = 0; i < info.graphValue.length; ++i) {
                for (j = 0; j < info.graphValue[i].length; ++j) {
                    if (info.disabled[j]) continue;
                    if (info.graphValue[i][j] < min) {
                        min = info.graphValue[i][j];
                    }
                    if (!(info.graphValue[i][j] > max)) continue;
                    max = info.graphValue[i][j];
                }
            }
        }
        if (min == Double.MAX_VALUE) {
            min = 0.0;
            max = 1.0;
        }
        if (max == min && min >= 0.0 && min <= 1.0) {
            min = 0.0;
            max = 1.0;
        }
        if (max == min) {
            min = Math.floor(min);
            max = min + 1.0;
        }
        double extra = 0.05 * (max - min);
        min -= extra;
        max += extra;
        if (largerOnly && min > oldmin) {
            min = oldmin;
        }
        if (largerOnly && max < oldmax) {
            max = oldmax;
        }
        this.vstart = min;
        this.vscale = (double)dim.height / (max - min);
        this.vertAxis.setGraphRange(min, max);
        this.oldHeight = dim.height;
    }

    public void tracksModified() {
        for (int i = 0; i < this.tracks.length; ++i) {
            this.tracks[i].findValues();
        }
        this.selectionChanged();
        this.repaint();
    }

    public void selectionChanged() {
        for (int i = 0; i < this.tracks.length; ++i) {
            int j;
            TrackInfo info = this.tracks[i];
            for (j = 0; j < info.selected.length; ++j) {
                info.selected[j] = false;
            }
            SelectionInfo[] selection = this.theScore.getSelectedKeyframes();
            for (j = 0; j < selection.length; ++j) {
                if (selection[j].track != info.track) continue;
                info.selected[selection[j].keyIndex] = true;
            }
        }
    }

    private void findInitialKeyValues() {
        SelectionInfo[] sel = this.theScore.getSelectedKeyframes();
        this.dragKeyTime = new double[sel.length];
        this.dragKeyValue = new double[sel.length][];
        for (int i = 0; i < sel.length; ++i) {
            double[] t = sel[i].track.getKeyTimes();
            this.dragKeyTime[i] = t[sel[i].keyIndex];
            Keyframe[] key = sel[i].track.getTimecourse().getValues();
            this.dragKeyValue[i] = key[sel[i].keyIndex].getGraphValues();
        }
    }

    private void mousePressed(MousePressedEvent ev) {
        this.lastPos = ev.getPoint();
        this.undo = null;
        this.dragPos = null;
        this.draggingBox = false;
        int n = this.effectiveMode = UIUtilities.mouseButtonThree(ev) ? 1 : this.mode;
        if (this.effectiveMode != 0) {
            return;
        }
        Rectangle dim = this.getBounds();
        for (int i = 0; i < this.tracks.length; ++i) {
            for (int j = 0; j < this.tracks[i].keyValue.length; ++j) {
                int x = (int)Math.round(this.hscale * (this.tracks[i].keyTime[j] - this.hstart));
                if (this.lastPos.x < x - 2 || this.lastPos.x > x + 2) continue;
                for (int k = this.tracks[i].keyValue[j].length - 1; k >= 0; --k) {
                    int y;
                    if (this.tracks[i].disabled[k] || this.lastPos.y < (y = dim.height - (int)Math.round(this.vscale * (this.tracks[i].keyValue[j][k] - this.vstart))) - 2 || this.lastPos.y > y + 2) continue;
                    Keyframe key = this.tracks[i].track.getTimecourse().getValues()[j];
                    SelectionInfo newsel = new SelectionInfo(this.tracks[i].track, key);
                    for (int m = 0; m < newsel.selected.length; ++m) {
                        newsel.selected[m] = m == k;
                    }
                    if (ev.isShiftDown()) {
                        if (this.theScore.isKeyframeSelected(key, k)) {
                            this.theScore.removeSelectedKeyframe(key);
                        } else {
                            this.theScore.addSelectedKeyframes(new SelectionInfo[]{newsel});
                        }
                    } else if (!this.theScore.isKeyframeSelected(key, k)) {
                        this.theScore.setSelectedKeyframes(new SelectionInfo[]{newsel});
                    }
                    this.findInitialKeyValues();
                    this.selectionChanged();
                    this.theScore.repaintGraphs();
                    return;
                }
            }
        }
        if (!ev.isShiftDown()) {
            this.theScore.setSelectedKeyframes(new SelectionInfo[0]);
        }
        this.selectionChanged();
        this.draggingBox = true;
        this.theScore.repaintGraphs();
    }

    private void mouseDragged(MouseDraggedEvent ev) {
        Point pos = ev.getPoint();
        if (this.effectiveMode == 0) {
            int j;
            int i;
            if (this.draggingBox) {
                this.dragPos = pos;
                this.repaint();
                return;
            }
            SelectionInfo[] sel = this.theScore.getSelectedKeyframes();
            if (this.undo == null) {
                this.undo = new UndoRecord(this.window, false);
                for (i = 0; i < sel.length; ++i) {
                    Track tr = sel[i].track;
                    for (j = 0; j < i && tr != sel[j].track; ++j) {
                    }
                    if (j != i) continue;
                    this.undo.addCommand(12, new Object[]{tr, tr.duplicate(tr.getParent())});
                }
                this.window.setUndoRecord(this.undo);
            }
            double dt = (double)(pos.x - this.lastPos.x) / this.hscale;
            double dv = (double)(this.lastPos.y - pos.y) / this.vscale;
            for (i = 0; i < sel.length; ++i) {
                Track tr = sel[i].track;
                for (j = 0; j < this.tracks.length && tr != this.tracks[j].track; ++j) {
                }
                if (j == this.tracks.length) continue;
                for (int k = 0; k < sel[i].selected.length; ++k) {
                    if (!sel[i].selected[k]) continue;
                    double newval = this.dragKeyValue[i][k] + dv;
                    if (newval < this.tracks[j].valueRange[k][0]) {
                        newval = this.tracks[j].valueRange[k][0];
                    }
                    if (newval > this.tracks[j].valueRange[k][1]) {
                        newval = this.tracks[j].valueRange[k][1];
                    }
                    this.tracks[j].keyValue[sel[i].keyIndex][k] = newval;
                }
                sel[i].key.setGraphValues(this.tracks[j].keyValue[sel[i].keyIndex]);
            }
            for (i = 0; i < sel.length; ++i) {
                int newindex;
                int oldindex = sel[i].keyIndex;
                double t = this.dragKeyTime[i] + dt;
                if (sel[i].track.isQuantized()) {
                    t = (double)Math.round(t * (double)this.subdivisions) / (double)this.subdivisions;
                }
                if (oldindex == (newindex = sel[i].track.moveKeyframe(oldindex, t))) continue;
                for (j = 0; j < sel.length; ++j) {
                    if (sel[j].keyIndex < oldindex && sel[j].keyIndex > newindex) {
                        ++sel[j].keyIndex;
                        continue;
                    }
                    if (sel[j].keyIndex <= oldindex || sel[j].keyIndex >= newindex) continue;
                    --sel[j].keyIndex;
                }
                sel[i].keyIndex = newindex;
            }
            this.theScore.tracksModified(false);
            return;
        }
        if (this.effectiveMode != 1) {
            return;
        }
        Rectangle dim = this.getBounds();
        if (ev.isShiftDown()) {
            this.hscale *= Math.pow(1.01, pos.x - this.lastPos.x);
            this.vscale *= Math.pow(1.01, this.lastPos.y - pos.y);
            this.vertAxis.setGraphRange(this.vstart, this.vstart + (double)dim.height / this.vscale);
            if (pos.x == this.lastPos.x) {
                this.repaint();
                this.vertAxis.repaint();
            } else {
                this.theScore.setScale(this.hscale);
            }
            this.lastPos = pos;
            return;
        }
        this.hstart -= (double)(pos.x - this.lastPos.x) / this.hscale;
        this.vstart -= (double)(this.lastPos.y - pos.y) / this.vscale;
        this.vertAxis.setGraphRange(this.vstart, this.vstart + (double)dim.height / this.vscale);
        if (pos.x == this.lastPos.x) {
            this.repaint();
            this.vertAxis.repaint();
        } else {
            this.theScore.setStartTime(this.hstart);
        }
        this.lastPos = pos;
    }

    private void mouseReleased(MouseReleasedEvent ev) {
        if (this.dragPos == null) {
            if (this.effectiveMode == 0) {
                this.theScore.tracksModified(true);
            }
            return;
        }
        int x1 = Math.min(this.lastPos.x, this.dragPos.x);
        int x2 = Math.max(this.lastPos.x, this.dragPos.x);
        int y1 = Math.min(this.lastPos.y, this.dragPos.y);
        int y2 = Math.max(this.lastPos.y, this.dragPos.y);
        this.dragPos = null;
        Vector<SelectionInfo> v = new Vector<SelectionInfo>();
        Rectangle dim = this.getBounds();
        for (int i = 0; i < this.tracks.length; ++i) {
            for (int j = 0; j < this.tracks[i].keyValue.length; ++j) {
                int x = (int)Math.round(this.hscale * (this.tracks[i].keyTime[j] - this.hstart));
                if (x < x1 || x > x2) continue;
                Keyframe key = this.tracks[i].track.getTimecourse().getValues()[j];
                SelectionInfo newsel = new SelectionInfo(this.tracks[i].track, key);
                boolean any = false;
                for (int k = 0; k < this.tracks[i].keyValue[j].length; ++k) {
                    int y;
                    newsel.selected[k] = false;
                    if (this.tracks[i].disabled[k] || (y = dim.height - (int)Math.round(this.vscale * (this.tracks[i].keyValue[j][k] - this.vstart))) < y1 || y > y2) continue;
                    any = true;
                    newsel.selected[k] = true;
                }
                if (!any) continue;
                v.addElement(newsel);
            }
        }
        SelectionInfo[] sel = new SelectionInfo[v.size()];
        for (int i = 0; i < sel.length; ++i) {
            sel[i] = (SelectionInfo)v.elementAt(i);
        }
        this.theScore.addSelectedKeyframes(sel);
        this.selectionChanged();
        this.theScore.repaintGraphs();
    }

    private void mouseClicked(MouseClickedEvent ev) {
        if (ev.getClickCount() == 2 && this.effectiveMode == 0) {
            this.theScore.editSelectedKeyframe();
        }
    }

    private void paint(RepaintEvent ev) {
        int y;
        int x;
        Rectangle dim = this.getBounds();
        if (this.lastBounds == null || dim.width != this.lastBounds.width || dim.height != this.lastBounds.height) {
            this.sizeChanged();
        }
        Graphics2D g = ev.getGraphics();
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int fontHeight = fm.getMaxAscent() + fm.getMaxDescent();
        int labels = 0;
        SelectionInfo[] selection = this.theScore.getSelectedKeyframes();
        for (int which = 0; which < this.tracks.length; ++which) {
            TrackInfo info = this.tracks[which];
            int num = info.valueName.length;
            for (int i = 0; i < num; ++i) {
                if (info.disabled[i]) continue;
                g.setColor(info.dimmed ? LIGHT_LINE_COLOR[labels % LINE_COLOR.length] : LINE_COLOR[labels % LINE_COLOR.length]);
                this.plotLine(g, info.graphTime, info.graphValue, i, dim);
                for (int j = 0; j < info.keyTime.length; ++j) {
                    g.setColor(LINE_COLOR[labels % LINE_COLOR.length]);
                    if (info.selected[j]) {
                        for (int k = 0; k < selection.length; ++k) {
                            if (selection[k].track != info.track || selection[k].keyIndex != j) continue;
                            if (selection[k].selected[i]) {
                                g.setColor(SELECTED_VALUE_COLOR);
                                continue;
                            }
                            g.setColor(SELECTED_KEY_COLOR);
                        }
                    }
                    x = (int)Math.round(this.hscale * (info.keyTime[j] - this.hstart));
                    y = dim.height - (int)Math.round(this.vscale * (info.keyValue[j][i] - this.vstart));
                    g.fillRect(x - 2, y - 2, 5, 5);
                }
                g.setColor(LINE_COLOR[labels % LINE_COLOR.length]);
                y = fontHeight * labels + fontHeight / 2;
                g.drawLine(dim.width - 15, y, dim.width - 5, y);
                x = dim.width - 20 - fm.stringWidth(info.valueName[i]);
                g.drawString(info.valueName[i], x, fontHeight * (labels + 1));
                ++labels;
            }
        }
        String message = null;
        if (this.tracks.length == 0) {
            message = Translate.text("noTracksSelected");
        } else if (labels == 0) {
            message = this.tracks.length == 1 ? Translate.text("singleTrackNoGraph", (Object)this.tracks[0].track.getName()) : Translate.text("multiTrackNoGraph");
        }
        if (message != null) {
            x = (dim.width - fm.stringWidth(message)) / 2;
            y = (dim.height + fontHeight) / 2;
            g.drawString(message, x, y);
        }
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker m = this.markers.elementAt(i);
            g.setColor(m.color);
            x = (int)Math.round(this.hscale * (m.position - this.hstart));
            g.drawLine(x, 0, x, dim.height);
        }
        if (this.lineAtBottom) {
            g.setColor(Color.black);
            g.drawLine(0, dim.height - 1, dim.width, dim.height - 1);
        }
        if (this.dragPos != null && this.tracks.length > 0) {
            g.setColor(Color.BLACK);
            g.drawRect(Math.min(this.lastPos.x, this.dragPos.x), Math.min(this.lastPos.y, this.dragPos.y), Math.abs(this.dragPos.x - this.lastPos.x), Math.abs(this.dragPos.y - this.lastPos.y));
        }
    }

    private void plotLine(Graphics2D g, double[] x, double[][] y, int which, Rectangle dim) {
        int toX = (int)Math.round(this.hscale * (x[0] - this.hstart));
        int toY = dim.height - (int)Math.round(this.vscale * (y[0][which] - this.vstart));
        if (toX > 0) {
            g.drawLine(0, toY, toX, toY);
        }
        for (int i = 1; i < x.length; ++i) {
            int fromX = toX;
            int fromY = toY;
            toX = (int)Math.round(this.hscale * (x[i] - this.hstart));
            toY = dim.height - (int)Math.round(this.vscale * (y[i][which] - this.vstart));
            g.drawLine(fromX, fromY, toX, toY);
        }
        if (toX < dim.width) {
            g.drawLine(toX, toY, dim.width, toY);
        }
    }

    static {
        for (int i = 0; i < LINE_COLOR.length; ++i) {
            TrackGraph.LIGHT_LINE_COLOR[i] = new Color(191 + LINE_COLOR[i].getRed() / 4, 191 + LINE_COLOR[i].getGreen() / 4, 191 + LINE_COLOR[i].getBlue() / 4);
        }
        SELECTED_VALUE_COLOR = Color.red;
        SELECTED_KEY_COLOR = Color.magenta;
    }

    private class TrackInfo {
        Track track;
        String[] valueName;
        double[] keyTime;
        double[][] keyValue;
        double[] graphTime;
        double[][] graphValue;
        double[][] valueRange;
        boolean[] disabled;
        boolean[] selected;
        boolean dimmed;

        public TrackInfo(Track tr) {
            this.track = tr;
            this.findValues();
        }

        public void findValues() {
            int i;
            Keyframe[] graphKeyframe;
            Track tr;
            Timecourse tc = this.track.getTimecourse();
            if (tc == null) {
                this.valueName = new String[0];
                this.keyTime = new double[0];
                this.keyValue = new double[0][0];
                this.graphTime = new double[0];
                this.graphValue = new double[0][0];
                this.disabled = new boolean[0];
                this.selected = new boolean[0];
                return;
            }
            this.valueName = this.track.getValueNames();
            int num = this.valueName.length;
            this.valueRange = this.track.getValueRange();
            this.keyTime = tc.getTimes();
            Keyframe[] keyframe = tc.getValues();
            if (this.track instanceof PositionTrack) {
                tr = (PositionTrack)this.track;
                this.disabled = new boolean[]{!((PositionTrack)tr).affectsX(), !((PositionTrack)tr).affectsY(), !((PositionTrack)tr).affectsZ()};
            } else if (this.track instanceof RotationTrack) {
                tr = (RotationTrack)this.track;
                this.disabled = new boolean[]{!((RotationTrack)tr).affectsX(), !((RotationTrack)tr).affectsY(), !((RotationTrack)tr).affectsZ()};
            } else {
                this.disabled = new boolean[num];
            }
            if (this.selected == null || this.selected.length != this.keyTime.length) {
                this.selected = new boolean[this.keyTime.length];
            }
            boolean bl = this.dimmed = this.track instanceof RotationTrack && ((RotationTrack)this.track).getUseQuaternion();
            if (this.keyTime.length == 0) {
                this.graphTime = new double[]{0.0};
                this.graphValue = new double[1][];
                this.graphValue[0] = this.track.getDefaultGraphValues();
                this.keyValue = new double[0][0];
                return;
            }
            if (this.track.getSmoothingMethod() == 0) {
                this.graphTime = new double[keyframe.length * 2 - 1];
                graphKeyframe = new Keyframe[keyframe.length * 2 - 1];
                for (int i2 = 0; i2 < keyframe.length; ++i2) {
                    graphKeyframe[i2 * 2] = keyframe[i2];
                    this.graphTime[i2 * 2] = this.keyTime[i2];
                    if (i2 >= keyframe.length - 1) continue;
                    graphKeyframe[i2 * 2 + 1] = keyframe[i2];
                    this.graphTime[i2 * 2 + 1] = this.keyTime[i2 + 1];
                }
            } else {
                Timecourse sub = tc.subdivide(this.track.getSmoothingMethod());
                sub = sub.subdivide(this.track.getSmoothingMethod());
                sub = sub.subdivide(this.track.getSmoothingMethod());
                this.graphTime = sub.getTimes();
                graphKeyframe = sub.getValues();
            }
            this.keyValue = new double[keyframe.length][];
            for (i = 0; i < keyframe.length; ++i) {
                this.keyValue[i] = keyframe[i].getGraphValues();
            }
            this.graphValue = new double[graphKeyframe.length][1];
            for (i = 0; i < graphKeyframe.length; ++i) {
                this.graphValue[i] = graphKeyframe[i].getGraphValues();
            }
        }
    }
}

