/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.Scene;
import artofillusion.image.ImageMap;
import artofillusion.image.MIPMappedImage;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.Date;
import javax.imageio.ImageIO;

public class ExternalImage
extends ImageMap {
    private File externalFile;
    private String loadingError;
    private String imageType;
    private ImageMap imageMap;
    private int w;
    private int h;
    private String type;
    private String lastAbsolutePath;
    private String lastRelativePath;
    private File imageFile;
    private Image brokenImage;
    private boolean connected;
    private boolean nameAutomatic = true;

    public ExternalImage(String path) throws InterruptedException {
        this(new File(path));
    }

    public ExternalImage(File file) throws InterruptedException {
        this(file, null);
    }

    public ExternalImage(File file, Scene scene) throws InterruptedException {
        try {
            this.imageFile = file;
            this.loadExternalImage(this.imageFile);
            this.setDataCreated(this.imageFile);
            this.lastAbsolutePath = this.imageFile.getAbsolutePath();
            this.lastRelativePath = scene == null ? new String() : this.findRelativePath(scene);
            this.w = this.imageMap.getWidth();
            this.h = this.imageMap.getHeight();
            this.imageType = this.imageMap.getType();
            this.connected = true;
            this.brokenImage = null;
        }
        catch (Exception e) {
            throw new InterruptedException();
        }
    }

    private Image loadIcon(String iconName) {
        try {
            return ImageIO.read(ExternalImage.class.getResource("/artofillusion/image/icons/" + iconName));
        }
        catch (IOException e) {
            System.out.println(e);
            return null;
        }
    }

    @Override
    public File getFile() {
        if (!this.connected) {
            return null;
        }
        return this.imageFile;
    }

    public String getPath() {
        if (this.connected) {
            return this.imageFile.getAbsolutePath();
        }
        return this.lastAbsolutePath;
    }

    @Override
    public String getType() {
        if (this.connected) {
            return this.imageMap.getType();
        }
        return this.imageType;
    }

    @Override
    public int getWidth() {
        return this.imageMap.getWidth();
    }

    @Override
    public int getHeight() {
        return this.imageMap.getHeight();
    }

    @Override
    public float getAspectRatio() {
        return this.imageMap.getAspectRatio();
    }

    @Override
    public int getComponentCount() {
        return this.imageMap.getComponentCount();
    }

    @Override
    public float getComponent(int component, boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        return this.imageMap.getComponent(component, wrapx, wrapy, x, y, xsize, ysize);
    }

    @Override
    public float getAverageComponent(int component) {
        return this.imageMap.getAverageComponent(component);
    }

    @Override
    public void getColor(RGBColor theColor, boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        this.imageMap.getColor(theColor, wrapx, wrapy, x, y, xsize, ysize);
    }

    @Override
    public void getGradient(Vec2 grad, int component, boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        this.imageMap.getGradient(grad, component, wrapx, wrapy, x, y, xsize, ysize);
    }

    @Override
    public Image getPreview() {
        if (this.connected) {
            return this.imageMap.getPreview();
        }
        return this.brokenImage.getScaledInstance(50, 50, 4);
    }

    @Override
    public Image getPreview(int size) {
        if (this.connected) {
            return this.imageMap.getPreview(size);
        }
        if (size <= 256) {
            return this.brokenImage.getScaledInstance(size, size, 4);
        }
        return this.createTemporaryImage(size, size);
    }

    public boolean isNameAutomatic() {
        return this.nameAutomatic;
    }

    public void setNameAutomatic(boolean automatic) {
        this.nameAutomatic = automatic;
    }

    private void loadExternalImage(File file) throws Exception {
        this.imageMap = ExternalImage.loadImage(file);
    }

    private void setTemporaryImage() {
        if (this.brokenImage != null) {
            return;
        }
        try {
            if (this.w <= 0 || this.h <= 0) {
                this.h = 256;
                this.w = 256;
            }
            this.imageMap = new MIPMappedImage(this.createTemporaryImage(this.w, this.h));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private BufferedImage createTemporaryImage(int imageW, int imageH) {
        BufferedImage tempImg;
        try {
            this.brokenImage = this.loadIcon(this.imageType + ".png");
            int wto = this.brokenImage.getWidth(null);
            int hto = this.brokenImage.getHeight(null);
            int nwm = (int)Math.ceil((float)imageW / (float)wto);
            int nhm = (int)Math.ceil((float)imageH / (float)hto);
            float scale = Math.min((float)imageW / (float)nwm / (float)wto, (float)imageH / (float)nhm / (float)hto);
            int tw = (int)((float)wto * scale);
            int th = (int)((float)hto * scale);
            Image tile = this.brokenImage.getScaledInstance(tw, th, 4);
            tempImg = new BufferedImage(imageW, imageH, 2);
            Graphics2D g2 = tempImg.createGraphics();
            if (this.type == "RGB" || this.type == "HDR" || this.type == "GRAY") {
                g2.setColor(new Color(127, 127, 127, 255));
            } else {
                g2.setColor(new Color(255, 255, 255, 0));
            }
            g2.fillRect(0, 0, imageW, imageH);
            int nw = imageW / tw;
            int nh = imageH / th;
            for (int i = 0; i < nw; ++i) {
                for (int j = 0; j < nh; ++j) {
                    g2.drawImage(tile, imageW * i / nw, imageH * j / nh, null);
                }
            }
            g2.dispose();
        }
        catch (Exception e) {
            tempImg = new BufferedImage(imageW, imageH, 2);
            Graphics2D g2 = tempImg.createGraphics();
            g2.setColor(new Color(127, 63, 63, 127));
            g2.fillRect(0, 0, imageW, imageH);
            g2.dispose();
        }
        return tempImg;
    }

    public void refreshImage() {
        File file = this.imageFile != null && this.imageFile.isFile() ? this.imageFile : (!this.lastRelativePath.isEmpty() && new File(this.lastRelativePath).isFile() ? new File(this.lastRelativePath) : new File(this.lastAbsolutePath));
        if (!file.isFile() && !this.connected) {
            return;
        }
        try {
            this.loadExternalImage(file);
            this.setDataEdited();
            this.imageFile = file;
            this.imageType = this.imageMap.getType();
            this.w = this.imageMap.getWidth();
            this.h = this.imageMap.getHeight();
            this.brokenImage = null;
            this.connected = true;
        }
        catch (Exception e) {
            if (!this.connected) {
                return;
            }
            this.connected = false;
            this.setTemporaryImage();
            return;
        }
    }

    public void reconnectImage(File file, Scene scene) throws Exception {
        try {
            this.loadExternalImage(file);
            this.setDataEdited();
            if (this.nameAutomatic) {
                this.imageName = file.getName().substring(0, file.getName().lastIndexOf(46));
            }
            this.lastAbsolutePath = this.imageFile.getAbsolutePath();
            this.lastRelativePath = scene == null ? new String() : this.findRelativePath(scene);
            this.w = this.imageMap.getWidth();
            this.h = this.imageMap.getHeight();
            this.imageFile = file;
            this.imageType = this.imageMap.getType();
            this.connected = true;
            this.brokenImage = null;
        }
        catch (Exception e) {
            this.connected = false;
            this.setTemporaryImage();
            throw e;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public ImageMap getImageMap() {
        return this.imageMap;
    }

    public ExternalImage(DataInputStream in) throws IOException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("Unrecognized version of ExternalImage");
        }
        String absolutePath = in.readUTF();
        String relativePath = in.readUTF();
        this.lastAbsolutePath = absolutePath;
        this.lastRelativePath = relativePath;
        File f = new File(absolutePath);
        this.imageFile = new File(relativePath);
        if (!this.imageFile.isFile() && f.isFile()) {
            this.imageFile = f;
        }
        this.w = in.readInt();
        this.h = in.readInt();
        this.imageType = in.readUTF();
        this.imageName = in.readUTF();
        this.nameAutomatic = in.readBoolean();
        this.userCreated = in.readUTF();
        this.dateCreated = new Date(in.readLong());
        this.zoneCreated = in.readUTF();
        this.userEdited = in.readUTF();
        this.dateEdited = new Date(in.readLong());
        this.zoneEdited = in.readUTF();
        try {
            this.loadExternalImage(this.imageFile);
            this.connected = true;
            this.brokenImage = null;
        }
        catch (Exception e) {
            this.connected = false;
            this.setTemporaryImage();
        }
    }

    @Override
    @Deprecated
    public void writeToStream(DataOutputStream out) throws IOException {
        this.writeToStream(out, null);
    }

    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        out.writeShort(0);
        if (this.connected) {
            out.writeUTF(this.imageFile.getAbsolutePath());
            if (scene == null) {
                out.writeUTF(this.imageFile.getAbsolutePath());
            } else {
                this.lastRelativePath = this.findRelativePath(scene);
            }
            out.writeUTF(this.lastRelativePath);
        } else {
            out.writeUTF(this.lastAbsolutePath);
            out.writeUTF(this.lastRelativePath);
        }
        if (this.imageMap.getWidth() < 0 && this.imageMap.getHeight() < 0) {
            this.w = this.imageMap.getWidth();
            this.h = this.imageMap.getHeight();
        }
        out.writeInt(this.w);
        out.writeInt(this.h);
        out.writeUTF(this.imageType);
        out.writeUTF(this.imageName);
        out.writeBoolean(this.nameAutomatic);
        out.writeUTF(this.userCreated);
        out.writeLong(this.dateCreated.getTime());
        out.writeUTF(this.zoneCreated);
        out.writeUTF(this.userEdited);
        out.writeLong(this.dateEdited.getTime());
        out.writeUTF(this.zoneEdited);
    }

    private String findRelativePath(Scene scene) {
        int i;
        int numCommon;
        String scenePath = null;
        String imagePath = null;
        try {
            scenePath = new File(scene.getDirectory()).getCanonicalPath();
            imagePath = this.imageFile.getCanonicalPath();
        }
        catch (Exception e) {
            return "";
        }
        String splitExpr = File.separator;
        if ("\\".equals(splitExpr)) {
            splitExpr = "\\\\";
        }
        String[] scenePathParts = scenePath.split(splitExpr);
        String[] externalPathParts = imagePath.split(splitExpr);
        for (numCommon = 0; numCommon < scenePathParts.length && numCommon < externalPathParts.length && scenePathParts[numCommon].equals(externalPathParts[numCommon]); ++numCommon) {
        }
        StringBuilder relPath = new StringBuilder();
        for (i = numCommon; i < scenePathParts.length; ++i) {
            relPath.append("..").append(File.separator);
        }
        for (i = numCommon; i < externalPathParts.length; ++i) {
            if (i > numCommon) {
                relPath.append(File.separator);
            }
            relPath.append(externalPathParts[i]);
        }
        return relPath.toString();
    }
}

