/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.keystroke;

import artofillusion.keystroke.KeystrokeEditor;
import artofillusion.keystroke.KeystrokeManager;
import artofillusion.keystroke.KeystrokeRecord;
import artofillusion.script.ScriptRunner;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.MouseClickedEvent;
import buoy.event.SelectionChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BScrollPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BTable;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.table.AbstractTableModel;

public class KeystrokePreferencesPanel
extends FormContainer {
    private final ArrayList<KeystrokeRecord> records;
    private BTable table;
    private BButton editButton;
    private BButton addButton;
    private BButton deleteButton;
    private boolean changed;
    private int sortColumn = 1;

    public KeystrokePreferencesPanel() {
        super(new double[]{1.0}, new double[]{1.0, 0.0});
        KeystrokeRecord[] allRecords = KeystrokeManager.getAllRecords();
        this.records = new ArrayList(allRecords.length);
        for (int i = 0; i < allRecords.length; ++i) {
            this.records.add(allRecords[i]);
        }
        this.table = new BTable(new KeystrokeTableModel());
        this.table.setColumnWidth(0, 100);
        this.table.setColumnWidth(1, 250);
        this.table.setColumnsReorderable(false);
        this.table.addEventLink(SelectionChangedEvent.class, (Object)this, "selectionChanged");
        this.table.addEventLink(MouseClickedEvent.class, (Object)this, "tableClicked");
        this.table.getTableHeader().addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent(MouseClickedEvent ev) {
                int col = KeystrokePreferencesPanel.this.table.findColumn(ev.getPoint());
                if (col > -1) {
                    KeystrokePreferencesPanel.this.sortColumn = col;
                    KeystrokePreferencesPanel.this.sortRecords();
                }
            }
        });
        BScrollPane scroll = new BScrollPane(this.table, BScrollPane.SCROLLBAR_NEVER, BScrollPane.SCROLLBAR_AS_NEEDED);
        scroll.setPreferredViewSize(new Dimension(350, this.table.getRowCount() == 0 ? 150 : 15 * this.table.getRowHeight(0)));
        this.add(scroll, 0, 0, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH));
        RowContainer buttons = new RowContainer();
        this.add(buttons, 0, 1, new LayoutInfo());
        this.editButton = Translate.button("edit", "...", this, "editRecord");
        buttons.add(this.editButton);
        this.addButton = Translate.button("add", "...", this, "addRecord");
        buttons.add(this.addButton);
        this.deleteButton = Translate.button("delete", this, "deleteRecords");
        buttons.add(this.deleteButton);
        this.selectionChanged();
    }

    public void saveChanges() {
        if (!this.changed) {
            return;
        }
        KeystrokeManager.setAllRecords(this.records.toArray(new KeystrokeRecord[this.records.size()]));
        try {
            KeystrokeManager.saveRecords();
        }
        catch (Exception ex) {
            new BStandardDialog("", Translate.text("errorSavingPrefs", (Object)(ex.getMessage() == null ? "" : ex.getMessage())), BStandardDialog.ERROR).showMessageDialog(this);
        }
    }

    private void selectionChanged() {
        int count = this.table.getSelectedRows().length;
        this.editButton.setEnabled(count == 1);
        this.deleteButton.setEnabled(count > 0);
    }

    private void tableClicked(MouseClickedEvent ev) {
        if (ev.getClickCount() != 2 || ev.getModifiersEx() != 0) {
            return;
        }
        this.editRecord();
    }

    private void editRecord() {
        int row = this.table.getSelectedRows()[0];
        KeystrokeRecord record = this.records.get(row);
        KeystrokeRecord edited = KeystrokeEditor.showEditorDialog(record, UIUtilities.findWindow(this));
        if (edited == null) {
            return;
        }
        this.records.set(row, edited);
        this.sortRecords();
        this.changed = true;
    }

    private void addRecord() {
        KeystrokeRecord record = new KeystrokeRecord(0, 0, "", "", ScriptRunner.LANGUAGES[0]);
        KeystrokeRecord edited = KeystrokeEditor.showEditorDialog(record, UIUtilities.findWindow(this));
        if (edited == null) {
            return;
        }
        this.records.add(edited);
        this.sortRecords();
        this.changed = true;
    }

    private void deleteRecords() {
        int[] selected = this.table.getSelectedRows();
        Arrays.sort(selected);
        for (int i = 0; i < selected.length; ++i) {
            this.records.remove(selected[i]);
        }
        this.sortRecords();
        this.changed = true;
    }

    private void sortRecords() {
        final Collator stringComparator = Collator.getInstance(Translate.getLocale());
        Collections.sort(this.records, new Comparator<KeystrokeRecord>(){

            @Override
            public int compare(KeystrokeRecord r1, KeystrokeRecord r2) {
                String s2;
                String s1;
                if (KeystrokePreferencesPanel.this.sortColumn == 0) {
                    s1 = KeystrokePreferencesPanel.getKeyDescription(r1.getKeyCode(), r1.getModifiers());
                    s2 = KeystrokePreferencesPanel.getKeyDescription(r2.getKeyCode(), r2.getModifiers());
                } else {
                    s1 = r1.getName();
                    s2 = r2.getName();
                }
                return stringComparator.compare(s1, s2);
            }
        });
        ((KeystrokeTableModel)this.table.getModel()).fireTableDataChanged();
    }

    static String getKeyDescription(int code, int modifiers) {
        if (code == 0) {
            return "";
        }
        String keyDesc = KeyEvent.getKeyText(code);
        if (modifiers != 0) {
            keyDesc = KeyEvent.getKeyModifiersText(modifiers) + "+" + keyDesc;
        }
        return keyDesc;
    }

    private class KeystrokeTableModel
    extends AbstractTableModel {
        private KeystrokeTableModel() {
        }

        @Override
        public int getRowCount() {
            return KeystrokePreferencesPanel.this.records.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            KeystrokeRecord record = (KeystrokeRecord)KeystrokePreferencesPanel.this.records.get(rowIndex);
            if (columnIndex == 1) {
                return record.getName();
            }
            return KeystrokePreferencesPanel.getKeyDescription(record.getKeyCode(), record.getModifiers());
        }

        @Override
        public String getColumnName(int column) {
            return column == 1 ? Translate.text("Name") : Translate.text("Key");
        }
    }
}

