/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.material;

import artofillusion.MaterialPreviewer;
import artofillusion.Scene;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.material.MaterialSpec;
import artofillusion.material.UniformMaterialMapping;
import artofillusion.math.RGBColor;
import artofillusion.object.Object3D;
import artofillusion.ui.ActionProcessor;
import artofillusion.ui.ColorChooser;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.MouseClickedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BTextField;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class UniformMaterial
extends Material {
    RGBColor transparencyColor;
    RGBColor matColor;
    RGBColor scatteringColor;
    RGBColor trueTrans;
    RGBColor trueScat;
    float density;
    float scattering;
    float transparency;
    double eccentricity;
    boolean shadows;

    public UniformMaterial() {
        this.transparencyColor = new RGBColor(1.0f, 1.0f, 1.0f);
        this.matColor = new RGBColor(0.0f, 0.0f, 0.0f);
        this.scatteringColor = new RGBColor(0.5f, 0.5f, 0.5f);
        this.trueTrans = new RGBColor(0.0f, 0.0f, 0.0f);
        this.trueScat = new RGBColor(0.0f, 0.0f, 0.0f);
        this.density = 1.0f;
        this.scattering = 0.0f;
        this.transparency = 0.5f;
        this.eccentricity = 0.0;
        this.name = "";
        this.refraction = 1.0;
        this.shadows = true;
        this.recalcColors();
    }

    private void recalcColors() {
        this.trueTrans.setRGB((float)Math.pow(this.transparencyColor.red * this.transparency, this.density), (float)Math.pow(this.transparencyColor.green * this.transparency, this.density), (float)Math.pow(this.transparencyColor.blue * this.transparency, this.density));
        this.trueScat.copy(this.scatteringColor);
        this.trueScat.scale(this.density * this.scattering);
    }

    public static String getTypeName() {
        return "Uniform";
    }

    @Override
    public boolean isScattering() {
        return (double)this.density > 0.0 && (double)this.scattering > 0.0;
    }

    @Override
    public boolean castsShadows() {
        return this.shadows;
    }

    public void getMaterialSpec(MaterialSpec spec) {
        spec.transparency.copy(this.trueTrans);
        spec.color.copy(this.matColor);
        if ((double)this.scattering > 0.0) {
            spec.scattering.copy(this.trueScat);
            spec.eccentricity = this.eccentricity;
        }
    }

    @Override
    public MaterialMapping getDefaultMapping(Object3D obj) {
        return new UniformMaterialMapping(obj, this);
    }

    @Override
    public Material duplicate() {
        UniformMaterial m = new UniformMaterial();
        m.name = this.name;
        m.transparencyColor.copy(this.transparencyColor);
        m.matColor.copy(this.matColor);
        m.scatteringColor.copy(this.scatteringColor);
        m.refraction = this.refraction;
        m.density = this.density;
        m.scattering = this.scattering;
        m.transparency = this.transparency;
        m.eccentricity = this.eccentricity;
        m.shadows = this.shadows;
        m.recalcColors();
        return m;
    }

    @Override
    public void edit(WindowWidget parent, Scene sc) {
        final UniformMaterial newMaterial = (UniformMaterial)this.duplicate();
        BTextField nameField = new BTextField(this.name);
        final ValueField refractField = new ValueField(this.refraction, 3);
        final ValueSlider densitySlider = new ValueSlider(0.0, 1.0, 100, this.density);
        final ValueSlider scatSlider = new ValueSlider(0.0, 1.0, 100, this.scattering);
        final ValueSlider transSlider = new ValueSlider(0.0, 1.0, 100, this.transparency);
        final ValueSlider eccSlider = new ValueSlider(-1.0, 1.0, 100, this.eccentricity);
        final Widget transPatch = this.transparencyColor.getSample(50, 30);
        final Widget colorPatch = this.matColor.getSample(50, 30);
        final Widget scatPatch = this.scatteringColor.getSample(50, 30);
        final BCheckBox shadowBox = new BCheckBox(Translate.text("CastsShadows"), this.shadows);
        final MaterialPreviewer preview = new MaterialPreviewer(null, newMaterial, 200, 160);
        final ActionProcessor process = new ActionProcessor();
        final Runnable renderCallback = new Runnable(){

            @Override
            public void run() {
                preview.render();
            }
        };
        transPatch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(transPatch, Translate.text("Transparency"), newMaterial.transparencyColor);
                transPatch.setBackground(newMaterial.transparencyColor.getColor());
                newMaterial.recalcColors();
                process.addEvent(renderCallback);
            }
        });
        colorPatch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(colorPatch, Translate.text("MaterialColor"), newMaterial.matColor);
                colorPatch.setBackground(newMaterial.matColor.getColor());
                newMaterial.recalcColors();
                process.addEvent(renderCallback);
            }
        });
        scatPatch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(scatPatch, Translate.text("ScatteringColor"), newMaterial.scatteringColor);
                scatPatch.setBackground(newMaterial.scatteringColor.getColor());
                newMaterial.recalcColors();
                process.addEvent(renderCallback);
            }
        });
        Object valueListener = new Object(){

            void processEvent() {
                newMaterial.density = (float)densitySlider.getValue();
                newMaterial.scattering = (float)scatSlider.getValue();
                newMaterial.transparency = (float)transSlider.getValue();
                newMaterial.eccentricity = (float)eccSlider.getValue();
                newMaterial.refraction = refractField.getValue();
                newMaterial.shadows = shadowBox.getState();
                newMaterial.recalcColors();
                process.addEvent(renderCallback);
            }
        };
        refractField.addEventLink(ValueChangedEvent.class, valueListener);
        densitySlider.addEventLink(ValueChangedEvent.class, valueListener);
        scatSlider.addEventLink(ValueChangedEvent.class, valueListener);
        transSlider.addEventLink(ValueChangedEvent.class, valueListener);
        eccSlider.addEventLink(ValueChangedEvent.class, valueListener);
        shadowBox.addEventLink(ValueChangedEvent.class, valueListener);
        ComponentsDialog dlg = new ComponentsDialog(parent, "", new Widget[]{preview, nameField, colorPatch, transPatch, transSlider, densitySlider, scatSlider, scatPatch, eccSlider, refractField, shadowBox}, new String[]{null, Translate.text("Name"), Translate.text("EmissiveColor"), Translate.text("TransparentColor"), Translate.text("Transparency"), Translate.text("Density"), Translate.text("Scattering"), Translate.text("ScatteringColor"), Translate.text("Eccentricity"), Translate.text("IndexOfRefraction"), null});
        process.stopProcessing();
        if (!dlg.clickedOk()) {
            return;
        }
        this.refraction = refractField.getValue();
        this.transparency = (float)transSlider.getValue();
        this.density = (float)densitySlider.getValue();
        this.scattering = (float)scatSlider.getValue();
        this.name = nameField.getText();
        this.transparencyColor.copy(newMaterial.transparencyColor);
        this.matColor.copy(newMaterial.matColor);
        this.scatteringColor.copy(newMaterial.scatteringColor);
        this.eccentricity = newMaterial.eccentricity;
        this.shadows = newMaterial.shadows;
        this.recalcColors();
        int index = sc.indexOf(this);
        if (index > -1) {
            sc.changeMaterial(index);
        }
    }

    public UniformMaterial(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.refraction = in.readDouble();
        this.transparencyColor = new RGBColor(in);
        this.matColor = new RGBColor(in);
        this.scatteringColor = new RGBColor(in);
        this.density = in.readFloat();
        this.scattering = in.readFloat();
        this.transparency = version == 0 ? 1.0f : in.readFloat();
        this.eccentricity = in.readDouble();
        this.shadows = in.readBoolean();
        this.trueTrans = new RGBColor(0.0f, 0.0f, 0.0f);
        this.trueScat = new RGBColor(0.0f, 0.0f, 0.0f);
        this.recalcColors();
    }

    @Override
    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(1);
        out.writeUTF(this.name);
        out.writeDouble(this.refraction);
        this.transparencyColor.writeToFile(out);
        this.matColor.writeToFile(out);
        this.scatteringColor.writeToFile(out);
        out.writeFloat(this.density);
        out.writeFloat(this.scattering);
        out.writeFloat(this.transparency);
        out.writeDouble(this.eccentricity);
        out.writeBoolean(this.shadows);
    }
}

