/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.math;

import artofillusion.math.FastMath;
import artofillusion.math.Vec3;
import java.util.Random;

public class PerlinNoise {
    private static short[] permute;
    private static short[] grad;
    private static Vec3[] vect;
    private static final int TABLE_SIZE = 256;
    private static final double GRAD_SCALE;

    public static double value(double x, double y, double z) {
        double xi = FastMath.floor(x);
        double yi = FastMath.floor(y);
        double zi = FastMath.floor(z);
        double u1 = x - xi;
        double v1 = y - yi;
        double w1 = z - zi;
        double u2 = 1.0 - u1;
        double v2 = 1.0 - v1;
        double w2 = 1.0 - w1;
        int i = (int)xi & 0xFF;
        int j = (int)yi & 0xFF;
        int k = (int)zi & 0xFF;
        return GRAD_SCALE * (PerlinNoise.getWavelet(i, j, k, u1, v1, w1) + PerlinNoise.getWavelet(i + 1, j, k, u2, v1, w1) + PerlinNoise.getWavelet(i, j + 1, k, u1, v2, w1) + PerlinNoise.getWavelet(i + 1, j + 1, k, u2, v2, w1) + PerlinNoise.getWavelet(i, j, k + 1, u1, v1, w2) + PerlinNoise.getWavelet(i + 1, j, k + 1, u2, v1, w2) + PerlinNoise.getWavelet(i, j + 1, k + 1, u1, v2, w2) + PerlinNoise.getWavelet(i + 1, j + 1, k + 1, u2, v2, w2));
    }

    private static double getWavelet(int i, int j, int k, double u, double v, double w) {
        double u2 = u * u;
        double v2 = v * v;
        double w2 = w * w;
        double drop = 1.0 - u2 * (10.0 * u + (6.0 * u - 15.0) * u2);
        drop *= 1.0 - v2 * (10.0 * v + (6.0 * v - 15.0) * v2);
        drop *= 1.0 - w2 * (10.0 * w + (6.0 * w - 15.0) * w2);
        switch (grad[permute[permute[i] + j] + k]) {
            case 0: {
                return drop * (u + v);
            }
            case 1: {
                return drop * (-u + v);
            }
            case 2: {
                return drop * (u - v);
            }
            case 3: {
                return drop * (-u - v);
            }
            case 4: {
                return drop * (u + w);
            }
            case 5: {
                return drop * (-u + w);
            }
            case 6: {
                return drop * (u - w);
            }
            case 7: {
                return drop * (-u - w);
            }
            case 8: {
                return drop * (v + w);
            }
            case 9: {
                return drop * (-v + w);
            }
            case 10: {
                return drop * (v - w);
            }
            case 11: {
                return drop * (-v - w);
            }
        }
        return 0.0;
    }

    public static void calcGradient(Vec3 gradient, double x, double y, double z) {
        double xi = FastMath.floor(x);
        double yi = FastMath.floor(y);
        double zi = FastMath.floor(z);
        double u1 = x - xi;
        double v1 = y - yi;
        double w1 = z - zi;
        double u2 = 1.0 - u1;
        double v2 = 1.0 - v1;
        double w2 = 1.0 - w1;
        int i = (int)xi & 0xFF;
        int j = (int)yi & 0xFF;
        int k = (int)zi & 0xFF;
        gradient.set(0.0, 0.0, 0.0);
        PerlinNoise.addWaveletGradient(gradient, i, j, k, u1, v1, w1);
        PerlinNoise.addWaveletGradient(gradient, i + 1, j, k, u2, v1, w1);
        PerlinNoise.addWaveletGradient(gradient, i, j + 1, k, u1, v2, w1);
        PerlinNoise.addWaveletGradient(gradient, i + 1, j + 1, k, u2, v2, w1);
        PerlinNoise.addWaveletGradient(gradient, i, j, k + 1, u1, v1, w2);
        PerlinNoise.addWaveletGradient(gradient, i + 1, j, k + 1, u2, v1, w2);
        PerlinNoise.addWaveletGradient(gradient, i, j + 1, k + 1, u1, v2, w2);
        PerlinNoise.addWaveletGradient(gradient, i + 1, j + 1, k + 1, u2, v2, w2);
        gradient.scale(2.0);
    }

    private static void addWaveletGradient(Vec3 gradient, int i, int j, int k, double u, double v, double w) {
        double u2 = u * u;
        double v2 = v * v;
        double w2 = w * w;
        double dropu = 1.0 - u2 * (10.0 * u + (6.0 * u - 15.0) * u2);
        double dropv = 1.0 - v2 * (10.0 * v + (6.0 * v - 15.0) * v2);
        double dropw = 1.0 - w2 * (10.0 * w + (6.0 * w - 15.0) * w2);
        double product = dropu * dropv * dropw;
        switch (grad[permute[permute[i] + j] + k]) {
            case 0: {
                double dot = 30.0 * (u + v);
                gradient.x += -dropv * dropw * u2 * (u2 - 2.0 * u + 1.0) * dot + product;
                gradient.y += -dropw * dropu * v2 * (v2 - 2.0 * v + 1.0) * dot + product;
                gradient.z += -dropu * dropv * w2 * (w2 - 2.0 * w + 1.0) * dot;
                return;
            }
            case 1: {
                double dot = 30.0 * (-u + v);
                gradient.x += -dropv * dropw * u2 * (u2 - 2.0 * u + 1.0) * dot - product;
                gradient.y += -dropw * dropu * v2 * (v2 - 2.0 * v + 1.0) * dot + product;
                gradient.z += -dropu * dropv * w2 * (w2 - 2.0 * w + 1.0) * dot;
                return;
            }
            case 2: {
                double dot = 30.0 * (u - v);
                gradient.x += -dropv * dropw * u2 * (u2 - 2.0 * u + 1.0) * dot + product;
                gradient.y += -dropw * dropu * v2 * (v2 - 2.0 * v + 1.0) * dot - product;
                gradient.z += -dropu * dropv * w2 * (w2 - 2.0 * w + 1.0) * dot;
                return;
            }
            case 3: {
                double dot = -30.0 * (u + v);
                gradient.x += -dropv * dropw * u2 * (u2 - 2.0 * u + 1.0) * dot - product;
                gradient.y += -dropw * dropu * v2 * (v2 - 2.0 * v + 1.0) * dot - product;
                gradient.z += -dropu * dropv * w2 * (w2 - 2.0 * w + 1.0) * dot;
                return;
            }
            case 4: {
                double dot = 30.0 * (u + w);
                gradient.x += -dropv * dropw * u2 * (u2 - 2.0 * u + 1.0) * dot + product;
                gradient.y += -dropw * dropu * v2 * (v2 - 2.0 * v + 1.0) * dot;
                gradient.z += -dropu * dropv * w2 * (w2 - 2.0 * w + 1.0) * dot + product;
                return;
            }
            case 5: {
                double dot = 30.0 * (-u + w);
                gradient.x += -dropv * dropw * u2 * (u2 - 2.0 * u + 1.0) * dot - product;
                gradient.y += -dropw * dropu * v2 * (v2 - 2.0 * v + 1.0) * dot;
                gradient.z += -dropu * dropv * w2 * (w2 - 2.0 * w + 1.0) * dot + product;
                return;
            }
            case 6: {
                double dot = 30.0 * (u - w);
                gradient.x += -dropv * dropw * u2 * (u2 - 2.0 * u + 1.0) * dot + product;
                gradient.y += -dropw * dropu * v2 * (v2 - 2.0 * v + 1.0) * dot;
                gradient.z += -dropu * dropv * w2 * (w2 - 2.0 * w + 1.0) * dot - product;
                return;
            }
            case 7: {
                double dot = -30.0 * (u + w);
                gradient.x += -dropv * dropw * u2 * (u2 - 2.0 * u + 1.0) * dot - product;
                gradient.y += -dropw * dropu * v2 * (v2 - 2.0 * v + 1.0) * dot;
                gradient.z += -dropu * dropv * w2 * (w2 - 2.0 * w + 1.0) * dot - product;
                return;
            }
            case 8: {
                double dot = 30.0 * (v + w);
                gradient.x += -dropv * dropw * u2 * (u2 - 2.0 * u + 1.0) * dot;
                gradient.y += -dropw * dropu * v2 * (v2 - 2.0 * v + 1.0) * dot + product;
                gradient.z += -dropu * dropv * w2 * (w2 - 2.0 * w + 1.0) * dot + product;
                return;
            }
            case 9: {
                double dot = 30.0 * (-v + w);
                gradient.x += -dropv * dropw * u2 * (u2 - 2.0 * u + 1.0) * dot;
                gradient.y += -dropw * dropu * v2 * (v2 - 2.0 * v + 1.0) * dot - product;
                gradient.z += -dropu * dropv * w2 * (w2 - 2.0 * w + 1.0) * dot + product;
                return;
            }
            case 10: {
                double dot = 30.0 * (v - w);
                gradient.x += -dropv * dropw * u2 * (u2 - 2.0 * u + 1.0) * dot;
                gradient.y += -dropw * dropu * v2 * (v2 - 2.0 * v + 1.0) * dot + product;
                gradient.z += -dropu * dropv * w2 * (w2 - 2.0 * w + 1.0) * dot - product;
                return;
            }
            case 11: {
                double dot = -30.0 * (v + w);
                gradient.x += -dropv * dropw * u2 * (u2 - 2.0 * u + 1.0) * dot;
                gradient.y += -dropw * dropu * v2 * (v2 - 2.0 * v + 1.0) * dot - product;
                gradient.z += -dropu * dropv * w2 * (w2 - 2.0 * w + 1.0) * dot - product;
                return;
            }
        }
    }

    public static void calcVector(Vec3 v, double x, double y, double z) {
        double xi = FastMath.floor(x);
        double yi = FastMath.floor(y);
        double zi = FastMath.floor(z);
        double u1 = x - xi;
        double v1 = y - yi;
        double w1 = z - zi;
        double u2 = 1.0 - u1;
        double v2 = 1.0 - v1;
        double w2 = 1.0 - w1;
        int i = (int)xi & 0xFF;
        int j = (int)yi & 0xFF;
        int k = (int)zi & 0xFF;
        v.set(0.0, 0.0, 0.0);
        PerlinNoise.addVectorWavelet(v, i, j, k, u1, v1, w1);
        PerlinNoise.addVectorWavelet(v, i + 1, j, k, u2, v1, w1);
        PerlinNoise.addVectorWavelet(v, i, j + 1, k, u1, v2, w1);
        PerlinNoise.addVectorWavelet(v, i + 1, j + 1, k, u2, v2, w1);
        PerlinNoise.addVectorWavelet(v, i, j, k + 1, u1, v1, w2);
        PerlinNoise.addVectorWavelet(v, i + 1, j, k + 1, u2, v1, w2);
        PerlinNoise.addVectorWavelet(v, i, j + 1, k + 1, u1, v2, w2);
        PerlinNoise.addVectorWavelet(v, i + 1, j + 1, k + 1, u2, v2, w2);
    }

    private static void addVectorWavelet(Vec3 vec, int i, int j, int k, double u, double v, double w) {
        Vec3 g = vect[permute[permute[permute[i] + j] + k]];
        double u2 = u * u;
        double v2 = v * v;
        double w2 = w * w;
        double drop = 1.0 - u2 * (10.0 * u + (6.0 * u - 15.0) * u2);
        drop *= 1.0 - v2 * (10.0 * v + (6.0 * v - 15.0) * v2);
        vec.x += (drop *= 1.0 - w2 * (10.0 * w + (6.0 * w - 15.0) * w2)) * g.x;
        vec.y += drop * g.y;
        vec.z += drop * g.z;
    }

    static {
        int i;
        GRAD_SCALE = 2.0 / Math.sqrt(2.0);
        Random random = new Random();
        random.setSeed(0L);
        permute = new short[512];
        grad = new short[512];
        for (i = 0; i < 256; ++i) {
            PerlinNoise.permute[i] = (short)i;
        }
        for (i = 0; i < 256; ++i) {
            int j = Math.abs(random.nextInt()) % 256;
            short temp = permute[i];
            PerlinNoise.permute[i] = permute[j];
            PerlinNoise.permute[j] = temp;
        }
        for (i = 0; i < 256; ++i) {
            PerlinNoise.grad[i] = (short)(permute[i] % 12);
        }
        vect = new Vec3[512];
        for (i = 0; i < 256; ++i) {
            Vec3 v;
            double len;
            while ((len = (v = new Vec3(2.0 * random.nextDouble() - 1.0, 2.0 * random.nextDouble() - 1.0, 2.0 * random.nextDouble() - 1.0)).length2()) > 1.0) {
            }
            v.scale(1.0 / Math.sqrt(len));
            PerlinNoise.vect[i] = v;
        }
        for (i = 0; i < 256; ++i) {
            PerlinNoise.permute[256 + i] = permute[i];
            PerlinNoise.grad[256 + i] = grad[i];
            PerlinNoise.vect[256 + i] = vect[i];
        }
    }
}

