/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Property;
import artofillusion.Scene;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.PoseTrack;
import artofillusion.math.BoundingBox;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Light;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ColorChooser;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.event.MouseClickedEvent;
import buoy.widget.BComboBox;
import buoy.widget.BFrame;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class PointLight
extends Light {
    double radius;
    static BoundingBox bounds;
    static WireframeMesh mesh;
    private static final Property[] PROPERTIES;

    public PointLight(RGBColor theColor, float theIntensity, double theRadius) {
        this(theColor, theIntensity, theRadius, 0, 0.25f);
    }

    public PointLight(RGBColor theColor, float theIntensity, double theRadius, int type, float decay) {
        this.setParameters(theColor.duplicate(), theIntensity, type, decay);
        this.setRadius(theRadius);
        bounds = new BoundingBox(-0.25, 0.25, -0.25, 0.25, -0.25, 0.25);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double r) {
        this.radius = r;
    }

    @Override
    public void getLight(RGBColor light, Vec3 position) {
        double d = position.length() * (double)this.decayRate;
        light.copy(this.color);
        light.scale((double)this.intensity / (1.0 + d + d * d));
    }

    @Override
    public Object3D duplicate() {
        return new PointLight(this.color, this.intensity, this.radius, this.type, this.decayRate);
    }

    @Override
    public void copyObject(Object3D obj) {
        PointLight lt = (PointLight)obj;
        this.setParameters(lt.color.duplicate(), lt.intensity, lt.type, lt.decayRate);
        this.setRadius(lt.radius);
    }

    @Override
    public BoundingBox getBounds() {
        return bounds;
    }

    @Override
    public void setSize(double xsize, double ysize, double zsize) {
    }

    @Override
    public boolean canSetTexture() {
        return false;
    }

    @Override
    public WireframeMesh getWireframeMesh() {
        return mesh;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public void edit(EditingWindow parent, ObjectInfo info, Runnable cb) {
        final Widget patch = this.color.getSample(50, 30);
        ValueField intensityField = new ValueField(this.intensity, 0);
        ValueField radiusField = new ValueField(this.radius, 1);
        ValueField decayField = new ValueField(this.decayRate, 1);
        BComboBox typeChoice = new BComboBox(new String[]{Translate.text("normalLight"), Translate.text("shadowlessLight"), Translate.text("ambientLight")});
        typeChoice.setSelectedIndex(this.type);
        RGBColor oldColor = this.color.duplicate();
        BFrame parentFrame = parent.getFrame();
        patch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(patch, Translate.text("lightColor"), PointLight.this.color);
                patch.setBackground(PointLight.this.color.getColor());
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(parentFrame, Translate.text("editPointLightTitle"), new Widget[]{patch, intensityField, radiusField, decayField, typeChoice}, new String[]{Translate.text("Color"), Translate.text("Intensity"), Translate.text("Radius"), Translate.text("decayRate"), Translate.text("lightType")});
        if (!dlg.clickedOk()) {
            this.color.copy(oldColor);
            return;
        }
        this.setParameters(this.color, (float)intensityField.getValue(), typeChoice.getSelectedIndex(), (float)decayField.getValue());
        this.setRadius(radiusField.getValue());
        cb.run();
    }

    public PointLight(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.setParameters(new RGBColor(in), in.readFloat(), version == 0 ? (in.readBoolean() ? 2 : 0) : in.readShort(), in.readFloat());
        this.setRadius(in.readDouble());
    }

    @Override
    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(1);
        this.color.writeToFile(out);
        out.writeFloat(this.intensity);
        out.writeShort(this.type);
        out.writeFloat(this.decayRate);
        out.writeDouble(this.radius);
    }

    @Override
    public Property[] getProperties() {
        return (Property[])PROPERTIES.clone();
    }

    @Override
    public Object getPropertyValue(int index) {
        switch (index) {
            case 0: {
                return this.color.duplicate();
            }
            case 1: {
                return new Double(this.intensity);
            }
            case 2: {
                return new Double(this.decayRate);
            }
            case 3: {
                return this.radius;
            }
            case 4: {
                return PROPERTIES[index].getAllowedValues()[this.type];
            }
        }
        return null;
    }

    @Override
    public void setPropertyValue(int index, Object value) {
        if (index == 0) {
            this.color = ((RGBColor)value).duplicate();
        } else if (index == 1) {
            this.intensity = ((Double)value).floatValue();
        } else if (index == 2) {
            this.decayRate = ((Double)value).floatValue();
        } else if (index == 3) {
            this.radius = (Double)value;
        } else if (index == 4) {
            Object[] values = PROPERTIES[index].getAllowedValues();
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].equals(value)) continue;
                this.type = i;
            }
        }
    }

    @Override
    public Keyframe getPoseKeyframe() {
        return new PointLightKeyframe(this.color, this.intensity, this.decayRate, this.radius);
    }

    @Override
    public void applyPoseKeyframe(Keyframe k) {
        PointLightKeyframe key = (PointLightKeyframe)k;
        this.setParameters(key.color.duplicate(), key.intensity, this.type, key.decayRate);
        this.setRadius(key.radius);
    }

    @Override
    public void configurePoseTrack(PoseTrack track) {
        track.setGraphableValues(new String[]{"Intensity", "Decay Rate", "Radius"}, new double[]{this.intensity, this.decayRate, this.radius}, new double[][]{{-1.7976931348623157E308, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}});
    }

    @Override
    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        final PointLightKeyframe key = (PointLightKeyframe)k;
        final Widget patch = key.color.getSample(50, 30);
        ValueField intensityField = new ValueField(key.intensity, 0);
        ValueField radiusField = new ValueField(key.radius, 1);
        ValueField decayField = new ValueField(key.decayRate, 1);
        RGBColor oldColor = key.color.duplicate();
        BFrame parentFrame = parent.getFrame();
        patch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(patch, Translate.text("lightColor"), key.color);
                patch.setBackground(key.color.getColor());
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(parentFrame, Translate.text("editPointLightTitle"), new Widget[]{patch, intensityField, radiusField, decayField}, new String[]{Translate.text("Color"), Translate.text("Intensity"), Translate.text("Radius"), Translate.text("decayRate")});
        if (!dlg.clickedOk()) {
            key.color.copy(oldColor);
            return;
        }
        key.intensity = (float)intensityField.getValue();
        key.decayRate = (float)decayField.getValue();
        key.radius = radiusField.getValue();
    }

    static {
        PROPERTIES = new Property[]{new Property(Translate.text("lightColor"), new RGBColor(1.0, 1.0, 1.0)), new Property(Translate.text("Intensity"), -1.7976931348623157E308, Double.MAX_VALUE, 1.0), new Property(Translate.text("decayRate"), 0.0, Double.MAX_VALUE, 0.25), new Property(Translate.text("Radius"), 0.0, Double.MAX_VALUE, 0.1), new Property(Translate.text("lightType"), new String[]{Translate.text("normalLight"), Translate.text("shadowlessLight"), Translate.text("ambientLight")}, Translate.text("normalLight"))};
        double r1 = 0.05;
        double r2 = 0.25;
        bounds = new BoundingBox(-0.25, 0.25, -0.25, 0.25, -0.25, 0.25);
        Vec3[] vert = new Vec3[28];
        int[] from = new int[14];
        int[] to = new int[14];
        vert[0] = new Vec3(r1, 0.0, 0.0);
        vert[1] = new Vec3(r2, 0.0, 0.0);
        from[0] = 0;
        to[0] = 1;
        vert[2] = new Vec3(-r1, 0.0, 0.0);
        vert[3] = new Vec3(-r2, 0.0, 0.0);
        from[1] = 2;
        to[1] = 3;
        vert[4] = new Vec3(0.0, r1, 0.0);
        vert[5] = new Vec3(0.0, r2, 0.0);
        from[2] = 4;
        to[2] = 5;
        vert[6] = new Vec3(0.0, -r1, 0.0);
        vert[7] = new Vec3(0.0, -r2, 0.0);
        from[3] = 6;
        to[3] = 7;
        vert[8] = new Vec3(0.0, 0.0, r1);
        vert[9] = new Vec3(0.0, 0.0, r2);
        from[4] = 8;
        to[4] = 9;
        vert[10] = new Vec3(0.0, 0.0, -r1);
        vert[11] = new Vec3(0.0, 0.0, -r2);
        from[5] = 10;
        to[5] = 11;
        r1 *= 0.57735;
        r2 *= 0.57735;
        int ind1 = 12;
        int ind2 = 6;
        for (double i = -1.0; i < 2.0; i += 2.0) {
            for (double j = -1.0; j < 2.0; j += 2.0) {
                for (double k = -1.0; k < 2.0; k += 2.0) {
                    vert[ind1++] = new Vec3(r1 * i, r1 * j, r1 * k);
                    vert[ind1++] = new Vec3(r2 * i, r2 * j, r2 * k);
                    from[ind2] = ind1 - 2;
                    to[ind2++] = ind1 - 1;
                }
            }
        }
        mesh = new WireframeMesh(vert, from, to);
    }

    public static class PointLightKeyframe
    implements Keyframe {
        public RGBColor color;
        public float intensity;
        public float decayRate;
        public double radius;

        public PointLightKeyframe(RGBColor color, float intensity, float decayRate, double radius) {
            this.color = color.duplicate();
            this.intensity = intensity;
            this.decayRate = decayRate;
            this.radius = radius;
        }

        @Override
        public Keyframe duplicate() {
            return new PointLightKeyframe(this.color, this.intensity, this.decayRate, this.radius);
        }

        @Override
        public Keyframe duplicate(Object owner) {
            return this.duplicate();
        }

        @Override
        public double[] getGraphValues() {
            return new double[]{this.intensity, this.decayRate, this.radius};
        }

        @Override
        public void setGraphValues(double[] values) {
            this.intensity = (float)values[0];
            this.decayRate = (float)values[1];
            this.radius = values[2];
        }

        @Override
        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            PointLightKeyframe k2 = (PointLightKeyframe)o2;
            RGBColor c = new RGBColor(weight1 * (double)this.color.getRed() + weight2 * (double)k2.color.getRed(), weight1 * (double)this.color.getGreen() + weight2 * (double)k2.color.getGreen(), weight1 * (double)this.color.getBlue() + weight2 * (double)k2.color.getBlue());
            return new PointLightKeyframe(c, (float)(weight1 * (double)this.intensity + weight2 * (double)k2.intensity), (float)(weight1 * (double)this.decayRate + weight2 * (double)k2.decayRate), weight1 * this.radius + weight2 * k2.radius);
        }

        @Override
        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            PointLightKeyframe k2 = (PointLightKeyframe)o2;
            PointLightKeyframe k3 = (PointLightKeyframe)o3;
            RGBColor c = new RGBColor(weight1 * (double)this.color.getRed() + weight2 * (double)k2.color.getRed() + weight3 * (double)k3.color.getRed(), weight1 * (double)this.color.getGreen() + weight2 * (double)k2.color.getGreen() + weight3 * (double)k3.color.getGreen(), weight1 * (double)this.color.getBlue() + weight2 * (double)k2.color.getBlue() + weight3 * (double)k3.color.getBlue());
            return new PointLightKeyframe(c, (float)(weight1 * (double)this.intensity + weight2 * (double)k2.intensity + weight3 * (double)k3.intensity), (float)(weight1 * (double)this.decayRate + weight2 * (double)k2.decayRate + weight3 * (double)k3.decayRate), weight1 * this.radius + weight2 * k2.radius + weight3 * k3.radius);
        }

        @Override
        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            PointLightKeyframe k2 = (PointLightKeyframe)o2;
            PointLightKeyframe k3 = (PointLightKeyframe)o3;
            PointLightKeyframe k4 = (PointLightKeyframe)o4;
            RGBColor c = new RGBColor(weight1 * (double)this.color.getRed() + weight2 * (double)k2.color.getRed() + weight3 * (double)k3.color.getRed() + weight4 * (double)k4.color.getRed(), weight1 * (double)this.color.getGreen() + weight2 * (double)k2.color.getGreen() + weight3 * (double)k3.color.getGreen() + weight4 * (double)k4.color.getGreen(), weight1 * (double)this.color.getBlue() + weight2 * (double)k2.color.getBlue() + weight3 * (double)k3.color.getBlue() + weight4 * (double)k4.color.getBlue());
            return new PointLightKeyframe(c, (float)(weight1 * (double)this.intensity + weight2 * (double)k2.intensity + weight3 * (double)k3.intensity + weight4 * (double)k4.intensity), (float)(weight1 * (double)this.decayRate + weight2 * (double)k2.decayRate + weight3 * (double)k3.decayRate + weight4 * (double)k4.decayRate), weight1 * this.radius + weight2 * k2.radius + weight3 * k3.radius + weight4 * k4.radius);
        }

        @Override
        public boolean equals(Keyframe k) {
            if (!(k instanceof PointLightKeyframe)) {
                return false;
            }
            PointLightKeyframe key = (PointLightKeyframe)k;
            return key.color.equals(this.color) && key.intensity == this.intensity && key.decayRate == this.decayRate && key.radius == this.radius;
        }

        @Override
        public void writeToStream(DataOutputStream out) throws IOException {
            this.color.writeToFile(out);
            out.writeFloat(this.intensity);
            out.writeFloat(this.decayRate);
            out.writeDouble(this.radius);
        }

        public PointLightKeyframe(DataInputStream in, Object parent) throws IOException {
            this(new RGBColor(in), in.readFloat(), in.readFloat(), in.readDouble());
        }
    }
}

