/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.ProceduralModule;
import java.awt.Point;

public class RatioModule
extends ProceduralModule {
    boolean valueOk;
    boolean errorOk;
    double value;
    double error;
    double valueIn1;
    double valueIn2;
    double errorIn1;
    double errorIn2;
    double lastBlur;
    Vec3 tempVec = new Vec3();

    public RatioModule(Point position) {
        super("\u00f7", new IOPort[]{new IOPort(0, 0, 0, new String[]{"Value 1", "(0)"}), new IOPort(0, 0, 1, new String[]{"Value 2", "(0)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Ratio"})}, position);
    }

    @Override
    public void init(PointInfo p) {
        this.errorOk = false;
        this.valueOk = false;
    }

    @Override
    public double getAverageValue(int which, double blur) {
        if (this.valueOk && blur == this.lastBlur) {
            return this.value;
        }
        this.valueOk = true;
        this.lastBlur = blur;
        this.valueIn1 = this.linkFrom[0] == null ? 0.0 : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        double d = this.valueIn2 = this.linkFrom[1] == null ? 0.0 : this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        if (this.valueIn2 == 0.0) {
            this.value = this.valueIn1 < 0.0 ? -1.7976931348623157E308 : Double.MAX_VALUE;
            this.error = Double.MAX_VALUE;
            this.errorOk = true;
            return this.value;
        }
        this.value = this.valueIn1 / this.valueIn2;
        return this.value;
    }

    @Override
    public double getValueError(int which, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        if (this.errorOk) {
            return this.error;
        }
        this.errorOk = true;
        this.valueOk = true;
        this.errorIn1 = this.linkFrom[0] == null ? 0.0 : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        this.errorIn2 = this.linkFrom[1].getValueError(this.linkFromIndex[1], blur);
        this.error = Math.abs(this.errorIn1 / this.valueIn2) + Math.abs(this.valueIn1 * this.errorIn2 / (this.valueIn2 * this.valueIn2));
        return this.error;
    }

    @Override
    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        if (this.linkFrom[0] == null) {
            grad.set(0.0, 0.0, 0.0);
            return;
        }
        if (this.linkFrom[1] == null) {
            grad.set(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
            return;
        }
        this.linkFrom[0].getValueGradient(this.linkFromIndex[0], grad, blur);
        this.linkFrom[1].getValueGradient(this.linkFromIndex[1], this.tempVec, blur);
        double d1 = 1.0 / this.valueIn2;
        double d2 = this.valueIn1 / (this.valueIn2 * this.valueIn2);
        grad.x = grad.x * d1 - this.tempVec.x * d2;
        grad.y = grad.y * d1 - this.tempVec.y * d2;
        grad.z = grad.z * d1 - this.tempVec.z * d2;
    }
}

