/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;

public abstract class ToolButton {
    protected int height;
    protected int width;
    protected int state;
    protected Point position;
    protected Object owner;
    public static final int NORMAL_STATE = 0;
    public static final int SELECTED_STATE = 1;
    public static final int HIGHLIGHTED_STATE = 2;

    public ToolButton(Object owner) {
        this.owner = owner;
        this.state = 0;
        this.position = new Point(0, 0);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public int getState() {
        return this.state;
    }

    public void setSelected(boolean selected) {
        this.state = selected ? 1 : 0;
    }

    public void setHighlighted(boolean highlighted) {
        if (this.state == 1) {
            return;
        }
        this.state = highlighted ? 2 : 0;
    }

    public boolean isSelected() {
        return this.state == 1;
    }

    public boolean isHighlighted() {
        return this.state == 2;
    }

    public abstract void paint(Graphics2D var1);

    public void setPosition(int x, int y) {
        this.position = new Point(x, y);
    }

    public Point getPosition() {
        return this.position;
    }
}

