/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.unwrap;

import artofillusion.math.Vec3;
import artofillusion.object.MeshVertex;
import artofillusion.object.TriangleMesh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public class SeamFinder {
    private TriangleMesh mesh;
    private double[] edgeVisibility;
    private double[] vertexDistortion;
    private int[] terminalVertices;
    private ArrayList<Integer> seamEdges;

    public SeamFinder(TriangleMesh mesh) {
        this.mesh = mesh;
        this.seamEdges = new ArrayList();
        ArrayList<HashSet<Integer>> surface = this.findSurfaces();
        this.computeEdgeVisibility();
        this.computeVertexDistortion();
        this.findTerminalVertices();
        this.findSeams();
    }

    public List<Integer> getSeamEdges() {
        return Collections.unmodifiableList(this.seamEdges);
    }

    private ArrayList<HashSet<Integer>> findSurfaces() {
        ArrayList<HashSet<Integer>> surfaces = new ArrayList<HashSet<Integer>>();
        TriangleMesh.Edge[] meshEdge = this.mesh.getEdges();
        TriangleMesh.Face[] meshFace = this.mesh.getFaces();
        boolean[] assigned = new boolean[meshFace.length];
        int[] boundary = new int[meshFace.length];
        for (int i = 0; i < assigned.length; ++i) {
            if (assigned[i]) continue;
            HashSet<Integer> surface = new HashSet<Integer>();
            surfaces.add(surface);
            int boundarySize = 0;
            boundary[boundarySize++] = i;
            while (boundarySize > 0) {
                int f3;
                int faceIndex = boundary[--boundarySize];
                surface.add(faceIndex);
                assigned[faceIndex] = true;
                TriangleMesh.Face face = meshFace[faceIndex];
                int f1 = meshEdge[face.e1].f1 == faceIndex ? meshEdge[face.e1].f2 : meshEdge[face.e1].f1;
                int f2 = meshEdge[face.e2].f1 == faceIndex ? meshEdge[face.e2].f2 : meshEdge[face.e2].f1;
                int n = f3 = meshEdge[face.e3].f1 == faceIndex ? meshEdge[face.e3].f2 : meshEdge[face.e3].f1;
                if (f1 != -1 && !assigned[f1]) {
                    boundary[boundarySize++] = f1;
                }
                if (f2 != -1 && !assigned[f2]) {
                    boundary[boundarySize++] = f2;
                }
                if (f3 == -1 || assigned[f3]) continue;
                boundary[boundarySize++] = f3;
            }
        }
        return surfaces;
    }

    private void computeEdgeVisibility() {
        int i;
        MeshVertex[] meshVertex = this.mesh.getVertices();
        TriangleMesh.Face[] meshFace = this.mesh.getFaces();
        TriangleMesh.Edge[] meshEdge = this.mesh.getEdges();
        Vec3[] faceNorm = new Vec3[meshFace.length];
        for (int i2 = 0; i2 < meshFace.length; ++i2) {
            Vec3 edge1 = meshVertex[meshFace[i2].v2].r.minus(meshVertex[meshFace[i2].v1].r);
            Vec3 edge2 = meshVertex[meshFace[i2].v3].r.minus(meshVertex[meshFace[i2].v1].r);
            Vec3 edge3 = meshVertex[meshFace[i2].v3].r.minus(meshVertex[meshFace[i2].v2].r);
            edge1.normalize();
            edge2.normalize();
            edge3.normalize();
            faceNorm[i2] = edge1.cross(edge2);
            double length = faceNorm[i2].length();
            if (!(length > 0.0)) continue;
            faceNorm[i2].scale(1.0 / length);
        }
        double[] vertexVisibility = new double[meshVertex.length];
        Vec3 center = this.mesh.getBounds().getCenter();
        Vec3[] vertexNormal = this.mesh.getNormals();
        for (i = 0; i < vertexVisibility.length; ++i) {
            Vec3 outward = meshVertex[i].r.minus(center);
            outward.normalize();
            vertexVisibility[i] = 0.25 * (2.0 + Math.max(vertexNormal[i].y, 0.0) + vertexNormal[i].dot(outward));
        }
        this.edgeVisibility = new double[meshEdge.length];
        for (i = 0; i < this.edgeVisibility.length; ++i) {
            TriangleMesh.Edge edge = meshEdge[i];
            this.edgeVisibility[i] = 0.5 + 0.5 * (vertexVisibility[edge.v1] + vertexVisibility[edge.v2]);
            if (edge.f2 == -1) continue;
            int n = i;
            this.edgeVisibility[n] = this.edgeVisibility[n] + 0.5 * faceNorm[edge.f1].dot(faceNorm[edge.f2]);
        }
    }

    private void computeVertexDistortion() {
        MeshVertex[] meshVertex = this.mesh.getVertices();
        TriangleMesh.Face[] meshFace = this.mesh.getFaces();
        TriangleMesh.Edge[] meshEdge = this.mesh.getEdges();
        this.vertexDistortion = new double[meshVertex.length];
        double[] localDistortion = new double[meshVertex.length];
        block0: for (int vertIndex = 0; vertIndex < this.vertexDistortion.length; ++vertIndex) {
            TriangleMesh.Edge edge;
            HashSet<Integer> faces = new HashSet<Integer>();
            HashSet<Integer> edges = new HashSet<Integer>();
            int[] vertEdges = ((TriangleMesh.Vertex)meshVertex[vertIndex]).getEdges();
            for (int edgeIndex : vertEdges) {
                edge = meshEdge[edgeIndex];
                faces.add(edge.f1);
                faces.add(edge.f2);
            }
            Object object = faces.iterator();
            while (object.hasNext()) {
                int faceIndex = (Integer)object.next();
                TriangleMesh.Face face = meshFace[faceIndex];
                if (face.v1 != vertIndex && face.v2 != vertIndex) {
                    edges.add(face.e1);
                }
                if (face.v2 != vertIndex && face.v3 != vertIndex) {
                    edges.add(face.e2);
                }
                if (face.v3 == vertIndex || face.v1 == vertIndex) continue;
                edges.add(face.e3);
            }
            localDistortion[vertIndex] = this.computePatchDistortion(meshVertex[vertIndex].r, edges);
            this.vertexDistortion[vertIndex] = localDistortion[vertIndex];
            int iteration = 0;
            while (true) {
                HashSet<Integer> neighbors = new HashSet<Integer>();
                for (int edgeIndex : edges) {
                    edge = meshEdge[edgeIndex];
                    if (!faces.contains(edge.f1) && !neighbors.contains(edge.f1)) {
                        neighbors.add(edge.f1);
                    }
                    if (edge.f2 == -1 || faces.contains(edge.f2) || neighbors.contains(edge.f2)) continue;
                    neighbors.add(edge.f2);
                }
                faces.addAll(neighbors);
                HashSet<Integer> addedEdges = new HashSet<Integer>();
                Iterator edgeIndex = neighbors.iterator();
                while (edgeIndex.hasNext()) {
                    int faceIndex = (Integer)edgeIndex.next();
                    TriangleMesh.Face face = meshFace[faceIndex];
                    addedEdges.add(face.e1);
                    addedEdges.add(face.e2);
                    addedEdges.add(face.e3);
                }
                edgeIndex = addedEdges.iterator();
                while (edgeIndex.hasNext()) {
                    int edgeIndex2 = (Integer)edgeIndex.next();
                    TriangleMesh.Edge edge2 = meshEdge[edgeIndex2];
                    if (faces.contains(edge2.f1) && faces.contains(edge2.f2)) {
                        edges.remove(edgeIndex2);
                        continue;
                    }
                    edges.add(edgeIndex2);
                }
                if (edges.isEmpty() || faces.size() > meshFace.length / 4) continue block0;
                double distortion = this.computePatchDistortion(meshVertex[vertIndex].r, edges);
                if (distortion > this.vertexDistortion[vertIndex]) {
                    this.vertexDistortion[vertIndex] = distortion;
                    continue;
                }
                if (++iteration > 3) break;
            }
        }
    }

    private double computePatchDistortion(Vec3 vertexPos, HashSet<Integer> edges) {
        MeshVertex[] meshVertex = this.mesh.getVertices();
        TriangleMesh.Edge[] meshEdge = this.mesh.getEdges();
        HashSet<Integer> remainingEdges = new HashSet<Integer>(edges);
        ArrayList loopEdges = new ArrayList();
        ArrayList loopVerts = new ArrayList();
        while (remainingEdges.size() > 0) {
            boolean foundEdge = false;
            Iterator<Integer> iter = remainingEdges.iterator();
            block1: while (iter.hasNext() && loopEdges.size() > 0) {
                int edgeIndex = iter.next();
                TriangleMesh.Edge edge = meshEdge[edgeIndex];
                for (int i = 0; i < loopVerts.size(); ++i) {
                    if (((HashSet)loopVerts.get(i)).contains(edge.v1)) {
                        ((HashSet)loopVerts.get(i)).add(edge.v2);
                        ((HashSet)loopEdges.get(i)).add(edgeIndex);
                        iter.remove();
                        foundEdge = true;
                        continue block1;
                    }
                    if (!((HashSet)loopVerts.get(i)).contains(edge.v2)) continue;
                    ((HashSet)loopVerts.get(i)).add(edge.v1);
                    ((HashSet)loopEdges.get(i)).add(edgeIndex);
                    iter.remove();
                    foundEdge = true;
                    continue block1;
                }
            }
            if (foundEdge) continue;
            HashSet<Integer> newLoopEdges = new HashSet<Integer>();
            HashSet<Integer> newLoopVerts = new HashSet<Integer>();
            int edgeIndex = remainingEdges.iterator().next();
            TriangleMesh.Edge edge = meshEdge[edgeIndex];
            newLoopEdges.add(edgeIndex);
            newLoopVerts.add(edge.v1);
            newLoopVerts.add(edge.v2);
            loopEdges.add(newLoopEdges);
            loopVerts.add(newLoopVerts);
            remainingEdges.remove(edgeIndex);
        }
        double totalDistortion = 0.0;
        for (int loop = 0; loop < loopEdges.size(); ++loop) {
            double totalAngle = 0.0;
            boolean isBoundary = false;
            Iterator iterator = ((HashSet)loopEdges.get(loop)).iterator();
            while (iterator.hasNext()) {
                int edgeIndex = (Integer)iterator.next();
                TriangleMesh.Edge edge = meshEdge[edgeIndex];
                if (edge.f2 == -1) {
                    isBoundary = true;
                }
                Vec3 v1 = meshVertex[edge.v1].r.minus(vertexPos);
                Vec3 v2 = meshVertex[edge.v2].r.minus(vertexPos);
                v1.normalize();
                v2.normalize();
                totalAngle += Math.acos(v1.dot(v2));
            }
            double distortion = 1.0 - totalAngle / (Math.PI * 2);
            if (isBoundary && distortion > 0.0) {
                distortion = 0.0;
            }
            totalDistortion += distortion;
        }
        return totalDistortion;
    }

    private void findTerminalVertices() {
        MeshVertex[] meshVertex = this.mesh.getVertices();
        TriangleMesh.Edge[] meshEdge = this.mesh.getEdges();
        ArrayList<Integer> terminals = new ArrayList<Integer>();
        for (int vertIndex = 0; vertIndex < this.vertexDistortion.length; ++vertIndex) {
            if (this.vertexDistortion[vertIndex] < 0.2) continue;
            int[] vertEdges = ((TriangleMesh.Vertex)meshVertex[vertIndex]).getEdges();
            boolean isLocalMaximum = true;
            for (int i = 0; i < vertEdges.length && isLocalMaximum; ++i) {
                int otherVert;
                TriangleMesh.Edge edge = meshEdge[vertEdges[i]];
                int n = otherVert = edge.v1 == vertIndex ? edge.v2 : edge.v1;
                if (!(this.vertexDistortion[otherVert] > this.vertexDistortion[vertIndex])) continue;
                isLocalMaximum = false;
            }
            if (!isLocalMaximum) continue;
            terminals.add(vertIndex);
        }
        this.terminalVertices = new int[terminals.size()];
        for (int i = 0; i < terminals.size(); ++i) {
            this.terminalVertices[i] = (Integer)terminals.get(i);
        }
    }

    private void findSeams() {
        MeshVertex[] meshVertex = this.mesh.getVertices();
        TriangleMesh.Edge[] meshEdge = this.mesh.getEdges();
        double[] edgeCost = new double[meshEdge.length];
        double minCost = 1.0E-10;
        for (int edgeIndex = 0; edgeIndex < meshEdge.length; ++edgeIndex) {
            TriangleMesh.Edge edge = meshEdge[edgeIndex];
            if (edge.f2 == -1) {
                edgeCost[edgeIndex] = minCost;
                continue;
            }
            Object delta = meshVertex[edge.v1].r.minus(meshVertex[edge.v2].r);
            edgeCost[edgeIndex] = Math.max(minCost, ((Vec3)delta).length() * this.edgeVisibility[edgeIndex]);
        }
        int[][] vertEdges = new int[meshVertex.length][];
        for (int vertIndex = 0; vertIndex < meshVertex.length; ++vertIndex) {
            vertEdges[vertIndex] = ((TriangleMesh.Vertex)meshVertex[vertIndex]).getEdges();
        }
        ArrayList<Patch> patches = new ArrayList<Patch>();
        for (int vertIndex : this.terminalVertices) {
            Patch patch = new Patch();
            this.computeCostToVertex(patch.costToVertex, vertIndex, edgeCost, vertEdges);
            patch.addVertex(vertIndex, vertEdges[vertIndex]);
            patches.add(patch);
        }
        int nextPatch = -1;
        while (patches.size() > 1) {
            if (++nextPatch >= patches.size()) {
                nextPatch = 0;
            }
            Patch patch = (Patch)patches.get(nextPatch);
            if (patch.candidates.isEmpty()) {
                patches.remove(nextPatch);
                continue;
            }
            int newVert = patch.getNextCandidate();
            int alreadyInPatch = -1;
            for (int i = 0; i < patches.size(); ++i) {
                if (i == nextPatch || !((Patch)patches.get((int)i)).vertices.contains(newVert)) continue;
                alreadyInPatch = i;
                break;
            }
            if (alreadyInPatch == -1) {
                patch.addVertex(newVert, vertEdges[newVert]);
                continue;
            }
            Patch otherPatch = (Patch)patches.get(alreadyInPatch);
            this.connectVertexToPatch(newVert, patch, vertEdges);
            this.connectVertexToPatch(newVert, otherPatch, vertEdges);
            patch.vertices.addAll(otherPatch.vertices);
            patch.candidates.removeAll(otherPatch.vertices);
            otherPatch.candidates.removeAll(patch.vertices);
            patch.candidates.addAll(otherPatch.candidates);
            double[] costToNewVert = new double[meshVertex.length];
            this.computeCostToVertex(costToNewVert, newVert, edgeCost, vertEdges);
            for (int i = 0; i < costToNewVert.length; ++i) {
                patch.costToVertex[i] = Math.min(Math.min(costToNewVert[i], patch.costToVertex[i]), otherPatch.costToVertex[i]);
            }
            patches.remove(alreadyInPatch);
        }
    }

    private void computeCostToVertex(final double[] costToVertex, int vertex, double[] edgeCost, int[][] vertEdges) {
        TriangleMesh.Edge[] meshEdge = this.mesh.getEdges();
        Arrays.fill(costToVertex, Double.MAX_VALUE);
        costToVertex[vertex] = 0.0;
        boolean[] processed = new boolean[costToVertex.length];
        PriorityQueue<Integer> front = new PriorityQueue<Integer>(10, new Comparator<Integer>(){

            @Override
            public int compare(Integer v1, Integer v2) {
                return Double.compare(costToVertex[v1], costToVertex[v2]);
            }
        });
        front.add(vertex);
        while (!front.isEmpty()) {
            int vertIndex = front.poll();
            processed[vertIndex] = true;
            for (int edgeIndex : vertEdges[vertIndex]) {
                double newDist;
                int newVert;
                TriangleMesh.Edge edge = meshEdge[edgeIndex];
                int n = newVert = edge.v1 == vertIndex ? edge.v2 : edge.v1;
                if (processed[newVert] || !((newDist = costToVertex[vertIndex] + edgeCost[edgeIndex]) < costToVertex[newVert])) continue;
                costToVertex[newVert] = newDist;
                front.add(newVert);
            }
        }
    }

    private void connectVertexToPatch(int vertIndex, Patch patch, int[][] vertEdges) {
        TriangleMesh.Edge[] meshEdge = this.mesh.getEdges();
        while (patch.costToVertex[vertIndex] > 0.0) {
            int bestEdge = -1;
            double bestCost = Double.MAX_VALUE;
            int nextVert = -1;
            for (int edgeIndex : vertEdges[vertIndex]) {
                int otherVert;
                TriangleMesh.Edge edge = meshEdge[edgeIndex];
                int n = otherVert = edge.v1 == vertIndex ? edge.v2 : edge.v1;
                if (!(patch.costToVertex[otherVert] < bestCost)) continue;
                bestEdge = edgeIndex;
                bestCost = patch.costToVertex[otherVert];
                nextVert = otherVert;
            }
            this.seamEdges.add(bestEdge);
            vertIndex = nextVert;
        }
    }

    private class Patch {
        HashSet<Integer> vertices = new HashSet();
        HashSet<Integer> candidates = new HashSet();
        double[] costToVertex;

        Patch() {
            this.costToVertex = new double[SeamFinder.this.mesh.getVertices().length];
        }

        int getNextCandidate() {
            int bestIndex = -1;
            double bestCost = Double.MAX_VALUE;
            for (int vertIndex : this.candidates) {
                if (!(this.costToVertex[vertIndex] < bestCost)) continue;
                bestIndex = vertIndex;
                bestCost = this.costToVertex[vertIndex];
            }
            return bestIndex;
        }

        void addVertex(int vertIndex, int[] vertEdges) {
            this.vertices.add(vertIndex);
            this.candidates.remove(vertIndex);
            for (int edgeIndex : vertEdges) {
                int otherVert;
                TriangleMesh.Edge edge = SeamFinder.this.mesh.getEdges()[edgeIndex];
                int n = otherVert = edge.v1 == vertIndex ? edge.v2 : edge.v1;
                if (this.vertices.contains(otherVert)) continue;
                this.candidates.add(otherVert);
            }
        }
    }
}

