/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.view;

import artofillusion.math.RGBColor;
import artofillusion.texture.TextureSpec;
import artofillusion.view.VertexShader;

public class SelectionVertexShader
implements VertexShader {
    private RGBColor selectionColor;
    private VertexShader shader;
    private int[] faceIndex;
    private boolean[] selected;

    public SelectionVertexShader(RGBColor selectionColor, VertexShader shader, int[] faceIndex, boolean[] selected) {
        this.selectionColor = selectionColor;
        this.shader = shader;
        this.faceIndex = faceIndex;
        this.selected = selected;
    }

    @Override
    public void getColor(int face, int vertex, RGBColor color) {
        if (this.selected[this.faceIndex[face]]) {
            color.copy(this.selectionColor);
        } else {
            this.shader.getColor(face, vertex, color);
        }
    }

    @Override
    public boolean isUniformFace(int face) {
        if (this.selected[this.faceIndex[face]]) {
            return true;
        }
        return this.shader.isUniformFace(face);
    }

    @Override
    public boolean isUniformTexture() {
        return false;
    }

    @Override
    public void getTextureSpec(TextureSpec spec) {
    }
}

