/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.raytracer.PhotonMap;
import artofillusion.raytracer.PhotonSource;
import artofillusion.raytracer.RTEllipsoid;
import artofillusion.raytracer.RTSphere;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.RaytracerRenderer;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.util.ThreadManager;

public class EllipsoidPhotonSource
implements PhotonSource {
    private double rx;
    private double ry;
    private double rz;
    private double[] param;
    private Mat4 fromLocal;
    private TextureMapping texMap;
    private RGBColor color;
    private float lightIntensity;

    public EllipsoidPhotonSource(RTEllipsoid obj, PhotonMap map) {
        this.rx = obj.rx;
        this.ry = obj.ry;
        this.rz = obj.rz;
        this.fromLocal = obj.fromLocal;
        if (this.fromLocal == null) {
            this.fromLocal = Mat4.translation((double)obj.cx, (double)obj.cy, (double)obj.cz);
        }
        this.param = obj.param;
        this.texMap = obj.getTextureMapping();
        this.color = new RGBColor();
        ObjectInfo info = new ObjectInfo((Object3D)obj.theSphere, new CoordinateSystem(), "");
        RenderingMesh mesh = info.getPreviewMesh();
        double area = 0.0;
        for (int i = 0; i < mesh.triangle.length; ++i) {
            RenderingTriangle tri = mesh.triangle[i];
            Vec3 v1 = mesh.vert[tri.v1];
            Vec3 v2 = mesh.vert[tri.v2];
            Vec3 v3 = mesh.vert[tri.v3];
            Vec3 e1 = v2.minus(v1);
            Vec3 e2 = v3.minus(v1);
            area += 0.5 * e1.cross(e2).length();
        }
        if (this.texMap.appliesTo() == 0) {
            area *= 2.0;
        }
        if (mesh.triangle.length == 8) {
            area *= 1.8;
        } else if (mesh.triangle.length == 32) {
            area *= 1.2;
        } else if (mesh.triangle.length == 128) {
            area *= 1.05;
        } else if (mesh.triangle.length == 512) {
            area *= 1.01;
        }
        TextureSpec spec = map.getWorkspace().surfSpec[0];
        this.texMap.getTexture().getAverageSpec(spec, map.getRaytracer().getTime(), obj.param);
        this.color.copy(spec.emissive);
        this.lightIntensity = 0.5f * (this.color.getRed() + this.color.getGreen() + this.color.getBlue()) * (float)area;
    }

    public EllipsoidPhotonSource(RTSphere obj, PhotonMap map) {
        this.ry = this.rz = obj.r;
        this.rx = this.rz;
        this.fromLocal = obj.fromLocal;
        if (this.fromLocal == null) {
            this.fromLocal = Mat4.translation((double)obj.cx, (double)obj.cy, (double)obj.cz);
        }
        this.param = obj.param;
        this.texMap = obj.getTextureMapping();
        this.color = new RGBColor();
        double area = Math.PI * 4 * this.rx * this.rx;
        if (this.texMap.appliesTo() == 0) {
            area *= 2.0;
        }
        TextureSpec spec = map.getWorkspace().surfSpec[0];
        this.texMap.getTexture().getAverageSpec(spec, map.getRaytracer().getTime(), obj.param);
        this.color.copy(spec.emissive);
        this.lightIntensity = 0.5f * (this.color.getRed() + this.color.getGreen() + this.color.getBlue()) * (float)area;
    }

    @Override
    public double getTotalIntensity() {
        return this.lightIntensity;
    }

    @Override
    public void generatePhotons(PhotonMap map, double intensity, ThreadManager threads) {
        Ray r = new Ray(map.getWorkspace().context);
        Vec3 orig = r.getOrigin();
        Vec3 norm = new Vec3();
        double nx = 1.0 / this.rx;
        double ny = 1.0 / this.ry;
        double nz = 1.0 / this.rz;
        for (double emittedIntensity = 0.0; emittedIntensity < intensity; emittedIntensity += (double)this.generateOnePhoton(map, r, norm)) {
            double ctheta = (map.random.nextDouble() - 0.5) * 2.0;
            double stheta = Math.sqrt(1.0 - ctheta * ctheta);
            double phi = map.random.nextDouble() * 2.0 * Math.PI;
            double sphi = Math.sin(phi);
            double cphi = Math.cos(phi);
            double x = stheta * sphi;
            double y = stheta * cphi;
            double z = ctheta;
            norm.set(nx * x, ny * y, nz * z);
            norm.normalize();
            orig.set(this.rx * x, this.ry * y, this.rz * z);
        }
    }

    private float generateOnePhoton(PhotonMap map, Ray r, Vec3 norm) {
        double dot;
        double absdot;
        RaytracerRenderer rt = map.getRenderer();
        TextureSpec spec = map.getWorkspace().surfSpec[0];
        Vec3 dir = r.getDirection();
        float intensity = 1.0f;
        do {
            dir.set(0.0, 0.0, 0.0);
            map.randomizePoint(dir, 1.0);
            dir.normalize();
        } while ((absdot = (dot = norm.dot(dir)) > 0.0 ? dot : -dot) < map.random.nextDouble());
        if (!this.texMap.appliesToFace(dot > 0.0)) {
            dot = -dot;
            dir.scale(-1.0);
        }
        this.texMap.getTextureSpec(dir, spec, dot, rt.smoothScale, rt.time, this.param);
        this.color.copy(spec.emissive);
        intensity = this.color.getRed() + this.color.getGreen() + this.color.getBlue();
        if ((double)intensity < 1.0) {
            if (intensity < map.random.nextFloat()) {
                return intensity;
            }
            this.color.scale(1.0f / intensity);
        }
        this.fromLocal.transform(r.getOrigin());
        this.fromLocal.transformDirection(dir);
        r.newID();
        map.spawnPhoton(r, this.color, true);
        return intensity;
    }
}

