/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.Camera;
import artofillusion.PluginRegistry;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.Scene;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Cube;
import artofillusion.object.Cylinder;
import artofillusion.object.DirectionalLight;
import artofillusion.object.ImplicitObject;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectCollection;
import artofillusion.object.ObjectInfo;
import artofillusion.object.ObjectWrapper;
import artofillusion.object.PointLight;
import artofillusion.object.Sphere;
import artofillusion.object.SpotLight;
import artofillusion.object.TriangleMesh;
import artofillusion.raytracer.OctreeNode;
import artofillusion.raytracer.RTCube;
import artofillusion.raytracer.RTCylinder;
import artofillusion.raytracer.RTDirectionalLight;
import artofillusion.raytracer.RTDisplacedTriangle;
import artofillusion.raytracer.RTEllipsoid;
import artofillusion.raytracer.RTImplicitObject;
import artofillusion.raytracer.RTLight;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.RTObjectFactory;
import artofillusion.raytracer.RTSphere;
import artofillusion.raytracer.RTSphericalLight;
import artofillusion.raytracer.RTTriangle;
import artofillusion.raytracer.RTTriangleLowMemory;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.RaytracerContext;
import artofillusion.raytracer.SurfaceIntersection;
import artofillusion.texture.Texture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class Raytracer {
    private RTObject[] sceneObject;
    private RTLight[] light;
    private OctreeNode rootNode;
    private OctreeNode cameraNode;
    private OctreeNode[] lightNode;
    private Scene scene;
    private Camera camera;
    private double time;
    private double surfaceError = 0.02;
    private boolean preview;
    private boolean softShadows;
    private boolean adaptive = true;
    private boolean reducedMemory;
    private ThreadLocal<RaytracerContext> threadContext;
    private List<RTObjectFactory> factories;
    private List<RTObject> objectList;
    private List<RTLight> lightList;
    public static final double TOL = 1.0E-12;

    public Raytracer(Scene scene, Camera camera) {
        this.scene = scene;
        this.camera = camera;
        this.factories = PluginRegistry.getPlugins(RTObjectFactory.class);
        this.objectList = Collections.synchronizedList(new ArrayList());
        this.lightList = Collections.synchronizedList(new ArrayList());
        this.threadContext = new ThreadLocal<RaytracerContext>(){

            @Override
            protected RaytracerContext initialValue() {
                return new RaytracerContext(Raytracer.this);
            }
        };
    }

    public double getSurfaceError() {
        return this.surfaceError;
    }

    public void setSurfaceError(double surfaceError) {
        this.surfaceError = surfaceError;
    }

    public boolean isAdaptive() {
        return this.adaptive;
    }

    public void setAdaptive(boolean adaptive) {
        this.adaptive = adaptive;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        this.time = time;
    }

    public boolean getUsePreviewMeshes() {
        return this.preview;
    }

    public void setUsePreviewMeshes(boolean preview) {
        this.preview = preview;
    }

    public boolean getUseReducedMemory() {
        return this.reducedMemory;
    }

    public void setUseReducedMemory(boolean reducedMemory) {
        this.reducedMemory = reducedMemory;
    }

    public boolean getUseSoftShadows() {
        return this.softShadows;
    }

    public void setUseSoftShadows(boolean softShadows) {
        this.softShadows = softShadows;
    }

    public RTObject[] getObjects() {
        return this.sceneObject;
    }

    public RTLight[] getLights() {
        return this.light;
    }

    public RaytracerContext getContext() {
        return this.threadContext.get();
    }

    public OctreeNode getRootNode() {
        return this.rootNode;
    }

    public OctreeNode getCameraNode() {
        return this.cameraNode;
    }

    public OctreeNode[] getLightNodes() {
        return this.lightNode;
    }

    public void addObject(ObjectInfo info) {
        RenderingMesh mesh;
        double dist;
        if (this.sceneObject != null) {
            throw new IllegalStateException("finishConstruction() has already been called");
        }
        if (this.objectList == null) {
            throw new IllegalStateException("cleanup() has already been called");
        }
        for (RTObjectFactory factory : this.factories) {
            if (!factory.processObject(info, this.scene, this.camera, this.objectList, this.lightList)) continue;
            return;
        }
        Object3D theObject = info.getObject();
        Mat4 toLocal = info.getCoords().toLocal();
        Mat4 fromLocal = info.getCoords().fromLocal();
        if (theObject instanceof PointLight) {
            this.lightList.add(new RTSphericalLight((PointLight)theObject, info.getCoords(), this.softShadows));
            return;
        }
        if (theObject instanceof SpotLight) {
            this.lightList.add(new RTSphericalLight((SpotLight)theObject, info.getCoords(), this.softShadows));
            return;
        }
        if (theObject instanceof DirectionalLight) {
            this.lightList.add(new RTDirectionalLight((DirectionalLight)theObject, info.getCoords(), this.softShadows));
            return;
        }
        while (theObject instanceof ObjectWrapper) {
            theObject = ((ObjectWrapper)theObject).getWrappedObject();
        }
        if (theObject instanceof ObjectCollection) {
            Enumeration enm = ((ObjectCollection)theObject).getObjects(info, false, this.scene);
            while (enm.hasMoreElements()) {
                ObjectInfo elem = (ObjectInfo)enm.nextElement();
                if (!elem.isVisible()) continue;
                ObjectInfo copy = elem.duplicate();
                copy.getCoords().transformCoordinates(fromLocal);
                this.addObject(copy);
            }
            return;
        }
        Vec3 cameraOrig = this.camera.getCameraCoordinates().getOrigin();
        double distToScreen = this.camera.getDistToScreen();
        double tol = this.adaptive ? ((dist = info.getBounds().distanceToPoint(toLocal.times(cameraOrig))) < distToScreen ? this.surfaceError : this.surfaceError * dist / distToScreen) : this.surfaceError;
        boolean displaced = false;
        Texture tex = theObject.getTexture();
        if (tex != null && tex.hasComponent(6)) {
            displaced = true;
            if (theObject.canConvertToTriangleMesh() != 0) {
                TriangleMesh tm = theObject.convertToTriangleMesh(tol);
                tm.setTexture(tex, theObject.getTextureMapping().duplicate());
                if (theObject.getMaterialMapping() != null) {
                    tm.setMaterial(theObject.getMaterial(), theObject.getMaterialMapping().duplicate());
                }
                theObject = tm;
            }
        }
        if (!info.isDistorted()) {
            if (theObject instanceof Sphere) {
                Vec3 rad = ((Sphere)theObject).getRadii();
                if (rad.x == rad.y && rad.x == rad.z) {
                    this.objectList.add(new RTSphere((Sphere)theObject, fromLocal, toLocal, info.getObject().getAverageParameterValues()));
                    return;
                }
                this.objectList.add(new RTEllipsoid((Sphere)theObject, fromLocal, toLocal, info.getObject().getAverageParameterValues()));
                return;
            }
            if (theObject instanceof Cylinder) {
                this.objectList.add(new RTCylinder((Cylinder)theObject, fromLocal, toLocal, info.getObject().getAverageParameterValues()));
                return;
            }
            if (theObject instanceof Cube) {
                this.objectList.add(new RTCube((Cube)theObject, fromLocal, toLocal, info.getObject().getAverageParameterValues()));
                return;
            }
            if (theObject instanceof ImplicitObject && ((ImplicitObject)theObject).getPreferDirectRendering()) {
                this.objectList.add(new RTImplicitObject((ImplicitObject)theObject, fromLocal, toLocal, info.getObject().getAverageParameterValues(), tol));
                return;
            }
        }
        if (this.preview) {
            mesh = info.getPreviewMesh();
            if (mesh != null) {
                mesh = mesh.clone();
            }
        } else {
            mesh = info.getRenderingMesh(tol);
        }
        if (mesh == null) {
            return;
        }
        mesh.transformMesh(fromLocal);
        Vec3[] vert = mesh.vert;
        RenderingTriangle[] t = mesh.triangle;
        if (displaced) {
            int i;
            Vec3 cameraZDir = this.camera.getCameraCoordinates().getZDirection();
            double[] vertTol = new double[vert.length];
            if (this.adaptive) {
                for (i = 0; i < vert.length; ++i) {
                    Vec3 offset = vert[i].minus(cameraOrig);
                    double vertDist = offset.length();
                    if (offset.dot(cameraZDir) < 0.0) {
                        vertDist = -vertDist;
                    }
                    vertTol[i] = vertDist < distToScreen ? this.surfaceError : this.surfaceError * vertDist / distToScreen;
                }
            }
            for (i = 0; i < t.length; ++i) {
                double localTol;
                RenderingTriangle tri = mesh.triangle[i];
                if (mesh.faceNorm[i].length() < 1.0E-12 || vert[tri.v1].distance(vert[tri.v2]) < 1.0E-12 || vert[tri.v1].distance(vert[tri.v3]) < 1.0E-12 || vert[tri.v2].distance(vert[tri.v3]) < 1.0E-12) continue;
                if (this.adaptive) {
                    localTol = vertTol[tri.v1];
                    if (vertTol[tri.v2] < localTol) {
                        localTol = vertTol[tri.v2];
                    }
                    if (vertTol[tri.v3] < localTol) {
                        localTol = vertTol[tri.v3];
                    }
                } else {
                    localTol = tol;
                }
                RTDisplacedTriangle dispTri = new RTDisplacedTriangle(mesh, i, fromLocal, toLocal, localTol, this.time);
                RTObject dt = dispTri;
                if (!dispTri.isReallyDisplaced()) {
                    dt = this.reducedMemory ? new RTTriangleLowMemory(mesh, i, fromLocal, toLocal) : new RTTriangle(mesh, i, fromLocal, toLocal);
                }
                this.objectList.add(dt);
                if (!this.adaptive || !(dt instanceof RTDisplacedTriangle)) continue;
                double dist2 = dt.getBounds().distanceToPoint(cameraOrig);
                if (dist2 < distToScreen) {
                    ((RTDisplacedTriangle)dt).setTolerance(this.surfaceError);
                    continue;
                }
                ((RTDisplacedTriangle)dt).setTolerance(this.surfaceError * dist2 / distToScreen);
            }
        } else {
            for (int i = 0; i < t.length; ++i) {
                RenderingTriangle tri = mesh.triangle[i];
                if (mesh.faceNorm[i].length() < 1.0E-12 || vert[tri.v1].distance(vert[tri.v2]) < 1.0E-12 || vert[tri.v1].distance(vert[tri.v3]) < 1.0E-12 || vert[tri.v2].distance(vert[tri.v3]) < 1.0E-12) continue;
                if (this.reducedMemory) {
                    this.objectList.add(new RTTriangleLowMemory(mesh, i, fromLocal, toLocal));
                    continue;
                }
                this.objectList.add(new RTTriangle(mesh, i, fromLocal, toLocal));
            }
        }
    }

    public void finishConstruction() {
        int i;
        if (this.sceneObject != null) {
            throw new IllegalStateException("finishConstruction() has already been called");
        }
        if (this.objectList == null) {
            throw new IllegalStateException("cleanup() has already been called");
        }
        this.sceneObject = this.objectList.toArray(new RTObject[this.objectList.size()]);
        for (int i2 = 0; i2 < this.sceneObject.length; ++i2) {
            this.sceneObject[i2].index = i2;
        }
        this.light = this.lightList.toArray(new RTLight[this.lightList.size()]);
        this.objectList = null;
        this.lightList = null;
        BoundingBox[] objBounds = new BoundingBox[this.sceneObject.length];
        double minz = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double minx = Double.MAX_VALUE;
        double maxz = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        double maxx = -1.7976931348623157E308;
        for (i = 0; i < this.sceneObject.length; ++i) {
            objBounds[i] = this.sceneObject[i].getBounds();
            if (objBounds[i].minx < minx) {
                minx = objBounds[i].minx;
            }
            if (objBounds[i].maxx > maxx) {
                maxx = objBounds[i].maxx;
            }
            if (objBounds[i].miny < miny) {
                miny = objBounds[i].miny;
            }
            if (objBounds[i].maxy > maxy) {
                maxy = objBounds[i].maxy;
            }
            if (objBounds[i].minz < minz) {
                minz = objBounds[i].minz;
            }
            if (!(objBounds[i].maxz > maxz)) continue;
            maxz = objBounds[i].maxz;
        }
        this.rootNode = new OctreeNode(Math.nextAfter((float)(minx -= 1.0E-12), Double.NEGATIVE_INFINITY), Math.nextAfter((float)(maxx += 1.0E-12), Double.POSITIVE_INFINITY), Math.nextAfter((float)(miny -= 1.0E-12), Double.NEGATIVE_INFINITY), Math.nextAfter((float)(maxy += 1.0E-12), Double.POSITIVE_INFINITY), Math.nextAfter((float)(minz -= 1.0E-12), Double.NEGATIVE_INFINITY), Math.nextAfter((float)(maxz += 1.0E-12), Double.POSITIVE_INFINITY), this.sceneObject, objBounds, null);
        this.cameraNode = this.rootNode.findNode(this.camera.getCameraCoordinates().getOrigin());
        this.lightNode = new OctreeNode[this.light.length];
        for (i = 0; i < this.light.length; ++i) {
            this.lightNode[i] = this.light[i].getLight() instanceof DirectionalLight ? null : this.rootNode.findNode(this.light[i].getCoords().getOrigin());
        }
    }

    public void cleanup() {
        this.objectList = null;
        this.lightList = null;
        this.sceneObject = null;
        this.light = null;
        this.rootNode = null;
        this.cameraNode = null;
        this.lightNode = null;
        this.scene = null;
        this.camera = null;
        this.factories = null;
    }

    public RayIntersection traceRay(Vec3 origin, Vec3 direction) {
        if (this.sceneObject == null) {
            if (this.objectList == null) {
                throw new IllegalStateException("cleanup() has already been called");
            }
            throw new IllegalStateException("finishConstruction() has not been called");
        }
        RaytracerContext context = this.getContext();
        Ray r = new Ray(context);
        r.origin.set(origin);
        r.direction.set(direction);
        RayIntersection intersect = new RayIntersection();
        OctreeNode firstNode = this.rootNode.findFirstNode(r);
        if (firstNode == null) {
            intersect.first = (intersect.second = SurfaceIntersection.NO_INTERSECTION);
        } else {
            this.traceRay(r, firstNode, intersect);
        }
        return intersect;
    }

    public OctreeNode traceRay(Ray r, OctreeNode node, RayIntersection intersect) {
        RTObject first = null;
        RTObject second = null;
        double firstDist = Double.MAX_VALUE;
        double secondDist = Double.MAX_VALUE;
        Vec3 intersectionPoint = r.rt.tempVec;
        while (first == null) {
            RTObject[] obj = node.getObjects();
            for (int i = obj.length - 1; i >= 0; --i) {
                SurfaceIntersection intersection = r.findIntersection(obj[i]);
                if (intersection == SurfaceIntersection.NO_INTERSECTION) continue;
                intersection.intersectionPoint(0, intersectionPoint);
                if (!node.contains(intersectionPoint)) continue;
                double dist = intersection.intersectionDist(0);
                if (dist < firstDist) {
                    secondDist = firstDist;
                    second = first;
                    firstDist = dist;
                    first = obj[i];
                    continue;
                }
                if (!(dist < secondDist)) continue;
                secondDist = dist;
                second = obj[i];
            }
            if (first != null || (node = node.findNextNode(r)) != null) continue;
            intersect.first = SurfaceIntersection.NO_INTERSECTION;
            return null;
        }
        intersect.first = r.rt.lastRayResult[first.index];
        intersect.distance = firstDist;
        if (secondDist - firstDist < 1.0E-12) {
            intersect.second = r.rt.lastRayResult[second.index];
        } else {
            intersect.second = SurfaceIntersection.NO_INTERSECTION;
        }
        return node;
    }

    public static class RayIntersection {
        private SurfaceIntersection first;
        private SurfaceIntersection second;
        private double distance;

        public SurfaceIntersection getFirst() {
            return this.first;
        }

        public SurfaceIntersection getSecond() {
            return this.second;
        }

        public double getDistance() {
            return this.distance;
        }
    }
}

