/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.SelectionChangedEvent;
import buoy.widget.Widget;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class BFileChooser
extends Widget {
    private SelectionMode selectMode;
    private static File lastDirectory = FileSystemView.getFileSystemView().getDefaultDirectory();
    public static final SelectionMode OPEN_FILE = new SelectionMode();
    public static final SelectionMode SAVE_FILE = new SelectionMode();
    public static final SelectionMode SELECT_FOLDER = new SelectionMode();

    public BFileChooser() {
        this(OPEN_FILE, null, lastDirectory);
    }

    public BFileChooser(SelectionMode mode, String title) {
        this(mode, title, lastDirectory);
    }

    public BFileChooser(SelectionMode mode, String title, File directory) {
        this.component = this.createComponent();
        this.setMode(mode);
        this.setTitle(title);
        this.setDirectory(directory);
        this.getComponent().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                String name = ev.getPropertyName();
                if ("SelectedFilesChangedProperty".equals(name) || "SelectedFileChangedProperty".equals(name) && !BFileChooser.this.isMultipleSelectionEnabled()) {
                    BFileChooser.this.dispatchEvent(new SelectionChangedEvent(BFileChooser.this));
                }
            }
        });
    }

    protected JFileChooser createComponent() {
        return new JFileChooser();
    }

    public JFileChooser getComponent() {
        return (JFileChooser)this.component;
    }

    public String getTitle() {
        return this.getComponent().getDialogTitle();
    }

    public void setTitle(String title) {
        this.getComponent().setDialogTitle(title);
    }

    public SelectionMode getMode() {
        return this.selectMode;
    }

    public void setMode(SelectionMode mode) {
        this.selectMode = mode;
        this.getComponent().setFileSelectionMode(mode == SELECT_FOLDER ? 1 : 0);
    }

    public boolean isMultipleSelectionEnabled() {
        return this.getComponent().isMultiSelectionEnabled();
    }

    public void setMultipleSelectionEnabled(boolean multiple) {
        this.getComponent().setMultiSelectionEnabled(multiple);
    }

    public FileFilter getFileFilter() {
        return this.getComponent().getFileFilter();
    }

    public void setFileFilter(FileFilter filter) {
        this.getComponent().setFileFilter(filter);
    }

    public File getDirectory() {
        return this.getComponent().getCurrentDirectory();
    }

    public void setDirectory(File directory) {
        this.getComponent().setCurrentDirectory(directory);
        lastDirectory = directory;
    }

    public File getSelectedFile() {
        return this.getComponent().getSelectedFile();
    }

    public void setSelectedFile(File file) {
        this.getComponent().setSelectedFile(file);
    }

    public File[] getSelectedFiles() {
        return this.getComponent().getSelectedFiles();
    }

    public void setSelectedFiles(File[] files) throws IllegalArgumentException {
        if (!this.isMultipleSelectionEnabled()) {
            throw new IllegalArgumentException();
        }
        this.getComponent().setSelectedFiles(files);
    }

    public boolean showDialog(Widget parent) {
        JFileChooser jfc = this.getComponent();
        Component parentComponent = parent == null ? null : parent.getComponent();
        int result = this.selectMode == SAVE_FILE ? jfc.showSaveDialog(parentComponent) : jfc.showOpenDialog(parentComponent);
        lastDirectory = jfc.getCurrentDirectory();
        return result == 0;
    }

    static {
        WidgetEncoder.setPersistenceDelegate(SelectionMode.class, new StaticFieldDelegate(SelectionMode.class));
    }

    public static class SelectionMode {
        private SelectionMode() {
        }
    }
}

