/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.internal.WidgetContainerPanel;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.IndexedContainerDelegate;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplicitContainer
extends WidgetContainer {
    private ArrayList<Widget> children;
    private ArrayList<Rectangle> childBounds;
    private Dimension requiredSize;

    public ExplicitContainer() {
        this.component = new WidgetContainerPanel(this);
        this.children = new ArrayList();
        this.childBounds = new ArrayList();
        this.requiredSize = new Dimension(0, 0);
    }

    @Override
    public JPanel getComponent() {
        return (JPanel)this.component;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    public Widget getChild(int i) {
        return this.children.get(i);
    }

    @Override
    public Collection<Widget> getChildren() {
        return new ArrayList<Widget>(this.children);
    }

    @Override
    public void layoutChildren() {
        for (int i = 0; i < this.children.size(); ++i) {
            Widget child = this.children.get(i);
            Rectangle bounds = this.childBounds.get(i);
            child.getComponent().setBounds(bounds);
            if (!(child instanceof WidgetContainer)) continue;
            ((WidgetContainer)child).layoutChildren();
        }
    }

    public void add(Widget widget, Rectangle bounds) {
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        this.children.add(widget);
        this.childBounds.add(new Rectangle(bounds));
        this.getComponent().add(widget.getComponent());
        widget.getComponent().setBounds(bounds);
        this.setAsParent(widget);
        this.requiredSize.width = Math.max(this.requiredSize.width, bounds.x + bounds.width);
        this.requiredSize.height = Math.max(this.requiredSize.height, bounds.y + bounds.height);
        this.invalidateSize();
    }

    public int getChildIndex(Widget widget) {
        return this.children.indexOf(widget);
    }

    public Rectangle getChildBounds(int index) {
        return new Rectangle(this.childBounds.get(index));
    }

    public void setChildBounds(int index, Rectangle bounds) {
        this.childBounds.set(index, new Rectangle(bounds));
        this.findRequiredSize();
    }

    public Rectangle getChildBounds(Widget widget) {
        int index = this.children.indexOf(widget);
        if (index > -1) {
            return new Rectangle(this.childBounds.get(index));
        }
        return null;
    }

    public void setChildBounds(Widget widget, Rectangle bounds) {
        int index = this.children.indexOf(widget);
        if (index > -1) {
            this.childBounds.set(index, new Rectangle(bounds));
            this.findRequiredSize();
        }
    }

    @Override
    public void remove(Widget widget) {
        int index = this.children.indexOf(widget);
        if (index > -1) {
            this.getComponent().remove(widget.getComponent());
            this.children.remove(index);
            this.childBounds.remove(index);
            this.removeAsParent(widget);
            this.findRequiredSize();
        }
    }

    @Override
    public void removeAll() {
        this.getComponent().removeAll();
        for (int i = 0; i < this.children.size(); ++i) {
            this.removeAsParent(this.children.get(i));
        }
        this.children.clear();
        this.childBounds.clear();
        this.requiredSize.height = 0;
        this.requiredSize.width = 0;
        this.invalidateSize();
    }

    private void findRequiredSize() {
        this.requiredSize.height = 0;
        this.requiredSize.width = 0;
        for (int i = this.childBounds.size() - 1; i >= 0; --i) {
            Rectangle r = this.childBounds.get(i);
            this.requiredSize.width = Math.max(this.requiredSize.width, r.x + r.width);
            this.requiredSize.height = Math.max(this.requiredSize.height, r.y + r.height);
        }
        this.invalidateSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.requiredSize;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.requiredSize;
    }

    static {
        WidgetEncoder.setPersistenceDelegate(ExplicitContainer.class, new IndexedContainerDelegate(new String[]{"getChild", "getChildBounds"}));
    }
}

