/*
 * Decompiled with CFR 0.152.
 */
package buoy.xml;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class WidgetLocalization {
    private static HashSet localizedStringSet = new HashSet();
    private static ResourceBundle currentBundle;

    public static void addLocalizedString(String s) {
        localizedStringSet.add(new WeakIdentityReference(s));
    }

    public static void removeLocalizedString(String s) {
        localizedStringSet.remove(new WeakIdentityReference(s));
    }

    public static boolean isLocalizedString(String s) {
        return localizedStringSet.contains(new WeakIdentityReference(s));
    }

    static void setResourceBundle(ResourceBundle bundle) {
        currentBundle = bundle;
    }

    public static String[] getAllLocalizedStrings() {
        Iterator entries = localizedStringSet.iterator();
        ArrayList strings = new ArrayList();
        while (entries.hasNext()) {
            Object obj = ((Reference)entries.next()).get();
            if (obj != null) {
                strings.add(obj);
                continue;
            }
            entries.remove();
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static Object getLocalizedString(String key) {
        if (currentBundle == null) {
            WidgetLocalization.addLocalizedString(key);
            return key;
        }
        try {
            return currentBundle.getString(key);
        }
        catch (MissingResourceException ex) {
            return key;
        }
    }

    private static class WeakIdentityReference
    extends WeakReference {
        private int hash;

        public WeakIdentityReference(Object obj) {
            super(obj);
            this.hash = obj.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            obj = ((Reference)obj).get();
            Object thisObj = this.get();
            if (thisObj == null || obj == null) {
                return false;
            }
            return thisObj == obj;
        }
    }
}

