/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.LayoutWindow;
import artofillusion.ModellingTool;
import artofillusion.TriMeshSimplifier;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.CSGObject;
import artofillusion.object.Curve;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.object.Tube;
import artofillusion.texture.Texture;
import artofillusion.tools.TextDialog;
import artofillusion.ui.Translate;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Arrays;

public class TextTool
implements ModellingTool {
    public String getName() {
        return Translate.text((String)"menu.textTool");
    }

    public void commandSelected(LayoutWindow window) {
        new TextDialog(window);
    }

    public static ArrayList<ObjectInfo> createText(String text, String fontName, TextType type, boolean bold, boolean italic, double thickness, Texture texture) {
        ArrayList<ObjectInfo> objects = new ArrayList<ObjectInfo>();
        int style = 0;
        if (bold) {
            style |= 1;
        }
        if (italic) {
            style |= 2;
        }
        Font font = new Font(fontName, style, 1);
        try {
            GlyphVector glyphVector = font.createGlyphVector(new FontRenderContext(null, true, true), text);
            for (int glyphIndex = 0; glyphIndex < glyphVector.getNumGlyphs(); ++glyphIndex) {
                float[] segmentCoords = new float[6];
                ArrayList<Vec3> points = new ArrayList<Vec3>();
                ArrayList<Float> smoothnesses = new ArrayList<Float>();
                boolean firstCurveOfGlyph = true;
                String glyphName = Character.toString(text.charAt(glyphVector.getGlyphCharIndex(glyphIndex)));
                ObjectInfo fullLetterOI = null;
                Shape currentOutline = glyphVector.getGlyphOutline(glyphIndex);
                PathIterator pathIterator = currentOutline.getPathIterator(null);
                block14: while (!pathIterator.isDone()) {
                    switch (pathIterator.currentSegment(segmentCoords)) {
                        case 0: {
                            points.add(new Vec3((double)segmentCoords[0], (double)(-segmentCoords[1]), 0.0));
                            smoothnesses.add(Float.valueOf(1.0f));
                            break;
                        }
                        case 1: {
                            if (smoothnesses.size() > 0) {
                                smoothnesses.set(smoothnesses.size() - 1, Float.valueOf(0.0f));
                            }
                            points.add(new Vec3((double)segmentCoords[0], (double)(-segmentCoords[1]), 0.0));
                            smoothnesses.add(Float.valueOf(0.0f));
                            break;
                        }
                        case 2: {
                            points.add(new Vec3((double)segmentCoords[0], (double)(-segmentCoords[1]), 0.0));
                            smoothnesses.add(Float.valueOf(1.0f));
                            points.add(new Vec3((double)segmentCoords[2], (double)(-segmentCoords[3]), 0.0));
                            smoothnesses.add(Float.valueOf(1.0f));
                            break;
                        }
                        case 3: {
                            points.add(new Vec3((double)segmentCoords[0], (double)(-segmentCoords[1]), 0.0));
                            smoothnesses.add(Float.valueOf(1.0f));
                            points.add(new Vec3((double)segmentCoords[2], (double)(-segmentCoords[3]), 0.0));
                            smoothnesses.add(Float.valueOf(1.0f));
                            points.add(new Vec3((double)segmentCoords[4], (double)(-segmentCoords[5]), 0.0));
                            smoothnesses.add(Float.valueOf(1.0f));
                            break;
                        }
                        case 4: {
                            if (((Vec3)points.get(0)).distance((Vec3)points.get(points.size() - 1)) < 1.0E-4) {
                                points.remove(points.size() - 1);
                                smoothnesses.remove(smoothnesses.size() - 1);
                            }
                            float[] smoothnessesArray = new float[smoothnesses.size()];
                            for (int i = 0; i < smoothnesses.size(); ++i) {
                                smoothnessesArray[i] = ((Float)smoothnesses.get(i)).floatValue();
                            }
                            Curve theCurve = new Curve(points.toArray(new Vec3[points.size()]), smoothnessesArray, 3, true);
                            ObjectInfo currentGlyphOI = new ObjectInfo((Object3D)theCurve, new CoordinateSystem(), glyphName);
                            currentGlyphOI.setTexture(texture, texture.getDefaultMapping(currentGlyphOI.object));
                            if (type == TextType.Surface || type == TextType.Solid) {
                                Curve subdividedCurve = theCurve.subdivideCurve(1);
                                TriangleMesh theMesh = subdividedCurve.convertToTriangleMesh(1.0);
                                if (theMesh == null && (theMesh = (subdividedCurve = subdividedCurve.subdivideCurve(1)).convertToTriangleMesh(1.0)) == null && (theMesh = theCurve.convertToTriangleMesh(1.0)) == null) {
                                    pathIterator.next();
                                    continue block14;
                                }
                                currentGlyphOI = new ObjectInfo((Object3D)theMesh, new CoordinateSystem(), glyphName);
                                currentGlyphOI.setTexture(texture, texture.getDefaultMapping(currentGlyphOI.object));
                                if (firstCurveOfGlyph) {
                                    fullLetterOI = currentGlyphOI;
                                } else {
                                    ObjectInfo meshToTestForIntersection = new ObjectInfo((Object3D)TextTool.solidify((TriangleMesh)currentGlyphOI.getObject(), 0.2), currentGlyphOI.coords.duplicate(), glyphName);
                                    meshToTestForIntersection.setTexture(texture, texture.getDefaultMapping(meshToTestForIntersection.object));
                                    Vec3 coordsDiff = currentGlyphOI.getBounds().getCenter().minus(meshToTestForIntersection.getBounds().getCenter());
                                    meshToTestForIntersection.coords.setOrigin(meshToTestForIntersection.coords.getOrigin().plus(coordsDiff));
                                    CSGObject testCSG = new CSGObject(fullLetterOI, meshToTestForIntersection, 1);
                                    TriangleMesh testCSGMesh = testCSG.convertToTriangleMesh(1.0);
                                    if (testCSGMesh.getEdges().length > 0) {
                                        BoundingBox bounds1 = fullLetterOI.getBounds();
                                        BoundingBox bounds2 = currentGlyphOI.getBounds();
                                        boolean firstIsLarger = (bounds1.maxx - bounds1.minx) * (bounds1.maxy - bounds1.miny) >= (bounds2.maxx - bounds2.minx) * (bounds2.maxy - bounds2.miny);
                                        ObjectInfo firstMesh = firstIsLarger ? fullLetterOI : currentGlyphOI;
                                        ObjectInfo secondMesh = firstIsLarger ? currentGlyphOI : fullLetterOI;
                                        ObjectInfo meshToCut = new ObjectInfo((Object3D)TextTool.solidify((TriangleMesh)secondMesh.getObject(), 0.2), secondMesh.coords.duplicate(), glyphName);
                                        meshToCut.setTexture(texture, texture.getDefaultMapping(meshToCut.object));
                                        coordsDiff = secondMesh.getBounds().getCenter().minus(meshToCut.getBounds().getCenter());
                                        meshToCut.coords.setOrigin(meshToCut.coords.getOrigin().plus(coordsDiff));
                                        CSGObject aCSG = new CSGObject(firstMesh, meshToCut, 2);
                                        TriangleMesh aCSGMesh = aCSG.convertToTriangleMesh(1.0);
                                        TriangleMesh cutout = (TriangleMesh)secondMesh.getObject();
                                        for (int i = 0; i < cutout.getVertices().length; ++i) {
                                            if (cutout.getVertex((int)i).smoothness != 0.0f) continue;
                                            for (int j = 0; j < aCSGMesh.getVertices().length; ++j) {
                                                if (!(cutout.getVertex((int)i).r.distance2(aCSGMesh.getVertex((int)j).r) < 1.0E-10)) continue;
                                                aCSGMesh.getVertex((int)j).smoothness = 0.0f;
                                            }
                                        }
                                        fullLetterOI = new ObjectInfo((Object3D)aCSGMesh, fullLetterOI.coords.duplicate(), glyphName);
                                        fullLetterOI.setTexture(texture, texture.getDefaultMapping(fullLetterOI.object));
                                    } else {
                                        CSGObject aCSG = new CSGObject(fullLetterOI, currentGlyphOI, 0);
                                        TriangleMesh aCSGMesh = aCSG.convertToTriangleMesh(1.0);
                                        fullLetterOI = new ObjectInfo((Object3D)aCSGMesh, fullLetterOI.coords.duplicate(), glyphName);
                                        fullLetterOI.setTexture(texture, texture.getDefaultMapping(fullLetterOI.object));
                                    }
                                    try {
                                        fullLetterOI.object = TriangleMesh.optimizeMesh((TriangleMesh)((TriangleMesh)fullLetterOI.object));
                                        fullLetterOI.clearCachedMeshes();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                firstCurveOfGlyph = false;
                            } else if (type == TextType.Tube) {
                                double[] tubeThickness = new double[theCurve.getVertices().length];
                                Arrays.fill(tubeThickness, thickness);
                                Tube theTube = new Tube(theCurve, tubeThickness, 1);
                                theTube.setTexture(texture, texture.getDefaultMapping((Object3D)theTube));
                                objects.add(new ObjectInfo((Object3D)theTube, new CoordinateSystem(), glyphName));
                            } else {
                                objects.add(currentGlyphOI);
                            }
                            points = new ArrayList();
                            smoothnesses = new ArrayList();
                        }
                    }
                    pathIterator.next();
                }
                if (fullLetterOI == null) continue;
                if (type == TextType.Surface || type == TextType.Solid) {
                    boolean[] selection = new boolean[((TriangleMesh)fullLetterOI.getObject()).getEdges().length];
                    Arrays.fill(selection, true);
                    new TriMeshSimplifier((TriangleMesh)fullLetterOI.getObject(), selection, 1.0E-6, null);
                    try {
                        TriangleMesh mesh = (TriangleMesh)fullLetterOI.getObject();
                        for (TriangleMesh.Edge e : mesh.getEdges()) {
                            if (mesh.getVertex((int)e.v1).smoothness != 0.0f || mesh.getVertex((int)e.v2).smoothness != 0.0f) continue;
                            e.smoothness = 0.0f;
                        }
                        mesh.setSmoothingMethod(3);
                        fullLetterOI.object = TriangleMesh.optimizeMesh((TriangleMesh)mesh);
                        fullLetterOI.clearCachedMeshes();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (type == TextType.Solid) {
                    TriangleMesh mesh = TextTool.solidify((TriangleMesh)fullLetterOI.getObject(), thickness);
                    ObjectInfo extrudedMeshOI = new ObjectInfo((Object3D)mesh, fullLetterOI.coords.duplicate(), glyphName);
                    extrudedMeshOI.setTexture(texture, texture.getDefaultMapping(extrudedMeshOI.object));
                    Vec3 coordsDiff = fullLetterOI.getBounds().getCenter().minus(extrudedMeshOI.getBounds().getCenter());
                    extrudedMeshOI.coords.setOrigin(extrudedMeshOI.coords.getOrigin().plus(coordsDiff));
                    fullLetterOI = extrudedMeshOI;
                    mesh.setSmoothingMethod(3);
                    mesh = TriangleMesh.optimizeMesh((TriangleMesh)mesh);
                    fullLetterOI.object = mesh;
                    fullLetterOI.clearCachedMeshes();
                }
                if (type == TextType.Outline || type == TextType.Tube || firstCurveOfGlyph) continue;
                objects.add(fullLetterOI);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return objects;
    }

    private static TriangleMesh solidify(TriangleMesh mesh, double thickness) {
        int i;
        MeshVertex[] vert = mesh.getVertices();
        Vec3[] norm = mesh.getNormals();
        TriangleMesh.Vertex[] newVert = new TriangleMesh.Vertex[vert.length * 2];
        double offset = 0.5 * thickness;
        for (Vec3 n : norm) {
            if (n.z == 0.0) continue;
            offset = 0.5 * thickness * n.z;
            break;
        }
        for (int i2 = 0; i2 < vert.length; ++i2) {
            TriangleMesh triangleMesh = mesh;
            triangleMesh.getClass();
            newVert[i2] = new TriangleMesh.Vertex(triangleMesh, (TriangleMesh.Vertex)vert[i2]);
            int n = i2 + vert.length;
            TriangleMesh triangleMesh2 = mesh;
            triangleMesh2.getClass();
            newVert[n] = new TriangleMesh.Vertex(triangleMesh2, (TriangleMesh.Vertex)vert[i2]);
            newVert[i2].r.z += offset;
            newVert[i2 + vert.length].r.z -= offset;
        }
        TriangleMesh.Edge[] edge = mesh.getEdges();
        int numBoundary = 0;
        for (TriangleMesh.Edge e : edge) {
            if (e.f2 != -1) continue;
            ++numBoundary;
        }
        TriangleMesh.Face[] face = mesh.getFaces();
        int[][] newFace = new int[face.length * 2 + numBoundary * 2][3];
        for (i = 0; i < face.length; ++i) {
            newFace[i][0] = face[i].v1;
            newFace[i][1] = face[i].v2;
            newFace[i][2] = face[i].v3;
            newFace[face.length + i][0] = face[i].v1 + vert.length;
            newFace[face.length + i][1] = face[i].v3 + vert.length;
            newFace[face.length + i][2] = face[i].v2 + vert.length;
        }
        int j = face.length * 2;
        for (i = 0; i < edge.length; ++i) {
            if (edge[i].f2 != -1) continue;
            TriangleMesh.Edge e = edge[i];
            newFace[j][0] = e.v2;
            newFace[j][1] = e.v1;
            newFace[j++][2] = e.v1 + vert.length;
            newFace[j][0] = e.v2;
            newFace[j][1] = e.v1 + vert.length;
            newFace[j++][2] = e.v2 + vert.length;
        }
        TriangleMesh newMesh = new TriangleMesh(newVert, newFace);
        TriangleMesh.Face[] newf = newMesh.getFaces();
        TriangleMesh.Edge[] newe = newMesh.getEdges();
        for (int i3 = 0; i3 < face.length; ++i3) {
            newe[newf[i3].e1].smoothness = edge[face[i3].e1].smoothness;
            newe[newf[i3].e2].smoothness = edge[face[i3].e2].smoothness;
            newe[newf[i3].e3].smoothness = edge[face[i3].e3].smoothness;
            newe[newf[i3 + face.length].e1].smoothness = edge[face[i3].e3].smoothness;
            newe[newf[i3 + face.length].e2].smoothness = edge[face[i3].e2].smoothness;
            newe[newf[i3 + face.length].e3].smoothness = edge[face[i3].e1].smoothness;
        }
        int firstNewFace = face.length * 2;
        for (TriangleMesh.Edge e : newe) {
            int j2 = 0;
            if (e.f1 >= firstNewFace) {
                ++j2;
            }
            if (e.f2 >= firstNewFace) {
                ++j2;
            }
            if (j2 != 1) continue;
            e.smoothness = 0.0f;
        }
        for (TriangleMesh.Edge e : newe) {
            if (newMesh.getVertex((int)e.v1).smoothness != 0.0f || newMesh.getVertex((int)e.v2).smoothness != 0.0f) continue;
            e.smoothness = 0.0f;
        }
        return newMesh;
    }

    public static enum TextType {
        Outline,
        Tube,
        Surface,
        Solid;

    }
}

