/*
 * Decompiled with CFR 0.152.
 */
package nik777.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Locale;

public class XmlStreamParser {
    protected Reader in;
    protected StreamTokenizer parser;
    protected StringBuffer sbuff;
    protected int type = -1;
    protected int level = 0;
    protected String endMatch = null;
    protected HashMap entities = new HashMap(20);
    protected HashMap namespaces = null;
    public static final int NONE = -1;
    public static final int CLOSE = 0;
    public static final int HEADER = 1;
    public static final int ELEMENT = 2;
    public static final int END = 3;
    public static final int ATTRIBUTE = 4;
    public static final int VALUE = 5;
    public static final int CONTENT = 6;
    public static final int CDATA = 7;
    public static final int COMMENT = 8;
    public static final int INSTRUCTION = 9;
    private static final String openEntity = "&{";
    private static final String closeEntity = ";}";
    private static final String openHeader = "xml";
    private static final String nameSpace = "xmlns:";
    private static final char namespaceDelim = ':';
    private static final String enCoding = "encoding";
    private static final String nameAtt = "name";
    private static final String defaultAtt = "default";
    private static final String localeAtt = "locale";
    private static final String selectAtt = "select";
    private static final String delimStr = "<>/!?\"'";
    private static final String whiteStr = "\t\r\n =";
    private static final char[] delimiters = "<>/!?\"'".toCharArray();
    private static final char[] whitespace = "\t\r\n =".toCharArray();
    private static final char[] entityDelim = "&{;}".toCharArray();
    private static final String[] quote = new String[]{"\"", "'"};
    private static final String quotes = quote[0] + quote[1];
    private static final String[] delims = new String[10];

    public XmlStreamParser() {
        if (delims[0] == null) {
            XmlStreamParser.delims[0] = "";
            XmlStreamParser.delims[1] = "?";
            XmlStreamParser.delims[2] = "";
            XmlStreamParser.delims[3] = "";
            XmlStreamParser.delims[4] = "";
            XmlStreamParser.delims[5] = "";
            XmlStreamParser.delims[6] = "<";
            XmlStreamParser.delims[7] = "]]";
            XmlStreamParser.delims[8] = "--";
            XmlStreamParser.delims[9] = "?>";
        }
        this.addEntity("&lt;", "<");
        this.addEntity("&gt;", ">");
        this.addEntity("&quot;", "\"");
        this.addEntity("&nbsp;", " ");
        this.addEntity("&amp;", "&");
        this.addEntity("&tab;", "\t");
        this.addEntity("&nl;", "\n");
        this.addEntity("&cr;", "\r");
        this.addEntity("&crnl;", "\r\n");
    }

    public void open(InputStream data, String encoding) throws IOException {
        if (encoding == null || encoding.length() == 0) {
            encoding = "UTF-8";
        }
        this.open(new InputStreamReader(data, encoding));
    }

    public void open(Reader data) throws IOException {
        int x;
        this.in = data;
        this.parser = new StreamTokenizer(this.in);
        this.parser.resetSyntax();
        this.parser.wordChars(0, 65535);
        for (x = 0; x < whitespace.length; ++x) {
            this.parser.whitespaceChars(whitespace[x], whitespace[x]);
        }
        for (x = 0; x < delimiters.length; ++x) {
            this.parser.ordinaryChar(delimiters[x]);
        }
        this.sbuff = new StringBuffer(100);
        this.level = 0;
        this.type = 0;
    }

    public void close() throws IOException {
        this.in = null;
    }

    public void addEntity(String name, String value) {
        if (openEntity.indexOf((name = name.trim()).charAt(0)) < 0) {
            name = '{' + name + '}';
        }
        this.entities.put(name, value);
    }

    public String getNamespace(String name) {
        return this.namespaces != null ? (String)this.namespaces.get(name) : null;
    }

    public int type() {
        return this.type;
    }

    public int level() {
        return this.level;
    }

    public boolean ready() throws IOException {
        return this.in.ready();
    }

    public int next() throws IOException {
        if (this.endMatch != null) {
            this.parser.ordinaryChar(this.endMatch.charAt(0));
            int len = this.endMatch.length();
            for (int x = 0; x < len; ++x) {
                if (this.parser.ttype != this.endMatch.charAt(x)) {
                    x = -1;
                }
                if (x >= len - 1 && this.type == 6) continue;
                this.parser.nextToken();
            }
            if (this.type == 6 || this.type == 7 || this.type == 5) {
                this.parser.pushBack();
            } else if (this.type != 8 && this.type != 9) {
                this.parser.nextToken();
            }
            this.endMatch = null;
            if (this.type != 5 && this.type != 6) {
                this.type = 0;
                return this.type;
            }
        }
        this.parser.nextToken();
        block0 : switch (this.parser.ttype) {
            case -1: {
                this.type = this.parser.ttype;
                return -1;
            }
            case 60: {
                ++this.level;
                switch (this.parser.nextToken()) {
                    case 47: {
                        this.type = 3;
                        --this.level;
                        break block0;
                    }
                    case 33: {
                        this.parser.ordinaryChar(45);
                        this.parser.ordinaryChar(91);
                        switch (this.parser.nextToken()) {
                            case 45: {
                                if (this.parser.nextToken() != 45) {
                                    throw new RuntimeException("xml syntax error: <!-" + this.context());
                                }
                                this.type = 8;
                                break;
                            }
                            case 91: {
                                if (this.parser.nextToken() == -3 && this.parser.sval.equals("CDATA") && this.parser.nextToken() == 91) {
                                    this.type = 7;
                                    break;
                                }
                                throw new RuntimeException("xml syntax error: <!" + this.context());
                            }
                            default: {
                                if (this.parser.nextToken() == -3) {
                                    this.parser.pushBack();
                                    this.endMatch = ">";
                                    this.type = 6;
                                    break;
                                }
                                throw new RuntimeException("xml syntax error: <!" + this.context());
                            }
                        }
                        this.parser.wordChars(45, 45);
                        this.parser.wordChars(91, 91);
                        this.endMatch = delims[this.type];
                        break block0;
                    }
                    case 63: {
                        if (this.parser.nextToken() == -3) {
                            if (this.parser.sval.equals(openHeader)) {
                                this.type = 1;
                                break block0;
                            }
                            this.type = 9;
                            break block0;
                        }
                        throw new RuntimeException("xml syntax error: <?" + this.context());
                    }
                }
                this.type = 2;
                break;
            }
            case 47: {
                this.type = 3;
                break;
            }
            case 63: {
                if (this.parser.nextToken() == 62) {
                    this.type = 0;
                    --this.level;
                    break;
                }
                throw new RuntimeException("xml syntax error: not an end tag: " + this.context());
            }
            case 62: {
                if (this.type == 3 || this.type == 8 || this.type == 7 || this.type == 9) {
                    --this.level;
                }
                this.type = 0;
                break;
            }
            case 34: 
            case 39: {
                if (this.type == 4) {
                    this.endMatch = quote[quotes.indexOf(this.parser.ttype)];
                    this.type = 5;
                    break;
                }
                throw new RuntimeException("xml syntax error: unexpected quote:" + this.context());
            }
            case -3: {
                switch (this.type) {
                    case 3: {
                        break block0;
                    }
                    case 0: 
                    case 9: {
                        this.type = 6;
                        this.endMatch = delims[this.type == 0 ? 6 : this.type];
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 5: {
                        if (this.parser.sval.startsWith(nameSpace)) {
                            String name = this.parser.sval.substring(nameSpace.length());
                            this.parser.nextToken();
                            if (this.namespaces == null) {
                                this.namespaces = new HashMap(10);
                            }
                            this.namespaces.put(name, this.resolve(this.parser.ttype));
                            return this.next();
                        }
                        if (this.parser.sval.equals(enCoding)) {
                            this.parser.nextToken();
                            return this.next();
                        }
                        this.type = 4;
                        break block0;
                    }
                }
                throw new RuntimeException("xml syntax error: missing delimiter: " + this.context());
            }
            default: {
                throw new RuntimeException("xml syntax error: missing delimiter: " + this.context());
            }
        }
        return this.type;
    }

    public boolean next(int nextType) throws IOException {
        while (this.type != -1) {
            if (nextType == 6 && this.type == 0) {
                if (this.parser.nextToken() != -3) {
                    this.parser.pushBack();
                    return false;
                }
                this.parser.pushBack();
            }
            if (this.next() != nextType) continue;
        }
        return this.type == nextType;
    }

    public String nextValue() throws IOException {
        this.next();
        return this.value();
    }

    public String snippet(int startType, int stopType) throws IOException {
        int target;
        int n = target = startType == 4 ? 2 : startType;
        if (startType != -1 && target != this.type) {
            this.next(target);
        }
        if (this.type == -1) {
            return "";
        }
        String result = "";
        block0 : switch (startType) {
            case -1: {
                switch (stopType) {
                    case -1: {
                        result = this.text(">", 0);
                        break block0;
                    }
                }
                result = this.text(delims[6], this.level);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                result = this.text(delims[this.type], this.level);
                break;
            }
            case 4: {
                switch (stopType) {
                    case 4: {
                        result = this.text("=", this.level);
                        break;
                    }
                    case 5: {
                        result = this.text("=", this.level) + this.text(" ", this.level);
                        break;
                    }
                    case -1: 
                    case 0: 
                    case 3: {
                        result = this.text("", this.level);
                    }
                }
                break;
            }
            case 2: {
                String tag = this.value();
                result = tag + this.text("", this.level);
                switch (stopType) {
                    case 0: {
                        result = "<" + result + (this.parser.ttype == 47 ? "/>\n" : ">\n");
                        break block0;
                    }
                    case 3: {
                        if (this.parser.ttype == 62) {
                            result = "<" + result + this.text("</" + tag + ">", this.level) + "</" + tag + ">\n";
                            break block0;
                        }
                        result = "<" + result + "/>";
                        break block0;
                    }
                    case -1: {
                        result = "<" + result + this.text(">", 0);
                    }
                }
            }
        }
        this.type = stopType == -1 ? 0 : stopType;
        this.endMatch = null;
        return result;
    }

    public String value() throws IOException {
        switch (this.type) {
            case 0: {
                return "";
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                if (this.parser.ttype != -3 && this.parser.nextToken() != -3) {
                    if (this.type == 3 && this.parser.ttype == 62) {
                        this.parser.pushBack();
                        return "";
                    }
                    throw new RuntimeException("xml syntax error: missing value");
                }
                String result = this.parser.sval;
                int pos = result.indexOf(58);
                if (pos <= 0 || this.namespaces == null) {
                    return result;
                }
                String prefix = result.substring(0, pos);
                String ns = (String)this.namespaces.get(prefix);
                return ns != null && ns.length() > 0 ? ns + result.substring(pos) : result;
            }
            case 7: 
            case 8: {
                for (int x = 0; x < delimiters.length; ++x) {
                    this.parser.wordChars(delimiters[x], delimiters[x]);
                }
                String result = this.text(this.endMatch, this.level);
                for (int x = 0; x < delimiters.length; ++x) {
                    this.parser.ordinaryChar(delimiters[x]);
                }
                this.endMatch = null;
                return result;
            }
        }
        return this.resolve(this.type);
    }

    public long longValue() throws IOException {
        if (this.type == 5 || this.type == 6) {
            return Long.parseLong(this.value());
        }
        throw new RuntimeException("longValue: current token is not a VALUE");
    }

    public double doubleValue() throws IOException {
        if (this.type == 5 || this.type == 6) {
            return Double.parseDouble(this.value());
        }
        throw new RuntimeException("doubleValue: current token is not a VALUE");
    }

    public String context() {
        if (this.parser.ttype == -3) {
            return " context (" + this.type + "): ~" + this.parser.sval + "~";
        }
        return " context (" + this.type + "): ~" + (char)this.parser.ttype + "~";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void select(XmlStreamParser xml, String namespace, String select) throws IOException {
        String matchStr;
        String nameStr = nameAtt;
        String defaultStr = defaultAtt;
        String selectStr = selectAtt;
        String string = matchStr = select != null && select.length() > 0 ? select : Locale.getDefault().getLanguage();
        if (namespace != null && namespace.length() > 0) {
            if (namespace.charAt(namespace.length() - 1) != ':') {
                namespace = namespace + ':';
            }
            nameStr = namespace + nameAtt;
            defaultStr = namespace + defaultAtt;
            selectStr = namespace + selectAtt;
        }
        String name = null;
        Object value = null;
        String dflt = null;
        boolean matchAll = false;
        try {
            while (xml.next() == 4) {
                if (name != null && xml.value().equals(matchStr)) {
                    xml.addEntity(name, xml.nextValue());
                    return;
                }
                if (matchAll && (namespace == null || !xml.value().startsWith(namespace))) {
                    name = xml.value();
                    xml.addEntity(name, xml.nextValue());
                    continue;
                }
                if (xml.value().equals(nameStr)) {
                    name = xml.nextValue();
                    continue;
                }
                if (xml.value().equals(selectStr)) {
                    if (xml.nextValue().equals(matchStr)) {
                        matchAll = true;
                        continue;
                    }
                    return;
                }
                if (xml.value().equals(defaultStr)) {
                    dflt = xml.nextValue();
                    continue;
                }
                xml.next();
                xml.next();
            }
            if (name != null && dflt != null) {
                xml.addEntity(name, dflt);
            }
        }
        finally {
            if (xml.type() != 0) {
                xml.next(0);
            }
        }
    }

    protected String text(String ematch, int elevel) throws IOException {
        int x;
        int len = ematch.length();
        for (x = 0; x < whitespace.length; ++x) {
            this.parser.ordinaryChars(whitespace[x], whitespace[x]);
            this.parser.wordChars(whitespace[x], whitespace[x]);
        }
        for (x = 0; x < quotes.length(); ++x) {
            this.parser.quoteChar(quotes.charAt(x));
        }
        String termString = "";
        if (len > 0) {
            for (x = 0; x < len; ++x) {
                this.parser.ordinaryChar(ematch.charAt(x));
            }
            termString = ematch.substring(1);
        }
        this.sbuff.setLength(0);
        boolean matchStart = false;
        for (x = 0; len == 0 || x < len; ++x) {
            this.parser.nextToken();
            if (whiteStr.indexOf(this.parser.ttype) >= 0) {
                this.sbuff.append((char)this.parser.ttype);
                continue;
            }
            if (this.parser.ttype == -1) break;
            if (x < len && this.parser.ttype == ematch.charAt(x)) {
                matchStart = true;
            }
            if (len != 0 && this.parser.ttype == ematch.charAt(x)) continue;
            if (len > 0) {
                if (this.parser.ttype == -3 && this.parser.sval.startsWith(termString)) break;
                if (x > 0) {
                    this.sbuff.append(ematch.substring(0, x));
                }
            }
            if (len == 0 && "</>".indexOf(this.parser.ttype) >= 0) break;
            if (quotes.indexOf(this.parser.ttype) >= 0) {
                this.sbuff.append((char)this.parser.ttype);
                this.sbuff.append(this.parser.sval);
                this.sbuff.append((char)this.parser.ttype);
            } else if (this.parser.ttype == -3) {
                this.sbuff.append(this.parser.sval);
            } else {
                this.sbuff.append((char)this.parser.ttype);
            }
            x = -1;
        }
        for (x = 0; x < len; ++x) {
            char c = ematch.charAt(x);
            if (delimStr.indexOf(c) >= 0) continue;
            this.parser.wordChars(c, c);
        }
        if (delimStr.indexOf(this.parser.ttype) >= 0) {
            this.parser.pushBack();
        }
        for (x = 0; x < quotes.length(); ++x) {
            this.parser.ordinaryChar(quotes.charAt(x));
        }
        for (x = 0; x < whitespace.length; ++x) {
            this.parser.whitespaceChars(whitespace[x], whitespace[x]);
        }
        return this.sbuff.toString();
    }

    protected String resolve(int ltype) throws IOException {
        int x;
        int x2;
        char delim = '\u0000';
        this.sbuff.setLength(0);
        for (x2 = 0; x2 < whitespace.length; ++x2) {
            this.parser.ordinaryChar(whitespace[x2]);
            this.parser.wordChars(whitespace[x2], whitespace[x2]);
        }
        for (x2 = 0; x2 < entityDelim.length; ++x2) {
            this.parser.ordinaryChar(entityDelim[x2]);
        }
        switch (ltype) {
            case 6: {
                delim = delims[6].charAt(0);
                if (this.parser.ttype != -3) break;
                this.sbuff.append(this.parser.sval);
                this.parser.nextToken();
                break;
            }
            case 5: {
                delim = (char)this.parser.ttype;
                this.parser.ordinaryChar(9);
                this.parser.ordinaryChar(13);
                this.parser.ordinaryChar(10);
                this.parser.nextToken();
                break;
            }
            default: {
                delim = (char)ltype;
                this.parser.nextToken();
            }
        }
        String match = null;
        String enty = null;
        while (this.parser.ttype != delim) {
            switch (this.parser.ttype) {
                case -1: {
                    throw new RuntimeException("xml syntax error: EOF before end of token: " + this.context());
                }
                case -3: {
                    this.sbuff.append(this.parser.sval);
                    break;
                }
                case 9: 
                case 10: 
                case 13: {
                    this.sbuff.append(' ');
                    break;
                }
                case 38: 
                case 123: {
                    char c = (char)this.parser.ttype;
                    if (this.parser.nextToken() == -3) {
                        match = c + this.parser.sval;
                        c = (char)this.parser.nextToken();
                        if (closeEntity.indexOf(c) < 0) {
                            this.sbuff.append(match).append(c);
                            break;
                        }
                    } else {
                        this.sbuff.append(c);
                        break;
                    }
                    match = match + c;
                    enty = (String)this.entities.get(match);
                    this.sbuff.append(enty != null ? enty : match);
                    break;
                }
                default: {
                    this.sbuff.append((char)this.parser.ttype);
                }
            }
            this.parser.nextToken();
        }
        if (ltype == 6) {
            this.parser.pushBack();
        }
        this.endMatch = null;
        for (x = 0; x < whitespace.length; ++x) {
            this.parser.whitespaceChars(whitespace[x], whitespace[x]);
        }
        for (x = 0; x < entityDelim.length; ++x) {
            this.parser.wordChars(entityDelim[x], entityDelim[x]);
        }
        return this.sbuff.toString();
    }
}

