/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.billboard;

import de.grogra.billboard.BBResources;
import de.grogra.billboard.RotationCamera;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp.IMP;
import de.grogra.imp.IMPWorkbench;
import de.grogra.imp.Renderer;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.objects.GlobalTransformation;
import de.grogra.imp3d.ray2.Raytracer;
import de.grogra.math.TVector3d;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.expr.ObjectExpr;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.util.LockProtectedCommand;
import de.grogra.util.Lock;
import de.grogra.util.Lockable;
import de.grogra.util.MimeType;
import de.grogra.util.StringMap;
import de.grogra.vecmath.Matrix34d;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.vecmath.Point3d;

public abstract class Billboarder {
    protected RotationCamera camera;
    protected View3D view3d;
    protected double RotationAngle = 0.0;
    protected TVector3d rotationPoint = new TVector3d(0.0, 0.0, 0.0);
    protected double angleOffset = 0.0;
    protected String pathAndFileName = "";
    protected String imageFolder = "";
    protected String prefix = "bill_";
    protected String appendfix = "";
    protected String suffix = "";
    private ArrayList<String> bbNameList;
    protected int countZero = 0;
    protected File file;
    protected MimeType mt;
    protected int imgWidth = 0;
    protected int imgHeight = 0;
    protected int sides = 1;
    protected int currentSide = 0;
    private LockProtectedCommand lpc;
    private LockProtectedCommand lpcLast;
    public static final MimeType MT_JPG = new MimeType("image/jpeg", null);
    public static final MimeType MT_PJPG = new MimeType("image/pjepg", null);
    public static final MimeType MT_PNG = new MimeType("image/png", null);
    public static final MimeType MT_EXR = new MimeType("image/exr", null);
    public static final MimeType MT_X_EXR = new MimeType("image/x-exr", null);

    protected void setDestination(File file, MimeType mimeType) throws IOException {
        if (!file.isDirectory()) {
            file.mkdir();
        }
        this.file = file;
        this.mt = mimeType;
        if (mimeType == MT_JPG) {
            this.suffix = "jpg";
        }
        if (mimeType == MT_PJPG) {
            this.suffix = "jpg";
        }
        if (mimeType == MT_PNG) {
            this.suffix = "png";
        }
        if (mimeType == MT_EXR) {
            this.suffix = "exr";
        }
        if (mimeType == MT_X_EXR) {
            this.suffix = "exr";
        }
    }

    public void initialize(double d, double d2, int n) {
        if (n > 0) {
            this.sides = n;
            this.RotationAngle = Math.round(360 / n);
            this.countZero = (int)Math.floor(Math.log10(n));
            this.bbNameList = new ArrayList();
        }
        this.camera.setDistance(d, d2);
        this.setLPCs();
    }

    public void beginAt(int n) {
        if (n > 0 && n <= this.sides) {
            this.currentSide = n;
            this.nextSide();
            String string = this.getLeadingZeros(this.sides, this.currentSide);
            String string2 = "";
            string2 = this.prefix + string + this.currentSide + this.appendfix + "." + this.suffix;
            this.bbNameList.add((this.imageFolder != "" ? this.imageFolder + "/" : "") + string2);
        }
    }

    public void angleOffset(int n) {
        this.angleOffset = n;
    }

    protected void nextSide(int n) {
        this.camera.moveAroundZ(this.RotationAngle * (double)n - this.angleOffset);
    }

    protected void nextSide() {
        this.camera.moveAroundZ(this.RotationAngle * (double)this.currentSide - this.angleOffset);
    }

    public void billboarding() {
        ObjectExpr objectExpr = (ObjectExpr)Item.resolveItem((RegistryContext)Workbench.current(), (String)"/renderers/3d/ray2");
        Raytracer raytracer = (Raytracer)objectExpr.evaluate((RegistryContext)Workbench.current(), new StringMap());
        Workbench.current().logGUIInfo(BBResources.msg("billboard.progress", this.currentSide, this.sides));
        raytracer.addImageObserver(new ImageObserver(){

            public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                if ((n & 0x20) == 0) {
                    return true;
                }
                ++Billboarder.this.currentSide;
                if (Billboarder.this.imgWidth == 0) {
                    Billboarder.this.imgWidth = n4;
                }
                if (Billboarder.this.imgHeight == 0) {
                    Billboarder.this.imgHeight = n5;
                }
                String string = "";
                String string2 = Billboarder.this.getLeadingZeros(Billboarder.this.sides, Billboarder.this.currentSide);
                string = Billboarder.this.prefix + string2 + Billboarder.this.currentSide + Billboarder.this.appendfix + "." + Billboarder.this.suffix;
                Billboarder.this.insertName((Billboarder.this.imageFolder != "" ? Billboarder.this.imageFolder + "/" : "") + string);
                string = (Billboarder.this.imageFolder != "" ? Billboarder.this.imageFolder + File.separator : "") + string;
                Billboarder.this.pathAndFileName = Billboarder.this.file.getPath() + File.separator + string;
                IMP.writeImage((Context)Billboarder.this.view3d, (RenderedImage)((RenderedImage)((Object)image)), (MimeType)Billboarder.this.mt, (File)new File(Billboarder.this.pathAndFileName));
                if (Billboarder.this.currentSide < Billboarder.this.sides) {
                    Billboarder.this.view3d.getWorkbench().getJobManager().runLater((Command)Billboarder.this.lpc, null, (Context)Billboarder.this.view3d, 0);
                } else if (Billboarder.this.lpcLast != null) {
                    Billboarder.this.view3d.getWorkbench().getJobManager().runLater((Command)Billboarder.this.lpcLast, null, (Context)Billboarder.this.view3d, 0);
                }
                return false;
            }
        });
        this.view3d.getViewComponent().render((Renderer)raytracer);
    }

    protected String getLeadingZeros(int n, int n2) {
        if (n < 10) {
            return "";
        }
        int n3 = (int)Math.floor(Math.log10(n));
        n3 -= n2 > 0 ? (int)Math.floor(Math.log10(n2)) : 0;
        String string = "";
        while (n3-- > 0) {
            string = string + "0";
        }
        return string;
    }

    protected void insertName(String string) {
        if (string != null && !string.equals("")) {
            this.bbNameList.add(string);
        }
    }

    protected String getBBName(int n) {
        if (n >= 0 && n < this.bbNameList.size()) {
            return this.bbNameList.get(n);
        }
        return null;
    }

    private void setLPCs() {
        this.lpc = new LockProtectedCommand((Lockable)this.view3d.getGraph(), true, 0){

            protected void runImpl(Object object, Context context, Lock lock) {
                Billboarder.this.setRunLater();
            }
        };
        this.lpcLast = new LockProtectedCommand((Lockable)this.view3d.getGraph(), true, 0){

            protected void runImpl(Object object, Context context, Lock lock) {
                Billboarder.this.finalAction();
            }
        };
    }

    public static Point3d location(Node node) {
        Point3d point3d = new Point3d();
        Matrix34d matrix34d = Billboarder.transformation(node, false);
        point3d.x = matrix34d.m03;
        point3d.y = matrix34d.m13;
        point3d.z = matrix34d.m23;
        return point3d;
    }

    public static Matrix34d transformation(Node node, boolean bl) {
        return GlobalTransformation.get((Object)node, (boolean)true, (GraphState)GraphState.current((Graph)node.getGraph()), (boolean)bl);
    }

    public static GraphManager graph() {
        IMPWorkbench iMPWorkbench = (IMPWorkbench)Workbench.current();
        return iMPWorkbench != null ? iMPWorkbench.getRegistry().getProjectGraph() : null;
    }

    protected abstract void setRunLater();

    protected void finalAction() {
    }

    public static void justRenderView(final File file, final MimeType mimeType) {
        final View3D view3D = View3D.getDefaultView((Context)Workbench.current());
        ObjectExpr objectExpr = (ObjectExpr)Item.resolveItem((RegistryContext)Workbench.current(), (String)"/renderers/3d/ray2");
        Raytracer raytracer = (Raytracer)objectExpr.evaluate((RegistryContext)Workbench.current(), new StringMap());
        raytracer.addImageObserver(new ImageObserver(){

            public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                if ((n & 0x20) == 0) {
                    return true;
                }
                IMP.writeImage((Context)view3D, (RenderedImage)((RenderedImage)((Object)image)), (MimeType)mimeType, (File)file);
                return false;
            }
        });
        view3D.getViewComponent().render((Renderer)raytracer);
    }
}

