/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.billboard.vrml;

import de.grogra.billboard.BBResources;
import de.grogra.billboard.CakeBillboarder;
import de.grogra.billboard.vrml.VRMLBuilder;
import de.grogra.pf.ui.Workbench;
import de.grogra.util.MimeType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class VRMLCakeBuilder
extends CakeBillboarder
implements VRMLBuilder {
    private String vrmlFileName = "bb";
    private String vrmlTempl = "";
    private File vrmlDest;

    public VRMLCakeBuilder(File file, MimeType mimeType) {
        super(file, mimeType);
        this.vrmlDest = new File(file.getPath() + File.separator + this.vrmlFileName + ".wrl");
        this.vrmlTempl = BBResources.getVRMLTempl(this.getClass(), "vrmlcaketempl.txt");
    }

    public VRMLCakeBuilder(File file, MimeType mimeType, String string) throws IOException {
        super(file, mimeType);
        this.vrmlDest = new File(file.getPath() + File.separator + this.vrmlFileName + ".wrl");
        file = new File(file.getPath() + File.separator + string);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        this.imageFolder = string;
        this.vrmlTempl = BBResources.getVRMLTempl(this.getClass(), "vrmlcaketempl.txt");
        this.setRunLater();
    }

    public String getVRMLTempl() {
        return this.vrmlTempl;
    }

    public void writeVRML(int n, int n2) {
        String string = this.vrmlTempl;
        String string2 = "";
        int n3 = 0;
        while (n3 < this.sides) {
            string2 = string2 + "PngFrame { url \"" + this.getBBName(n3++) + "\" rotate 0 1 0 " + (double)n3 / (double)this.sides * (Math.PI * 2) + "}" + System.getProperty("line.separator");
        }
        double d = (double)n2 / (double)n;
        string = string.replaceAll("::REL_HEIGHT::", Double.toString(d));
        string = string.replaceAll("::PNG_PROTO_CALL::", string2);
        string = string.replaceAll("::BILL_NUM::", Integer.toString(this.sides));
        try {
            FileWriter fileWriter = new FileWriter(this.vrmlDest);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string);
            bufferedWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            Workbench.current().logGUIInfo("Error: " + iOException.getMessage());
        }
    }

    protected void finalAction() {
        this.writeVRML(this.imgWidth, this.imgHeight);
        super.finalAction();
    }
}

