/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidFrameBorder;
import com.birosoft.liquid.LiquidInternalFrameBorder;
import com.birosoft.liquid.borders.LiquidFocusCellHighlightBorder;
import com.birosoft.liquid.borders.LiquidListBorder;
import com.birosoft.liquid.borders.LiquidPopupMenuBorder;
import com.birosoft.liquid.borders.LiquidTextFieldBorder;
import com.birosoft.liquid.skin.SkinImageCache;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicLookAndFeel;

public class LiquidLookAndFeel
extends BasicLookAndFeel {
    protected static UIDefaults uiDefaults;
    protected static boolean defaultRowBackgroundMode;
    protected static boolean showTableGrids;
    protected static boolean panelTransparency;
    private static boolean bgStipples;
    protected static boolean winDecoPanther;
    protected static boolean toolbarFlattedButtons;
    private static boolean isInstalled;
    private String fontName = "Helvetica";
    protected Toolkit awtToolkit = Toolkit.getDefaultToolkit();
    private HashMap colorMap = new HashMap();
    Border focusCellHighlightBorder = new LiquidFocusCellHighlightBorder(new Color(86, 46, 0));
    Border listBorder = new LiquidListBorder();
    Border zeroEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    Object fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
    Object multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
    Object formattedInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "ESCAPE", "reset-field-edit", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"});
    private boolean windowslfforfilechooser = false;

    public LiquidLookAndFeel() {
        if (!isInstalled) {
            isInstalled = true;
            UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo("LiquidLookAndFeel", "com.birosoft.liquid.LiquidLookAndFeel"));
        }
    }

    public String getID() {
        return "Liquid";
    }

    public String getName() {
        return "Liquid";
    }

    public static ColorUIResource getControl() {
        return (ColorUIResource)uiDefaults.get("control");
    }

    public String getDescription() {
        return "KDE 3.x Liquid look and feel for Java.";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public final boolean isSupportedLookAndFeel() {
        return true;
    }

    public boolean getSupportsWindowDecorations() {
        return true;
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
        uiDefaults = uIDefaults;
        super.initClassDefaults(uIDefaults);
        Properties properties = new Properties();
        try {
            boolean bl;
            boolean bl2;
            FileInputStream fileInputStream = new FileInputStream("liquidlnf.conf");
            properties.load(fileInputStream);
            fileInputStream.close();
            boolean bl3 = Boolean.valueOf(properties.get("panelTransparency").toString());
            LiquidLookAndFeel.setPanelTransparency(bl3);
            boolean bl4 = Boolean.valueOf(properties.get("showTableGrids").toString());
            LiquidLookAndFeel.setShowTableGrids(bl4);
            boolean bl5 = Boolean.valueOf(properties.get("stipples").toString());
            LiquidLookAndFeel.setStipples(bl5);
            boolean bl6 = Boolean.valueOf(properties.get("alternateBackground").toString());
            LiquidLookAndFeel.setDefaultRowBackgroundMode(bl6);
            winDecoPanther = bl2 = properties.get("windowDecoration").toString().equalsIgnoreCase("panther");
            toolbarFlattedButtons = bl = Boolean.valueOf(properties.get("toolbarFlattedButtons").toString()).booleanValue();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        uIDefaults.putDefaults(new Object[]{"ButtonUI", "com.birosoft.liquid.LiquidButtonUI", "CheckBoxUI", "com.birosoft.liquid.LiquidCheckBoxUI", "TextFieldUI", "com.birosoft.liquid.LiquidTextFieldUI", "FormattedTextFieldUI", "com.birosoft.liquid.LiquidTextFieldUI", "PasswordTextFieldUI", "com.birosoft.liquid.LiquidPasswordFieldUI", "PasswordFieldUI", "com.birosoft.liquid.LiquidPasswordFieldUI", "SliderUI", "com.birosoft.liquid.LiquidSliderUI", "SpinnerUI", "com.birosoft.liquid.LiquidSpinnerUI", "ToolBarUI", "com.birosoft.liquid.LiquidToolBarUI", "MenuBarUI", "com.birosoft.liquid.LiquidMenuBarUI", "MenuUI", "com.birosoft.liquid.LiquidMenuUI", "PanelUI", "com.birosoft.liquid.LiquidPanelUI", "MenuItemUI", "com.birosoft.liquid.LiquidMenuItemUI", "CheckBoxMenuItemUI", "com.birosoft.liquid.LiquidCheckBoxMenuItemUI", "RadioButtonMenuItemUI", "com.birosoft.liquid.LiquidRadioButtonMenuItemUI", "TableUI", "com.birosoft.liquid.LiquidTableUI", "TableHeaderUI", "com.birosoft.liquid.LiquidTableHeaderUI", "ScrollBarUI", "com.birosoft.liquid.LiquidScrollBarUI", "TabbedPaneUI", "com.birosoft.liquid.LiquidTabbedPaneUI", "ToggleButtonUI", "com.birosoft.liquid.LiquidToggleButtonUI", "ScrollPaneUI", "com.birosoft.liquid.LiquidScrollPaneUI", "ProgressBarUI", "com.birosoft.liquid.LiquidProgressBarUI", "InternalFrameUI", "com.birosoft.liquid.LiquidInternalFrameUI", "RadioButtonUI", "com.birosoft.liquid.LiquidRadioButtonUI", "ComboBoxUI", "com.birosoft.liquid.LiquidComboBoxUI", "ListUI", "com.birosoft.liquid.LiquidListUI", "SeparatorUI", "com.birosoft.liquid.LiquidSeparatorUI", "PopupMenuSeparatorUI", "com.birosoft.liquid.LiquidPopupMenuSeparatorUI", "SplitPaneUI", "com.birosoft.liquid.LiquidSplitPaneUI", "FileChooserUI", "com.birosoft.liquid.FileChooserBasicUI", "RootPaneUI", "com.birosoft.liquid.LiquidRootPaneUI", "OptionPaneUI", "com.birosoft.liquid.LiquidOptionPaneUI"});
    }

    protected void initSystemColorDefaults(UIDefaults uIDefaults) {
        this.colorMap.put("activeBackground", "#3E91EB");
        this.colorMap.put("activeBlend", "#3E91EB");
        this.colorMap.put("activeForeground", "#FFFFFF");
        this.colorMap.put("activeTitleBtnBg", "#AFD6FF");
        this.colorMap.put("alternateBackground", "#EEF6FF");
        this.colorMap.put("background", "#F6F5F4");
        this.colorMap.put("buttonBackground", "#D7E7F9");
        this.colorMap.put("buttonForeground", "#000000");
        this.colorMap.put("foreground", "#000000");
        this.colorMap.put("inactiveBackground", "#AFD6FF");
        this.colorMap.put("inactiveBlend", "#AFD6FF");
        this.colorMap.put("inactiveForeground", "#232323");
        this.colorMap.put("inactiveTitleBtnBg", "#DAEEFF");
        this.colorMap.put("linkColor", "#0000C0");
        this.colorMap.put("selectBackground", "#A9D1FF");
        this.colorMap.put("selectForeground", "#030303");
        this.colorMap.put("visitedLinkColor", "#800080");
        this.colorMap.put("windowBackground", "#FFFFFF");
        this.colorMap.put("windowForeground", "#000000");
        String[] stringArray = new String[]{"desktop", (String)this.colorMap.get("alternateBackground"), "activeCaption", (String)this.colorMap.get("activeBackground"), "activeCaptionText", (String)this.colorMap.get("activeForeground"), "activeCaptionBorder", (String)this.colorMap.get("activeBackground"), "inactiveCaption", (String)this.colorMap.get("inactiveBackground"), "inactiveCaptionText", (String)this.colorMap.get("inactiveForeground"), "inactiveCaptionBorder", (String)this.colorMap.get("inactiveBackground"), "window", (String)this.colorMap.get("background"), "windowBorder", (String)this.colorMap.get("windowBackground"), "windowText", (String)this.colorMap.get("windowForeground"), "menu", (String)this.colorMap.get("background"), "menuText", (String)this.colorMap.get("foreground"), "text", (String)this.colorMap.get("windowBackground"), "textText", (String)this.colorMap.get("windowForeground"), "textHighlight", (String)this.colorMap.get("selectBackground"), "textHighlightText", (String)this.colorMap.get("selectForeground"), "textInactiveText", "#A7A5A3", "control", (String)this.colorMap.get("background"), "controlText", (String)this.colorMap.get("buttonForeground"), "controlHighlight", (String)this.colorMap.get("buttonBackground"), "controlLtHighlight", (String)this.colorMap.get("selectBackground"), "controlShadow", "#BBBBBB", "controlLightShadow", "#000000", "controlDkShadow", "#000000", "scrollbar", "#000000", "info", (String)this.colorMap.get("foreground"), "infoText", (String)this.colorMap.get("foreground")};
        this.loadSystemColors(uIDefaults, stringArray, false);
    }

    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        AbstractBorder abstractBorder = new EmptyBorder(0, 0, 0, 0);
        uIDefaults.put("Button.margin", this.getButtonMargin());
        uIDefaults.put("Button.border", new BasicBorders.MarginBorder());
        uIDefaults.put("ToggleButton.margin", this.getButtonMargin());
        uIDefaults.put("ToggleButton.border", new BasicBorders.MarginBorder());
        uIDefaults.put("ToggleButton.background", uIDefaults.get("window"));
        uIDefaults.put("TextField.border", new LiquidTextFieldBorder());
        uIDefaults.put("PasswordField.border", new LiquidTextFieldBorder());
        uIDefaults.put("Spinner.border", new LiquidTextFieldBorder(new Insets(2, 2, 2, 2)));
        uIDefaults.put("ToolBar.background", uIDefaults.get("window"));
        uIDefaults.put("MenuBar.background", uIDefaults.get("window"));
        abstractBorder = new EmptyBorder(2, 2, 2, 2);
        uIDefaults.put("InternalFrame.border", abstractBorder);
        uIDefaults.put("InternalFrame.paletteBorder", abstractBorder);
        uIDefaults.put("InternalFrame.optionDialogBorder", new LiquidInternalFrameBorder());
        abstractBorder = new EmptyBorder(3, 1, 3, 1);
        uIDefaults.put("Menu.border", abstractBorder);
        uIDefaults.put("MenuItem.border", abstractBorder);
        uIDefaults.put("CheckBoxMenuItem.border", abstractBorder);
        uIDefaults.put("RadioButtonMenuItem.border", abstractBorder);
        uIDefaults.put("CheckBoxMenuItem.checkIcon", LiquidLookAndFeel.loadIcon("menucheck.png", this));
        uIDefaults.put("CheckBoxMenuItem.checkedIcon", LiquidLookAndFeel.loadIcon("menuchecked.png", this));
        uIDefaults.put("RadioButtonMenuItem.checkIcon", LiquidLookAndFeel.loadIcon("menuradio.png", this));
        uIDefaults.put("RadioButtonMenuItem.checkedIcon", LiquidLookAndFeel.loadIcon("menuradio_down.png", this));
        uIDefaults.put("MenuItem.arrowIcon", LiquidLookAndFeel.loadIcon("menuarrow.png", this));
        uIDefaults.put("MenuItem.selArrowIcon", LiquidLookAndFeel.loadIcon("menuarrowsel.png", this));
        uIDefaults.put("Menu.submenuPopupOffsetX", new Integer(-3));
        uIDefaults.put("Menu.submenuPopupOffsetY", new Integer(4));
        abstractBorder = new LiquidPopupMenuBorder();
        uIDefaults.put("PopupMenu.border", abstractBorder);
        uIDefaults.put("SplitPane.dividerSize", new Integer(7));
        uIDefaults.put("InternalFrame.paletteTitleHeight", new Integer(14));
        uIDefaults.put("InternalFrame.frameTitleHeight", new Integer(24));
        uIDefaults.put("InternalFrame.normalTitleFont", this.getFont(1, 14));
        uIDefaults.put("Panel.background", uIDefaults.get("window"));
        uIDefaults.put("TabbedPane.selectedTabPadInsets", new Insets(1, 1, 1, 1));
        uIDefaults.put("TabbedPane.tabAreaInsets", new Insets(4, 2, 0, 0));
        uIDefaults.put("TabbedPane.contentBorderInsets", new Insets(5, 0, 0, 0));
        uIDefaults.put("TabbedPane.unselected", uIDefaults.get("shadow"));
        uIDefaults.put("Checkbox.select", uIDefaults.get("shadow"));
        uIDefaults.put("PopupMenu.background", uIDefaults.get("window"));
        uIDefaults.put("PopupMenu.foreground", Color.black);
        uIDefaults.put("TextField.selectionForeground", uIDefaults.get("textHighlightText"));
        uIDefaults.put("TextField.selectionBackground", uIDefaults.get("textHighlight"));
        uIDefaults.put("TextField.background", uIDefaults.get("text"));
        uIDefaults.put("TextField.disabledBackground", uIDefaults.get("window"));
        uIDefaults.put("TextField.focusInputMap", this.fieldInputMap);
        uIDefaults.put("PasswordField.focusInputMap", this.fieldInputMap);
        uIDefaults.put("TextArea.focusInputMap", this.multilineInputMap);
        uIDefaults.put("TextPane.focusInputMap", this.multilineInputMap);
        uIDefaults.put("TextPane.background", uIDefaults.get("text"));
        uIDefaults.put("EditorPane.focusInputMap", this.multilineInputMap);
        uIDefaults.put("FormattedTextField.focusInputMap", this.formattedInputMap);
        uIDefaults.put("List.background", uIDefaults.get("text"));
        uIDefaults.put("List.border", this.zeroEmptyBorder);
        uIDefaults.put("List.selectionForeground", uIDefaults.get("textHighlightText"));
        uIDefaults.put("List.selectionBackground", uIDefaults.get("textHighlight"));
        uIDefaults.put("List.focusCellHighlightBorder", this.focusCellHighlightBorder);
        uIDefaults.put("ScrollPane.border", this.listBorder);
        uIDefaults.put("ComboBox.border", new EmptyBorder(1, 1, 1, 1));
        uIDefaults.put("ComboBox.foreground", uIDefaults.get("textHighlightText"));
        uIDefaults.put("ComboBox.background", uIDefaults.get("text"));
        uIDefaults.put("ComboBox.selectionForeground", uIDefaults.get("textHighlightText"));
        uIDefaults.put("ComboBox.selectionBackground", uIDefaults.get("textHighlight"));
        uIDefaults.put("ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "ENTER", "enterPressed"}));
        uIDefaults.put("InternalFrame.paletteCloseIcon", LiquidLookAndFeel.loadIcon("closebutton.png", this));
        uIDefaults.put("InternalFrame.closeIcon", LiquidLookAndFeel.loadWinButtonIcon("close.png", this));
        uIDefaults.put("InternalFrame.maximizeIcon", LiquidLookAndFeel.loadWinButtonIcon("maximize.png", this));
        uIDefaults.put("InternalFrame.iconifyIcon", LiquidLookAndFeel.loadWinButtonIcon("minimize.png", this));
        uIDefaults.put("InternalFrame.minimizeIcon", LiquidLookAndFeel.loadWinButtonIcon("restore.png", this));
        uIDefaults.put("InternalFrame.frameTitleHeight", new Integer(25));
        uIDefaults.put("InternalFrame.paletteTitleHeight", new Integer(16));
        uIDefaults.put("InternalFrame.icon", LiquidLookAndFeel.loadIcon("internalframeicon.png", this));
        uIDefaults.put("InternalFrame.pantherIcon", LiquidLookAndFeel.loadIcon("panther-blue.png", this));
        uIDefaults.put("InternalFrame.pantherIconInactive", LiquidLookAndFeel.loadIcon("panther-gray.png", this));
        uIDefaults.put("Table.background", uIDefaults.get("text"));
        uIDefaults.put("Table.foreground", uIDefaults.get("controlText"));
        uIDefaults.put("Table.selectionBackground", uIDefaults.get("textHighlight"));
        uIDefaults.put("Table.selectionForeground", uIDefaults.get("textHighlightText"));
        uIDefaults.put("Table.focusCellBackground", uIDefaults.get("textHighlight"));
        uIDefaults.put("Table.focusCellForeground", uIDefaults.get("textHighlightText"));
        uIDefaults.put("Table.focusCellHighlightBorder", this.focusCellHighlightBorder);
        uIDefaults.put("Table.scrollPaneBorder", this.listBorder);
        uIDefaults.put("TableHeader.font", this.getFont(0, 12));
        uIDefaults.put("TableHeader.foreground", uIDefaults.get("textText"));
        uIDefaults.put("TableHeader.background", uIDefaults.get("window"));
        uIDefaults.put("TableHeader.cellBorder", this.zeroEmptyBorder);
        uIDefaults.put("ToolTip.background", new Color(255, 255, 225));
        uIDefaults.put("ToolTip.foreground", new Color(0, 0, 0));
        uIDefaults.put("ToolTip.font", this.getFont(0, 12));
        uIDefaults.put("ToolTip.border", new CompoundBorder(new LineBorder(Color.black, 1), new EmptyBorder(2, 2, 2, 2)));
        uIDefaults.put("Tree.font", this.getFont(0, 12));
        uIDefaults.put("Tree.selectionForeground", uIDefaults.get("textHighlightText"));
        uIDefaults.put("Tree.selectionBackground", uIDefaults.get("textHighlight"));
        uIDefaults.put("Tree.foreground", uIDefaults.get("textText"));
        uIDefaults.put("Tree.background", uIDefaults.get("text"));
        uIDefaults.put("Tree.expandedIcon", LiquidLookAndFeel.loadIcon("treeminus.png", this));
        uIDefaults.put("Tree.collapsedIcon", LiquidLookAndFeel.loadIcon("treeplus.png", this));
        uIDefaults.put("Tree.openIcon", LiquidLookAndFeel.loadIcon("treefolderopened.png", this));
        uIDefaults.put("Tree.closedIcon", LiquidLookAndFeel.loadIcon("treefolderclosed.png", this));
        uIDefaults.put("Tree.leafIcon", LiquidLookAndFeel.loadIcon("treeleaf.png", this));
        uIDefaults.put("Tree.rowHeight", new Integer(18));
        uIDefaults.put("Tree.selectionBorderColor", new Color(86, 46, 0));
        uIDefaults.put("SplitPane.background", uIDefaults.get("text"));
        uIDefaults.put("SplitPane.border", this.listBorder);
        uIDefaults.put("SplitPaneDivider.border", this.zeroEmptyBorder);
        uIDefaults.put("FileView.directoryIcon", LiquidLookAndFeel.loadIcon("treefolderclosed.png", this));
        uIDefaults.put("FileView.computerIcon", LiquidLookAndFeel.loadIcon("computericon.png", this));
        uIDefaults.put("FileView.fileIcon", LiquidLookAndFeel.loadIcon("document.png", this));
        uIDefaults.put("FileView.floppyDriveIcon", LiquidLookAndFeel.loadIcon("floppy.png", this));
        uIDefaults.put("FileView.hardDriveIcon", LiquidLookAndFeel.loadIcon("harddisk.png", this));
        uIDefaults.put("FileChooser.detailsViewIcon", LiquidLookAndFeel.loadIcon("filedetails.png", this));
        uIDefaults.put("FileChooser.homeFolderIcon", LiquidLookAndFeel.loadIcon("desktopicon.png", this));
        uIDefaults.put("FileChooser.listViewIcon", LiquidLookAndFeel.loadIcon("filelist.png", this));
        uIDefaults.put("FileChooser.newFolderIcon", LiquidLookAndFeel.loadIcon("newfolder.png", this));
        uIDefaults.put("FileChooser.upFolderIcon", LiquidLookAndFeel.loadIcon("parentdirectory.png", this));
        uIDefaults.put("FileChooser.upFolderIcon", LiquidLookAndFeel.loadIcon("parentdirectory.png", this));
        uIDefaults.put("OptionPane.errorIcon", LiquidLookAndFeel.loadIcon("error.png", this));
        uIDefaults.put("OptionPane.informationIcon", LiquidLookAndFeel.loadIcon("information.png", this));
        uIDefaults.put("OptionPane.warningIcon", LiquidLookAndFeel.loadIcon("warning.png", this));
        uIDefaults.put("OptionPane.questionIcon", LiquidLookAndFeel.loadIcon("question.png", this));
        uIDefaults.put("RootPane.colorChooserDialogBorder", LiquidFrameBorder.getInstance());
        uIDefaults.put("RootPane.errorDialogBorder", LiquidFrameBorder.getInstance());
        uIDefaults.put("RootPane.fileChooserDialogBorder", LiquidFrameBorder.getInstance());
        uIDefaults.put("RootPane.frameBorder", LiquidFrameBorder.getInstance());
        uIDefaults.put("RootPane.informationDialogBorder", LiquidFrameBorder.getInstance());
        uIDefaults.put("RootPane.plainDialogBorder", LiquidFrameBorder.getInstance());
        uIDefaults.put("RootPane.questionDialogBorder", LiquidFrameBorder.getInstance());
        uIDefaults.put("RootPane.warningDialogBorder", LiquidFrameBorder.getInstance());
    }

    public static ImageIcon loadIcon(String string, Object object) {
        return LiquidLookAndFeel.loadIconImmediately(string, object);
    }

    public static ImageIcon loadWinButtonIcon(String string, Object object) {
        if (winDecoPanther) {
            string = "panther-" + string;
        }
        return LiquidLookAndFeel.loadIconImmediately(string, object);
    }

    public static ImageIcon loadIconImmediately(String string, Object object) {
        try {
            Image image = SkinImageCache.getInstance().getImage(string);
            ImageIcon imageIcon = new ImageIcon(image);
            if (imageIcon.getIconWidth() <= 0) {
                System.out.println("******************** File " + string + " not found. Exiting");
                System.exit(1);
            }
            return imageIcon;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error getting resource " + string);
            return null;
        }
    }

    protected Font getFont(int n, int n2) {
        return new Font(this.fontName, n, n2);
    }

    private InsetsUIResource getButtonMargin() {
        return new InsetsUIResource(4, 16, 4, 16);
    }

    public static Color getLightControl() {
        return (Color)uiDefaults.get("control");
    }

    public static Color getDarkControl() {
        return new Color(127, 127, 127);
    }

    public static Color getBackgroundColor() {
        return (Color)uiDefaults.get("window");
    }

    public static Color getDesktopColor() {
        return (Color)uiDefaults.get("desktop");
    }

    protected static Color getWindowTitleInactiveForeground() {
        return (Color)uiDefaults.get("inactiveCaptionText");
    }

    public static Color getWindowBackground() {
        return (Color)uiDefaults.get("window");
    }

    public static Color getButtonBackground() {
        return (Color)uiDefaults.get("controlHighlight");
    }

    public static void setDefaultTableBackgroundMode(boolean bl) {
        LiquidLookAndFeel.setDefaultRowBackgroundMode(bl);
    }

    public static void setDefaultRowBackgroundMode(boolean bl) {
        defaultRowBackgroundMode = bl;
        if (!bl) {
            showTableGrids = true;
        }
    }

    public static void setLiquidDecorations(boolean bl) {
        JFrame.setDefaultLookAndFeelDecorated(bl);
        JDialog.setDefaultLookAndFeelDecorated(bl);
    }

    public static void setLiquidDecorations(boolean bl, String string) {
        JFrame.setDefaultLookAndFeelDecorated(bl);
        JDialog.setDefaultLookAndFeelDecorated(bl);
        if (string.equalsIgnoreCase("panther")) {
            winDecoPanther = true;
        }
    }

    protected static boolean areStipplesUsed() {
        return bgStipples;
    }

    public static void setStipples(boolean bl) {
        bgStipples = bl;
    }

    public static void setShowTableGrids(boolean bl) {
        showTableGrids = bl;
    }

    public static void setPanelTransparency(boolean bl) {
        panelTransparency = bl;
    }

    public static void setToolbarFlattedButtons(boolean bl) {
        toolbarFlattedButtons = bl;
    }

    static {
        defaultRowBackgroundMode = true;
        showTableGrids = false;
        panelTransparency = true;
        bgStipples = true;
        winDecoPanther = false;
        toolbarFlattedButtons = true;
        isInstalled = false;
    }
}

