/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.util.Colors;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class LiquidPanelUI
extends BasicPanelUI {
    private static LiquidPanelUI panelUI;
    private static ArrayList panels;

    public static ComponentUI createUI(JComponent jComponent) {
        if (panelUI == null) {
            panelUI = new LiquidPanelUI();
        }
        return panelUI;
    }

    public void installUI(JComponent jComponent) {
        JPanel jPanel = (JPanel)jComponent;
        super.installUI(jPanel);
        this.installDefaults(jPanel);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        Iterator iterator = panels.iterator();
        while (iterator.hasNext()) {
            ((JPanel)iterator.next()).setOpaque(true);
        }
        panels.removeAll(panels);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Color color = LiquidLookAndFeel.getBackgroundColor();
        if (LiquidLookAndFeel.areStipplesUsed()) {
            Container container = jComponent.getParent();
            if (LiquidLookAndFeel.panelTransparency && container instanceof JPanel && jComponent.isOpaque() && ((JPanel)jComponent).getClientProperty("panelTransparency") == null) {
                panels.add(jComponent);
                jComponent.setOpaque(false);
                if (jComponent.isOpaque()) {
                    ((JPanel)jComponent).putClientProperty("panelTransparency", "");
                }
                container.repaint();
            }
            if (LiquidLookAndFeel.getBackgroundColor().equals(jComponent.getBackground()) && jComponent.isOpaque()) {
                Colors.drawStipples(graphics, jComponent, color);
            }
            if (container instanceof JLayeredPane) {
                jComponent.setOpaque(true);
            }
        }
        super.paint(graphics, jComponent);
    }

    static {
        panels = new ArrayList();
    }
}

