/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.skin.Skin;
import com.birosoft.liquid.skin.SkinSimpleButtonIndexModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class LiquidSliderUI
extends BasicSliderUI {
    private static Skin skinThumbHoriz;
    private static Skin skinThumbVert;
    private static Skin skinHorizSlider;
    private static Skin skinVertSlider;
    private Skin skinSlider;
    private SkinSimpleButtonIndexModel skinIndexModel = new SkinSimpleButtonIndexModel();
    protected boolean isRollover = false;
    protected boolean wasRollover = false;
    protected boolean isDragging = false;
    protected BasicSliderUI.TrackListener trackListener;

    public LiquidSliderUI() {
        super(null);
    }

    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new MyTrackListener();
    }

    protected Dimension getThumbSize() {
        Dimension dimension = this.getSkinThumb().getSize();
        return dimension;
    }

    public void paintThumb(Graphics graphics) {
        Rectangle rectangle = this.thumbRect;
        int n = this.skinIndexModel.getIndexForState(this.slider.isEnabled(), this.isRollover, this.isDragging);
        this.getSkinThumb().drawCentered(graphics, n, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new LiquidSliderUI();
    }

    protected int getTrackWidth() {
        if (this.slider.getOrientation() == 0) {
            return (int)(0.4375 * (double)this.thumbRect.height);
        }
        return (int)(0.4375 * (double)this.thumbRect.width);
    }

    protected int getThumbOverhang() {
        if (this.slider.getOrientation() == 1) {
            return (int)(this.getThumbSize().getWidth() - (double)this.getTrackWidth()) / 2;
        }
        return (int)(this.getThumbSize().getHeight() - (double)this.getTrackWidth()) / 2;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        jComponent.setOpaque(false);
        graphics.setColor(new Color(0, 0, 0, 0));
        graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        super.paint(graphics, jComponent);
    }

    public void paintTicks(Graphics graphics) {
        Rectangle rectangle = this.tickRect;
        int n = rectangle.width;
        int n2 = rectangle.height;
        boolean bl = this.slider.getComponentOrientation().isLeftToRight();
        graphics.setColor(new Color(0, 0, 0, 0));
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        int n3 = this.slider.getMajorTickSpacing();
        int n4 = this.slider.getMinorTickSpacing();
        if (this.slider.getOrientation() == 0) {
            int n5;
            graphics.translate(0, rectangle.y);
            int n6 = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                for (n5 = this.slider.getMinimum(); n5 <= this.slider.getMaximum(); n5 += this.slider.getMinorTickSpacing()) {
                    n6 = this.xPositionForValue(n5);
                    this.paintMinorTickForHorizSlider(graphics, rectangle, n6);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                for (n5 = this.slider.getMinimum(); n5 <= this.slider.getMaximum(); n5 += this.slider.getMajorTickSpacing()) {
                    n6 = this.xPositionForValue(n5);
                    this.paintMajorTickForHorizSlider(graphics, rectangle, n6);
                }
            }
            graphics.translate(0, -rectangle.y);
        } else {
            graphics.translate(rectangle.x, 0);
            int n7 = this.slider.getMinimum();
            int n8 = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                int n9 = 0;
                if (!bl) {
                    n9 = rectangle.width - rectangle.width / 2;
                    graphics.translate(n9, 0);
                }
                while (n7 <= this.slider.getMaximum()) {
                    n8 = this.yPositionForValue(n7);
                    this.paintMinorTickForVertSlider(graphics, rectangle, n8);
                    n7 += this.slider.getMinorTickSpacing();
                }
                if (!bl) {
                    graphics.translate(-n9, 0);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                n7 = this.slider.getMinimum();
                if (!bl) {
                    graphics.translate(2, 0);
                }
                while (n7 <= this.slider.getMaximum()) {
                    n8 = this.yPositionForValue(n7);
                    this.paintMajorTickForVertSlider(graphics, rectangle, n8);
                    n7 += this.slider.getMajorTickSpacing();
                }
                if (!bl) {
                    graphics.translate(-2, 0);
                }
            }
            graphics.translate(-rectangle.x, 0);
        }
    }

    public void paintTrack(Graphics graphics) {
        Color color = Color.red;
        boolean bl = this.slider.getComponentOrientation().isLeftToRight();
        graphics.translate(this.trackRect.x, this.trackRect.y);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.slider.getOrientation() == 0) {
            n4 = this.trackRect.height - 1 - this.getThumbOverhang();
            n2 = n4 - (this.getTrackWidth() - 1);
            n3 = this.trackRect.width - 1;
            int n5 = (n4 - n2 - LiquidSliderUI.getSkinHorizSlider().getVsize()) / 2;
            LiquidSliderUI.getSkinHorizSlider().draw(graphics, 0, n, n2 + n5, n3 - n, LiquidSliderUI.getSkinHorizSlider().getVsize());
        } else {
            if (bl) {
                n = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                n3 = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                n = this.getThumbOverhang();
                n3 = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            n4 = this.trackRect.height - 1;
            int n6 = (n3 - n - LiquidSliderUI.getSkinVertSlider().getHsize()) / 2;
            LiquidSliderUI.getSkinVertSlider().draw(graphics, 0, n + n6, n2, LiquidSliderUI.getSkinVertSlider().getHsize(), n4 - n2);
        }
        graphics.translate(-this.trackRect.x, -this.trackRect.y);
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(LiquidLookAndFeel.getDarkControl());
        graphics.drawLine(n, 0, n, rectangle.height / 2 - 1);
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(LiquidLookAndFeel.getDarkControl());
        graphics.drawLine(n, 0, n, rectangle.height - 2);
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(LiquidLookAndFeel.getDarkControl());
        graphics.drawLine(0, n, rectangle.width / 2 - 1, n);
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(LiquidLookAndFeel.getDarkControl());
        graphics.drawLine(0, n, rectangle.width - 2, n);
    }

    public static Skin getSkinHorizSlider() {
        if (skinHorizSlider == null) {
            skinHorizSlider = new Skin("sliderhorizbackground.png", 1, 6, 0, 6, 0);
        }
        return skinHorizSlider;
    }

    public static Skin getSkinThumbHoriz() {
        if (skinThumbHoriz == null) {
            skinThumbHoriz = new Skin("sliderhoriz.png", 4, 0);
        }
        return skinThumbHoriz;
    }

    public static Skin getSkinThumbVert() {
        if (skinThumbVert == null) {
            skinThumbVert = new Skin("slidervert.png", 4, 0);
        }
        return skinThumbVert;
    }

    public static Skin getSkinVertSlider() {
        if (skinVertSlider == null) {
            skinVertSlider = new Skin("slidervertbackground.png", 1, 0, 6, 0, 6);
        }
        return skinVertSlider;
    }

    public Skin getSkinThumb() {
        if (this.skinSlider == null) {
            this.skinSlider = this.slider.getOrientation() == 0 ? LiquidSliderUI.getSkinThumbHoriz() : LiquidSliderUI.getSkinThumbVert();
        }
        return this.skinSlider;
    }

    class MyTrackListener
    extends BasicSliderUI.TrackListener {
        MyTrackListener() {
            super(LiquidSliderUI.this);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            LiquidSliderUI.this.isDragging = false;
            LiquidSliderUI.this.slider.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (LiquidSliderUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
                LiquidSliderUI.this.isDragging = true;
            }
            LiquidSliderUI.this.slider.repaint();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            LiquidSliderUI.this.isRollover = false;
            LiquidSliderUI.this.wasRollover = false;
            if (LiquidSliderUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
                LiquidSliderUI.this.isRollover = true;
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            LiquidSliderUI.this.isRollover = false;
            if (LiquidSliderUI.this.isRollover != LiquidSliderUI.this.wasRollover) {
                LiquidSliderUI.this.slider.repaint();
                LiquidSliderUI.this.wasRollover = LiquidSliderUI.this.isRollover;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (LiquidSliderUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
                LiquidSliderUI.this.isRollover = true;
            }
            super.mouseDragged(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (LiquidSliderUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
                LiquidSliderUI.this.isRollover = true;
                if (LiquidSliderUI.this.isRollover != LiquidSliderUI.this.wasRollover) {
                    LiquidSliderUI.this.slider.repaint();
                    LiquidSliderUI.this.wasRollover = LiquidSliderUI.this.isRollover;
                }
            } else {
                LiquidSliderUI.this.isRollover = false;
                if (LiquidSliderUI.this.isRollover != LiquidSliderUI.this.wasRollover) {
                    LiquidSliderUI.this.slider.repaint();
                    LiquidSliderUI.this.wasRollover = LiquidSliderUI.this.isRollover;
                }
            }
        }
    }
}

