/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler;

import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Field;
import de.grogra.reflect.FieldBase;
import de.grogra.reflect.LazyType;
import de.grogra.reflect.Lookup;
import de.grogra.reflect.MemberBase;
import de.grogra.reflect.Method;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.reflect.TypeLoader;
import de.grogra.reflect.XArray;
import de.grogra.util.WrapException;
import de.grogra.xl.compiler.ASMTypeLoader;
import de.grogra.xl.util.ObjectList;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ASMType
extends MemberBase
implements Type,
ClassVisitor {
    private final ASMTypeLoader loader;
    private String binaryName;
    private String simpleName;
    private String internalName;
    private Type superType;
    private Type[] interfaces;
    private ObjectList<ASMType> types = new ObjectList();
    private ObjectList<Field> fields = new ObjectList();
    private ObjectList<ASMMethod> methods = new ObjectList();
    private ObjectList varArgs = null;
    private HashMap<String, Object> defaultValues;
    private Type resolvedType;
    private Lookup lookup;
    int nextOffset;
    static final ObjectList<Object> EMPTY_LIST = new ObjectList();
    private ObjectList<Type> ptypes = new ObjectList();

    public ASMType(ASMTypeLoader aSMTypeLoader) {
        this.loader = aSMTypeLoader;
    }

    synchronized Type resolve() {
        if (this.resolvedType == null) {
            try {
                this.resolvedType = ClassAdapter.wrap(Class.forName(this.binaryName, false, this.loader.getClassLoader()), (boolean)false);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException.getMessage());
            }
        }
        return this.resolvedType;
    }

    public TypeLoader getTypeLoader() {
        return this.loader;
    }

    public int getTypeId() {
        return 0;
    }

    public String getPackage() {
        return this.binaryName.substring(0, Math.max(0, this.binaryName.lastIndexOf(46)));
    }

    public String getBinaryName() {
        return this.binaryName;
    }

    public boolean isInstance(Object object) {
        return this.resolve().isInstance(object);
    }

    public Class getImplementationClass() {
        return this.resolve().getImplementationClass();
    }

    public Type getSupertype() {
        return this.superType;
    }

    public int getDeclaredInterfaceCount() {
        return this.interfaces.length;
    }

    public Type getDeclaredInterface(int n) {
        return this.interfaces[n];
    }

    public int getDeclaredFieldCount() {
        return this.fields.size();
    }

    public Field getDeclaredField(int n) {
        return (Field)this.fields.get(n);
    }

    public int getDeclaredTypeCount() {
        return this.types.size();
    }

    public Type getDeclaredType(int n) {
        return (Type)this.types.get(n);
    }

    public int getDeclaredMethodCount() {
        return this.methods.size();
    }

    public Method getDeclaredMethod(int n) {
        return (Method)this.methods.get(n);
    }

    public Type getComponentType() {
        return null;
    }

    public Type getArrayType() {
        return new XArray((Type)this);
    }

    public Object createArray(int n) {
        throw new AssertionError();
    }

    public Object cloneObject(Object object, boolean bl) throws CloneNotSupportedException {
        return this.resolve().cloneObject(object, bl);
    }

    public boolean isStringSerializable() {
        return this.resolve().isStringSerializable();
    }

    public Object valueOf(String string) {
        return this.resolve().valueOf(string);
    }

    public Object newInstance() throws InvocationTargetException, InstantiationException, IllegalAccessException {
        return this.resolve().newInstance();
    }

    public synchronized Object getDefaultElementValue(String string) {
        if (this.defaultValues == null) {
            return null;
        }
        Object object = this.defaultValues.get(string);
        Object object2 = this.convertElementValue(this, string, object);
        if (object2 != object) {
            this.defaultValues.put(string, object2);
        }
        return object2;
    }

    public final synchronized Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = new Lookup((Type)this);
        }
        return this.lookup;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        this.modifiers = n2 & 0x1FFF;
        this.internalName = string;
        this.descriptor = 'L' + string + ';';
        this.binaryName = string.replace('/', '.');
        this.name = this.binaryName.replace('$', '.');
        this.simpleName = this.binaryName.substring(this.binaryName.lastIndexOf(46) + 1);
        this.superType = string3 != null ? new LazyType(string3.replace('/', '.'), (TypeLoader)this.loader) : null;
        this.interfaces = this.getTypes(stringArray);
    }

    public void visitSource(String string, String string2) {
    }

    public void visitOuterClass(String string, String string2, String string3) {
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        if (this.annots == null) {
            this.annots = new ObjectList();
        }
        return new AnnVisitor(string, (List<de.grogra.reflect.Annotation>)this.annots, null, null);
    }

    public void visitAttribute(Attribute attribute) {
    }

    public void visitInnerClass(String string, String string2, String string3, int n) {
        string = string.replace('/', '.');
        try {
            ASMType aSMType = (ASMType)this.loader.typeForName(string);
            aSMType.simpleName = string3;
            aSMType.modifiers = aSMType.modifiers & 0xFFFFFFF0 | n & 0xF;
            if (this.internalName.equals(string2)) {
                aSMType.declaringType = this;
                this.types.add((Object)aSMType);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WrapException((Throwable)classNotFoundException);
        }
    }

    private Type getType(CharSequence charSequence, int n) {
        this.nextOffset = n + 1;
        switch (charSequence.charAt(n)) {
            case 'V': {
                return VOID;
            }
            case 'Z': {
                return BOOLEAN;
            }
            case 'B': {
                return BYTE;
            }
            case 'S': {
                return SHORT;
            }
            case 'C': {
                return CHAR;
            }
            case 'I': {
                return INT;
            }
            case 'J': {
                return LONG;
            }
            case 'F': {
                return FLOAT;
            }
            case 'D': {
                return DOUBLE;
            }
            case '[': {
                return new XArray(this.getType(charSequence, n + 1));
            }
            case 'L': {
                int n2 = n + 2;
                while (charSequence.charAt(n2) != ';') {
                    ++n2;
                }
                this.nextOffset = n2 + 1;
                return new LazyType(((Object)charSequence.subSequence(n + 1, n2)).toString().replace('/', '.'), (TypeLoader)this.loader);
            }
        }
        throw new ClassFormatError(((Object)charSequence).toString());
    }

    private Type[] getTypes(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return TYPE_0;
        }
        Type[] typeArray = new Type[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            typeArray[i] = new LazyType(stringArray[i].replace('/', '.'), (TypeLoader)this.loader);
        }
        return typeArray;
    }

    Object convertElementValue(Type type, String string, Object object) {
        if (object instanceof org.objectweb.asm.Type) {
            return this.getType(((org.objectweb.asm.Type)object).getDescriptor(), 0);
        }
        if (object instanceof ObjectList) {
            Method method = Reflection.getElementMethod((Type)type, (String)string);
            if (method == null) {
                throw new NoSuchMethodError(type + " " + string);
            }
            ObjectList objectList = (ObjectList)object;
            Type type2 = method.getReturnType().getComponentType();
            Class clazz = Reflection.isPrimitive((Type)type2) ? type2.getImplementationClass() : (Reflection.equal((Type)type2, (Type)Type.STRING) ? String.class : (Reflection.equal((Type)type2, (Type)Type.CLASS) ? Type.class : (Reflection.isSuperclassOrSame(Enum.class, (Type)type2) ? String.class : de.grogra.reflect.Annotation.class)));
            object = Array.newInstance(clazz, objectList.size());
            for (int i = 0; i < objectList.size(); ++i) {
                Array.set(object, i, this.convertElementValue(null, null, objectList.get(i)));
            }
            return object;
        }
        return object;
    }

    public FieldVisitor visitField(int n, String string, String string2, String string3, final Object object) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ASMField
        extends FieldBase
        implements FieldVisitor {
            private Field resolved;

            ASMField(String string, int n, Type type) {
                super(string, n, (Type)ASMType.this, type);
            }

            private synchronized Field resolveField() {
                if (this.resolved == null) {
                    this.resolved = Reflection.getDeclaredField((Type)ASMType.this.resolve(), (String)this.getSimpleName());
                }
                return this.resolved;
            }

            public boolean getBoolean(Object object2) throws IllegalAccessException {
                if (object != null) {
                    return ((Number)object).intValue() != 0;
                }
                return this.resolveField().getBoolean(object2);
            }

            public void setBoolean(Object object2, boolean bl) throws IllegalAccessException {
                this.resolveField().setBoolean(object2, bl);
            }

            public byte getByte(Object object2) throws IllegalAccessException {
                if (object != null) {
                    return ((Number)object).byteValue();
                }
                return this.resolveField().getByte(object2);
            }

            public void setByte(Object object2, byte by) throws IllegalAccessException {
                this.resolveField().setByte(object2, by);
            }

            public short getShort(Object object2) throws IllegalAccessException {
                if (object != null) {
                    return ((Number)object).shortValue();
                }
                return this.resolveField().getShort(object2);
            }

            public void setShort(Object object2, short s) throws IllegalAccessException {
                this.resolveField().setShort(object2, s);
            }

            public char getChar(Object object2) throws IllegalAccessException {
                if (object != null) {
                    return (char)((Number)object).intValue();
                }
                return this.resolveField().getChar(object2);
            }

            public void setChar(Object object2, char c) throws IllegalAccessException {
                this.resolveField().setChar(object2, c);
            }

            public int getInt(Object object2) throws IllegalAccessException {
                if (object != null) {
                    return ((Number)object).intValue();
                }
                return this.resolveField().getInt(object2);
            }

            public void setInt(Object object2, int n) throws IllegalAccessException {
                this.resolveField().setInt(object2, n);
            }

            public long getLong(Object object2) throws IllegalAccessException {
                if (object != null) {
                    return ((Number)object).longValue();
                }
                return this.resolveField().getLong(object2);
            }

            public void setLong(Object object2, long l) throws IllegalAccessException {
                this.resolveField().setLong(object2, l);
            }

            public float getFloat(Object object2) throws IllegalAccessException {
                if (object != null) {
                    return ((Number)object).floatValue();
                }
                return this.resolveField().getFloat(object2);
            }

            public void setFloat(Object object2, float f) throws IllegalAccessException {
                this.resolveField().setFloat(object2, f);
            }

            public double getDouble(Object object2) throws IllegalAccessException {
                if (object != null) {
                    return ((Number)object).doubleValue();
                }
                return this.resolveField().getDouble(object2);
            }

            public void setDouble(Object object2, double d) throws IllegalAccessException {
                this.resolveField().setDouble(object2, d);
            }

            public Object getObject(Object object2) throws IllegalAccessException {
                if (object != null) {
                    return object;
                }
                return this.resolveField().getObject(object2);
            }

            public void setObject(Object object3, Object object2) throws IllegalAccessException {
                this.resolveField().setObject(object3, object2);
            }

            public AnnotationVisitor visitAnnotation(String string, boolean bl) {
                if (this.annots == null) {
                    this.annots = new ObjectList();
                }
                return new AnnVisitor(string, (List<de.grogra.reflect.Annotation>)this.annots, null, null);
            }

            public void visitAttribute(Attribute attribute) {
            }

            public void visitEnd() {
            }
        }
        ASMField aSMField = new ASMField(string, n & 0x1FFF | (object != null ? 262144 : 0), this.getType(string2, 0));
        this.fields.add((Object)aSMField);
        if (string.startsWith("$VARARGS_") && object instanceof String) {
            if (this.varArgs == null) {
                this.varArgs = new ObjectList();
            }
            this.varArgs.add(object);
        }
        return aSMField;
    }

    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        this.ptypes.clear();
        int n2 = 1;
        while (string2.charAt(n2) != ')') {
            this.ptypes.add((Object)this.getType(string2, n2));
            n2 = this.nextOffset;
        }
        ASMMethod aSMMethod = new ASMMethod(string, null, n & 0x1FFF, this, this.getType(string2, n2 + 1), (Type[])this.ptypes.toArray((Object[])new Type[this.ptypes.size()]), this.getTypes(stringArray));
        this.methods.add((Object)aSMMethod);
        return aSMMethod;
    }

    public void visitEnd() {
        if (this.varArgs != null) {
            while (!this.varArgs.isEmpty()) {
                ASMMethod aSMMethod = (ASMMethod)Reflection.getDeclaredMethod((Type)this, (String)((String)this.varArgs.pop()));
                if (aSMMethod == null) continue;
                aSMMethod.setVarArgs();
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    static class ASMMethod
    extends MemberBase
    implements Method,
    MethodVisitor {
        private final Type returnType;
        private final Type[] parameterTypes;
        private final Type[] exceptionTypes;
        private Method resolved;
        private ObjectList<de.grogra.reflect.Annotation>[] parameterAnnotations;

        ASMMethod(String string, String string2, int n, ASMType aSMType, Type type, Type[] typeArray, Type[] typeArray2) {
            super(string, Reflection.getMethodDescriptor((String)string, (Type)type, (Type[])typeArray), n, (Type)aSMType);
            this.returnType = type;
            this.parameterTypes = typeArray;
            this.exceptionTypes = typeArray2;
        }

        void setVarArgs() {
            this.modifiers |= 0x80;
        }

        private synchronized Method resolveMethod() {
            if (this.resolved == null) {
                this.resolved = Reflection.getDeclaredMethod((Type)((ASMType)this.getDeclaringType()).resolve(), (String)this.getDescriptor());
            }
            return this.resolved;
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public Object invoke(Object object, Object[] objectArray) throws InvocationTargetException, IllegalAccessException {
            return this.resolveMethod().invoke(object, objectArray);
        }

        public int getExceptionCount() {
            return this.exceptionTypes.length;
        }

        public Type getExceptionType(int n) {
            return this.exceptionTypes[n];
        }

        public int getParameterCount() {
            return this.parameterTypes.length;
        }

        public Type getParameterType(int n) {
            return this.parameterTypes[n];
        }

        public int getParameterAnnotationCount(int n) {
            if (this.parameterAnnotations == null) {
                return 0;
            }
            if (this.parameterAnnotations[n] == null) {
                return 0;
            }
            return this.parameterAnnotations[n].size();
        }

        public de.grogra.reflect.Annotation getParameterAnnotation(int n, int n2) {
            return (de.grogra.reflect.Annotation)this.parameterAnnotations[n].get(n2);
        }

        public AnnotationVisitor visitAnnotation(String string, boolean bl) {
            if (this.annots == null) {
                this.annots = new ObjectList();
            }
            ASMType aSMType = (ASMType)this.getDeclaringType();
            ((Object)((Object)aSMType)).getClass();
            return aSMType.new AnnVisitor(string, (List<de.grogra.reflect.Annotation>)this.annots, null, null);
        }

        public AnnotationVisitor visitAnnotationDefault() {
            ASMType aSMType = (ASMType)this.getDeclaringType();
            ((Object)((Object)aSMType)).getClass();
            return aSMType.new AnnVisitor(null, null, null, this.getSimpleName());
        }

        public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
            if (this.parameterAnnotations == null) {
                this.parameterAnnotations = new ObjectList[this.parameterTypes.length];
            }
            if (this.parameterAnnotations[n] == null) {
                this.parameterAnnotations[n] = new ObjectList(1);
            }
            ASMType aSMType = (ASMType)this.getDeclaringType();
            ((Object)((Object)aSMType)).getClass();
            return aSMType.new AnnVisitor(string, (List<de.grogra.reflect.Annotation>)this.parameterAnnotations[n], null, null);
        }

        public void visitEnd() {
        }

        public void visitAttribute(Attribute attribute) {
        }

        public void visitCode() {
        }

        public void visitFieldInsn(int n, String string, String string2, String string3) {
        }

        public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        }

        public void visitIincInsn(int n, int n2) {
        }

        public void visitInsn(int n) {
        }

        public void visitIntInsn(int n, int n2) {
        }

        public void visitJumpInsn(int n, Label label) {
        }

        public void visitLabel(Label label) {
        }

        public void visitLdcInsn(Object object) {
        }

        public void visitLineNumber(int n, Label label) {
        }

        public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        }

        public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        }

        public void visitMaxs(int n, int n2) {
        }

        public void visitMethodInsn(int n, String string, String string2, String string3) {
        }

        public void visitMultiANewArrayInsn(String string, int n) {
        }

        public void visitTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
        }

        public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        }

        public void visitTypeInsn(int n, String string) {
        }

        public void visitVarInsn(int n, int n2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnVisitor
    implements AnnotationVisitor,
    de.grogra.reflect.Annotation {
        private final String typeDesc;
        private final List<de.grogra.reflect.Annotation> list;
        private final AnnVisitor parent;
        private final String elementName;
        private Type type;
        private HashMap<String, Object> values;
        private ObjectList<Object> elements;
        private String currentName;

        AnnVisitor(String string, List<de.grogra.reflect.Annotation> list, AnnVisitor annVisitor, String string2) {
            this.typeDesc = string;
            this.list = list;
            this.parent = annVisitor;
            this.elementName = string2;
        }

        public void visit(String string, Object object) {
            if (this.typeDesc == null) {
                if (this.elements == null) {
                    this.elements = new ObjectList();
                }
                this.elements.add(object);
            } else {
                if (this.values == null) {
                    this.values = new HashMap();
                }
                this.values.put(string, object);
            }
        }

        public AnnotationVisitor visitAnnotation(String string, String string2) {
            this.currentName = string;
            return new AnnVisitor(string2, null, this, null);
        }

        public AnnotationVisitor visitArray(String string) {
            this.currentName = string;
            return new AnnVisitor(null, null, this, null);
        }

        public void visitEnd() {
            if (this.list != null) {
                this.list.add(this);
            } else if (this.typeDesc != null) {
                this.parent.visit(this.parent.currentName, this);
            } else if (this.parent != null) {
                this.parent.visit(this.parent.currentName, this.elements != null ? this.elements : EMPTY_LIST);
            } else {
                if (this.elements.size() != 1) {
                    throw new AnnotationFormatError(this.elements.toString());
                }
                if (ASMType.this.defaultValues == null) {
                    ASMType.this.defaultValues = new HashMap();
                }
                ASMType.this.defaultValues.put(this.elementName, this.elements.get(0));
            }
        }

        public void visitEnum(String string, String string2, String string3) {
            this.visit(string, string3);
        }

        public synchronized Type<? extends Annotation> annotationType() {
            if (this.type == null) {
                this.type = ASMType.this.getType(this.typeDesc, 0);
            }
            return this.type;
        }

        public synchronized Object value(String string) {
            Object object;
            if (this.values != null && (object = this.values.get(string)) != null) {
                Object object2 = ASMType.this.convertElementValue(this.annotationType(), string, object);
                if (object2 != object) {
                    this.values.put(string, object2);
                }
                return object2;
            }
            return this.annotationType().getDefaultElementValue(string);
        }

        public String toString() {
            return "Annotation[" + this.annotationType() + ',' + this.values + ']';
        }
    }
}

