/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler.scope;

import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.reflect.TypeLoader;
import de.grogra.xl.compiler.ASMTypeLoader;
import de.grogra.xl.compiler.scope.Members;
import de.grogra.xl.compiler.scope.Package;
import de.grogra.xl.compiler.scope.PackageImportOnDemand;
import de.grogra.xl.compiler.scope.Scope;
import de.grogra.xl.compiler.scope.SingleTypeImport;
import de.grogra.xl.compiler.scope.StaticImportOnDemand;
import de.grogra.xl.compiler.scope.TypeImportOnDemand;
import java.util.HashMap;

public final class ClassPath
extends Scope
implements TypeLoader {
    private final ASMTypeLoader loader;
    private final HashMap packages = new HashMap();
    private final HashMap declaredTypes = new HashMap();

    public ClassPath(ASMTypeLoader aSMTypeLoader) {
        super(null);
        this.loader = aSMTypeLoader;
    }

    public static ClassPath get(Scope scope) {
        while (!(scope instanceof ClassPath)) {
            if (scope == null) {
                return null;
            }
            scope = scope.getEnclosingScope();
        }
        return (ClassPath)scope;
    }

    public Package getPackage(String string, boolean bl) {
        Package package_ = (Package)this.packages.get(string);
        if (package_ == null && (bl || this.loader.hasPackage(string))) {
            int n;
            package_ = new Package(this, string);
            this.packages.put(string, package_);
            if (bl && (n = string.lastIndexOf(46)) > 0) {
                this.getPackage(string.substring(0, n), bl);
            }
        }
        return package_;
    }

    void declareType(Type type) {
        this.declaredTypes.put(type.getBinaryName(), type);
    }

    public Type typeForNameOrNull(String string) {
        try {
            return this.loader.typeForNameOrNull(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Type typeForClass(Class clazz) throws ClassNotFoundException {
        ClassAdapter classAdapter;
        int n = 0;
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        Object object = classAdapter = clazz.isPrimitive() ? ClassAdapter.wrap(clazz) : this.loader.typeForName(clazz.getName());
        while (--n >= 0) {
            classAdapter = classAdapter.getArrayType();
        }
        return classAdapter;
    }

    public Type typeForType(Type type) throws ClassNotFoundException {
        int n = 0;
        while (Reflection.isArray((Type)type)) {
            ++n;
            type = type.getComponentType();
        }
        if (!Reflection.isPrimitive((Type)type)) {
            type = this.loader.typeForName(type.getName());
        }
        while (--n >= 0) {
            type = type.getArrayType();
        }
        return type;
    }

    public Type typeForName(String string) throws ClassNotFoundException {
        Type type = (Type)this.declaredTypes.get(string);
        return type != null ? type : this.loader.typeForName(string);
    }

    public Class classForName(String string) throws ClassNotFoundException {
        return this.loader.classForName(string);
    }

    public ClassLoader getClassLoader() {
        return this.loader.getClassLoader();
    }

    public void findMembers(String string, int n, Members members) {
        if ((n & 0x1000) != 0) {
            members.add(this.getPackage(string, false), this, n);
        }
    }

    public Scope createImports(String[] stringArray, Class[] classArray, Class[] classArray2, Class[] classArray3) throws ClassNotFoundException {
        int n;
        Scope scope = null;
        for (n = classArray3.length - 1; n >= 0; --n) {
            scope = new StaticImportOnDemand(scope, this.typeForClass(classArray3[n]));
        }
        for (n = classArray2.length - 1; n >= 0; --n) {
            scope = new SingleTypeImport(scope, this.typeForClass(classArray2[n]));
        }
        for (n = classArray.length - 1; n >= 0; --n) {
            scope = new TypeImportOnDemand(scope, this.typeForClass(classArray[n]));
        }
        for (n = stringArray.length - 1; n >= 0; --n) {
            scope = new PackageImportOnDemand(scope, this.getPackage(stringArray[n], false));
        }
        return scope;
    }
}

