/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler.scope;

import antlr.collections.AST;
import de.grogra.reflect.Member;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.scope.BlockScope;
import de.grogra.xl.compiler.scope.Members;
import de.grogra.xl.compiler.scope.Scope;
import de.grogra.xl.compiler.scope.TypeScope;
import de.grogra.xl.expr.Block;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.ExpressionFactory;

public class InstanceScope
extends BlockScope
implements ExpressionFactory {
    final boolean shadowsEnclosing;
    private ExpressionFactory instance;
    private final int memberFlags;

    public InstanceScope(BlockScope blockScope) {
        this(blockScope, new Block(), null, 10, true);
    }

    InstanceScope(BlockScope blockScope, Expression expression, ExpressionFactory expressionFactory, int n, boolean bl) {
        super((Scope)blockScope, expression);
        this.instance = expressionFactory;
        this.shadowsEnclosing = bl;
        this.memberFlags = n;
    }

    public ExpressionFactory getInstance() {
        return this.instance;
    }

    public Type getType() {
        return this.instance.getType();
    }

    public Expression createExpression(Scope scope, AST aST) {
        return this.instance.createExpression(scope, aST);
    }

    public void setInstance(ExpressionFactory expressionFactory) {
        this.instance = expressionFactory;
    }

    public void findMembers(String string, int n, Members members) {
        if ((n & 0x8000) == 0 && (n & this.memberFlags & 0x7F) != 0) {
            TypeScope.findMembers(this.instance.getType(), null, string, n & this.memberFlags, members, this);
        }
        if ((n & 0x10000) != 0) {
            n |= 0x8000;
        }
        super.findMembers(string, n, members);
    }

    public Type getOwnerOf(Member member) {
        return Reflection.isMember((Member)member, (Type)this.instance.getType()) ? this.instance.getType() : super.getOwnerOf(member);
    }

    public String toString() {
        return super.toString() + '[' + this.instance + ']';
    }
}

