/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Type;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.expr.Add;
import de.grogra.xl.expr.Assignment;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.IntConst;
import de.grogra.xl.expr.LocalAccess;
import de.grogra.xl.vmx.VMXState;

public class AssignLocal
extends Assignment
implements LocalAccess {
    private VMXState.Local local;
    private Local clocal;
    private Expression expr;

    public AssignLocal(VMXState.Local local, Type type, int n) {
        super(type, n);
        this.local = local;
    }

    public AssignLocal(Local local, int n) {
        super(local.getType(), n);
        this.clocal = local;
    }

    protected boolean evaluateBooleanImpl(VMXState vMXState) {
        switch (this.assignmentType) {
            case 0: {
                boolean bl = this.expr.evaluateBoolean(vMXState);
                vMXState.iset(this.local, bl ? 1 : 0, null);
                return bl;
            }
            case 1: {
                vMXState.ipush(vMXState.iget(this.local, null));
                boolean bl = this.expr.evaluateBoolean(vMXState);
                vMXState.iset(this.local, bl ? 1 : 0, null);
                return bl;
            }
            case 2: {
                boolean bl = vMXState.iget(this.local, null) != 0;
                vMXState.ipush(bl ? 1 : 0);
                vMXState.iset(this.local, this.expr.evaluateBoolean(vMXState) ? 1 : 0, null);
                return bl;
            }
        }
        throw new AssertionError();
    }

    protected byte evaluateByteImpl(VMXState vMXState) {
        switch (this.assignmentType) {
            case 0: {
                byte by = this.expr.evaluateByte(vMXState);
                vMXState.iset(this.local, (int)by, null);
                return by;
            }
            case 1: {
                vMXState.ipush(vMXState.iget(this.local, null));
                byte by = this.expr.evaluateByte(vMXState);
                vMXState.iset(this.local, (int)by, null);
                return by;
            }
            case 2: {
                byte by = (byte)vMXState.iget(this.local, null);
                vMXState.ipush((int)by);
                vMXState.iset(this.local, (int)this.expr.evaluateByte(vMXState), null);
                return by;
            }
        }
        throw new AssertionError();
    }

    protected short evaluateShortImpl(VMXState vMXState) {
        switch (this.assignmentType) {
            case 0: {
                short s = this.expr.evaluateShort(vMXState);
                vMXState.iset(this.local, (int)s, null);
                return s;
            }
            case 1: {
                vMXState.ipush(vMXState.iget(this.local, null));
                short s = this.expr.evaluateShort(vMXState);
                vMXState.iset(this.local, (int)s, null);
                return s;
            }
            case 2: {
                short s = (short)vMXState.iget(this.local, null);
                vMXState.ipush((int)s);
                vMXState.iset(this.local, (int)this.expr.evaluateShort(vMXState), null);
                return s;
            }
        }
        throw new AssertionError();
    }

    protected char evaluateCharImpl(VMXState vMXState) {
        switch (this.assignmentType) {
            case 0: {
                char c = this.expr.evaluateChar(vMXState);
                vMXState.iset(this.local, (int)c, null);
                return c;
            }
            case 1: {
                vMXState.ipush(vMXState.iget(this.local, null));
                char c = this.expr.evaluateChar(vMXState);
                vMXState.iset(this.local, (int)c, null);
                return c;
            }
            case 2: {
                char c = (char)vMXState.iget(this.local, null);
                vMXState.ipush((int)c);
                vMXState.iset(this.local, (int)this.expr.evaluateChar(vMXState), null);
                return c;
            }
        }
        throw new AssertionError();
    }

    protected int evaluateIntImpl(VMXState vMXState) {
        switch (this.assignmentType) {
            case 0: {
                int n = this.expr.evaluateInt(vMXState);
                vMXState.iset(this.local, n, null);
                return n;
            }
            case 1: {
                vMXState.ipush(vMXState.iget(this.local, null));
                int n = this.expr.evaluateInt(vMXState);
                vMXState.iset(this.local, n, null);
                return n;
            }
            case 2: {
                int n = vMXState.iget(this.local, null);
                vMXState.ipush(n);
                vMXState.iset(this.local, this.expr.evaluateInt(vMXState), null);
                return n;
            }
        }
        throw new AssertionError();
    }

    protected long evaluateLongImpl(VMXState vMXState) {
        switch (this.assignmentType) {
            case 0: {
                long l = this.expr.evaluateLong(vMXState);
                vMXState.lset(this.local, l, null);
                return l;
            }
            case 1: {
                vMXState.lpush(vMXState.lget(this.local, null));
                long l = this.expr.evaluateLong(vMXState);
                vMXState.lset(this.local, l, null);
                return l;
            }
            case 2: {
                long l = vMXState.lget(this.local, null);
                vMXState.lpush(l);
                vMXState.lset(this.local, this.expr.evaluateLong(vMXState), null);
                return l;
            }
        }
        throw new AssertionError();
    }

    protected float evaluateFloatImpl(VMXState vMXState) {
        switch (this.assignmentType) {
            case 0: {
                float f = this.expr.evaluateFloat(vMXState);
                vMXState.fset(this.local, f, null);
                return f;
            }
            case 1: {
                vMXState.fpush(vMXState.fget(this.local, null));
                float f = this.expr.evaluateFloat(vMXState);
                vMXState.fset(this.local, f, null);
                return f;
            }
            case 2: {
                float f = vMXState.fget(this.local, null);
                vMXState.fpush(f);
                vMXState.fset(this.local, this.expr.evaluateFloat(vMXState), null);
                return f;
            }
        }
        throw new AssertionError();
    }

    protected double evaluateDoubleImpl(VMXState vMXState) {
        switch (this.assignmentType) {
            case 0: {
                double d = this.expr.evaluateDouble(vMXState);
                vMXState.dset(this.local, d, null);
                return d;
            }
            case 1: {
                vMXState.dpush(vMXState.dget(this.local, null));
                double d = this.expr.evaluateDouble(vMXState);
                vMXState.dset(this.local, d, null);
                return d;
            }
            case 2: {
                double d = vMXState.dget(this.local, null);
                vMXState.dpush(d);
                vMXState.dset(this.local, this.expr.evaluateDouble(vMXState), null);
                return d;
            }
        }
        throw new AssertionError();
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        switch (this.assignmentType) {
            case 0: {
                Object object = this.expr.evaluateObject(vMXState);
                vMXState.aset(this.local, object, null);
                return object;
            }
            case 1: {
                vMXState.apush(vMXState.aget(this.local, null));
                Object object = this.expr.evaluateObject(vMXState);
                vMXState.aset(this.local, object, null);
                return object;
            }
            case 2: {
                Object object = vMXState.aget(this.local, null);
                vMXState.apush(object);
                vMXState.aset(this.local, this.expr.evaluateObject(vMXState), null);
                return object;
            }
        }
        throw new AssertionError();
    }

    public int getLocalCount() {
        return 1;
    }

    public int getAccessType(int n) {
        return this.assignmentType == 0 ? 32 : 33;
    }

    public Local getLocal(int n) {
        return this.clocal;
    }

    public void setLocal(int n, Local local) {
        this.clocal = local;
    }

    public void complete(MethodScope methodScope) {
        this.local = this.clocal.createVMXLocal();
    }

    public void link(boolean bl) {
        this.checkExpressionCount(1);
        this.expr = this.getExpression(0, this.etype, bl);
    }

    protected String paramString() {
        return super.paramString() + ',' + this.local + ',' + this.clocal;
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        switch (this.assignmentType) {
            case 0: {
                this.writeChildren(bytecodeWriter);
                if (!bl) {
                    bytecodeWriter.visitDup(this.etype);
                }
                bytecodeWriter.visitStore(this.local, this.getType());
                break;
            }
            case 2: {
                if (!bl) {
                    bytecodeWriter.visitLoad(this.local, this.getType());
                    if (this.writeIinc(bytecodeWriter)) break;
                    bytecodeWriter.visitDup(this.etype);
                    this.writeChildren(bytecodeWriter);
                    bytecodeWriter.visitStore(this.local, this.getType());
                    break;
                }
            }
            case 1: {
                if (this.writeIinc(bytecodeWriter)) {
                    if (bl) break;
                    bytecodeWriter.visitLoad(this.local, this.getType());
                    break;
                }
                bytecodeWriter.visitLoad(this.local, this.getType());
                this.writeChildren(bytecodeWriter);
                if (!bl) {
                    bytecodeWriter.visitDup(this.etype);
                }
                bytecodeWriter.visitStore(this.local, this.getType());
            }
        }
    }

    private boolean writeIinc(BytecodeWriter bytecodeWriter) {
        int n;
        Expression expression;
        if (this.etype == 6 && this.assignmentType != 0 && this.local.isJavaLocal() && (expression = this.getFirstExpression()) instanceof Add && (expression = expression.getExpression(1)) instanceof IntConst && Short.MIN_VALUE <= (n = ((IntConst)expression).value) && n <= Short.MAX_VALUE) {
            bytecodeWriter.visitIincInsn(this.local.getIndex(), n);
            return true;
        }
        return false;
    }
}

