/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.expr.BreakTarget;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.VoidExpression;
import de.grogra.xl.vmx.AbruptCompletion;
import de.grogra.xl.vmx.VMXState;

public abstract class ControlTransfer
extends VoidExpression {
    private int nesting = 0;

    public void setNesting(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.nesting = n;
    }

    protected String paramString() {
        return super.paramString() + ",nesting=" + this.nesting;
    }

    protected final void evaluateVoidImpl(VMXState vMXState) {
        AbruptCompletion abruptCompletion = this.evaluate(vMXState);
        if (this.nesting == 0) {
            throw abruptCompletion;
        }
        throw vMXState.newNonlocal(this.nesting, abruptCompletion, null);
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        if (this.nesting == 0) {
            this.writeChildren(bytecodeWriter);
            this.writeLocal(bytecodeWriter, this);
        } else {
            bytecodeWriter.visitVMX();
            bytecodeWriter.visiticonst(this.nesting);
            this.writeAbruptCompletion(bytecodeWriter);
            bytecodeWriter.visitaconst(null);
            bytecodeWriter.visitMethodInsn(VMX_TYPE, "newNonlocal", "(ILde/grogra/xl/vmx/AbruptCompletion;" + BytecodeWriter.AUTH_DESCR + ")Lde/grogra/xl/vmx/AbruptCompletion$Nonlocal;");
            bytecodeWriter.visitInsn(191);
        }
    }

    protected abstract void writeLocal(BytecodeWriter var1, Expression var2);

    protected abstract void writeTransfer(BytecodeWriter var1, BreakTarget var2);

    protected abstract void writeAbruptCompletion(BytecodeWriter var1);

    protected abstract AbruptCompletion evaluate(VMXState var1);
}

