/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp;

import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.swing.Job;
import de.grogra.reflect.MemberBase;
import de.grogra.util.Lock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectInspector
implements TreeModel,
TreeSelectionListener {
    protected final Context ctx;
    protected final GraphManager graph;
    protected TreeNode rootNode;
    protected HashSet<Node.NType> filter = null;
    protected boolean hierarchicFilter = false;
    private boolean activeTreeSelection = false;
    private boolean activeGISelection = false;

    public ObjectInspector(Context context, GraphManager graphManager) {
        this.ctx = context;
        this.graph = graphManager;
        this.initialize();
        this.buildTree();
    }

    public void setFilter(TreePath[] treePathArray, boolean bl) {
        this.hierarchicFilter = bl;
        if (treePathArray == null) {
            this.filter = null;
            return;
        }
        if (this.filter == null) {
            this.filter = new HashSet();
        } else {
            this.filter.clear();
        }
        for (TreePath treePath : treePathArray) {
            Object object = ((TreeNode)treePath.getLastPathComponent()).getObject();
            if (!(object instanceof Node)) continue;
            this.filter.add(((Node)object).getNType());
        }
    }

    public void removeFilter() {
        this.filter = null;
    }

    @Override
    public Object getChild(Object object, int n) {
        return ((TreeNode)object).getChildAt(n);
    }

    @Override
    public int getChildCount(Object object) {
        return ((TreeNode)object).getChildCount();
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return ((TreeNode)object).getIndex((TreeNode)object2);
    }

    @Override
    public Object getRoot() {
        return this.rootNode;
    }

    @Override
    public boolean isLeaf(Object object) {
        return ((TreeNode)object).isLeaf();
    }

    @Override
    public void valueChanged(final TreeSelectionEvent treeSelectionEvent) {
        if (this.activeGISelection) {
            return;
        }
        new Job(this.ctx){

            protected void runImpl(Object object, Context context, Lock lock) {
                Object object2 = treeSelectionEvent.getSource();
                if (object2 instanceof JTree) {
                    JTree jTree = (JTree)object2;
                    TreePath[] treePathArray = jTree.getSelectionPaths();
                    ArrayList<Node> arrayList = new ArrayList<Node>();
                    int n = 0;
                    for (TreePath treePath : treePathArray) {
                        Object object3 = treePath.getLastPathComponent();
                        Object object4 = ((TreeNode)object3).getObject();
                        if (!(object4 instanceof Node)) continue;
                        arrayList.add((Node)object4);
                        ++n;
                    }
                    TreePath[] treePathArray2 = new Node[n];
                    arrayList.toArray(treePathArray2);
                    ObjectInspector.this.activeTreeSelection = true;
                    context.getWorkbench().select((Node[])treePathArray2);
                }
            }
        }.execute();
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public TreeNode getTreeNodeForNode(Node node) {
        return this.findNode(this.rootNode, node);
    }

    private TreeNode findNode(TreeNode treeNode, Node node) {
        if (treeNode.getObject() == node) {
            return treeNode;
        }
        int n = treeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            TreeNode treeNode2 = this.findNode(treeNode.getChildAt(i), node);
            if (treeNode2 == null) continue;
            return treeNode2;
        }
        return null;
    }

    public void getPathToTreeNode(TreeNode treeNode, LinkedList<TreeNode> linkedList) {
        linkedList.addFirst(treeNode);
        while (treeNode != this.rootNode) {
            treeNode = treeNode.getParent();
            linkedList.addFirst(treeNode);
        }
    }

    public abstract void initialize();

    public abstract void buildTree();

    public boolean isActiveTreeSelection() {
        return this.activeTreeSelection;
    }

    public void setActiveTreeSelection(boolean bl) {
        this.activeTreeSelection = bl;
    }

    public boolean isActiveGISelection() {
        return this.activeGISelection;
    }

    public void setActiveGISelection(boolean bl) {
        this.activeGISelection = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TreeNode
    implements javax.swing.tree.TreeNode {
        private Object object;
        private TreeNode parent;
        private ArrayList<TreeNode> children;

        public TreeNode(Object object, TreeNode treeNode) {
            this.object = object;
            this.parent = treeNode;
        }

        public void addChild(TreeNode treeNode) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(treeNode);
        }

        public String toString() {
            if (this.object instanceof Node) {
                Node node = (Node)this.object;
                if (node.getName() == null) {
                    return node.getNType().getSimpleName() + " [" + node.getId() + "]";
                }
                return node.getName() + " [" + node.getId() + "]";
            }
            if (this.object instanceof MemberBase) {
                MemberBase memberBase = (MemberBase)this.object;
                return memberBase.getSimpleName();
            }
            if (this.object != null) {
                return this.object.toString();
            }
            return "";
        }

        public Object getObject() {
            return this.object;
        }

        @Override
        public int getChildCount() {
            if (this.children == null) {
                return 0;
            }
            return this.children.size();
        }

        @Override
        public TreeNode getChildAt(int n) {
            if (this.children == null) {
                return null;
            }
            return this.children.get(n);
        }

        @Override
        public int getIndex(javax.swing.tree.TreeNode treeNode) {
            if (this.children == null) {
                return 0;
            }
            return this.children.indexOf(treeNode);
        }

        public Enumeration<TreeNode> children() {
            if (this.children == null) {
                return null;
            }
            return Collections.enumeration(this.children);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }
    }
}

