/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp;

import de.grogra.graph.AttributeChangeEvent;
import de.grogra.graph.AttributeChangeListener;
import de.grogra.graph.Attributes;
import de.grogra.graph.ChangeBoundaryListener;
import de.grogra.graph.EdgeChangeListener;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.Path;
import de.grogra.imp.GraphDescriptor;
import de.grogra.imp.IMP;
import de.grogra.imp.PickList;
import de.grogra.imp.ProjectGraphDescriptor;
import de.grogra.imp.Renderer;
import de.grogra.imp.ViewComponent;
import de.grogra.imp.ViewEventHandler;
import de.grogra.imp.edit.Tool;
import de.grogra.imp.edit.ViewSelection;
import de.grogra.imp.io.ImageWriter;
import de.grogra.persistence.IndirectField;
import de.grogra.persistence.Manageable;
import de.grogra.persistence.PersistenceField;
import de.grogra.persistence.SCOType;
import de.grogra.persistence.Transaction;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ObjectItem;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.expr.Expression;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.FileChooserResult;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.PanelDecorator;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.UIToolkit;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.edit.ObjectSelection;
import de.grogra.pf.ui.edit.Selectable;
import de.grogra.pf.ui.edit.Selection;
import de.grogra.pf.ui.event.ActionEditEvent;
import de.grogra.pf.ui.event.UIPropertyEditEvent;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.FieldChain;
import de.grogra.util.Configuration;
import de.grogra.util.ConfigurationSet;
import de.grogra.util.Disposable;
import de.grogra.util.DisposableEventListener;
import de.grogra.util.EnumerationType;
import de.grogra.util.EventListener;
import de.grogra.util.I18NBundle;
import de.grogra.util.KeyDescription;
import de.grogra.util.KeyDescriptionImpl;
import de.grogra.util.Map;
import de.grogra.util.ModifiableMap;
import de.grogra.util.StringMap;
import de.grogra.util.ThreadContext;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.util.EventObject;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;

public abstract class View
extends PanelDecorator
implements EventListener,
TreeModelListener,
ModifiableMap.Producer,
Manageable {
    public static int LOD_MIN = 0;
    public static int LOD_MAX = 3;
    public static int SCALE_COUNT = 5;
    public static String SCALES_CHANGED = "scale changed";
    public static String SCALES_VISIBLE = "scale visible";
    public static final I18NBundle I18N = I18NBundle.getInstance(View.class);
    public static final EnumerationType LOD_TYPE = new EnumerationType("lod", IMP.I18N, LOD_MAX + 1);
    public static final UIProperty COMPONENT = UIProperty.getOrCreate((String)"viewComponent", (int)2);
    private static final int VIEW_ID = GraphState.allocatePropertyId();
    private static Renderer currentRenderer = null;
    GraphDescriptor graphDescriptor;
    boolean[] visibleScales;
    boolean[] visibleLayers;
    float epsilon;
    float epsilonSquared;
    float visualEpsilon;
    float visualEpsilonSquared;
    float magnitude;
    float magnitudeSquared;
    private final Object componentLock = new Object();
    private Graph graph;
    private GraphState state;
    private boolean disposed;
    private transient int stamp = 0;
    private ViewComponent component;
    private ViewEventHandler eventHandler;
    private Tool activeTool;
    private DisposableEventListener toolListener;
    protected final EventListener.Multicaster listeners = new EventListener.Multicaster();
    public static final Type $TYPE = new Type(View.class);
    public static final SCOType.Field graphDescriptor$FIELD = Type._addManagedField($TYPE, "graphDescriptor", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(GraphDescriptor.class), null, 0);
    public static final SCOType.Field visibleLayers$FIELD = Type._addManagedField($TYPE, "visibleLayers", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(boolean[].class), null, 1);
    public static final SCOType.Field epsilon$FIELD = Type._addManagedField($TYPE, "epsilon", 0x200000, de.grogra.reflect.Type.FLOAT, null, 2);
    public static final SCOType.Field visualEpsilon$FIELD = Type._addManagedField($TYPE, "visualEpsilon", 0x200000, de.grogra.reflect.Type.FLOAT, null, 3);
    public static final SCOType.Field magnitude$FIELD = Type._addManagedField($TYPE, "magnitude", 0x200000, de.grogra.reflect.Type.FLOAT, null, 4);
    public static final SCOType.Field visibleScales$FIELD = Type._addManagedField($TYPE, "visibleScales", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(boolean[].class), null, 5);

    public static View get(Context context) {
        Panel panel;
        for (panel = context.getPanel().resolve(); panel != null && !(panel instanceof View); panel = panel.getDecorator()) {
        }
        return (View)panel;
    }

    public static View get(GraphState graphState) {
        return (View)graphState.getUserProperty(VIEW_ID);
    }

    public static void set(GraphState graphState, View view) {
        graphState.setUserProperty(VIEW_ID, (Object)view);
    }

    public static ViewComponent getViewComponent(Context context) {
        return View.get(context).getViewComponent();
    }

    public static View create(View view, Context context, StringMap stringMap) {
        View view2 = (View)stringMap.get("view");
        if (view2 != null) {
            view = view2;
        }
        view.initialize(UIToolkit.get((Context)context).createPanel(context, (Disposable)view, (Map)stringMap), (Map)stringMap);
        if (view2 == null) {
            Expression expression;
            String string;
            GraphDescriptor graphDescriptor = (GraphDescriptor)stringMap.get((Object)"graph", null);
            if (graphDescriptor == null && (string = (String)stringMap.get((Object)"defaultGraph", null)) != null && (expression = (Expression)Item.resolveItem((RegistryContext)context.getWorkbench(), (String)string)) != null) {
                graphDescriptor = (GraphDescriptor)expression.evaluate((RegistryContext)context.getWorkbench(), stringMap);
            }
            if (graphDescriptor == null) {
                graphDescriptor = new ProjectGraphDescriptor();
            }
            view.setGraph(graphDescriptor);
        } else {
            view.setGraph();
        }
        return view;
    }

    public static Selectable getSelectableGraph(Context context) {
        final View view = View.get(context);
        return new Selectable(){

            public Selection toSelection(Context context) {
                return new ObjectSelection(context, view, new PersistenceField[]{graphDescriptor$FIELD}, null, null, null, null){

                    protected void valueChanged(PersistenceField persistenceField, Object object) {
                        if (persistenceField.overlaps(null, (FieldChain)graphDescriptor$FIELD, null)) {
                            view.setGraph();
                        }
                    }
                };
            }
        };
    }

    public static Selectable getSelectableLayers(Context context) {
        final View view = View.get(context);
        return new Selectable(){

            public Selection toSelection(Context context) {
                IndirectField indirectField = visibleLayers$FIELD.getArrayChain(1);
                PersistenceField[] persistenceFieldArray = new PersistenceField[16];
                int[][] nArrayArray = new int[16][];
                String[] stringArray = new String[16];
                for (int i = 0; i < 16; ++i) {
                    persistenceFieldArray[i] = indirectField;
                    nArrayArray[i] = new int[]{i};
                    stringArray[i] = IMP.I18N.msg("view.display-layer", (Object)i);
                }
                return new ObjectSelection(context, view, persistenceFieldArray, nArrayArray, null, stringArray, null){

                    protected void valueChanged(PersistenceField persistenceField, Object object) {
                        ViewComponent viewComponent;
                        if (persistenceField.overlaps(null, (FieldChain)visibleLayers$FIELD, null) && (viewComponent = view.getViewComponent()) != null) {
                            viewComponent.repaint(7);
                        }
                    }
                };
            }
        };
    }

    public static Selectable getSelectableScales(Context context) {
        final View view = View.get(context);
        final Workbench workbench = context.getWorkbench();
        return new Selectable(){

            public Selection toSelection(Context context) {
                IndirectField indirectField = visibleScales$FIELD.getArrayChain(1);
                PersistenceField[] persistenceFieldArray = new PersistenceField[SCALE_COUNT];
                int[][] nArrayArray = new int[SCALE_COUNT][];
                String[] stringArray = new String[SCALE_COUNT];
                for (int i = 0; i < SCALE_COUNT; ++i) {
                    persistenceFieldArray[i] = indirectField;
                    nArrayArray[i] = new int[]{i};
                    stringArray[i] = IMP.I18N.msg("view.display-scale", (Object)i);
                }
                return new ObjectSelection(context, view, persistenceFieldArray, nArrayArray, null, stringArray, null){

                    protected void valueChanged(PersistenceField persistenceField, Object object) {
                        if (persistenceField.overlaps(null, (FieldChain)visibleScales$FIELD, null)) {
                            boolean[] blArray = view.getVisibleScales();
                            workbench.setProperty(SCALES_VISIBLE, (Object)blArray);
                            workbench.setProperty(SCALES_CHANGED, (Object)new Boolean(true));
                            ViewComponent viewComponent = view.getViewComponent();
                            if (viewComponent != null) {
                                viewComponent.repaint(7);
                            }
                        }
                    }
                };
            }
        };
    }

    protected abstract UIProperty getToolProperty();

    public abstract IOFlavor getFlavor();

    public View() {
        int n;
        this.setDimensions(1.0f);
        this.visibleLayers = new boolean[16];
        for (n = 0; n < 16; ++n) {
            this.visibleLayers[n] = true;
        }
        this.visibleScales = new boolean[SCALE_COUNT];
        for (n = 0; n < SCALE_COUNT; ++n) {
            this.visibleScales[n] = false;
        }
        Workbench.current().setProperty(SCALES_VISIBLE, (Object)this.visibleScales);
        Workbench.current().setProperty(SCALES_CHANGED, (Object)new Boolean(false));
    }

    public void setGraph() {
        this.setGraph(this.graphDescriptor.getGraph(this));
    }

    public void setGraph(GraphDescriptor graphDescriptor) {
        this.graphDescriptor = graphDescriptor;
        this.setGraph(graphDescriptor.getGraph(this));
    }

    private void setGraph(Graph graph) {
        if (this.graph != null) {
            this.uninstall();
        }
        if (graph != null) {
            this.graph = graph;
            ViewSelection.create(this);
            ViewSelection.PROPERTY.addPropertyListener((Context)this, (EventListener)this);
            UIProperty.WORKBENCH_SELECTION.addPropertyListener((Context)this, (EventListener)this);
            this.getWorkbench().getRegistry().addTreeModelListener((TreeModelListener)this);
            this.toolListener = Tool.createToolListener(this, this.getToolProperty());
            this.installImpl();
        }
    }

    protected void uninstall() {
        if (this.activeTool != null) {
            this.activeTool.dispose();
            this.activeTool = null;
        }
        this.getWorkbench().getRegistry().removeTreeModelListener((TreeModelListener)this);
        ViewSelection.PROPERTY.removePropertyListener((Context)this, (EventListener)this);
        UIProperty.WORKBENCH_SELECTION.removePropertyListener((Context)this, (EventListener)this);
        this.toolListener.dispose();
        this.uninstallImpl();
        this.graph = null;
        this.state = null;
    }

    public Graph getGraph() {
        return this.graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GraphState getWorkbenchGraphState() {
        View view = this;
        synchronized (view) {
            if (this.state != null) {
                return this.state;
            }
        }
        view = GraphState.get((Graph)this.graph, (ThreadContext)this.getWorkbench().getJobManager().getThreadContext());
        View view2 = this;
        synchronized (view2) {
            this.state = view;
        }
        return view;
    }

    public void substituteSelection(GraphState[] graphStateArray, Object[] objectArray, boolean[] blArray, int n) {
        this.graphDescriptor.substituteSelection(graphStateArray, objectArray, blArray, n);
    }

    public Path getPathFor(GraphState graphState, Object object, boolean bl) {
        return this.graphDescriptor.getPathFor(this, graphState, object, bl);
    }

    public ViewEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void addMappings(ModifiableMap modifiableMap) {
        modifiableMap.put((Object)"view", (Object)this);
    }

    protected void initialize(Panel panel, Map map) {
        this.initPanel(panel);
    }

    protected abstract void installImpl();

    public abstract void pick(int var1, int var2, PickList var3);

    public abstract boolean isToolGraph(Graph var1);

    public void addEventListener(EventListener eventListener) {
        this.listeners.addEventListener(eventListener);
    }

    public void removeEventListener(EventListener eventListener) {
        this.listeners.removeEventListener(eventListener);
    }

    public final void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.setGraph((Graph)null);
        if (this.eventHandler != null) {
            this.eventHandler.dispose();
            this.eventHandler = null;
        }
        this.listeners.removeAllListeners();
    }

    protected abstract void uninstallImpl();

    protected abstract ViewEventHandler createEventHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewComponent(ViewComponent viewComponent) {
        Object object = this.componentLock;
        synchronized (object) {
            if (this.eventHandler == null) {
                this.eventHandler = this.createEventHandler();
            }
            viewComponent.initView(this, this.eventHandler);
            this.setContent(viewComponent);
            this.component = viewComponent;
        }
        COMPONENT.setValue((Context)this, (Object)viewComponent);
    }

    public ViewComponent getViewComponent() {
        return this.component;
    }

    public final void setActiveTool(Tool tool) {
        if (this.activeTool == tool) {
            return;
        }
        if (this.activeTool != null) {
            this.activeTool.dispose();
            this.activeTool = null;
        }
        this.activeTool = tool;
        if (tool != null) {
            tool.initialize(this);
        }
        this.repaint(12);
    }

    public final Tool getActiveTool() {
        return this.activeTool;
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        Object[] objectArray = treeModelEvent.getChildren();
        if (objectArray != null) {
            for (int i = objectArray.length - 1; i >= 0; --i) {
                if (!(objectArray[i] instanceof ObjectItem)) continue;
                this.repaint(9);
            }
        }
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }

    public void eventOccured(EventObject eventObject) {
        if (eventObject instanceof UIPropertyEditEvent) {
            UIProperty uIProperty = ((UIPropertyEditEvent)eventObject).getProperty();
            if (uIProperty == ViewSelection.PROPERTY) {
                this.repaint(10);
            } else if (uIProperty == UIProperty.WORKBENCH_SELECTION) {
                Object object = UIProperty.WORKBENCH_SELECTION.getValue((Context)this);
                if (!(object instanceof Selection)) {
                    object = null;
                }
                ViewSelection.get((Context)this).set((Selection)object, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void repaint(int n) {
        Object object = this.componentLock;
        synchronized (object) {
            if (this.component != null) {
                this.component.repaint(n);
            }
        }
    }

    public static void render(Item item, Object object, Context context) {
        if (context.getPanel() instanceof View && object instanceof ActionEditEvent && (object = ((ActionEditEvent)object).getSource()) instanceof Expression && (object = ((Expression)object).evaluate((RegistryContext)context.getWorkbench(), UI.getArgs((Context)context, null))) instanceof Renderer) {
            View view = (View)context.getPanel();
            ViewSelection viewSelection = ViewSelection.get((Context)view);
            if (viewSelection != null) {
                viewSelection.set(4, Path.PATH_0, false);
            }
            view.component.render((Renderer)object);
        }
    }

    public static void renderToFile(Item item, Object object, Context context) {
        if (context.getPanel() instanceof View && object instanceof ActionEditEvent && (object = ((ActionEditEvent)object).getSource()) instanceof Expression && (object = ((Expression)object).evaluate((RegistryContext)context.getWorkbench(), UI.getArgs((Context)context, null))) instanceof Renderer) {
            final View view = (View)context.getPanel();
            ViewSelection viewSelection = ViewSelection.get((Context)view);
            if (viewSelection != null) {
                viewSelection.set(4, Path.PATH_0, false);
            }
            ConfigurationSet configurationSet = new ConfigurationSet("Render dimensions");
            KeyDescriptionImpl keyDescriptionImpl = new KeyDescriptionImpl("width", I18N, "rendertofile.width", Type.INT, null);
            KeyDescriptionImpl keyDescriptionImpl2 = new KeyDescriptionImpl("height", I18N, "rendertofile.height", Type.INT, null);
            Configuration configuration = new Configuration(new KeyDescription[]{keyDescriptionImpl, keyDescriptionImpl2}, (Map)new StringMap().putInt("width", 600).putInt("height", 600));
            configurationSet.add(configuration);
            if (!Workbench.current().showConfigurationDialog(configurationSet)) {
                return;
            }
            int n = (Integer)configurationSet.get((Object)"width", null);
            int n2 = (Integer)configurationSet.get((Object)"height", null);
            final FileChooserResult fileChooserResult = Workbench.current().chooseFileToSave(I18N.msg("rendertofile.title"), ImageWriter.RENDERED_IMAGE_FLAVOR, null);
            if (fileChooserResult == null) {
                return;
            }
            Renderer renderer = (Renderer)object;
            renderer.addImageObserver(new ImageObserver(){

                public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                    if ((n & 0x20) == 0) {
                        return true;
                    }
                    IMP.writeImage((Context)view, (RenderedImage)((Object)image), fileChooserResult.getMimeType(), fileChooserResult.file);
                    return false;
                }
            });
            view.component.render(renderer, n, n2);
        }
    }

    public static void disposeRenderer(Item item, Object object, Context context) {
        if (context.getPanel() instanceof View) {
            View view = (View)context.getPanel();
            view.getViewComponent().disposeRenderer(null);
            view.repaint(15);
        }
    }

    public final void setDimensions(float f) {
        this.setDimensions(f, f * 1.0E-6f, f * 0.01f);
    }

    public final void setDimensions(float f, float f2, float f3) {
        this.setEpsilon(f2);
        this.setVisualEpsilon(f3);
        this.setMagnitude(f);
    }

    public void setEpsilon(float f) {
        this.epsilon = f;
        this.epsilonSquared = f * f;
    }

    public void setVisualEpsilon(float f) {
        this.visualEpsilon = f;
        this.visualEpsilonSquared = f * f;
    }

    public void setMagnitude(float f) {
        this.magnitude = f;
        this.magnitudeSquared = f * f;
    }

    public float getEpsilonSquared() {
        return this.epsilonSquared;
    }

    public float getVisualEpsilonSquared() {
        return this.visualEpsilonSquared;
    }

    public float getMagnitudeSquared() {
        return this.magnitudeSquared;
    }

    public void fieldModified(PersistenceField persistenceField, int[] nArray, Transaction transaction) {
        ++this.stamp;
    }

    public int getStamp() {
        return this.stamp;
    }

    public Manageable manageableReadResolve() {
        return this;
    }

    public Object manageableWriteReplace() {
        return this;
    }

    public boolean isInVisibleLayer(Object object, boolean bl, GraphState graphState) {
        int n = graphState.getIntDefault(object, bl, Attributes.LAYER, 0);
        return n < 0 || n >= this.visibleLayers.length || this.visibleLayers[n];
    }

    public Dimension getSize() {
        UIToolkit uIToolkit = UIToolkit.get((Context)this);
        return new Dimension(uIToolkit.getWidth(this.getViewComponent().getComponent()), uIToolkit.getHeight(this.getViewComponent().getComponent()));
    }

    public boolean[] getVisibleScales() {
        return this.visibleScales;
    }

    public float getEpsilon() {
        return this.epsilon;
    }

    public float getVisualEpsilon() {
        return this.visualEpsilon;
    }

    public float getMagnitude() {
        return this.magnitude;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 6;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(View view, SCOType sCOType) {
            super((Object)view, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 2: {
                    ((View)object).setEpsilon(f);
                    return;
                }
                case 3: {
                    ((View)object).setVisualEpsilon(f);
                    return;
                }
                case 4: {
                    ((View)object).setMagnitude(f);
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((View)object).getEpsilon();
                }
                case 3: {
                    return ((View)object).getVisualEpsilon();
                }
                case 4: {
                    return ((View)object).getMagnitude();
                }
            }
            return super.getFloat(object, n);
        }

        protected void setObject(Object object, int n, Object object2) {
            switch (n) {
                case 0: {
                    ((View)object).graphDescriptor = (GraphDescriptor)object2;
                    return;
                }
                case 1: {
                    ((View)object).visibleLayers = (boolean[])object2;
                    return;
                }
                case 5: {
                    ((View)object).visibleScales = (boolean[])object2;
                    return;
                }
            }
            super.setObject(object, n, object2);
        }

        protected Object getObject(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((View)object).graphDescriptor;
                }
                case 1: {
                    return ((View)object).visibleLayers;
                }
                case 5: {
                    return ((View)object).visibleScales;
                }
            }
            return super.getObject(object, n);
        }
    }

    protected class SceneListener
    implements AttributeChangeListener,
    EdgeChangeListener,
    ChangeBoundaryListener {
        protected boolean hasChanged = false;

        public void install(Graph graph) {
            graph.addAttributeChangeListener((AttributeChangeListener)this);
            graph.addEdgeChangeListener((EdgeChangeListener)this);
            graph.addChangeBoundaryListener((ChangeBoundaryListener)this);
        }

        public void remove(Graph graph) {
            graph.removeAttributeChangeListener((AttributeChangeListener)this);
            graph.removeEdgeChangeListener((EdgeChangeListener)this);
            graph.removeChangeBoundaryListener((ChangeBoundaryListener)this);
        }

        public void attributeChanged(AttributeChangeEvent attributeChangeEvent) {
            this.hasChanged = true;
            View.this.repaint(9);
        }

        public void edgeChanged(Object object, Object object2, Object object3, GraphState graphState) {
            this.hasChanged = true;
            View.this.repaint(9);
        }

        public void beginChange(GraphState graphState) {
            ViewSelection viewSelection = ViewSelection.get((Context)View.this);
            if (viewSelection != null) {
                viewSelection.graphModified(graphState);
            }
            this.hasChanged = false;
        }

        public void endChange(GraphState graphState) {
        }

        public int getPriority() {
            return 10;
        }
    }
}

