/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp.edit;

import de.grogra.graph.Attribute;
import de.grogra.graph.AttributeAccessor;
import de.grogra.graph.AttributeChangeEvent;
import de.grogra.graph.AttributeChangeListener;
import de.grogra.graph.BooleanAttribute;
import de.grogra.graph.ByteAttribute;
import de.grogra.graph.ChangeBoundaryListener;
import de.grogra.graph.CharAttribute;
import de.grogra.graph.DoubleAttribute;
import de.grogra.graph.FloatAttribute;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.GraphUtils;
import de.grogra.graph.IntAttribute;
import de.grogra.graph.LongAttribute;
import de.grogra.graph.ObjectAttribute;
import de.grogra.graph.Path;
import de.grogra.graph.ShortAttribute;
import de.grogra.imp.View;
import de.grogra.imp.edit.ToolRoot;
import de.grogra.imp.edit.ViewSelection;
import de.grogra.imp.registry.ToolFactory;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.UIProperty;
import de.grogra.reflect.FieldChain;
import de.grogra.util.Disposable;
import de.grogra.util.DisposableEventListener;
import de.grogra.util.EventListener;
import java.util.EventObject;

public final class Tool
implements Disposable,
AttributeChangeListener,
ChangeBoundaryListener {
    private final ToolRoot[] roots;
    private final Object object;
    private final boolean asNode;
    private GraphState state;
    private View view;
    private int toolCount;

    public Tool(Object object, boolean bl, ToolRoot[] toolRootArray) {
        this.object = object;
        this.asNode = bl;
        this.roots = toolRootArray;
    }

    public void initialize(View view) {
        this.view = view;
        this.state = view.getWorkbenchGraphState();
        this.toolCount = this.roots.length;
        for (int i = this.toolCount - 1; i >= 0; --i) {
            if (this.roots[i] != null) {
                if (this.roots[i].initialize(this)) continue;
                this.roots[i].dispose();
            }
            if (i >= --this.toolCount) continue;
            System.arraycopy(this.roots, i + 1, this.roots, i, this.toolCount - i);
        }
        this.state.getGraph().addAttributeChangeListener(this.object, this.asNode, (AttributeChangeListener)this);
        this.state.getGraph().addChangeBoundaryListener((ChangeBoundaryListener)this);
    }

    public View getView() {
        return this.view;
    }

    public Object getObject() {
        return this.object;
    }

    public boolean isNode() {
        return this.asNode;
    }

    public GraphState getGraphState() {
        return this.state;
    }

    public int getToolCount() {
        return this.toolCount;
    }

    public ToolRoot getRoot(int n) {
        return this.roots[n];
    }

    public void dispose() {
        this.state.getGraph().removeAttributeChangeListener(this.object, this.asNode, (AttributeChangeListener)this);
        this.state.getGraph().removeChangeBoundaryListener((ChangeBoundaryListener)this);
        for (int i = this.toolCount - 1; i >= 0; --i) {
            this.roots[i].dispose();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Tool[object=");
        stringBuffer.append(this.object).append(",roots={");
        for (int i = 0; i < this.toolCount; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append((Object)this.roots[i]);
        }
        return stringBuffer.append("}]").toString();
    }

    public void beginChange(GraphState graphState) {
    }

    public void endChange(GraphState graphState) {
        if (!graphState.containsInTree(this.object, this.asNode)) {
            this.view.setActiveTool(null);
        }
    }

    public int getPriority() {
        return 0;
    }

    public void attributeChanged(AttributeChangeEvent attributeChangeEvent) {
        for (int i = 0; i < this.toolCount; ++i) {
            this.roots[i].attributeChanged(attributeChangeEvent.getDependentAttributes());
        }
    }

    public static DisposableEventListener createToolListener(final View view, final UIProperty uIProperty) {
        Object object;
        if (uIProperty.getValue((Context)view) == null && (object = Item.resolveItem((RegistryContext)view.getWorkbench(), (String)uIProperty.getName())) != null) {
            uIProperty.setValue((Context)view, (Object)object.getBranch());
        }
        object = new DisposableEventListener(){
            private Object object;
            private boolean asNode;
            private ToolFactory factory;

            public void eventOccured(EventObject eventObject) {
                boolean bl;
                Path path = GraphUtils.cutToGraph((Path)ViewSelection.get((Context)view).getFirstPath(4), (Graph)view.getGraph());
                Object object = path != null ? path.getObject(-1) : null;
                boolean bl2 = bl = path != null && (path.getNodeAndEdgeCount() & 1) != 0;
                if (!view.getWorkbenchGraphState().containsInTree(object, bl)) {
                    object = null;
                }
                Object object2 = uIProperty.getValue((Context)view);
                if (object != this.object || bl != this.asNode || object2 != this.factory) {
                    this.object = object;
                    this.asNode = bl;
                    ToolFactory toolFactory = this.factory = object2 instanceof ToolFactory ? (ToolFactory)((Object)object2) : null;
                    if (object != null && this.factory != null) {
                        view.setActiveTool(this.factory.createTool(object, bl));
                    } else {
                        view.setActiveTool(null);
                    }
                }
            }

            public void dispose() {
                ViewSelection.PROPERTY.removePropertyListener((Context)view, (EventListener)this);
                uIProperty.removePropertyListener((Context)view, (EventListener)this);
            }
        };
        ViewSelection.PROPERTY.addPropertyListener((Context)view, (EventListener)object);
        uIProperty.addPropertyListener((Context)view, (EventListener)object);
        return object;
    }

    public AttributeAccessor getAccessorOfObject(Attribute attribute) {
        return this.state.getGraph().getAccessor(this.object, this.asNode, attribute);
    }

    public boolean isWritable(Attribute attribute) {
        AttributeAccessor attributeAccessor = this.getAccessorOfObject(attribute);
        return attributeAccessor != null && attributeAccessor.isWritable(this.object, this.state);
    }

    public void setBooleanOfObject(BooleanAttribute booleanAttribute, boolean bl) {
        booleanAttribute.setBoolean(this.object, this.asNode, bl, this.state);
    }

    public boolean getBooleanOfObject(BooleanAttribute booleanAttribute, boolean bl) {
        return this.state.getBooleanDefault(this.object, this.asNode, booleanAttribute, bl);
    }

    public void setByteOfObject(ByteAttribute byteAttribute, byte by) {
        byteAttribute.setByte(this.object, this.asNode, by, this.state);
    }

    public byte getByteOfObject(ByteAttribute byteAttribute, byte by) {
        return this.state.getByteDefault(this.object, this.asNode, byteAttribute, by);
    }

    public void setShortOfObject(ShortAttribute shortAttribute, short s) {
        shortAttribute.setShort(this.object, this.asNode, s, this.state);
    }

    public short getShortOfObject(ShortAttribute shortAttribute, short s) {
        return this.state.getShortDefault(this.object, this.asNode, shortAttribute, s);
    }

    public void setCharOfObject(CharAttribute charAttribute, char c) {
        charAttribute.setChar(this.object, this.asNode, c, this.state);
    }

    public char getCharOfObject(CharAttribute charAttribute, char c) {
        return this.state.getCharDefault(this.object, this.asNode, charAttribute, c);
    }

    public void setIntOfObject(IntAttribute intAttribute, int n) {
        intAttribute.setInt(this.object, this.asNode, n, this.state);
    }

    public int getIntOfObject(IntAttribute intAttribute, int n) {
        return this.state.getIntDefault(this.object, this.asNode, intAttribute, n);
    }

    public void setLongOfObject(LongAttribute longAttribute, long l) {
        longAttribute.setLong(this.object, this.asNode, l, this.state);
    }

    public long getLongOfObject(LongAttribute longAttribute, long l) {
        return this.state.getLongDefault(this.object, this.asNode, longAttribute, l);
    }

    public void setFloatOfObject(FloatAttribute floatAttribute, float f) {
        floatAttribute.setFloat(this.object, this.asNode, f, this.state);
    }

    public float getFloatOfObject(FloatAttribute floatAttribute, float f) {
        return this.state.getFloatDefault(this.object, this.asNode, floatAttribute, f);
    }

    public void setDoubleOfObject(DoubleAttribute doubleAttribute, double d) {
        doubleAttribute.setDouble(this.object, this.asNode, d, this.state);
    }

    public double getDoubleOfObject(DoubleAttribute doubleAttribute, double d) {
        return this.state.getDoubleDefault(this.object, this.asNode, doubleAttribute, d);
    }

    public void setObjectOfObject(ObjectAttribute objectAttribute, Object object) {
        objectAttribute.setObject(this.object, this.asNode, object, this.state);
    }

    public Object getObjectOfObject(ObjectAttribute objectAttribute, Object object) {
        return this.state.getObjectDefault(this.object, this.asNode, objectAttribute, object);
    }

    public void setSubfield(ObjectAttribute objectAttribute, FieldChain fieldChain, int[] nArray, Object object) {
        objectAttribute.setSubfield(this.object, this.asNode, fieldChain, nArray, object, this.state);
    }
}

