/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.blocks;

import de.grogra.imp.View;
import de.grogra.imp3d.View3D;
import de.grogra.math.Id;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.persistence.ShareableBase;
import de.grogra.reflect.ClassAdapter;
import de.grogra.xl.lang.FloatToFloat;
import javax.vecmath.Vector3d;

public class HydraLOD
extends ShareableBase {
    boolean useLOD = true;
    int number = 2 * View.LOD_MAX;
    FloatToFloat numberMode = new Id();
    int minNumber = 0;
    int scale = View.LOD_MIN;
    FloatToFloat scaleMode = new Id();
    private final float MAX_PIXEL = 20.0f;
    private float localLod_P = 1.0f;
    private float globalLod_P = 1.0f;
    public static final Type $TYPE = new Type(HydraLOD.class);
    public static final SCOType.Field useLOD$FIELD = Type._addManagedField($TYPE, "useLOD", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 0);
    public static final SCOType.Field number$FIELD = Type._addManagedField($TYPE, "number", 0x200000, de.grogra.reflect.Type.INT, null, 1);
    public static final SCOType.Field numberMode$FIELD = Type._addManagedField($TYPE, "numberMode", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(FloatToFloat.class), null, 2);
    public static final SCOType.Field minNumber$FIELD = Type._addManagedField($TYPE, "minNumber", 0x200000, de.grogra.reflect.Type.INT, null, 3);
    public static final SCOType.Field scale$FIELD = Type._addManagedField($TYPE, "scale", 0x200000, de.grogra.reflect.Type.INT, null, 4);
    public static final SCOType.Field scaleMode$FIELD = Type._addManagedField($TYPE, "scaleMode", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(FloatToFloat.class), null, 5);

    public void set(View view, Vector3d vector3d, float f) {
        View3D view3D = view instanceof View3D ? (View3D)view : null;
        int n = view3D != null ? view3D.getViewComponent().getGlobalLOD() : View.LOD_MAX;
        float f2 = f * (view3D != null ? view3D.getCanvasCamera().getScaleAt(vector3d.x, vector3d.y, vector3d.z) : 20.0f);
        this.globalLod_P = (float)(n + 1) / (float)(View.LOD_MAX + 1);
        this.localLod_P = f2 / 20.0f < 1.0f ? f2 / 20.0f : 1.0f;
    }

    private float toAktLod(float f) {
        return this.numberMode.evaluateFloat(this.localLod_P) * this.globalLod_P * f;
    }

    protected int numberToLod(float f) {
        if (this.useLOD) {
            int n = Math.round(this.toAktLod((float)(this.number + 1) / (float)(2 * View.LOD_MAX + 1) * f));
            if (n < this.minNumber) {
                return this.minNumber;
            }
            return n;
        }
        return Math.round(f);
    }

    protected float scaleToLod(float f) {
        if (this.useLOD) {
            return f + (1.0f - this.scaleMode.evaluateFloat(this.localLod_P) * this.globalLod_P) * ((float)(this.scale + 1) / (float)(2 * View.LOD_MAX + 1));
        }
        return f;
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public boolean isUseLOD() {
        return this.useLOD;
    }

    public void setUseLOD(boolean bl) {
        this.useLOD = bl;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int n) {
        this.number = n;
    }

    public int getMinNumber() {
        return this.minNumber;
    }

    public void setMinNumber(int n) {
        this.minNumber = n;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public FloatToFloat getNumberMode() {
        return this.numberMode;
    }

    public void setNumberMode(FloatToFloat floatToFloat) {
        numberMode$FIELD.setObject((Object)this, (Object)floatToFloat);
    }

    public FloatToFloat getScaleMode() {
        return this.scaleMode;
    }

    public void setScaleMode(FloatToFloat floatToFloat) {
        scaleMode$FIELD.setObject((Object)this, (Object)floatToFloat);
    }

    static {
        number$FIELD.setMinValue((Number)new Integer(View.LOD_MIN));
        number$FIELD.setMaxValue((Number)new Integer(2 * View.LOD_MAX));
        minNumber$FIELD.setMinValue((Number)new Integer(0));
        minNumber$FIELD.setMaxValue((Number)new Integer(50));
        scale$FIELD.setMinValue((Number)new Integer(View.LOD_MIN));
        scale$FIELD.setMaxValue((Number)new Integer(2 * View.LOD_MAX));
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 6;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(HydraLOD hydraLOD, SCOType sCOType) {
            super((Object)hydraLOD, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 0: {
                    ((HydraLOD)((Object)object)).useLOD = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((HydraLOD)((Object)object)).isUseLOD();
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 1: {
                    ((HydraLOD)((Object)object)).number = n2;
                    return;
                }
                case 3: {
                    ((HydraLOD)((Object)object)).minNumber = n2;
                    return;
                }
                case 4: {
                    ((HydraLOD)((Object)object)).scale = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 1: {
                    return ((HydraLOD)((Object)object)).getNumber();
                }
                case 3: {
                    return ((HydraLOD)((Object)object)).getMinNumber();
                }
                case 4: {
                    return ((HydraLOD)((Object)object)).getScale();
                }
            }
            return super.getInt(object, n);
        }

        protected void setObject(Object object, int n, Object object2) {
            switch (n) {
                case 2: {
                    ((HydraLOD)((Object)object)).numberMode = (FloatToFloat)object2;
                    return;
                }
                case 5: {
                    ((HydraLOD)((Object)object)).scaleMode = (FloatToFloat)object2;
                    return;
                }
            }
            super.setObject(object, n, object2);
        }

        protected Object getObject(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((HydraLOD)((Object)object)).getNumberMode();
                }
                case 5: {
                    return ((HydraLOD)((Object)object)).getScaleMode();
                }
            }
            return super.getObject(object, n);
        }

        public Object newInstance() {
            return new HydraLOD();
        }
    }
}

