/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.blocks.arrangeBlock;

import de.grogra.blocks.arrangeBlock.ArrangeBase;
import raskob.geometry.Point;
import raskob.geometry.PointArrayList;

public class HilbertDither
extends ArrangeBase {
    private PointArrayList hilbertPointList = new PointArrayList();
    private Point oldP = new Point(0.0, 0.0);
    private int lengthField = 128;
    private double error = 0.0;

    public HilbertDither(float f, float f2, float f3, float f4, float[][] fArray) {
        int n;
        int n2 = fArray.length;
        f3 *= f4;
        this.makeHilbert();
        double d = 0.0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.hilbertPointList.size(); ++n) {
            Point point = this.hilbertPointList.get(n);
            n3 = (int)point.getX();
            n4 = (int)point.getY();
            float[] fArray2 = fArray[n3];
            int n5 = n4;
            fArray2[n5] = (float)((double)fArray2[n5] + this.error);
            d = fArray[n3][n4];
            fArray[n3][n4] = fArray[n3][n4] < f3 ? 0.0f : f4;
            this.error = Math.abs(d - (double)fArray[n3][n4]);
        }
        this.pointList = new PointArrayList();
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                if (fArray[i][n] != f4) continue;
                this.pointList.add(new Point((double)((float)n * (f - 1.0f) / (float)n2), (double)((float)i * (f2 - 1.0f) / (float)n2)));
            }
        }
        this.pointListToArrays();
    }

    private void makeHilbert() {
        int n;
        for (int i = n = 7; i > 0; --i) {
            this.lengthField /= 2;
        }
        this.addPoint(this.lengthField / 2, this.lengthField / 2);
        this.hilbertA(n);
    }

    private void addPoint(float f, float f2) {
        Point point;
        this.oldP = point = new Point((double)((int)(this.oldP.getX() + (double)f)), (double)((int)(this.oldP.getY() + (double)f2)));
        this.hilbertPointList.add(point);
    }

    private void hilbertA(int n) {
        if (n > 0) {
            this.hilbertB(n - 1);
            this.addPoint(0.0f, this.lengthField);
            this.hilbertA(n - 1);
            this.addPoint(this.lengthField, 0.0f);
            this.hilbertA(n - 1);
            this.addPoint(0.0f, -this.lengthField);
            this.hilbertC(n - 1);
        }
    }

    private void hilbertB(int n) {
        if (n > 0) {
            this.hilbertA(n - 1);
            this.addPoint(this.lengthField, 0.0f);
            this.hilbertB(n - 1);
            this.addPoint(0.0f, this.lengthField);
            this.hilbertB(n - 1);
            this.addPoint(-this.lengthField, 0.0f);
            this.hilbertD(n - 1);
        }
    }

    private void hilbertC(int n) {
        if (n > 0) {
            this.hilbertD(n - 1);
            this.addPoint(-this.lengthField, 0.0f);
            this.hilbertC(n - 1);
            this.addPoint(0.0f, -this.lengthField);
            this.hilbertC(n - 1);
            this.addPoint(this.lengthField, 0.0f);
            this.hilbertA(n - 1);
        }
    }

    private void hilbertD(int n) {
        if (n > 0) {
            this.hilbertC(n - 1);
            this.addPoint(0.0f, -this.lengthField);
            this.hilbertD(n - 1);
            this.addPoint(-this.lengthField, 0.0f);
            this.hilbertD(n - 1);
            this.addPoint(0.0f, this.lengthField);
            this.hilbertB(n - 1);
        }
    }
}

