/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.blocks.arrangeBlock;

import de.grogra.blocks.arrangeBlock.ArrangeMethod;
import de.grogra.blocks.arrangeBlock.NormalProbability;
import de.grogra.blocks.arrangeBlock.ShareableArrangeBase;
import de.grogra.blocks.arrangeBlock.ShareableProbabilityArrangeBase;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.reflect.ClassAdapter;
import de.grogra.rgg.Library;
import raskob.geometry.Point;
import raskob.geometry.PointArrayList;

public class ProbabilityArrange
extends ShareableArrangeBase
implements ArrangeMethod {
    ShareableProbabilityArrangeBase method = new NormalProbability();
    int level = 1;
    float minRadius = 0.5f;
    boolean hierarchic = false;
    private PointArrayList pointList = null;
    public static final Type $TYPE = new Type(ProbabilityArrange.class);
    public static final SCOType.Field method$FIELD = Type._addManagedField($TYPE, "method", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(ShareableProbabilityArrangeBase.class), null, 0);
    public static final SCOType.Field level$FIELD = Type._addManagedField($TYPE, "level", 0x200000, de.grogra.reflect.Type.INT, null, 1);
    public static final SCOType.Field minRadius$FIELD = Type._addManagedField($TYPE, "minRadius", 0x200000, de.grogra.reflect.Type.FLOAT, null, 2);
    public static final SCOType.Field hierarchic$FIELD = Type._addManagedField($TYPE, "hierarchic", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 3);

    public void calculate() {
        this.pointList = new PointArrayList();
        if (this.hierarchic) {
            this.calculateHierarchic();
        } else {
            this.calculateSimple();
        }
        this.xx = new float[this.pointList.size()];
        this.yy = new float[this.pointList.size()];
        for (int i = 0; i < this.pointList.size(); ++i) {
            Point point = this.pointList.get(i);
            this.xx[i] = (float)point.getX();
            this.yy[i] = (float)point.getY();
        }
    }

    private void calculateSimple() {
        int n = (this.level + 1) * (this.level + 1);
        int[] nArray = this.method.getProbabilityValues(n, this.seed);
        double d = (this.maxX - 1.0f) / (float)(this.level + 1);
        double d2 = (this.maxY - 1.0f) / (float)(this.level + 1);
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            int n3 = 0;
            float f = i / (this.level + 1);
            float f2 = i % (this.level + 1);
            f2 = (float)((double)f2 * d);
            f = (float)((double)f * d2);
            float f3 = this.minRadius;
            while (n2 < nArray[i]) {
                Point point = new Point((double)(f2 + Library.random((float)0.0f, (float)((float)d))), (double)(f + Library.random((float)0.0f, (float)((float)d2))));
                if (!this.pointList.contains(point) && this.pointList.isRadiusFree(point, (double)f3)) {
                    this.pointList.add(point);
                    ++n2;
                    n3 = 0;
                }
                if (n3 > 10) {
                    if (f3 - f3 * 0.05f > 0.0f) {
                        f3 -= f3 * 0.05f;
                    }
                    n3 = 0;
                }
                ++n3;
            }
        }
    }

    private void calculateHierarchic() {
        int n = (this.level + 2) * (this.level + 2);
        double d = (this.maxX - 1.0f) / (float)(this.level + 2);
        double d2 = (this.maxY - 1.0f) / (float)(this.level + 2);
        for (int i = 0; i < n; ++i) {
            this.calculateInnerSegments((double)(i % (this.level + 2)) * d, d, (double)(i / (this.level + 2)) * d2, d2);
        }
    }

    private void calculateInnerSegments(double d, double d2, double d3, double d4) {
        int n = (this.level + 1) * (this.level + 1);
        int[] nArray = this.method.getProbabilityValues(n, this.seed);
        double d5 = (d2 - 1.0) / (double)(this.level + 1);
        double d6 = (d4 - 1.0) / (double)(this.level + 1);
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            int n3 = 0;
            float f = i / (this.level + 1);
            float f2 = i % (this.level + 1);
            f2 = (float)((double)f2 * (d5 + d));
            f = (float)((double)f * (d6 + d3));
            float f3 = this.minRadius;
            while (n2 < nArray[i]) {
                Point point = new Point((double)(f2 + Library.random((float)0.0f, (float)((float)d5))), (double)(f + Library.random((float)0.0f, (float)((float)d6))));
                if (!this.pointList.contains(point) && this.pointList.isRadiusFree(point, (double)f3)) {
                    this.pointList.add(point);
                    ++n2;
                    n3 = 0;
                }
                if (n3 > 10) {
                    if (f3 - f3 * 0.05f > 0.0f) {
                        f3 -= f3 * 0.05f;
                    }
                    n3 = 0;
                }
                ++n3;
            }
        }
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public boolean isHierarchic() {
        return this.hierarchic;
    }

    public void setHierarchic(boolean bl) {
        this.hierarchic = bl;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public float getMinRadius() {
        return this.minRadius;
    }

    public void setMinRadius(float f) {
        this.minRadius = f;
    }

    public ShareableProbabilityArrangeBase getMethod() {
        return this.method;
    }

    public void setMethod(ShareableProbabilityArrangeBase shareableProbabilityArrangeBase) {
        method$FIELD.setObject((Object)this, (Object)shareableProbabilityArrangeBase);
    }

    static {
        level$FIELD.setMinValue((Number)new Integer(0));
        level$FIELD.setMaxValue((Number)new Integer(15));
        minRadius$FIELD.setMinValue((Number)new Float(0.0f));
        minRadius$FIELD.setMaxValue((Number)new Float(5.0f));
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 4;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(ProbabilityArrange probabilityArrange, SCOType sCOType) {
            super((Object)probabilityArrange, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 3: {
                    ((ProbabilityArrange)object).hierarchic = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 3: {
                    return ((ProbabilityArrange)object).isHierarchic();
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 1: {
                    ((ProbabilityArrange)object).level = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 1: {
                    return ((ProbabilityArrange)object).getLevel();
                }
            }
            return super.getInt(object, n);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 2: {
                    ((ProbabilityArrange)object).minRadius = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((ProbabilityArrange)object).getMinRadius();
                }
            }
            return super.getFloat(object, n);
        }

        protected void setObject(Object object, int n, Object object2) {
            switch (n) {
                case 0: {
                    ((ProbabilityArrange)object).method = (ShareableProbabilityArrangeBase)object2;
                    return;
                }
            }
            super.setObject(object, n, object2);
        }

        protected Object getObject(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((ProbabilityArrange)object).getMethod();
                }
            }
            return super.getObject(object, n);
        }

        public Object newInstance() {
            return new ProbabilityArrange();
        }
    }
}

