/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.povray;

import de.grogra.ext.povray.POVExport;
import de.grogra.ext.povray.POVObject;
import de.grogra.ext.povray.POVPhong;
import de.grogra.ext.povray.POVWriter;
import de.grogra.imp3d.io.SceneGraphExport;
import de.grogra.imp3d.objects.SceneTree;
import de.grogra.imp3d.objects.SceneTreeWithShader;
import de.grogra.imp3d.shading.AffineUVTransformation;
import de.grogra.imp3d.shading.Phong;
import de.grogra.imp3d.shading.Shader;
import de.grogra.imp3d.shading.SideSwitchShader;
import de.grogra.math.ChannelMap;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3f;
import java.io.IOException;

public abstract class POVNode
extends POVObject
implements SceneGraphExport.NodeExport {
    public POVNode(String string) {
        super(string, string);
    }

    public POVNode(String string, String string2) {
        super(string, string2);
    }

    protected void exportFooter(Object object, SceneTreeWithShader.Leaf leaf, SceneTree.InnerNode innerNode, POVExport pOVExport) throws IOException {
        Shader shader = leaf.shader;
        if (shader instanceof SideSwitchShader) {
            SideSwitchShader sideSwitchShader = (SideSwitchShader)shader;
            this.exportMaterial(leaf, sideSwitchShader.getFrontShader(), sideSwitchShader.getBackShader(), null, pOVExport);
        } else if (shader instanceof Phong) {
            this.exportMaterial(leaf, shader, null, null, pOVExport);
        } else {
            float f;
            pOVExport.export(shader);
            if (leaf.interior != null && (f = leaf.interior.getIndexOfRefraction((Spectrum)new Spectrum3f(1.0f, 1.0f, 1.0f))) != 1.0f) {
                pOVExport.out.print("interior{ior ");
                pOVExport.out.print(f);
                pOVExport.out.print('}');
                pOVExport.out.println();
            }
        }
        this.exportTransform(leaf, innerNode, pOVExport);
    }

    protected void exportTransform(SceneTreeWithShader.Leaf leaf, SceneTree.InnerNode innerNode, POVExport pOVExport) throws IOException {
        if (innerNode != null) {
            pOVExport.out.print(innerNode);
            pOVExport.out.println();
        }
    }

    protected void exportMaterial(SceneTreeWithShader.Leaf leaf, Shader shader, Shader shader2, ChannelMap channelMap, POVExport pOVExport) throws IOException {
        float f;
        POVWriter pOVWriter = pOVExport.out;
        pOVWriter.print("material{");
        pOVWriter.println();
        pOVWriter.indent();
        if (shader != null) {
            String string = "texture";
            Shader shader3 = shader;
            for (int i = 0; i <= 1; ++i) {
                SceneGraphExport.ObjectExport objectExport = pOVExport.getExportForObject(shader3);
                if (objectExport instanceof POVPhong) {
                    ((POVPhong)objectExport).export(shader3, channelMap, leaf, string, this, pOVExport);
                } else {
                    pOVWriter.print(string);
                    pOVWriter.write("{pigment{color rgbt");
                    pOVWriter.printRGBT(shader3.getAverageColor());
                    pOVWriter.print("}}");
                    pOVWriter.println();
                }
                shader3 = shader2;
                if (shader3 != null) {
                    string = "interior_texture";
                    continue;
                }
                break;
            }
        } else {
            pOVWriter.print("texture{pigment{color rgb <1,1,1>}}");
            pOVWriter.println();
        }
        if (leaf.interior != null && (f = leaf.interior.getIndexOfRefraction((Spectrum)new Spectrum3f(1.0f, 1.0f, 1.0f))) != 1.0f) {
            pOVWriter.print("interior{ior ");
            pOVWriter.print(f);
            pOVWriter.print('}');
            pOVWriter.println();
        }
        pOVWriter.unindent();
        pOVWriter.print('}');
        pOVWriter.println();
    }

    protected void exportTextureHeader(Phong phong, SceneTreeWithShader.Leaf leaf, POVExport pOVExport) throws IOException {
        if (POVPhong.usesUVMapping(phong)) {
            pOVExport.out.write("uv_mapping ");
        }
    }

    protected void exportTextureFooter(Phong phong, ChannelMap channelMap, SceneTreeWithShader.Leaf leaf, POVExport pOVExport) throws IOException {
        if (channelMap instanceof AffineUVTransformation) {
            pOVExport.out.print((AffineUVTransformation)channelMap);
        }
    }

    public void export(SceneTree.Leaf leaf, SceneTree.InnerNode innerNode, SceneGraphExport sceneGraphExport) throws IOException {
        this.export(null, (SceneTreeWithShader.Leaf)leaf, innerNode, null, (POVExport)sceneGraphExport);
    }
}

