/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.jedit;

import de.grogra.ext.jedit.VFSAdapter;
import de.grogra.pf.registry.PluginDescriptor;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.TextEditor;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.awt.AWTSynchronizer;
import de.grogra.pf.ui.swing.PanelSupport;
import de.grogra.pf.ui.swing.SwingDockable;
import de.grogra.util.Map;
import de.grogra.util.ModifiableMap;
import java.awt.EventQueue;
import java.awt.Point;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;

public class JEditTextEditor
extends PanelSupport
implements TextEditor,
ModifiableMap.Producer {
    private static final String PFS_PREFIX = "pfs:";
    private static boolean initialized;
    private static String VFS_ROOT;
    private static final int OPEN_DOC = 4;
    private static final int CLOSE_DOC = 5;
    private static final int GET_DOCS = 6;
    private static final int CHECK_CLOSE = 7;

    private static synchronized View createView() {
        class Helper
        implements Runnable {
            boolean returnNewView;
            View view;

            Helper() {
            }

            public void run() {
                if (this.returnNewView) {
                    this.view = jEdit.newView(null, null, false);
                }
            }
        }
        Helper helper = new Helper();
        if (!initialized) {
            initialized = true;
            PluginDescriptor pluginDescriptor = PluginDescriptor.getInstance(helper.getClass());
            if (pluginDescriptor.getPluginDirectory() instanceof File) {
                System.setProperty("jedit.home", ((File)pluginDescriptor.getPluginDirectory()).getAbsolutePath());
            }
            final File file = pluginDescriptor.getConfigurationDirectory();
            new Thread("jEdit Startup"){

                public void run() {
                    jEdit.main(new String[]{file != null ? "-settings=" + file.getAbsolutePath() : "-nosettings", "-noserver", "-norestore"});
                }
            }.start();
            while (!jEdit.isStartupDone()) {
                try {
                    Thread.sleep(10L);
                    EventQueue.invokeAndWait(helper);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            VFS_ROOT = VFSAdapter.forAllProjects().getName() + ":/";
            return jEdit.getFirstView();
        }
        helper.returnNewView = true;
        AWTSynchronizer.staticInvokeAndWait((Runnable)helper);
        return helper.view;
    }

    public static void shutdown() {
        if (initialized) {
            jEdit.exit(null, true);
        }
    }

    public JEditTextEditor() {
        super((SwingDockable)JEditTextEditor.createView());
        this.mapProducer = this;
    }

    protected void configure(Map map) {
        super.configure(map);
        String[] stringArray = UI.getDocuments((Map)map);
        for (int i = 0; i < stringArray.length; ++i) {
            this.openDocument(stringArray[i], null);
        }
        String string = (String)map.get((Object)"selected", null);
        if (string != null) {
            this.openDocument(string, null);
        }
    }

    private String getVFSPrefix() {
        return VFS_ROOT + this.getRegistry().getFileSystemName() + '/';
    }

    private String getVFSPath(String string) {
        if (string.startsWith(PFS_PREFIX)) {
            return this.getVFSPrefix() + string.substring(PFS_PREFIX.length());
        }
        return string;
    }

    private String getSystemId(String string) {
        if (string.startsWith(VFS_ROOT)) {
            String string2 = this.getVFSPrefix();
            return string.startsWith(string2) ? PFS_PREFIX + string.substring(string2.length()) : null;
        }
        return string;
    }

    public Object run(int n, int n2, Object object, Object object2) {
        switch (n) {
            case 4: {
                Point[] pointArray;
                String string = this.getVFSPath((String)object);
                Buffer buffer = jEdit._getBuffer(string);
                if (buffer == null) {
                    buffer = jEdit.openFile((View)this.getComponent(), string);
                } else {
                    ((View)this.getComponent()).goToBuffer(buffer);
                }
                JEditTextArea jEditTextArea = ((View)this.getComponent()).getTextArea();
                if (buffer == null || jEditTextArea == null || jEditTextArea.getBuffer() != buffer || (pointArray = UI.parsePlainTextRange((String)((String)object2))) == null) break;
                try {
                    Point point = pointArray[0];
                    int n3 = jEditTextArea.getLineStartOffset(point.y);
                    if (point.x >= 0) {
                        n3 += point.x;
                    }
                    if ((point = pointArray[1]) == null) {
                        jEditTextArea.setCaretPosition(n3);
                        break;
                    }
                    jEditTextArea.setSelection(new Selection.Range(n3, point.x >= 0 ? jEditTextArea.getLineStartOffset(point.y) + point.x : jEditTextArea.getLineEndOffset(point.y)));
                    jEditTextArea.moveCaretPosition(n3, true);
                }
                catch (RuntimeException runtimeException) {}
                break;
            }
            case 5: {
                Buffer buffer = jEdit._getBuffer(this.getVFSPath((String)object));
                if (buffer == null) break;
                jEdit._closeBuffer((View)this.getComponent(), buffer);
                break;
            }
            case 6: {
                Buffer[] bufferArray = jEdit.getBuffers();
                String[] stringArray = new String[bufferArray.length];
                int n4 = 0;
                for (int i = 0; i < bufferArray.length; ++i) {
                    String string = this.getSystemId(bufferArray[i].getPath());
                    if (string == null) continue;
                    stringArray[n4++] = string;
                }
                if (n4 != stringArray.length) {
                    String[] stringArray2 = stringArray;
                    stringArray = new String[n4];
                    System.arraycopy(stringArray2, 0, stringArray, 0, n4);
                }
                return stringArray;
            }
            case 7: {
                Buffer[] bufferArray = jEdit.getBuffers();
                boolean bl = jEdit.getViewCount() == 1;
                for (int i = 0; i < bufferArray.length; ++i) {
                    if (!bl && !bufferArray[i].getPath().startsWith(this.getVFSPrefix()) || jEdit.closeBuffer((View)this.getComponent(), bufferArray[i])) continue;
                    return null;
                }
                return this;
            }
            default: {
                return super.run(n, n2, object, object2);
            }
        }
        return null;
    }

    public void openDocument(String string, String string2) {
        this.sync.invokeAndWait(4, 0, (Object)string, (Object)string2);
    }

    public void checkClose(Runnable runnable) {
        this.executeCheckClose(runnable);
    }

    protected void disposeImpl() {
        jEdit.closeView((View)this.getComponent(), false);
        super.disposeImpl();
    }

    public void checkClose(Command command) {
        if (this.sync.invokeAndWait(7) != null) {
            command.run(null, (Context)this);
        }
    }

    public String[] getDocuments() {
        return (String[])this.sync.invokeAndWait(6);
    }

    public void addMappings(ModifiableMap modifiableMap) {
        UI.putDocuments((TextEditor)this, (ModifiableMap)modifiableMap);
        String string = this.getSystemId(((View)this.getComponent()).getBuffer().getPath());
        if (string != null) {
            modifiableMap.put((Object)"selected", (Object)string);
        }
    }
}

