/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import bsh.NameSpace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class ActionBar
extends JPanel {
    private static NameSpace namespace = new NameSpace(BeanShell.getNameSpace(), "action bar namespace");
    private View view;
    private boolean temp;
    private int repeatCount;
    private HistoryTextField action;
    private CompletionPopup popup;
    private RolloverButton close;

    public ActionBar(View view, boolean bl) {
        this.setLayout(new BoxLayout(this, 0));
        this.view = view;
        this.temp = bl;
        this.add(Box.createHorizontalStrut(2));
        JLabel jLabel = new JLabel(jEdit.getProperty("view.action.prompt"));
        this.add(jLabel);
        this.add(Box.createHorizontalStrut(12));
        this.action = new ActionTextField();
        this.add(this.action);
        this.action.setEnterAddsToHistory(false);
        Dimension dimension = this.action.getPreferredSize();
        dimension.width = Integer.MAX_VALUE;
        this.action.setMaximumSize(dimension);
        this.action.addActionListener(new ActionHandler());
        this.action.getDocument().addDocumentListener(new DocumentHandler());
        if (bl) {
            this.close = new RolloverButton(GUIUtilities.loadIcon("closebox.gif"));
            this.close.addActionListener(new ActionHandler());
            this.close.setToolTipText(jEdit.getProperty("view.action.close-tooltip"));
            this.add(this.close);
        }
        this.temp = bl;
    }

    public HistoryTextField getField() {
        return this.action;
    }

    public void goToActionBar() {
        this.repeatCount = this.view.getInputHandler().getRepeatCount();
        this.action.setText(null);
        this.action.requestFocus();
    }

    private void invoke() {
        String string;
        Object object;
        String string2;
        if (this.popup != null) {
            string2 = this.popup.list.getSelectedValue().toString();
        } else {
            string2 = this.action.getText().trim();
            int n = string2.indexOf(61);
            if (n != -1) {
                String string3;
                this.action.addCurrentToHistory();
                object = string2.substring(0, n).trim();
                String string4 = string2.substring(n + 1).trim();
                if (((String)object).startsWith("buffer.")) {
                    string3 = ((String)object).equals("buffer.mode") ? "buffer.setMode(\"" + MiscUtilities.charsToEscapes(string4) + "\");" : "buffer.setStringProperty(\"" + MiscUtilities.charsToEscapes(((String)object).substring("buffer.".length())) + "\",\"" + MiscUtilities.charsToEscapes(string4) + "\");";
                    string3 = string3 + "\nbuffer.propertiesChanged();";
                } else {
                    string3 = ((String)object).startsWith("!buffer.") ? "jEdit.setProperty(\"" + MiscUtilities.charsToEscapes(((String)object).substring(1)) + "\",\"" + MiscUtilities.charsToEscapes(string4) + "\");\n" + "jEdit.propertiesChanged();" : "jEdit.setProperty(\"" + MiscUtilities.charsToEscapes((String)object) + "\",\"" + MiscUtilities.charsToEscapes(string4) + "\");\n" + "jEdit.propertiesChanged();";
                }
                Macros.Recorder recorder = this.view.getMacroRecorder();
                if (recorder != null) {
                    recorder.record(string3);
                }
                BeanShell.eval(this.view, namespace, string3);
                string2 = null;
            } else if (string2.length() != 0) {
                object = this.getCompletions(string2);
                if (((String[])object).length != 0) {
                    string2 = object[0];
                }
            } else {
                string2 = null;
            }
        }
        if (this.popup != null) {
            this.popup.dispose();
            this.popup = null;
        }
        Object object2 = object = (string = string2) == null ? null : jEdit.getAction(string);
        if (this.temp) {
            this.view.removeToolBar(this);
        }
        SwingUtilities.invokeLater(new Runnable((EditAction)object, string){
            final /* synthetic */ EditAction val$act;
            final /* synthetic */ String val$finalCmd;
            {
                this.val$act = editAction;
                this.val$finalCmd = string;
            }

            public void run() {
                ActionBar.this.view.getTextArea().requestFocus();
                if (this.val$act == null) {
                    if (this.val$finalCmd != null) {
                        ActionBar.this.view.getStatus().setMessageAndClear(jEdit.getProperty("view.action.no-completions"));
                    }
                } else {
                    ActionBar.this.view.getInputHandler().setRepeatCount(ActionBar.this.repeatCount);
                    ActionBar.this.view.getInputHandler().invokeAction(this.val$act);
                }
            }
        });
    }

    private String[] getCompletions(String string) {
        string = string.toLowerCase();
        String[] stringArray = jEdit.getActionNames();
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].toLowerCase().indexOf(string) == -1) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void complete(boolean bl) {
        String string = this.action.getText().trim();
        String[] stringArray = this.getCompletions(string);
        if (stringArray.length == 1) {
            if (bl) {
                this.action.setText(stringArray[0]);
            }
        } else if (stringArray.length != 0) {
            String string2;
            if (bl && (string2 = MiscUtilities.getLongestPrefix(stringArray, true)).indexOf(string) != -1) {
                this.action.setText(string2);
            }
            if (this.popup != null) {
                this.popup.setModel(stringArray);
            } else {
                this.popup = new CompletionPopup(stringArray);
            }
            return;
        }
        if (this.popup != null) {
            this.popup.dispose();
            this.popup = null;
        }
    }

    class CompletionPopup
    extends JWindow {
        CompletionList list;

        CompletionPopup(String[] stringArray) {
            super(ActionBar.this.view.getFrame());
            this.setContentPane(new JPanel(new BorderLayout()){

                public boolean isManagingFocus() {
                    return false;
                }

                public boolean getFocusTraversalKeysEnabled() {
                    return false;
                }
            });
            this.list = new CompletionList(stringArray);
            this.list.setVisibleRowCount(8);
            this.list.addMouseListener(new MouseHandler());
            this.list.setSelectedIndex(0);
            this.list.setSelectionMode(0);
            JScrollPane jScrollPane = new JScrollPane(this.list, 22, 31);
            this.getContentPane().add((Component)jScrollPane, "Center");
            GUIUtilities.requestFocus(this, this.list);
            this.pack();
            Point point = new Point(0, -this.getHeight());
            SwingUtilities.convertPointToScreen(point, ActionBar.this.action);
            this.setLocation(point);
            this.setVisible(true);
            KeyHandler keyHandler = new KeyHandler();
            this.addKeyListener(keyHandler);
            this.list.addKeyListener(keyHandler);
        }

        void setModel(String[] stringArray) {
            this.list.setListData(stringArray);
            this.list.setSelectedIndex(0);
        }

        class KeyHandler
        extends KeyAdapter {
            KeyHandler() {
            }

            public void keyTyped(KeyEvent keyEvent) {
                ActionBar.this.action.processKeyEvent(keyEvent);
            }

            public void keyPressed(KeyEvent keyEvent) {
                int n;
                int n2 = keyEvent.getKeyCode();
                if (n2 == 27) {
                    ActionBar.this.action.processKeyEvent(keyEvent);
                } else if (n2 == 10) {
                    ActionBar.this.invoke();
                } else if (n2 == 38) {
                    int n3 = CompletionPopup.this.list.getSelectedIndex();
                    if (n3 == 0) {
                        CompletionPopup.this.list.setSelectedIndex(CompletionPopup.this.list.getModel().getSize() - 1);
                        keyEvent.consume();
                    }
                } else if (n2 == 40 && (n = CompletionPopup.this.list.getSelectedIndex()) == CompletionPopup.this.list.getModel().getSize() - 1) {
                    CompletionPopup.this.list.setSelectedIndex(0);
                    keyEvent.consume();
                }
            }
        }

        class CompletionList
        extends JList {
            CompletionList(Object[] objectArray) {
                super(objectArray);
            }

            public void processKeyEvent(KeyEvent keyEvent) {
                super.processKeyEvent(keyEvent);
            }
        }

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                ActionBar.this.invoke();
            }
        }
    }

    class ActionTextField
    extends HistoryTextField {
        boolean repeat;
        boolean nonDigit;

        ActionTextField() {
            super("action");
            this.setSelectAllOnFocus(true);
        }

        public boolean isManagingFocus() {
            return false;
        }

        public boolean getFocusTraversalKeysEnabled() {
            return false;
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            if ((keyEvent = KeyEventWorkaround.processKeyEvent(keyEvent)) == null) {
                return;
            }
            switch (keyEvent.getID()) {
                case 400: {
                    char c = keyEvent.getKeyChar();
                    if (!this.nonDigit && Character.isDigit(c)) {
                        super.processKeyEvent(keyEvent);
                        this.repeat = true;
                        ActionBar.this.repeatCount = Integer.parseInt(ActionBar.this.action.getText());
                        break;
                    }
                    this.nonDigit = true;
                    if (this.repeat) {
                        this.passToView(keyEvent);
                        break;
                    }
                    super.processKeyEvent(keyEvent);
                    break;
                }
                case 401: {
                    int n = keyEvent.getKeyCode();
                    if (keyEvent.isActionKey() || keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isMetaDown() || n == 8 || n == 127 || n == 10 || n == 9 || n == 27) {
                        this.nonDigit = true;
                        if (this.repeat) {
                            this.passToView(keyEvent);
                            break;
                        }
                        if (n == 9) {
                            ActionBar.this.complete(true);
                            keyEvent.consume();
                        } else {
                            if (n == 27) {
                                keyEvent.consume();
                                if (ActionBar.this.popup != null) {
                                    ActionBar.this.popup.dispose();
                                    ActionBar.this.popup = null;
                                    ActionBar.this.action.requestFocus();
                                    break;
                                }
                                if (ActionBar.this.temp) {
                                    ActionBar.this.view.removeToolBar(ActionBar.this);
                                }
                                ActionBar.this.view.getEditPane().focusOnTextArea();
                                break;
                            }
                            if ((n == 38 || n == 40) && ActionBar.this.popup != null) {
                                ((ActionBar)ActionBar.this).popup.list.processKeyEvent(keyEvent);
                                break;
                            }
                        }
                    }
                    super.processKeyEvent(keyEvent);
                }
            }
        }

        private void passToView(final KeyEvent keyEvent) {
            if (ActionBar.this.temp) {
                ActionBar.this.view.removeToolBar(ActionBar.this);
            }
            ActionBar.this.view.getTextArea().requestFocus();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ActionBar.this.view.getTextArea().requestFocus();
                    ActionBar.this.view.getInputHandler().setRepeatCount(ActionBar.this.repeatCount);
                    ActionBar.this.view.processKeyEvent(keyEvent, 2);
                }
            });
        }

        public void addNotify() {
            super.addNotify();
            this.nonDigit = false;
            this.repeat = false;
        }
    }

    class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (ActionBar.this.popup != null) {
                ActionBar.this.complete(false);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (ActionBar.this.popup != null) {
                ActionBar.this.complete(false);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ActionBar.this.close) {
                ActionBar.this.view.removeToolBar(ActionBar.this);
            } else {
                ActionBar.this.invoke();
            }
        }
    }
}

