/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;

public class CloseDialog
extends EnhancedDialog {
    private View view;
    private JList bufferList;
    private DefaultListModel bufferModel;
    private JButton selectAll;
    private JButton save;
    private JButton discard;
    private JButton cancel;
    private boolean ok;
    boolean selectAllFlag;

    public CloseDialog(View view) {
        super(view, jEdit.getProperty("close.title"), true);
        Object object;
        this.view = view;
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        Box box = new Box(1);
        box.add(new JLabel(UIManager.getIcon("OptionPane.warningIcon")));
        box.add(Box.createGlue());
        jPanel.add("West", box);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(jEdit.getProperty("close.caption"));
        jLabel.setBorder(new EmptyBorder(0, 0, 6, 0));
        jPanel2.add("North", jLabel);
        this.bufferModel = new DefaultListModel();
        this.bufferList = new JList(this.bufferModel);
        this.bufferList.setVisibleRowCount(10);
        this.bufferList.addListSelectionListener(new ListHandler());
        Buffer[] bufferArray = jEdit.getBuffers();
        for (int i = 0; i < bufferArray.length; ++i) {
            object = bufferArray[i];
            if (!((Buffer)object).isDirty()) continue;
            this.bufferModel.addElement(((Buffer)object).getPath());
        }
        jPanel2.add("Center", new JScrollPane(this.bufferList));
        jPanel.add("Center", jPanel2);
        ActionHandler actionHandler = new ActionHandler();
        object = new Box(0);
        ((Container)object).add(Box.createGlue());
        this.selectAll = new JButton(jEdit.getProperty("close.selectAll"));
        ((Container)object).add(this.selectAll);
        this.selectAll.setMnemonic(jEdit.getProperty("close.selectAll.mnemonic").charAt(0));
        this.selectAll.addActionListener(actionHandler);
        ((Container)object).add(Box.createHorizontalStrut(6));
        this.save = new JButton(jEdit.getProperty("close.save"));
        ((Container)object).add(this.save);
        this.save.setMnemonic(jEdit.getProperty("close.save.mnemonic").charAt(0));
        this.save.addActionListener(actionHandler);
        ((Container)object).add(Box.createHorizontalStrut(6));
        this.discard = new JButton(jEdit.getProperty("close.discard"));
        ((Container)object).add(this.discard);
        this.discard.setMnemonic(jEdit.getProperty("close.discard.mnemonic").charAt(0));
        this.discard.addActionListener(actionHandler);
        ((Container)object).add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        ((Container)object).add(this.cancel);
        this.cancel.addActionListener(actionHandler);
        ((Container)object).add(Box.createGlue());
        this.bufferList.setSelectedIndex(0);
        jPanel.add("South", (Component)object);
        GUIUtilities.requestFocus(this, this.bufferList);
        this.pack();
        this.setLocationRelativeTo((Component)((Object)view));
        this.setVisible(true);
    }

    public boolean isOK() {
        return this.ok;
    }

    public void ok() {
    }

    public void cancel() {
        this.dispose();
    }

    private void updateButtons() {
        int n = this.bufferList.getSelectedIndex();
        this.save.getModel().setEnabled(n != -1);
        this.discard.getModel().setEnabled(n != -1);
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (CloseDialog.this.selectAllFlag) {
                return;
            }
            int n = CloseDialog.this.bufferList.getSelectedIndex();
            if (n != -1) {
                CloseDialog.this.view.goToBuffer(jEdit.getBuffer((String)CloseDialog.this.bufferModel.getElementAt(n)));
            }
            CloseDialog.this.updateButtons();
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == CloseDialog.this.selectAll) {
                try {
                    CloseDialog.this.selectAllFlag = true;
                    CloseDialog.this.bufferList.setSelectionInterval(0, CloseDialog.this.bufferModel.getSize() - 1);
                    Object var4_3 = null;
                    CloseDialog.this.selectAllFlag = false;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    CloseDialog.this.selectAllFlag = false;
                    throw throwable;
                }
                CloseDialog.this.bufferList.requestFocus();
            } else if (object == CloseDialog.this.save) {
                Object[] objectArray = CloseDialog.this.bufferList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    String string = (String)objectArray[i];
                    Buffer buffer = jEdit.getBuffer(string);
                    if (!buffer.save(CloseDialog.this.view, null, true)) {
                        return;
                    }
                    VFSManager.waitForRequests();
                    if (buffer.getBooleanProperty("BufferIORequest__error")) {
                        return;
                    }
                    jEdit._closeBuffer(CloseDialog.this.view, buffer);
                    CloseDialog.this.bufferModel.removeElement(string);
                }
                if (CloseDialog.this.bufferModel.getSize() == 0) {
                    CloseDialog.this.ok = true;
                    CloseDialog.this.dispose();
                } else {
                    CloseDialog.this.bufferList.setSelectedIndex(0);
                    CloseDialog.this.bufferList.requestFocus();
                }
            } else if (object == CloseDialog.this.discard) {
                Object[] objectArray = CloseDialog.this.bufferList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    String string = (String)objectArray[i];
                    Buffer buffer = jEdit.getBuffer(string);
                    jEdit._closeBuffer(CloseDialog.this.view, buffer);
                    CloseDialog.this.bufferModel.removeElement(string);
                }
                if (CloseDialog.this.bufferModel.getSize() == 0) {
                    CloseDialog.this.ok = true;
                    CloseDialog.this.dispose();
                } else {
                    CloseDialog.this.bufferList.setSelectedIndex(0);
                    CloseDialog.this.bufferList.requestFocus();
                }
            } else if (object == CloseDialog.this.cancel) {
                CloseDialog.this.cancel();
            }
        }
    }
}

