/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.InputHandler;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.util.Log;

public class DefaultInputHandler
extends InputHandler {
    private static Object PREFIX_STR = "PREFIX_STR";
    private Hashtable bindings;
    private Hashtable currentBindings;

    public DefaultInputHandler(View view) {
        super(view);
        this.bindings = this.currentBindings = new Hashtable();
    }

    public DefaultInputHandler(View view, DefaultInputHandler defaultInputHandler) {
        super(view);
        this.bindings = this.currentBindings = defaultInputHandler.bindings;
    }

    public void addKeyBinding(String string, String string2) {
        this._addKeyBinding(string, string2);
    }

    public void addKeyBinding(String string, EditAction editAction) {
        this._addKeyBinding(string, editAction);
    }

    public void removeKeyBinding(String string) {
        Hashtable hashtable = this.bindings;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            KeyEventTranslator.Key key = KeyEventTranslator.parseKey(string2);
            if (key == null) {
                return;
            }
            if (stringTokenizer.hasMoreTokens()) {
                Object v = hashtable.get(key);
                if (v instanceof Hashtable) {
                    hashtable = (Hashtable)v;
                    continue;
                }
                if (v != null) {
                    hashtable.remove(key);
                    return;
                }
                return;
            }
            hashtable.remove(key);
        }
    }

    public void removeAllKeyBindings() {
        this.bindings.clear();
    }

    public Object getKeyBinding(String string) {
        Hashtable hashtable = this.bindings;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            KeyEventTranslator.Key key = KeyEventTranslator.parseKey(stringTokenizer.nextToken());
            if (key == null) {
                return null;
            }
            if (stringTokenizer.hasMoreTokens()) {
                Object v = hashtable.get(key);
                if (v instanceof Hashtable) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        return v;
                    }
                    hashtable = (Hashtable)v;
                    continue;
                }
                return v;
            }
            return hashtable.get(key);
        }
        return null;
    }

    public boolean isPrefixActive() {
        return this.bindings != this.currentBindings || super.isPrefixActive();
    }

    public boolean handleKey(KeyEventTranslator.Key key) {
        Object v;
        char c = '\u0000';
        if (key.modifiers == null || key.modifiers.equals("S")) {
            switch (key.key) {
                case 9: 
                case 10: {
                    c = (char)key.key;
                    break;
                }
                default: {
                    c = key.input;
                }
            }
        }
        if (this.readNextChar != null) {
            if (c != '\u0000') {
                this.setCurrentBindings(this.bindings);
                this.invokeReadNextChar(c);
                this.repeatCount = 1;
                return true;
            }
            this.readNextChar = null;
            this.view.getStatus().setMessage(null);
        }
        if ((v = this.currentBindings.get(key)) == null) {
            if (this.currentBindings != this.bindings) {
                Toolkit.getDefaultToolkit().beep();
                this.repeatCount = 1;
                this.setCurrentBindings(this.bindings);
            }
            if (c != '\u0000') {
                this.userInput(c);
            } else {
                switch (key.key) {
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 109: 
                    case 110: 
                    case 111: {
                        KeyEventWorkaround.numericKeypadKey();
                    }
                }
            }
        } else {
            if (v instanceof Hashtable) {
                this.setCurrentBindings((Hashtable)v);
                return true;
            }
            if (v instanceof String) {
                this.setCurrentBindings(this.bindings);
                this.invokeAction((String)v);
                return true;
            }
            if (v instanceof EditAction) {
                this.setCurrentBindings(this.bindings);
                this.invokeAction((EditAction)v);
                return true;
            }
        }
        return false;
    }

    public static char getSymbolicModifierName(int n) {
        return KeyEventTranslator.getSymbolicModifierName(n);
    }

    public static String getModifierString(InputEvent inputEvent) {
        return KeyEventTranslator.getModifierString(inputEvent);
    }

    public static KeyStroke parseKeyStroke(String string) {
        int n;
        String string2;
        if (string == null) {
            return null;
        }
        int n2 = 0;
        int n3 = string.indexOf(43);
        if (n3 != -1) {
            block8: for (int i = 0; i < n3; ++i) {
                switch (Character.toUpperCase(string.charAt(i))) {
                    case 'A': {
                        n2 |= KeyEventTranslator.a;
                        continue block8;
                    }
                    case 'C': {
                        n2 |= KeyEventTranslator.c;
                        continue block8;
                    }
                    case 'M': {
                        n2 |= KeyEventTranslator.m;
                        continue block8;
                    }
                    case 'S': {
                        n2 |= KeyEventTranslator.s;
                    }
                }
            }
        }
        if ((string2 = string.substring(n3 + 1)).length() == 1) {
            char c = string2.charAt(0);
            if (n2 == 0) {
                return KeyStroke.getKeyStroke(c);
            }
            return KeyStroke.getKeyStroke((int)Character.toUpperCase(c), n2);
        }
        if (string2.length() == 0) {
            Log.log(9, DefaultInputHandler.class, "Invalid key stroke: " + string);
            return null;
        }
        try {
            n = KeyEvent.class.getField("VK_".concat(string2)).getInt(null);
        }
        catch (Exception exception) {
            Log.log(9, DefaultInputHandler.class, "Invalid key stroke: " + string);
            return null;
        }
        return KeyStroke.getKeyStroke(n, n2);
    }

    private void setCurrentBindings(Hashtable hashtable) {
        this.view.getStatus().setMessage((String)hashtable.get(PREFIX_STR));
        this.currentBindings = hashtable;
    }

    public void _addKeyBinding(String string, Object object) {
        Hashtable hashtable = this.bindings;
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string2 = string2 == null ? string3 : string2 + " " + string3;
            KeyEventTranslator.Key key = KeyEventTranslator.parseKey(string3);
            if (key == null) {
                return;
            }
            if (stringTokenizer.hasMoreTokens()) {
                Object object2 = hashtable.get(key);
                if (object2 instanceof Hashtable) {
                    hashtable = (Hashtable)object2;
                    continue;
                }
                Hashtable<Object, String> hashtable2 = new Hashtable<Object, String>();
                hashtable2.put(PREFIX_STR, string2);
                object2 = hashtable2;
                hashtable.put(key, object2);
                hashtable = (Hashtable)object2;
                continue;
            }
            hashtable.put(key, object);
        }
    }
}

