/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractListModel;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class HistoryModel
extends AbstractListModel {
    private static final String TO_ESCAPE = "\r\n\t\\\"'[]";
    private static int max;
    private String name;
    private Vector data;
    private static Hashtable models;
    private static boolean modified;
    private static File history;
    private static long historyModTime;

    public HistoryModel(String string) {
        this.name = string;
        this.data = new Vector(max);
    }

    public void addItem(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        modified = true;
        int n = this.data.indexOf(string);
        if (n != -1) {
            this.data.removeElementAt(n);
        }
        this.data.insertElementAt(string, 0);
        while (this.getSize() > max) {
            this.data.removeElementAt(this.data.size() - 1);
        }
    }

    public String getItem(int n) {
        return (String)this.data.elementAt(n);
    }

    public Object getElementAt(int n) {
        return this.getItem(n);
    }

    public void clear() {
        modified = true;
        this.data.removeAllElements();
    }

    public int getSize() {
        return this.data.size();
    }

    public String getName() {
        return this.name;
    }

    public static HistoryModel getModel(String string) {
        HistoryModel historyModel;
        if (models == null) {
            models = new Hashtable();
        }
        if ((historyModel = (HistoryModel)models.get(string)) == null) {
            historyModel = new HistoryModel(string);
            models.put(string, historyModel);
        }
        return historyModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadHistory() {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            return;
        }
        history = new File(MiscUtilities.constructPath(string, "history"));
        if (!history.exists()) {
            return;
        }
        historyModTime = history.lastModified();
        Log.log(3, HistoryModel.class, "Loading history");
        if (models == null) {
            models = new Hashtable();
        }
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(history));
            HistoryModel historyModel = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("[") && string2.endsWith("]")) {
                    if (historyModel != null) {
                        models.put(historyModel.getName(), historyModel);
                    }
                    String string3 = MiscUtilities.escapesToChars(string2.substring(1, string2.length() - 1));
                    historyModel = new HistoryModel(string3);
                    continue;
                }
                if (historyModel == null) {
                    throw new IOException("History data starts before model name");
                }
                historyModel.data.addElement(MiscUtilities.escapesToChars(string2));
            }
            if (historyModel != null) {
                models.put(historyModel.getName(), historyModel);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            Log.log(9, HistoryModel.class, iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveHistory() {
        if (!modified) {
            return;
        }
        Log.log(3, HistoryModel.class, "Saving history");
        File file = new File(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "#history#save#"));
        File file2 = new File(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "history"));
        if (file2.exists() && file2.lastModified() != historyModTime) {
            Log.log(7, HistoryModel.class, file2 + " changed on disk; will not save history");
            return;
        }
        jEdit.backupSettingsFile(file2);
        String string = System.getProperty("line.separator");
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            if (models != null) {
                Enumeration enumeration = models.elements();
                while (enumeration.hasMoreElements()) {
                    HistoryModel historyModel = (HistoryModel)enumeration.nextElement();
                    if (historyModel.getSize() == 0) continue;
                    bufferedWriter.write(91);
                    bufferedWriter.write(MiscUtilities.charsToEscapes(historyModel.getName(), TO_ESCAPE));
                    bufferedWriter.write(93);
                    bufferedWriter.write(string);
                    for (int i = 0; i < historyModel.getSize(); ++i) {
                        bufferedWriter.write(MiscUtilities.charsToEscapes(historyModel.getItem(i), TO_ESCAPE));
                        bufferedWriter.write(string);
                    }
                }
            }
            bufferedWriter.close();
            file2.delete();
            file.renameTo(file2);
            modified = false;
        }
        catch (IOException iOException) {
            Log.log(9, HistoryModel.class, iOException);
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
        historyModTime = file2.lastModified();
    }

    public static void propertiesChanged() {
        max = jEdit.getIntegerProperty("history", 25);
    }
}

