/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class VariableGridLayout
implements LayoutManager2,
Serializable {
    public static final int FIXED_NUM_ROWS = 1;
    public static final int FIXED_NUM_COLUMNS = 2;
    private int mode;
    private int size;
    private int hgap;
    private int vgap;
    private transient int nrows = -1;
    private transient int ncols = -1;
    private transient int[] row_heights = null;
    private transient int[] col_widths = null;

    public VariableGridLayout(int n, int n2, int n3, int n4) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("illegal mode; value is " + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("size cannot be zero or less; value is " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("hgap cannot be negative; value is " + n3);
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("vgap cannot be negative; value is " + n4);
        }
        this.mode = n;
        this.size = n2;
        this.hgap = n3;
        this.vgap = n4;
    }

    public VariableGridLayout(int n, int n2) {
        this(n, n2, 0, 0);
    }

    public VariableGridLayout() {
        this(1, 1, 0, 0);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void addLayoutComponent(Component component, Object object) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, 2);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, 0);
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.getLayoutSize(container, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            double d;
            int n2;
            this.update(container);
            int n3 = container.getComponentCount();
            if (n3 == 0) {
                return;
            }
            int n4 = 0;
            int n5 = 0;
            for (n2 = 0; n2 < this.nrows; ++n2) {
                for (int i = 0; i < this.ncols && n5 < n3; ++i, ++n5) {
                    Dimension dimension = container.getComponent(n5).getPreferredSize();
                    this.row_heights[n2] = Math.max(this.row_heights[n2], dimension.height);
                    this.col_widths[i] = Math.max(this.col_widths[i], dimension.width);
                }
                n4 += this.row_heights[n2];
            }
            n2 = 0;
            for (n5 = 0; n5 < this.ncols; ++n5) {
                n2 += this.col_widths[n5];
            }
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n6 = dimension.height - insets.top - insets.bottom - (this.nrows - 1) * this.vgap;
            int n7 = dimension.width - insets.left - insets.right - (this.ncols - 1) * this.hgap;
            if (n4 != n6) {
                d = (double)n6 / (double)n4;
                for (n = 0; n < this.nrows; ++n) {
                    this.row_heights[n] = (int)((double)this.row_heights[n] * d);
                }
            }
            if (n2 != n7) {
                d = (double)n7 / (double)n2;
                for (n = 0; n < this.ncols; ++n) {
                    this.col_widths[n] = (int)((double)this.col_widths[n] * d);
                }
            }
            int n8 = insets.top;
            n = 0;
            for (int i = 0; i < this.nrows; ++i) {
                int n9 = 0;
                int n10 = insets.left;
                while (n9 < this.ncols) {
                    if (n < n3) {
                        container.getComponent(n).setBounds(n10, n8, this.col_widths[n9], this.row_heights[i]);
                    }
                    n10 += this.col_widths[n9] + this.hgap;
                    ++n9;
                    ++n;
                }
                n8 += this.row_heights[i] + this.vgap;
            }
        }
    }

    public void invalidateLayout(Container container) {
    }

    public String toString() {
        return this.getClass().getName() + "[mode=" + this.mode + ",size=" + this.size + ",hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getLayoutSize(Container container, int n) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n2;
            int n3;
            int n4;
            this.update(container);
            int n5 = container.getComponentCount();
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            for (n4 = 0; n4 < this.nrows; ++n4) {
                n3 = 0;
                block12: for (n2 = 0; n2 < this.ncols && n8 < n5; ++n2, ++n8) {
                    switch (n) {
                        case 0: {
                            n3 = Math.max(n3, container.getComponent((int)n8).getMinimumSize().height);
                            continue block12;
                        }
                        case 1: {
                            n3 = Math.max(n3, container.getComponent((int)n8).getMaximumSize().height);
                            continue block12;
                        }
                        default: {
                            n3 = Math.max(n3, container.getComponent((int)n8).getPreferredSize().height);
                        }
                    }
                }
                n6 += n3;
            }
            for (n4 = 0; n4 < this.ncols; ++n4) {
                n8 = 0;
                block14: for (n3 = 0; n3 < this.nrows && (n2 = n3 * this.ncols + n4) < n5; ++n3) {
                    switch (n) {
                        case 0: {
                            n8 = Math.max(n8, container.getComponent((int)n2).getMinimumSize().width);
                            continue block14;
                        }
                        case 1: {
                            n8 = Math.max(n8, container.getComponent((int)n2).getMaximumSize().width);
                            continue block14;
                        }
                        default: {
                            n8 = Math.max(n8, container.getComponent((int)n2).getPreferredSize().width);
                        }
                    }
                }
                n7 += n8;
            }
            Insets insets = container.getInsets();
            return new Dimension(n7 + insets.left + insets.right + (this.ncols - 1) * this.hgap, n6 + insets.top + insets.bottom + (this.nrows - 1) * this.vgap);
        }
    }

    private void update(Container container) {
        int n = container.getComponentCount();
        int n2 = this.nrows;
        int n3 = this.ncols;
        if (this.mode == 1) {
            this.nrows = this.size;
            this.ncols = (n + this.nrows - 1) / this.nrows;
        } else {
            this.ncols = this.size;
            this.nrows = (n + this.ncols - 1) / this.ncols;
        }
        if (n2 != this.nrows) {
            this.row_heights = new int[this.nrows];
        }
        if (n3 != this.ncols) {
            this.col_widths = new int[this.ncols];
        }
    }
}

