/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.Abbrev;

class AbbrevsModel
extends AbstractTableModel {
    Vector abbrevs = new Vector();
    int lastSort;

    AbbrevsModel(Hashtable hashtable) {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                this.abbrevs.addElement(new Abbrev((String)enumeration.nextElement(), (String)enumeration2.nextElement()));
            }
            this.sort(0);
        }
    }

    void sort(int n) {
        this.lastSort = n;
        MiscUtilities.quicksort(this.abbrevs, (MiscUtilities.Compare)new AbbrevCompare(n));
        this.fireTableDataChanged();
    }

    void add(String string, String string2) {
        this.abbrevs.addElement(new Abbrev(string, string2));
        this.sort(this.lastSort);
    }

    void remove(int n) {
        this.abbrevs.removeElementAt(n);
        this.fireTableStructureChanged();
    }

    public Hashtable toHashtable() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < this.abbrevs.size(); ++i) {
            Abbrev abbrev = (Abbrev)this.abbrevs.elementAt(i);
            if (abbrev.abbrev.length() <= 0 || abbrev.expand.length() <= 0) continue;
            hashtable.put(abbrev.abbrev, abbrev.expand);
        }
        return hashtable;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.abbrevs.size();
    }

    public Object getValueAt(int n, int n2) {
        Abbrev abbrev = (Abbrev)this.abbrevs.elementAt(n);
        switch (n2) {
            case 0: {
                return abbrev.abbrev;
            }
            case 1: {
                return abbrev.expand;
            }
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object == null) {
            object = "";
        }
        Abbrev abbrev = (Abbrev)this.abbrevs.elementAt(n);
        if (n2 == 0) {
            abbrev.abbrev = (String)object;
        } else {
            abbrev.expand = (String)object;
        }
        this.fireTableRowsUpdated(n, n);
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return jEdit.getProperty("options.abbrevs.abbrev");
            }
            case 1: {
                return jEdit.getProperty("options.abbrevs.expand");
            }
        }
        return null;
    }

    class AbbrevCompare
    implements MiscUtilities.Compare {
        int col;

        AbbrevCompare(int n) {
            this.col = n;
        }

        public int compare(Object object, Object object2) {
            Abbrev abbrev = (Abbrev)object;
            Abbrev abbrev2 = (Abbrev)object2;
            if (this.col == 0) {
                String string = abbrev.abbrev.toLowerCase();
                String string2 = abbrev2.abbrev.toLowerCase();
                return MiscUtilities.compareStrings(string, string2, true);
            }
            String string = abbrev.expand.toLowerCase();
            String string3 = abbrev2.expand.toLowerCase();
            return MiscUtilities.compareStrings(string, string3, true);
        }
    }
}

