/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginList;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.jedit.pluginmgr.PluginManagerProgress;
import org.gjt.sp.jedit.pluginmgr.Roster;

class InstallPanel
extends JPanel {
    private JTable table;
    private PluginTableModel pluginModel;
    private PluginManager window;
    private PluginInfoBox infoBox;
    private boolean updates;

    InstallPanel(PluginManager pluginManager, boolean bl) {
        super(new BorderLayout(12, 12));
        this.window = pluginManager;
        this.updates = bl;
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        final JSplitPane jSplitPane = new JSplitPane(0, true);
        this.pluginModel = new PluginTableModel();
        this.table = new JTable(this.pluginModel);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setRowHeight(this.table.getRowHeight() + 2);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 200));
        this.table.setRequestFocusEnabled(false);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.setDefaultRenderer(Object.class, new TextRenderer((DefaultTableCellRenderer)this.table.getDefaultRenderer(Object.class)));
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        TableColumn tableColumn2 = this.table.getColumnModel().getColumn(1);
        TableColumn tableColumn3 = this.table.getColumnModel().getColumn(2);
        TableColumn tableColumn4 = this.table.getColumnModel().getColumn(3);
        TableColumn tableColumn5 = this.table.getColumnModel().getColumn(4);
        tableColumn.setPreferredWidth(30);
        tableColumn.setMinWidth(30);
        tableColumn.setMaxWidth(30);
        tableColumn.setResizable(false);
        tableColumn2.setPreferredWidth(180);
        tableColumn3.setPreferredWidth(130);
        tableColumn4.setPreferredWidth(70);
        tableColumn5.setPreferredWidth(70);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.addMouseListener(new HeaderMouseHandler());
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.getViewport().setBackground(this.table.getBackground());
        jSplitPane.setTopComponent(jScrollPane);
        this.infoBox = new PluginInfoBox();
        JScrollPane jScrollPane2 = new JScrollPane(this.infoBox);
        jScrollPane2.setPreferredSize(new Dimension(500, 100));
        jSplitPane.setBottomComponent(jScrollPane2);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jSplitPane.setDividerLocation(0.75);
            }
        });
        this.add("Center", jSplitPane);
        Box box = new Box(0);
        box.add(new InstallButton());
        box.add(Box.createHorizontalStrut(12));
        box.add(new SelectallButton());
        box.add(Box.createGlue());
        box.add(new SizeLabel());
        this.add("South", box);
    }

    public void updateModel() {
        this.pluginModel.clear();
        this.infoBox.setText(jEdit.getProperty("plugin-manager.list-download"));
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                InstallPanel.this.infoBox.setText(null);
                InstallPanel.this.pluginModel.update();
            }
        });
    }

    private String formatSize(int n) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(1);
        numberFormat.setMinimumFractionDigits(0);
        String string = n < 0x100000 ? n / 1024 + "KB" : numberFormat.format((double)n / 1048576.0) + "MB";
        return string;
    }

    class TextRenderer
    extends DefaultTableCellRenderer {
        private DefaultTableCellRenderer tcr;

        public TextRenderer(DefaultTableCellRenderer defaultTableCellRenderer) {
            this.tcr = defaultTableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this.tcr.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        }
    }

    class HeaderMouseHandler
    extends MouseAdapter {
        HeaderMouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            switch (InstallPanel.this.table.getTableHeader().columnAtPoint(mouseEvent.getPoint())) {
                case 1: {
                    InstallPanel.this.pluginModel.sort(0);
                    break;
                }
                case 2: {
                    InstallPanel.this.pluginModel.sort(1);
                    break;
                }
            }
        }
    }

    static class EntryCompare
    implements Comparator {
        public static final int NAME = 0;
        public static final int CATEGORY = 1;
        private int type;

        public EntryCompare(int n) {
            this.type = n;
        }

        public int compare(Object object, Object object2) {
            Entry entry = (Entry)object;
            Entry entry2 = (Entry)object2;
            if (this.type == 0) {
                return entry.name.compareToIgnoreCase(entry2.name);
            }
            int n = entry.set.compareToIgnoreCase(entry2.set);
            if (n == 0) {
                return entry.name.compareToIgnoreCase(entry2.name);
            }
            return n;
        }
    }

    class InstallButton
    extends JButton
    implements ActionListener,
    TableModelListener {
        public InstallButton() {
            super(jEdit.getProperty("install-plugins.install"));
            InstallPanel.this.pluginModel.addTableModelListener(this);
            this.addActionListener(this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (InstallPanel.this.pluginModel.isDownloadingList()) {
                return;
            }
            boolean bl = jEdit.getBooleanProperty("plugin-manager.downloadSource");
            boolean bl2 = jEdit.getBooleanProperty("plugin-manager.installUser");
            Roster roster = new Roster();
            String string = bl2 ? MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "jars") : MiscUtilities.constructPath(jEdit.getJEditHome(), "jars");
            int n2 = InstallPanel.this.pluginModel.getRowCount();
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                Entry entry = (Entry)InstallPanel.this.pluginModel.entries.get(n);
                if (!entry.install) continue;
                entry.plugin.install(roster, string, bl);
                if (InstallPanel.this.updates) {
                    entry.plugin.getCompatibleBranch().satisfyDependencies(roster, string, bl);
                }
                ++n3;
            }
            if (roster.isEmpty()) {
                return;
            }
            n = 0;
            if (InstallPanel.this.updates && roster.getOperationCount() > n3 && GUIUtilities.confirm(InstallPanel.this.window, "install-plugins.depend", null, 2, 2) == 2) {
                n = 1;
            }
            if (n == 0) {
                new PluginManagerProgress(InstallPanel.this.window, roster);
                roster.performOperationsInAWTThread(InstallPanel.this.window);
                InstallPanel.this.pluginModel.update();
            }
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (InstallPanel.this.pluginModel.isDownloadingList()) {
                return;
            }
            if (tableModelEvent.getType() == 0) {
                int n = InstallPanel.this.pluginModel.getRowCount();
                for (int i = 0; i < n; ++i) {
                    if (!((Boolean)InstallPanel.this.pluginModel.getValueAt(i, 0)).booleanValue()) continue;
                    this.setEnabled(true);
                    return;
                }
                this.setEnabled(false);
            }
        }
    }

    class SelectallButton
    extends JCheckBox
    implements ActionListener,
    TableModelListener {
        public SelectallButton() {
            super(jEdit.getProperty("install-plugins.select-all"));
            this.addActionListener(this);
            InstallPanel.this.pluginModel.addTableModelListener(this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InstallPanel.this.pluginModel.setSelectAll(this.isSelected());
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (InstallPanel.this.pluginModel.isDownloadingList()) {
                return;
            }
            this.setEnabled(InstallPanel.this.pluginModel.getRowCount() != 0);
            if (tableModelEvent.getType() == 0) {
                int n = InstallPanel.this.pluginModel.getRowCount();
                for (int i = 0; i < n; ++i) {
                    if (((Boolean)InstallPanel.this.pluginModel.getValueAt(i, 0)).booleanValue()) continue;
                    this.setSelected(false);
                    return;
                }
                if (n > 0) {
                    this.setSelected(true);
                }
            }
        }
    }

    class SizeLabel
    extends JLabel
    implements TableModelListener {
        private int size = 0;

        public SizeLabel() {
            this.setText(jEdit.getProperty("install-plugins.totalSize") + InstallPanel.this.formatSize(this.size));
            InstallPanel.this.pluginModel.addTableModelListener(this);
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == 0) {
                if (InstallPanel.this.pluginModel.isDownloadingList()) {
                    return;
                }
                this.size = 0;
                int n = InstallPanel.this.pluginModel.getRowCount();
                for (int i = 0; i < n; ++i) {
                    Entry entry = (Entry)InstallPanel.this.pluginModel.entries.get(i);
                    if (!entry.install) continue;
                    this.size += entry.size;
                }
                this.setText(jEdit.getProperty("install-plugins.totalSize") + InstallPanel.this.formatSize(this.size));
            }
        }
    }

    class PluginInfoBox
    extends JTextArea
    implements ListSelectionListener {
        public PluginInfoBox() {
            this.setEditable(false);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            InstallPanel.this.table.getSelectionModel().addListSelectionListener(this);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            String string = "";
            if (InstallPanel.this.table.getSelectedRowCount() == 1) {
                Entry entry = (Entry)InstallPanel.this.pluginModel.entries.get(InstallPanel.this.table.getSelectedRow());
                string = jEdit.getProperty("install-plugins.info", new String[]{entry.author, entry.date, entry.description});
            }
            this.setText(string);
            this.setCaretPosition(0);
        }
    }

    class Entry {
        String name;
        String version;
        String author;
        String date;
        String description;
        String set;
        int size;
        boolean install;
        PluginList.Plugin plugin;
        LinkedList parents = new LinkedList();

        Entry(PluginList.Plugin plugin, String string) {
            PluginList.Branch branch = plugin.getCompatibleBranch();
            boolean bl = jEdit.getBooleanProperty("plugin-manager.downloadSource");
            int n = bl ? branch.downloadSourceSize : branch.downloadSize;
            this.name = plugin.name;
            this.author = plugin.author;
            this.version = branch.version;
            this.size = n;
            this.date = branch.date;
            this.description = plugin.description;
            this.set = string;
            this.install = false;
            this.plugin = plugin;
        }

        String getParentString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.parents.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((Entry)iterator.next()).name);
                if (!iterator.hasNext()) continue;
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
    }

    class PluginTableModel
    extends AbstractTableModel {
        private ArrayList entries = new ArrayList();
        private int sortType = 1;

        PluginTableModel() {
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Boolean.class;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return Object.class;
                }
            }
            throw new Error("Column out of range");
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return " " + jEdit.getProperty("install-plugins.info.name");
                }
                case 2: {
                    return " " + jEdit.getProperty("install-plugins.info.category");
                }
                case 3: {
                    return " " + jEdit.getProperty("install-plugins.info.version");
                }
                case 4: {
                    return " " + jEdit.getProperty("install-plugins.info.size");
                }
            }
            throw new Error("Column out of range");
        }

        public int getRowCount() {
            return this.entries.size();
        }

        public Object getValueAt(int n, int n2) {
            Object e = this.entries.get(n);
            if (e instanceof String) {
                if (n2 == 1) {
                    return e;
                }
                return null;
            }
            Entry entry = (Entry)e;
            switch (n2) {
                case 0: {
                    return new Boolean(entry.install);
                }
                case 1: {
                    return entry.name;
                }
                case 2: {
                    return entry.set;
                }
                case 3: {
                    return entry.version;
                }
                case 4: {
                    return InstallPanel.this.formatSize(entry.size);
                }
            }
            throw new Error("Column out of range");
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void setSelectAll(boolean bl) {
            if (this.isDownloadingList()) {
                return;
            }
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    this.setValueAt(Boolean.TRUE, i, 0);
                    continue;
                }
                Entry entry = (Entry)this.entries.get(i);
                entry.parents = new LinkedList();
                entry.install = false;
            }
            this.fireTableChanged(new TableModelEvent(this));
        }

        public void setSortType(int n) {
            this.sortType = n;
            this.sort(n);
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 0) {
                return;
            }
            Object e = this.entries.get(n);
            if (e instanceof String) {
                return;
            }
            Entry entry = (Entry)e;
            Vector vector = entry.plugin.getCompatibleBranch().deps;
            boolean bl = (Boolean)object;
            if (!bl && entry.parents.size() > 0) {
                Object[] objectArray = new String[]{entry.name, entry.getParentString()};
                int n3 = GUIUtilities.confirm(InstallPanel.this.window, "plugin-manager.dependency", objectArray, 2, 2);
                if (n3 != 0) {
                    return;
                }
                Iterator iterator = entry.parents.iterator();
                while (iterator.hasNext()) {
                    ((Entry)iterator.next()).install = false;
                }
                this.fireTableRowsUpdated(0, this.getRowCount() - 1);
            }
            for (int i = 0; i < vector.size(); ++i) {
                PluginList.Dependency dependency = (PluginList.Dependency)vector.elementAt(i);
                if (!dependency.what.equals("plugin")) continue;
                for (int j = 0; j < this.entries.size(); ++j) {
                    Entry entry2 = (Entry)this.entries.get(j);
                    if (entry2.plugin != dependency.plugin) continue;
                    if (bl) {
                        entry2.parents.add(entry);
                        this.setValueAt(Boolean.TRUE, j, 0);
                        continue;
                    }
                    entry2.parents.remove(entry);
                }
            }
            entry.install = Boolean.TRUE.equals(object);
            this.fireTableCellUpdated(n, n2);
        }

        public void sort(int n) {
            this.sortType = n;
            if (this.isDownloadingList()) {
                return;
            }
            Collections.sort(this.entries, new EntryCompare(n));
            this.fireTableChanged(new TableModelEvent(this));
        }

        private boolean isDownloadingList() {
            return this.entries.size() == 1 && this.entries.get(0) instanceof String;
        }

        public void clear() {
            this.entries = new ArrayList();
            this.fireTableChanged(new TableModelEvent(this));
        }

        public void update() {
            PluginList pluginList = InstallPanel.this.window.getPluginList();
            if (pluginList == null) {
                return;
            }
            this.entries = new ArrayList();
            for (int i = 0; i < pluginList.pluginSets.size(); ++i) {
                PluginList.PluginSet pluginSet = (PluginList.PluginSet)pluginList.pluginSets.get(i);
                for (int j = 0; j < pluginSet.plugins.size(); ++j) {
                    PluginList.Plugin plugin = (PluginList.Plugin)pluginList.pluginHash.get(pluginSet.plugins.get(j));
                    PluginList.Branch branch = plugin.getCompatibleBranch();
                    String string = plugin.getInstalledVersion();
                    if (InstallPanel.this.updates) {
                        if (branch == null || !branch.canSatisfyDependencies() || string == null || MiscUtilities.compareStrings(branch.version, string, false) <= 0) continue;
                        this.entries.add(new Entry(plugin, pluginSet.name));
                        continue;
                    }
                    if (string != null || !plugin.canBeInstalled()) continue;
                    this.entries.add(new Entry(plugin, pluginSet.name));
                }
            }
            this.sort(this.sortType);
            this.fireTableChanged(new TableModelEvent(this));
        }
    }
}

