/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.help.HelpViewer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.jedit.pluginmgr.Roster;

public class ManagePanel
extends JPanel {
    private JCheckBox hideLibraries;
    private JTable table;
    private PluginTableModel pluginModel;
    private PluginManager window;

    public ManagePanel(PluginManager pluginManager) {
        super(new BorderLayout(12, 12));
        this.window = pluginManager;
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        Box box = new Box(0);
        this.hideLibraries = new HideLibrariesButton();
        box.add(this.hideLibraries);
        this.add("North", box);
        this.pluginModel = new PluginTableModel();
        this.table = new JTable(this.pluginModel);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setRowHeight(this.table.getRowHeight() + 2);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 300));
        this.table.setRequestFocusEnabled(false);
        this.table.setDefaultRenderer(Object.class, new TextRenderer((DefaultTableCellRenderer)this.table.getDefaultRenderer(Object.class)));
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        TableColumn tableColumn2 = this.table.getColumnModel().getColumn(1);
        TableColumn tableColumn3 = this.table.getColumnModel().getColumn(2);
        TableColumn tableColumn4 = this.table.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(30);
        tableColumn.setMinWidth(30);
        tableColumn.setMaxWidth(30);
        tableColumn.setResizable(false);
        tableColumn2.setPreferredWidth(300);
        tableColumn3.setPreferredWidth(100);
        tableColumn4.setPreferredWidth(100);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.addMouseListener(new HeaderMouseHandler());
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.getViewport().setBackground(this.table.getBackground());
        this.add("Center", jScrollPane);
        Box box2 = new Box(0);
        box2.add(new RemoveButton());
        box2.add(Box.createGlue());
        box2.add(new HelpButton());
        this.add("South", box2);
    }

    public void update() {
        this.pluginModel.update();
    }

    private int showListConfirm(String string, String[] stringArray, Vector vector) {
        JList jList = new JList(vector);
        jList.setVisibleRowCount(8);
        Object[] objectArray = new Object[]{jEdit.getProperty(string + ".message", stringArray), new JScrollPane(jList)};
        return JOptionPane.showConfirmDialog(this.window, objectArray, jEdit.getProperty(string + ".title"), 0, 3);
    }

    class HeaderMouseHandler
    extends MouseAdapter {
        HeaderMouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            switch (ManagePanel.this.table.getTableHeader().columnAtPoint(mouseEvent.getPoint())) {
                case 1: {
                    ManagePanel.this.pluginModel.setSortType(1);
                    break;
                }
                case 3: {
                    ManagePanel.this.pluginModel.setSortType(2);
                    break;
                }
            }
        }
    }

    static class EntryCompare
    implements Comparator {
        public static final int NAME = 1;
        public static final int STATUS = 2;
        private int type;

        public EntryCompare(int n) {
            this.type = n;
        }

        public int compare(Object object, Object object2) {
            Entry entry = (Entry)object;
            Entry entry2 = (Entry)object2;
            if (this.type == 1) {
                return this.compareNames(entry, entry2);
            }
            int n = entry.status.compareToIgnoreCase(entry2.status);
            if (n == 0) {
                return this.compareNames(entry, entry2);
            }
            return n;
        }

        private int compareNames(Entry entry, Entry entry2) {
            String string = entry.name == null ? MiscUtilities.getFileName(entry.jar) : entry.name;
            String string2 = entry2.name == null ? MiscUtilities.getFileName(entry2.jar) : entry2.name;
            return string.compareToIgnoreCase(string2);
        }
    }

    class HelpButton
    extends JButton
    implements ListSelectionListener,
    ActionListener {
        private URL docURL;

        public HelpButton() {
            super(jEdit.getProperty("manage-plugins.help"));
            ManagePanel.this.table.getSelectionModel().addListSelectionListener(this);
            this.addActionListener(this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new HelpViewer(this.docURL);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (ManagePanel.this.table.getSelectedRowCount() == 1) {
                try {
                    URL uRL;
                    Entry entry = ManagePanel.this.pluginModel.getEntry(ManagePanel.this.table.getSelectedRow());
                    String string = entry.clazz;
                    String string2 = entry.docs;
                    PluginJAR pluginJAR = jEdit.getPlugin(string).getPluginJAR();
                    if (pluginJAR != null && string != null && string2 != null && (uRL = pluginJAR.getClassLoader().getResource(string2)) != null) {
                        this.docURL = uRL;
                        this.setEnabled(true);
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setEnabled(false);
        }
    }

    class RemoveButton
    extends JButton
    implements ListSelectionListener,
    ActionListener {
        public RemoveButton() {
            super(jEdit.getProperty("manage-plugins.remove"));
            ManagePanel.this.table.getSelectionModel().addListSelectionListener(this);
            this.addActionListener(this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = ManagePanel.this.table.getSelectedRows();
            Vector<String> vector = new Vector<String>();
            Roster roster = new Roster();
            for (n = 0; n < nArray.length; ++n) {
                Entry entry = ManagePanel.this.pluginModel.getEntry(nArray[n]);
                for (String string : entry.jars) {
                    vector.addElement(string);
                    roster.addRemove(string);
                }
            }
            n = ManagePanel.this.showListConfirm("plugin-manager.remove-confirm", null, vector);
            if (n == 0) {
                roster.performOperationsInAWTThread(ManagePanel.this.window);
                ManagePanel.this.pluginModel.update();
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (ManagePanel.this.table.getSelectedRowCount() == 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    class HideLibrariesButton
    extends JCheckBox
    implements ActionListener {
        HideLibrariesButton() {
            super(jEdit.getProperty("plugin-manager.hide-libraries"));
            this.setSelected(jEdit.getBooleanProperty("plugin-manager.hide-libraries.toggle"));
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            jEdit.setBooleanProperty("plugin-manager.hide-libraries.toggle", this.isSelected());
            ManagePanel.this.update();
        }
    }

    class TextRenderer
    extends DefaultTableCellRenderer {
        private DefaultTableCellRenderer tcr;

        public TextRenderer(DefaultTableCellRenderer defaultTableCellRenderer) {
            this.tcr = defaultTableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Entry entry = ManagePanel.this.pluginModel.getEntry(n);
            if (entry.status.equals("error")) {
                this.tcr.setForeground(Color.red);
            } else {
                this.tcr.setForeground(UIManager.getColor("Table.foreground"));
            }
            return this.tcr.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        }
    }

    class PluginTableModel
    extends AbstractTableModel {
        private List entries = new ArrayList();
        private int sortType = 1;

        public PluginTableModel() {
            this.update();
        }

        public int getColumnCount() {
            return 4;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return jEdit.getProperty("manage-plugins.info.name");
                }
                case 2: {
                    return jEdit.getProperty("manage-plugins.info.version");
                }
                case 3: {
                    return jEdit.getProperty("manage-plugins.info.status");
                }
            }
            throw new Error("Column out of range");
        }

        public Entry getEntry(int n) {
            return (Entry)this.entries.get(n);
        }

        public int getRowCount() {
            return this.entries.size();
        }

        public Object getValueAt(int n, int n2) {
            Entry entry = (Entry)this.entries.get(n);
            switch (n2) {
                case 0: {
                    return new Boolean(!entry.status.equals("not-loaded"));
                }
                case 1: {
                    if (entry.name == null) {
                        return MiscUtilities.getFileName(entry.jar);
                    }
                    return entry.name;
                }
                case 2: {
                    return entry.version;
                }
                case 3: {
                    return jEdit.getProperty("plugin-manager.status." + entry.status);
                }
            }
            throw new Error("Column out of range");
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            Entry entry = (Entry)this.entries.get(n);
            if (n2 == 0) {
                PluginJAR pluginJAR = jEdit.getPluginJAR(entry.jar);
                if (pluginJAR == null) {
                    if (object.equals(Boolean.FALSE)) {
                        return;
                    }
                    this.loadPluginJAR(entry.jar);
                } else {
                    if (object.equals(Boolean.TRUE)) {
                        return;
                    }
                    this.unloadPluginJARWithDialog(pluginJAR);
                }
            }
            this.update();
        }

        public void setSortType(int n) {
            this.sortType = n;
            this.sort(n);
        }

        public void sort(int n) {
            Collections.sort(this.entries, new EntryCompare(n));
            this.fireTableChanged(new TableModelEvent(this));
        }

        public void update() {
            Entry entry;
            this.entries.clear();
            String string = MiscUtilities.constructPath(jEdit.getJEditHome(), "jars");
            String string2 = jEdit.getSettingsDirectory() == null ? null : MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "jars");
            PluginJAR[] pluginJARArray = jEdit.getPluginJARs();
            for (int i = 0; i < pluginJARArray.length; ++i) {
                String string3 = pluginJARArray[i].getPath();
                if (!string3.startsWith(string) && (string2 == null || !string3.startsWith(string2))) continue;
                entry = new Entry(pluginJARArray[i]);
                if (ManagePanel.this.hideLibraries.isSelected() && entry.clazz == null) continue;
                this.entries.add(entry);
            }
            String[] stringArray = jEdit.getNotLoadedPluginJARs();
            for (int i = 0; i < stringArray.length; ++i) {
                entry = new Entry(stringArray[i]);
                this.entries.add(entry);
            }
            this.sort(this.sortType);
        }

        private void loadPluginJAR(String string) {
            jEdit.addPluginJAR(string);
            PluginJAR pluginJAR = jEdit.getPluginJAR(string);
            if (pluginJAR == null || pluginJAR.getPlugin() == null) {
                return;
            }
            String string2 = jEdit.getProperty("plugin." + pluginJAR.getPlugin().getClassName() + ".jars");
            if (string2 != null) {
                String string3 = MiscUtilities.getParentOfPath(string);
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = MiscUtilities.constructPath(string3, stringTokenizer.nextToken());
                    PluginJAR pluginJAR2 = jEdit.getPluginJAR(string4);
                    if (pluginJAR2 != null) continue;
                    jEdit.addPluginJAR(string4);
                }
            }
            pluginJAR.checkDependencies();
            pluginJAR.activatePluginIfNecessary();
        }

        private void unloadPluginJARWithDialog(PluginJAR pluginJAR) {
            String[] stringArray = pluginJAR.getDependentPlugins();
            if (stringArray.length == 0) {
                this.unloadPluginJAR(pluginJAR);
            } else {
                Vector vector = new Vector();
                this.transitiveClosure(stringArray, vector);
                int n = ManagePanel.this.showListConfirm("plugin-manager.dependency", new String[]{pluginJAR.getFile().getName()}, vector);
                if (n == 0) {
                    this.unloadPluginJAR(pluginJAR);
                }
            }
        }

        private void transitiveClosure(String[] stringArray, Vector vector) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (vector.contains(string)) continue;
                vector.add(string);
                PluginJAR pluginJAR = jEdit.getPluginJAR(string);
                this.transitiveClosure(pluginJAR.getDependentPlugins(), vector);
            }
        }

        private void unloadPluginJAR(PluginJAR pluginJAR) {
            String[] stringArray = pluginJAR.getDependentPlugins();
            for (int i = 0; i < stringArray.length; ++i) {
                PluginJAR pluginJAR2 = jEdit.getPluginJAR(stringArray[i]);
                if (pluginJAR2 == null) continue;
                this.unloadPluginJAR(pluginJAR2);
            }
            jEdit.removePluginJAR(pluginJAR, false);
        }
    }

    class Entry {
        static final String ERROR = "error";
        static final String LOADED = "loaded";
        static final String NOT_LOADED = "not-loaded";
        String status;
        String jar;
        String clazz;
        String name;
        String version;
        String author;
        String docs;
        List jars = new LinkedList();

        Entry(String string) {
            this.jar = string;
            this.jars.add(this.jar);
            this.status = NOT_LOADED;
        }

        Entry(PluginJAR pluginJAR) {
            this.jar = pluginJAR.getPath();
            this.jars.add(this.jar);
            EditPlugin editPlugin = pluginJAR.getPlugin();
            if (editPlugin != null) {
                this.status = editPlugin instanceof EditPlugin.Broken ? ERROR : LOADED;
                this.clazz = editPlugin.getClassName();
                this.name = jEdit.getProperty("plugin." + this.clazz + ".name");
                this.version = jEdit.getProperty("plugin." + this.clazz + ".version");
                this.author = jEdit.getProperty("plugin." + this.clazz + ".author");
                this.docs = jEdit.getProperty("plugin." + this.clazz + ".docs");
                String string = jEdit.getProperty("plugin." + this.clazz + ".jars");
                if (string != null) {
                    String string2 = MiscUtilities.getParentOfPath(this.jar);
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    while (stringTokenizer.hasMoreElements()) {
                        this.jars.add(MiscUtilities.constructPath(string2, stringTokenizer.nextToken()));
                    }
                }
            } else {
                this.status = LOADED;
            }
        }
    }
}

