/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import com.microstar.xml.XmlParser;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginListHandler;
import org.gjt.sp.jedit.pluginmgr.Roster;
import org.gjt.sp.util.Log;

class PluginList {
    public static final int GZIP_MAGIC_1 = 31;
    public static final int GZIP_MAGIC_2 = 139;
    Vector plugins = new Vector();
    Hashtable pluginHash = new Hashtable();
    Vector pluginSets = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PluginList() throws Exception {
        String string = jEdit.getProperty("plugin-manager.export-url");
        String string2 = jEdit.getProperty("plugin-manager.mirror.id");
        if (!string2.equals("NONE")) {
            string = string + "?mirror=" + string2;
        }
        PluginListHandler pluginListHandler = new PluginListHandler(this, string);
        XmlParser xmlParser = new XmlParser();
        xmlParser.setHandler(pluginListHandler);
        FilterInputStream filterInputStream = new BufferedInputStream(new URL(string).openStream());
        try {
            if (((InputStream)filterInputStream).markSupported()) {
                ((InputStream)filterInputStream).mark(2);
                int n = ((InputStream)filterInputStream).read();
                int n2 = ((InputStream)filterInputStream).read();
                ((InputStream)filterInputStream).reset();
                if (n == 31 && n2 == 139) {
                    filterInputStream = new GZIPInputStream(filterInputStream);
                }
            }
            xmlParser.parse(null, null, new InputStreamReader((InputStream)filterInputStream, "UTF8"));
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            ((InputStream)filterInputStream).close();
            throw throwable;
        }
        ((InputStream)filterInputStream).close();
    }

    void addPlugin(Plugin plugin) {
        plugin.checkIfInstalled();
        this.plugins.addElement(plugin);
        this.pluginHash.put(plugin.name, plugin);
    }

    void addPluginSet(PluginSet pluginSet) {
        this.pluginSets.addElement(pluginSet);
    }

    void finished() {
        for (int i = 0; i < this.plugins.size(); ++i) {
            Plugin plugin = (Plugin)this.plugins.elementAt(i);
            for (int j = 0; j < plugin.branches.size(); ++j) {
                Branch branch = (Branch)plugin.branches.elementAt(j);
                for (int k = 0; k < branch.deps.size(); ++k) {
                    Dependency dependency = (Dependency)branch.deps.elementAt(k);
                    if (!dependency.what.equals("plugin")) continue;
                    dependency.plugin = (Plugin)this.pluginHash.get(dependency.pluginName);
                }
            }
        }
    }

    void dump() {
        for (int i = 0; i < this.plugins.size(); ++i) {
            System.err.println((Plugin)this.plugins.elementAt(i));
            System.err.println();
        }
    }

    static class Dependency {
        String what;
        String from;
        String to;
        String pluginName;
        Plugin plugin;

        Dependency(String string, String string2, String string3, String string4) {
            this.what = string;
            this.from = string2;
            this.to = string3;
            this.pluginName = string4;
        }

        boolean isSatisfied() {
            if (this.what.equals("plugin")) {
                for (int i = 0; i < this.plugin.branches.size(); ++i) {
                    String string = this.plugin.getInstalledVersion();
                    if (string == null || this.from != null && MiscUtilities.compareStrings(string, this.from, false) < 0 || this.to != null && MiscUtilities.compareStrings(string, this.to, false) > 0) continue;
                    return true;
                }
                return false;
            }
            if (this.what.equals("jdk")) {
                String string = System.getProperty("java.version").substring(0, 3);
                return !(this.from != null && MiscUtilities.compareStrings(string, this.from, false) < 0 || this.to != null && MiscUtilities.compareStrings(string, this.to, false) > 0);
            }
            if (this.what.equals("jedit")) {
                String string = jEdit.getBuild();
                return !(this.from != null && MiscUtilities.compareStrings(string, this.from, false) < 0 || this.to != null && MiscUtilities.compareStrings(string, this.to, false) > 0);
            }
            Log.log(9, this, "Invalid dependency: " + this.what);
            return false;
        }

        boolean canSatisfy() {
            if (this.isSatisfied()) {
                return true;
            }
            if (this.what.equals("plugin")) {
                return this.plugin.canBeInstalled();
            }
            return false;
        }

        void satisfy(Roster roster, String string, boolean bl) {
            if (this.what.equals("plugin")) {
                String string2 = this.plugin.getInstalledVersion();
                for (int i = 0; i < this.plugin.branches.size(); ++i) {
                    Branch branch = (Branch)this.plugin.branches.elementAt(i);
                    if (string2 != null && MiscUtilities.compareStrings(string2, branch.version, false) >= 0 || this.from != null && MiscUtilities.compareStrings(branch.version, this.from, false) < 0 || this.to != null && MiscUtilities.compareStrings(branch.version, this.to, false) > 0) continue;
                    this.plugin.install(roster, string, bl);
                    return;
                }
            }
        }

        public String toString() {
            return "[what=" + this.what + ",from=" + this.from + ",to=" + this.to + ",plugin=" + this.plugin + "]";
        }
    }

    static class Branch {
        String version;
        String date;
        int downloadSize;
        String download;
        int downloadSourceSize;
        String downloadSource;
        boolean obsolete;
        Vector deps = new Vector();

        Branch() {
        }

        boolean canSatisfyDependencies() {
            for (int i = 0; i < this.deps.size(); ++i) {
                Dependency dependency = (Dependency)this.deps.elementAt(i);
                if (dependency.canSatisfy()) continue;
                return false;
            }
            return true;
        }

        void satisfyDependencies(Roster roster, String string, boolean bl) {
            for (int i = 0; i < this.deps.size(); ++i) {
                Dependency dependency = (Dependency)this.deps.elementAt(i);
                dependency.satisfy(roster, string, bl);
            }
        }

        public String toString() {
            return "[version=" + this.version + ",download=" + this.download + ",obsolete=" + this.obsolete + ",deps=" + this.deps + "]";
        }
    }

    public static class Plugin {
        String jar;
        String name;
        String description;
        String author;
        Vector branches = new Vector();

        void checkIfInstalled() {
        }

        String getInstalledVersion() {
            PluginJAR[] pluginJARArray = jEdit.getPluginJARs();
            for (int i = 0; i < pluginJARArray.length; ++i) {
                String string = pluginJARArray[i].getPath();
                if (!MiscUtilities.getFileName(string).equals(this.jar)) continue;
                EditPlugin editPlugin = pluginJARArray[i].getPlugin();
                if (editPlugin != null) {
                    return jEdit.getProperty("plugin." + editPlugin.getClassName() + ".version");
                }
                return null;
            }
            return null;
        }

        String getInstalledPath() {
            PluginJAR[] pluginJARArray = jEdit.getPluginJARs();
            for (int i = 0; i < pluginJARArray.length; ++i) {
                String string = pluginJARArray[i].getPath();
                if (!MiscUtilities.getFileName(string).equals(this.jar)) continue;
                return string;
            }
            return null;
        }

        Branch getCompatibleBranch() {
            for (int i = 0; i < this.branches.size(); ++i) {
                Branch branch = (Branch)this.branches.elementAt(i);
                if (!branch.canSatisfyDependencies()) continue;
                return branch;
            }
            return null;
        }

        boolean canBeInstalled() {
            Branch branch = this.getCompatibleBranch();
            return branch != null && !branch.obsolete && branch.canSatisfyDependencies();
        }

        void install(Roster roster, String string, boolean bl) {
            String string2 = this.getInstalledPath();
            Branch branch = this.getCompatibleBranch();
            if (branch.obsolete) {
                if (string2 != null) {
                    roster.addRemove(string2);
                }
                return;
            }
            if (string2 != null) {
                string = MiscUtilities.getParentOfPath(string2);
            }
            roster.addInstall(string2, bl ? branch.downloadSource : branch.download, string, bl ? branch.downloadSourceSize : branch.downloadSize);
        }

        public String toString() {
            return this.name;
        }
    }

    static class PluginSet {
        String name;
        String description;
        Vector plugins = new Vector();

        PluginSet() {
        }

        public String toString() {
            return this.plugins.toString();
        }
    }
}

