/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.search.HyperSearchResult;

public class HyperSearchResults
extends JPanel
implements EBComponent,
DefaultFocusComponent {
    public static final String NAME = "hypersearch-results";
    private View view;
    private JLabel caption;
    private JTree resultTree;
    private DefaultMutableTreeNode resultTreeRoot;
    private DefaultTreeModel resultTreeModel;
    private RolloverButton clear;
    private RolloverButton multi;
    private boolean multiStatus;

    public HyperSearchResults(View view) {
        super(new BorderLayout());
        this.view = view;
        this.caption = new JLabel();
        Box box = new Box(0);
        box.add(this.caption);
        box.add(Box.createGlue());
        ActionHandler actionHandler = new ActionHandler();
        this.clear = new RolloverButton(GUIUtilities.loadIcon("Clear.png"));
        this.clear.setToolTipText(jEdit.getProperty("hypersearch-results.clear.label"));
        this.clear.addActionListener(actionHandler);
        box.add(this.clear);
        this.multi = new RolloverButton();
        this.multi.setToolTipText(jEdit.getProperty("hypersearch-results.multi.label"));
        this.multi.addActionListener(actionHandler);
        box.add(this.multi);
        this.add("North", box);
        this.resultTreeRoot = new DefaultMutableTreeNode();
        this.resultTreeModel = new DefaultTreeModel(this.resultTreeRoot);
        this.resultTree = new JTree(this.resultTreeModel);
        this.resultTree.setCellRenderer(new ResultCellRenderer());
        this.resultTree.setVisibleRowCount(16);
        this.resultTree.setRootVisible(false);
        this.resultTree.setShowsRootHandles(true);
        if (!OperatingSystem.isMacOSLF()) {
            this.resultTree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.resultTree.setEditable(false);
        this.resultTree.addKeyListener(new KeyHandler());
        this.resultTree.addMouseListener(new MouseHandler());
        JScrollPane jScrollPane = new JScrollPane(this.resultTree);
        Dimension dimension = jScrollPane.getPreferredSize();
        dimension.width = 400;
        jScrollPane.setPreferredSize(dimension);
        this.add("Center", jScrollPane);
    }

    public void focusOnDefaultComponent() {
        this.resultTree.requestFocus();
    }

    public void addNotify() {
        super.addNotify();
        EditBus.addToBus(this);
        this.multiStatus = jEdit.getBooleanProperty("hypersearch-results.multi");
        this.updateMultiStatus();
    }

    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus(this);
        jEdit.setBooleanProperty("hypersearch-results.multi", this.multiStatus);
    }

    private void visitBuffers(ResultVisitor resultVisitor, Buffer buffer) {
        for (int i = this.resultTreeRoot.getChildCount() - 1; i >= 0; --i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.resultTreeRoot.getChildAt(i);
            for (int j = defaultMutableTreeNode.getChildCount() - 1; j >= 0; --j) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j);
                for (int k = defaultMutableTreeNode2.getChildCount() - 1; k >= 0; --k) {
                    Object object = ((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(k)).getUserObject();
                    HyperSearchResult hyperSearchResult = (HyperSearchResult)object;
                    if (!hyperSearchResult.pathEquals(buffer.getSymlinkPath())) continue;
                    resultVisitor.visit(buffer, hyperSearchResult);
                }
            }
        }
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof BufferUpdate) {
            BufferUpdate bufferUpdate = (BufferUpdate)eBMessage;
            Buffer buffer = bufferUpdate.getBuffer();
            Object object = bufferUpdate.getWhat();
            if (object == BufferUpdate.LOADED || object == BufferUpdate.CLOSED) {
                ResultVisitor resultVisitor = null;
                resultVisitor = object == BufferUpdate.LOADED ? new BufferLoadedVisitor() : new BufferClosedVisitor();
                this.visitBuffers(resultVisitor, buffer);
            }
        }
    }

    public DefaultTreeModel getTreeModel() {
        return this.resultTreeModel;
    }

    public JTree getTree() {
        return this.resultTree;
    }

    public void searchStarted() {
        this.caption.setText(jEdit.getProperty("hypersearch-results.searching"));
    }

    public void searchFailed() {
        this.caption.setText(jEdit.getProperty("hypersearch-results.no-results"));
        for (int i = 0; i < this.resultTreeRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.resultTreeRoot.getChildAt(i);
            this.resultTree.collapsePath(new TreePath(new Object[]{this.resultTreeRoot, defaultMutableTreeNode}));
        }
    }

    public void searchDone(final DefaultMutableTreeNode defaultMutableTreeNode) {
        final int n = defaultMutableTreeNode.getChildCount();
        if (n < 1) {
            this.searchFailed();
            return;
        }
        this.caption.setText(jEdit.getProperty("hypersearch-results.done"));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!HyperSearchResults.this.multiStatus) {
                    for (int i = 0; i < HyperSearchResults.this.resultTreeRoot.getChildCount(); ++i) {
                        HyperSearchResults.this.resultTreeRoot.remove(0);
                    }
                }
                HyperSearchResults.this.resultTreeRoot.add(defaultMutableTreeNode);
                HyperSearchResults.this.resultTreeModel.reload(HyperSearchResults.this.resultTreeRoot);
                TreePath treePath = null;
                for (int i = 0; i < n; ++i) {
                    treePath = new TreePath(((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)).getPath());
                    HyperSearchResults.this.resultTree.expandPath(treePath);
                }
                HyperSearchResults.this.resultTree.scrollPathToVisible(new TreePath(new Object[]{HyperSearchResults.this.resultTreeRoot, defaultMutableTreeNode}));
            }
        });
    }

    private void updateMultiStatus() {
        if (this.multiStatus) {
            this.multi.setIcon(GUIUtilities.loadIcon("MultipleResults.png"));
        } else {
            this.multi.setIcon(GUIUtilities.loadIcon("SingleResult.png"));
        }
    }

    private void goToSelectedNode() {
        TreePath treePath = this.resultTree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.getParent() != this.resultTreeRoot) {
            if (object instanceof String) {
                Buffer buffer = jEdit.openFile(this.view, (String)object);
                if (buffer == null) {
                    return;
                }
                this.view.goToBuffer(buffer);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        HyperSearchResults.this.resultTree.requestFocus();
                    }
                });
            } else if (object instanceof HyperSearchResult) {
                ((HyperSearchResult)object).goTo(this.view);
            }
        }
    }

    class BufferClosedVisitor
    implements ResultVisitor {
        BufferClosedVisitor() {
        }

        public void visit(Buffer buffer, HyperSearchResult hyperSearchResult) {
            hyperSearchResult.bufferClosed();
        }
    }

    class BufferLoadedVisitor
    implements ResultVisitor {
        BufferLoadedVisitor() {
        }

        public void visit(Buffer buffer, HyperSearchResult hyperSearchResult) {
            hyperSearchResult.bufferOpened(buffer);
        }
    }

    static interface ResultVisitor {
        public void visit(Buffer var1, HyperSearchResult var2);
    }

    class ResultCellRenderer
    extends DefaultTreeCellRenderer {
        Font plainFont = UIManager.getFont("Tree.font");
        Font boldFont;

        ResultCellRenderer() {
            if (this.plainFont == null) {
                this.plainFont = jEdit.getFontProperty("metal.secondary.font");
            }
            this.boldFont = new Font(this.plainFont.getName(), 1, this.plainFont.getSize());
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setIcon(null);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (defaultMutableTreeNode.getParent() == HyperSearchResults.this.resultTreeRoot) {
                this.setFont(this.boldFont);
                int n2 = defaultMutableTreeNode.getChildCount();
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    n3 += defaultMutableTreeNode.getChildAt(i).getChildCount();
                }
                String string = "hypersearch-results.result-caption";
                if (n2 == 1) {
                    string = string + (n3 == 1 ? "1" : "2");
                }
                Object[] objectArray = new Object[]{defaultMutableTreeNode.toString(), new Integer(n3), new Integer(n2)};
                this.setText(jEdit.getProperty(string, objectArray));
            } else if (defaultMutableTreeNode.getUserObject() instanceof String) {
                this.setFont(this.boldFont);
                int n4 = defaultMutableTreeNode.getChildCount();
                if (n4 == 1) {
                    this.setText(jEdit.getProperty("hypersearch-results.file-caption1", new Object[]{defaultMutableTreeNode.getUserObject()}));
                } else {
                    this.setText(jEdit.getProperty("hypersearch-results.file-caption", new Object[]{defaultMutableTreeNode.getUserObject(), new Integer(n4)}));
                }
            } else {
                this.setFont(this.plainFont);
            }
            return this;
        }
    }

    class RemoveAllTreeNodesAction
    extends AbstractAction {
        public RemoveAllTreeNodesAction() {
            super(jEdit.getProperty("hypersearch-results.remove-all-nodes"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HyperSearchResults.this.resultTreeRoot = new DefaultMutableTreeNode();
            HyperSearchResults.this.resultTreeModel = new DefaultTreeModel(HyperSearchResults.this.resultTreeRoot);
            HyperSearchResults.this.resultTree.setModel(HyperSearchResults.this.resultTreeModel);
        }
    }

    class RemoveTreeNodeAction
    extends AbstractAction {
        public RemoveTreeNodeAction() {
            super(jEdit.getProperty("hypersearch-results.remove-node"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = HyperSearchResults.this.resultTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            MutableTreeNode mutableTreeNode = (MutableTreeNode)treePath.getLastPathComponent();
            HyperSearchResults.this.resultTreeModel.removeNodeFromParent(mutableTreeNode);
        }
    }

    class MouseHandler
    extends MouseAdapter {
        private JPopupMenu popupMenu;

        MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            TreePath treePath = HyperSearchResults.this.resultTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            HyperSearchResults.this.resultTree.setSelectionPath(treePath);
            if (GUIUtilities.isPopupTrigger(mouseEvent)) {
                this.showPopupMenu(mouseEvent);
            } else {
                HyperSearchResults.this.goToSelectedNode();
                HyperSearchResults.this.view.toFront();
                HyperSearchResults.this.view.requestFocus();
                HyperSearchResults.this.view.getTextArea().requestFocus();
            }
        }

        private void showPopupMenu(MouseEvent mouseEvent) {
            if (this.popupMenu == null) {
                this.popupMenu = new JPopupMenu();
                this.popupMenu.add(new RemoveTreeNodeAction());
            }
            GUIUtilities.showPopupMenu(this.popupMenu, mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            mouseEvent.consume();
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                HyperSearchResults.this.goToSelectedNode();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        HyperSearchResults.this.resultTree.requestFocus();
                    }
                });
                keyEvent.consume();
            }
        }
    }

    public class ActionHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == HyperSearchResults.this.clear) {
                HyperSearchResults.this.resultTreeRoot.removeAllChildren();
                HyperSearchResults.this.resultTreeModel.reload(HyperSearchResults.this.resultTreeRoot);
            } else if (object == HyperSearchResults.this.multi) {
                HyperSearchResults.this.multiStatus = !HyperSearchResults.this.multiStatus;
                HyperSearchResults.this.updateMultiStatus();
                if (!HyperSearchResults.this.multiStatus) {
                    for (int i = HyperSearchResults.this.resultTreeRoot.getChildCount() - 2; i >= 0; --i) {
                        HyperSearchResults.this.resultTreeModel.removeNodeFromParent((MutableTreeNode)HyperSearchResults.this.resultTreeRoot.getChildAt(i));
                    }
                }
            }
        }
    }
}

